/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kyuubi.shaded.zookeeper.server.quorum;

import java.io.PrintWriter;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.kyuubi.shaded.zookeeper.jmx.MBeanRegistry;
import org.apache.kyuubi.shaded.zookeeper.server.DataTreeBean;
import org.apache.kyuubi.shaded.zookeeper.server.FinalRequestProcessor;
import org.apache.kyuubi.shaded.zookeeper.server.PrepRequestProcessor;
import org.apache.kyuubi.shaded.zookeeper.server.ZKDatabase;
import org.apache.kyuubi.shaded.zookeeper.server.ZooKeeperServer;
import org.apache.kyuubi.shaded.zookeeper.server.ZooKeeperServerBean;
import org.apache.kyuubi.shaded.zookeeper.server.persistence.FileTxnSnapLog;
import org.apache.kyuubi.shaded.zookeeper.server.quorum.LocalPeerBean;
import org.apache.kyuubi.shaded.zookeeper.server.quorum.QuorumPeer;
import org.apache.kyuubi.shaded.zookeeper.server.quorum.ReadOnlyBean;
import org.apache.kyuubi.shaded.zookeeper.server.quorum.ReadOnlyRequestProcessor;

public class ReadOnlyZooKeeperServer
extends ZooKeeperServer {
    protected final QuorumPeer self;
    private volatile boolean shutdown = false;

    ReadOnlyZooKeeperServer(FileTxnSnapLog logFactory, QuorumPeer self, ZKDatabase zkDb) {
        super(logFactory, self.tickTime, self.minSessionTimeout, self.maxSessionTimeout, self.clientPortListenBacklog, zkDb, self.getInitialConfig(), self.isReconfigEnabled());
        this.self = self;
    }

    @Override
    protected void setupRequestProcessors() {
        FinalRequestProcessor finalProcessor = new FinalRequestProcessor(this);
        PrepRequestProcessor prepProcessor = new PrepRequestProcessor(this, finalProcessor);
        prepProcessor.start();
        this.firstProcessor = new ReadOnlyRequestProcessor(this, prepProcessor);
        ((ReadOnlyRequestProcessor)this.firstProcessor).start();
    }

    @Override
    public synchronized void startup() {
        if (this.shutdown) {
            LOG.warn("Not starting Read-only server as startup follows shutdown!");
            return;
        }
        this.registerJMX(new ReadOnlyBean(this), this.self.jmxLocalPeerBean);
        super.startup();
        this.self.setZooKeeperServer(this);
        this.self.adminServer.setZooKeeperServer(this);
        LOG.info("Read-only server started");
    }

    @Override
    protected void registerJMX() {
        try {
            this.jmxDataTreeBean = new DataTreeBean(this.getZKDatabase().getDataTree());
            MBeanRegistry.getInstance().register(this.jmxDataTreeBean, this.jmxServerBean);
        }
        catch (Exception e) {
            LOG.warn("Failed to register with JMX", (Throwable)e);
            this.jmxDataTreeBean = null;
        }
    }

    public void registerJMX(ZooKeeperServerBean serverBean, LocalPeerBean localPeerBean) {
        try {
            this.jmxServerBean = serverBean;
            MBeanRegistry.getInstance().register(serverBean, localPeerBean);
        }
        catch (Exception e) {
            LOG.warn("Failed to register with JMX", (Throwable)e);
            this.jmxServerBean = null;
        }
    }

    @Override
    protected void unregisterJMX() {
        try {
            if (this.jmxDataTreeBean != null) {
                MBeanRegistry.getInstance().unregister(this.jmxDataTreeBean);
            }
        }
        catch (Exception e) {
            LOG.warn("Failed to unregister with JMX", (Throwable)e);
        }
        this.jmxDataTreeBean = null;
    }

    protected void unregisterJMX(ZooKeeperServer zks) {
        try {
            if (this.jmxServerBean != null) {
                MBeanRegistry.getInstance().unregister(this.jmxServerBean);
            }
        }
        catch (Exception e) {
            LOG.warn("Failed to unregister with JMX", (Throwable)e);
        }
        this.jmxServerBean = null;
    }

    @Override
    public String getState() {
        return "read-only";
    }

    @Override
    public long getServerId() {
        return this.self.getId();
    }

    @Override
    public synchronized void shutdown() {
        if (!this.canShutdown()) {
            LOG.debug("ZooKeeper server is not running, so not proceeding to shutdown!");
            return;
        }
        this.shutdown = true;
        this.unregisterJMX(this);
        this.self.setZooKeeperServer(null);
        this.self.closeAllConnections();
        this.self.adminServer.setZooKeeperServer(null);
        super.shutdown();
    }

    @Override
    public void dumpConf(PrintWriter pwriter) {
        super.dumpConf(pwriter);
        pwriter.print("initLimit=");
        pwriter.println(this.self.getInitLimit());
        pwriter.print("syncLimit=");
        pwriter.println(this.self.getSyncLimit());
        pwriter.print("electionAlg=");
        pwriter.println(this.self.getElectionType());
        pwriter.print("electionPort=");
        pwriter.println(this.self.getElectionAddress().getAllPorts().stream().map(Objects::toString).collect(Collectors.joining("|")));
        pwriter.print("quorumPort=");
        pwriter.println(this.self.getQuorumAddress().getAllPorts().stream().map(Objects::toString).collect(Collectors.joining("|")));
        pwriter.print("peerType=");
        pwriter.println(this.self.getLearnerType().ordinal());
    }

    @Override
    protected void setState(ZooKeeperServer.State state) {
        this.state = state;
    }
}

