/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kyuubi.plugin.spark.authz.ranger;

import java.io.Serializable;
import java.util.Collection;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.util.ShutdownHookManager;
import org.apache.kyuubi.plugin.spark.authz.AccessControlException;
import org.apache.kyuubi.plugin.spark.authz.AccessControlException$;
import org.apache.kyuubi.plugin.spark.authz.ranger.AccessRequest;
import org.apache.kyuubi.plugin.spark.authz.ranger.AccessResource;
import org.apache.kyuubi.plugin.spark.authz.ranger.RangerConfigProvider;
import org.apache.kyuubi.plugin.spark.authz.ranger.SparkRangerAuditHandler;
import org.apache.ranger.plugin.policyengine.RangerAccessRequest;
import org.apache.ranger.plugin.policyengine.RangerAccessResult;
import org.apache.ranger.plugin.policyengine.RangerAccessResultProcessor;
import org.apache.ranger.plugin.service.RangerBasePlugin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.BufferLike;
import scala.collection.mutable.Iterable$;
import scala.collection.mutable.LinkedHashMap;
import scala.collection.mutable.LinkedHashMap$;
import scala.runtime.BoxesRunTime;

public final class SparkRangerAdminPlugin$
extends RangerBasePlugin
implements RangerConfigProvider {
    public static SparkRangerAdminPlugin$ MODULE$;
    private final Logger LOG;
    private final Configuration getRangerConf;

    static {
        new SparkRangerAdminPlugin$();
    }

    @Override
    public Configuration getRangerConf() {
        return this.getRangerConf;
    }

    @Override
    public void org$apache$kyuubi$plugin$spark$authz$ranger$RangerConfigProvider$_setter_$getRangerConf_$eq(Configuration x$1) {
        this.getRangerConf = x$1;
    }

    private final Logger LOG() {
        return this.LOG;
    }

    public boolean authorizeInSingleCall() {
        return this.getRangerConf().getBoolean(new StringBuilder(39).append("ranger.plugin.").append(this.getServiceType()).append(".authorize.in.single.call").toString(), false);
    }

    public boolean useUserGroupsFromUserStoreEnabled() {
        return this.getRangerConf().getBoolean(new StringBuilder(52).append("ranger.plugin.").append(this.getServiceType()).append(".use.usergroups.from.userstore.enabled").toString(), false);
    }

    public void initialize() {
        this.init();
        this.registerCleanupShutdownHook(this);
    }

    private void registerCleanupShutdownHook(RangerBasePlugin plugin) {
        ShutdownHookManager.get().addShutdownHook(() -> {
            if (plugin != null) {
                MODULE$.LOG().info(new StringBuilder(31).append("clean up ranger plugin, appId: ").append(plugin.getAppId()).toString());
                plugin.cleanup();
                plugin.getAuditProviderFactory().shutdown();
                return;
            }
        }, Integer.MAX_VALUE);
    }

    public Option<String> getFilterExpr(AccessRequest req) {
        RangerAccessResult result = this.evalRowFilterPolicies(req, null);
        return Option$.MODULE$.apply((Object)result).filter((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)x$1.isRowFilterEnabled())).map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.getFilterExpr()).filter((Function1 & Serializable & scala.Serializable)fe -> BoxesRunTime.boxToBoolean((boolean)SparkRangerAdminPlugin$.$anonfun$getFilterExpr$3(fe)));
    }

    public Option<String> getMaskingExpr(AccessRequest req) {
        String col = ((AccessResource)req.getResource()).getColumn();
        RangerAccessResult result = this.evalDataMaskPolicies(req, null);
        return Option$.MODULE$.apply((Object)result).filter((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)x$3.isMaskEnabled())).map((Function1 & Serializable & scala.Serializable)res -> {
            if ("MASK_NULL".equalsIgnoreCase(res.getMaskType())) {
                return "NULL";
            }
            if ("CUSTOM".equalsIgnoreCase(result.getMaskType())) {
                String maskVal = res.getMaskedValue();
                if (maskVal == null) {
                    return "NULL";
                }
                return String.valueOf(maskVal.replace("{col}", col));
            }
            if (result.getMaskTypeDef() != null) {
                String string = result.getMaskTypeDef().getName();
                if ("MASK".equals(string)) {
                    return MODULE$.regexp_replace(col, MODULE$.regexp_replace$default$2());
                }
                if ("MASK_SHOW_FIRST_4".equals(string)) {
                    return MODULE$.regexp_replace(col, true);
                }
                if ("MASK_SHOW_LAST_4".equals(string)) {
                    String left = MODULE$.regexp_replace(new StringBuilder(20).append("left(").append(col).append(", length(").append(col).append(") - 4)").toString(), MODULE$.regexp_replace$default$2());
                    return new StringBuilder(20).append("concat(").append(left).append(", right(").append(col).append(", 4))").toString();
                }
                if ("MASK_HASH".equals(string)) {
                    return new StringBuilder(21).append("md5(cast(").append(col).append(" as string))").toString();
                }
                if ("MASK_DATE_SHOW_YEAR".equals(string)) {
                    return new StringBuilder(20).append("date_trunc('YEAR', ").append(col).append(")").toString();
                }
                String string2 = result.getMaskTypeDef().getTransformer();
                if (string2 != null && new StringOps(Predef$.MODULE$.augmentString(string2)).nonEmpty()) {
                    return String.valueOf(string2.replace("{col}", col));
                }
                return null;
            }
            return null;
        });
    }

    private String regexp_replace(String expr, boolean hasLen) {
        String pos = hasLen ? ", 5" : "";
        String upper = new StringBuilder(30).append("regexp_replace(").append(expr).append(", '[A-Z]', 'X'").append(pos).append(")").toString();
        String lower = new StringBuilder(30).append("regexp_replace(").append(upper).append(", '[a-z]', 'x'").append(pos).append(")").toString();
        String digits = new StringBuilder(30).append("regexp_replace(").append(lower).append(", '[0-9]', 'n'").append(pos).append(")").toString();
        String other = new StringBuilder(37).append("regexp_replace(").append(digits).append(", '[^A-Za-z0-9]', 'U'").append(pos).append(")").toString();
        return other;
    }

    private boolean regexp_replace$default$2() {
        return false;
    }

    public void verify(Seq<RangerAccessRequest> requests, SparkRangerAuditHandler auditHandler) {
        if (requests.nonEmpty()) {
            Collection<RangerAccessResult> results = this.isAccessAllowed((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter(requests).asJava(), (RangerAccessResultProcessor)auditHandler);
            if (results != null) {
                Iterable indices = (Iterable)((TraversableLike)((TraversableLike)((IterableLike)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(results).asScala()).zipWithIndex(scala.collection.Iterable$.MODULE$.canBuildFrom())).filter((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)SparkRangerAdminPlugin$.$anonfun$verify$1(x0$1)))).map((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToInteger((int)x$4._2$mcI$sp()), scala.collection.Iterable$.MODULE$.canBuildFrom());
                if (indices.nonEmpty()) {
                    String user = ((RangerAccessRequest)requests.head()).getUser();
                    LinkedHashMap accessTypeToResource = (LinkedHashMap)indices.foldLeft((Object)LinkedHashMap$.MODULE$.empty(), (Function2 & Serializable & scala.Serializable)(m, idx) -> SparkRangerAdminPlugin$.$anonfun$verify$3(requests, m, BoxesRunTime.unboxToInt((Object)idx)));
                    String errorMsg = ((TraversableOnce)accessTypeToResource.map((Function1 & Serializable & scala.Serializable)x0$2 -> {
                        Tuple2 tuple2 = x0$2;
                        if (tuple2 != null) {
                            String accessType = (String)tuple2._1();
                            ArrayBuffer resources = (ArrayBuffer)tuple2._2();
                            return new StringBuilder(3).append("[").append(accessType).append("] ").append(resources.mkString("privilege on [", ",", "]")).toString();
                        }
                        throw new MatchError((Object)tuple2);
                    }, Iterable$.MODULE$.canBuildFrom())).mkString(", ");
                    throw new AccessControlException(new StringBuilder(41).append("Permission denied: user [").append(user).append("] does not have ").append(errorMsg).toString(), AccessControlException$.MODULE$.$lessinit$greater$default$2());
                }
                return;
            }
            return;
        }
    }

    public static final /* synthetic */ boolean $anonfun$getFilterExpr$3(String fe) {
        return fe != null && new StringOps(Predef$.MODULE$.augmentString(fe)).nonEmpty();
    }

    public static final /* synthetic */ boolean $anonfun$verify$1(Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            RangerAccessResult result = (RangerAccessResult)tuple2._1();
            return result != null && !result.getIsAllowed();
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ LinkedHashMap $anonfun$verify$3(Seq requests$1, LinkedHashMap m, int idx) {
        RangerAccessRequest req = (RangerAccessRequest)requests$1.apply(idx);
        String accessType = req.getAccessType();
        String resource = req.getResource().getAsString();
        ((BufferLike)m.getOrElseUpdate((Object)accessType, (Function0 & Serializable & scala.Serializable)() -> (ArrayBuffer)ArrayBuffer$.MODULE$.empty())).append((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{resource}));
        return m;
    }

    private SparkRangerAdminPlugin$() {
        super("spark", "sparkSql");
        MODULE$ = this;
        RangerConfigProvider.$init$(this);
        this.LOG = LoggerFactory.getLogger(this.getClass());
    }
}

