/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.admin.client;

import java.io.UnsupportedEncodingException;
import java.security.PrivilegedAction;
import java.util.HashMap;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.AccessControlException;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.kyuubi.shade.com.fasterxml.jackson.core.type.TypeReference;
import org.apache.kyuubi.shade.com.sun.jersey.api.client.ClientResponse;
import org.apache.kyuubi.shade.javax.ws.rs.core.Cookie;
import org.apache.kyuubi.shade.javax.ws.rs.core.NewCookie;
import org.apache.ranger.admin.client.AbstractRangerAdminClient;
import org.apache.ranger.admin.client.datatype.RESTResponse;
import org.apache.ranger.audit.provider.MiscUtil;
import org.apache.ranger.authorization.hadoop.config.RangerPluginConfig;
import org.apache.ranger.authorization.utils.StringUtil;
import org.apache.ranger.plugin.model.RangerRole;
import org.apache.ranger.plugin.util.GrantRevokeRequest;
import org.apache.ranger.plugin.util.GrantRevokeRoleRequest;
import org.apache.ranger.plugin.util.JsonUtilsV2;
import org.apache.ranger.plugin.util.RangerPluginCapability;
import org.apache.ranger.plugin.util.RangerRESTClient;
import org.apache.ranger.plugin.util.RangerRESTUtils;
import org.apache.ranger.plugin.util.RangerRoles;
import org.apache.ranger.plugin.util.RangerServiceNotFoundException;
import org.apache.ranger.plugin.util.RangerUserStore;
import org.apache.ranger.plugin.util.ServicePolicies;
import org.apache.ranger.plugin.util.ServiceTags;
import org.apache.ranger.plugin.util.URLEncoderUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RangerAdminRESTClient
extends AbstractRangerAdminClient {
    private static final Logger LOG = LoggerFactory.getLogger(RangerAdminRESTClient.class);
    private static final TypeReference<List<String>> TYPE_LIST_STRING = new TypeReference<List<String>>(){};
    private String serviceName;
    private String serviceNameUrlParam;
    private String pluginId;
    private String clusterName;
    private RangerRESTClient restClient;
    private RangerRESTUtils restUtils = new RangerRESTUtils();
    private boolean supportsPolicyDeltas;
    private boolean supportsTagDeltas;
    private boolean isRangerCookieEnabled;
    private String rangerAdminCookieName;
    private Cookie policyDownloadSessionId = null;
    private boolean isValidPolicyDownloadSessionCookie = false;
    private Cookie tagDownloadSessionId = null;
    private boolean isValidTagDownloadSessionCookie = false;
    private Cookie roleDownloadSessionId = null;
    private boolean isValidRoleDownloadSessionCookie = false;
    private final String pluginCapabilities = Long.toHexString(new RangerPluginCapability().getPluginCapabilities());

    @Override
    public void init(String serviceName, String appId, String propertyPrefix, Configuration config) {
        super.init(serviceName, appId, propertyPrefix, config);
        this.serviceName = serviceName;
        this.pluginId = this.restUtils.getPluginId(serviceName, appId);
        String url = "";
        String tmpUrl = config.get(propertyPrefix + ".policy.rest.url");
        String sslConfigFileName = config.get(propertyPrefix + ".policy.rest.ssl.config.file");
        this.clusterName = config.get(propertyPrefix + ".access.cluster.name", "");
        if (StringUtil.isEmpty(this.clusterName)) {
            this.clusterName = config.get(propertyPrefix + ".ambari.cluster.name", "");
            if (StringUtil.isEmpty(this.clusterName) && config instanceof RangerPluginConfig) {
                this.clusterName = ((RangerPluginConfig)config).getClusterName();
            }
        }
        int restClientConnTimeOutMs = config.getInt(propertyPrefix + ".policy.rest.client.connection.timeoutMs", 120000);
        int restClientReadTimeOutMs = config.getInt(propertyPrefix + ".policy.rest.client.read.timeoutMs", 30000);
        int restClientMaxRetryAttempts = config.getInt(propertyPrefix + ".policy.rest.client.max.retry.attempts", 3);
        int restClientRetryIntervalMs = config.getInt(propertyPrefix + ".policy.rest.client.retry.interval.ms", 1000);
        this.supportsPolicyDeltas = config.getBoolean(propertyPrefix + ".supports.policy.deltas", false);
        this.supportsTagDeltas = config.getBoolean(propertyPrefix + ".supports.tag.deltas", false);
        this.isRangerCookieEnabled = config.getBoolean(propertyPrefix + ".policy.rest.client.cookie.enabled", true);
        this.rangerAdminCookieName = config.get(propertyPrefix + ".policy.rest.client.session.cookie.name", "RANGERADMINSESSIONID");
        if (!StringUtil.isEmpty(tmpUrl)) {
            url = tmpUrl.trim();
        }
        if (url.endsWith("/")) {
            url = url.substring(0, url.length() - 1);
        }
        this.init(url, sslConfigFileName, restClientConnTimeOutMs, restClientReadTimeOutMs, restClientMaxRetryAttempts, restClientRetryIntervalMs, config);
        try {
            this.serviceNameUrlParam = URLEncoderUtil.encodeURIParam(serviceName);
        }
        catch (UnsupportedEncodingException e) {
            LOG.warn("Unsupported encoding, serviceName=" + serviceName);
            this.serviceNameUrlParam = serviceName;
        }
    }

    @Override
    public ServicePolicies getServicePoliciesIfUpdated(long lastKnownVersion, long lastActivationTimeInMillis) throws Exception {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> RangerAdminRESTClient.getServicePoliciesIfUpdated(" + lastKnownVersion + ", " + lastActivationTimeInMillis + ")");
        }
        ServicePolicies ret = this.isRangerCookieEnabled && this.policyDownloadSessionId != null && this.isValidPolicyDownloadSessionCookie ? this.getServicePoliciesIfUpdatedWithCookie(lastKnownVersion, lastActivationTimeInMillis) : this.getServicePoliciesIfUpdatedWithCred(lastKnownVersion, lastActivationTimeInMillis);
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== RangerAdminRESTClient.getServicePoliciesIfUpdated(" + lastKnownVersion + ", " + lastActivationTimeInMillis + "): " + ret);
        }
        return ret;
    }

    @Override
    public RangerRoles getRolesIfUpdated(long lastKnownRoleVersion, long lastActivationTimeInMillis) throws Exception {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> RangerAdminRESTClient.getRolesIfUpdated(" + lastKnownRoleVersion + ", " + lastActivationTimeInMillis + ")");
        }
        RangerRoles ret = this.isRangerCookieEnabled && this.roleDownloadSessionId != null && this.isValidRoleDownloadSessionCookie ? this.getRolesIfUpdatedWithCookie(lastKnownRoleVersion, lastActivationTimeInMillis) : this.getRolesIfUpdatedWithCred(lastKnownRoleVersion, lastActivationTimeInMillis);
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== RangerAdminRESTClient.getRolesIfUpdated(" + lastKnownRoleVersion + ", " + lastActivationTimeInMillis + "): ");
        }
        return ret;
    }

    @Override
    public RangerRole createRole(final RangerRole request) throws Exception {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> RangerAdminRESTClient.createRole(" + request + ")");
        }
        RangerRole ret = null;
        ClientResponse response = null;
        UserGroupInformation user = MiscUtil.getUGILoginUser();
        boolean isSecureMode = this.isKerberosEnabled(user);
        final String relativeURL = "/service/public/v2/api/roles/";
        final HashMap<String, String> queryParams = new HashMap<String, String>();
        queryParams.put("serviceName", this.serviceNameUrlParam);
        if (isSecureMode) {
            PrivilegedAction<ClientResponse> action = new PrivilegedAction<ClientResponse>(){

                @Override
                public ClientResponse run() {
                    ClientResponse clientRes = null;
                    try {
                        clientRes = RangerAdminRESTClient.this.restClient.post(relativeURL, queryParams, request);
                    }
                    catch (Exception e) {
                        LOG.error("Failed to get response, Error is : " + e.getMessage());
                    }
                    return clientRes;
                }
            };
            if (LOG.isDebugEnabled()) {
                LOG.debug("create role as user " + user);
            }
            response = (ClientResponse)user.doAs((PrivilegedAction)action);
        } else {
            response = this.restClient.post(relativeURL, queryParams, request);
        }
        if (response != null && response.getStatus() != 200) {
            RESTResponse resp = RESTResponse.fromClientResponse(response);
            LOG.error("createRole() failed: HTTP status=" + response.getStatus() + ", message=" + resp.getMessage() + ", isSecure=" + isSecureMode + (isSecureMode ? ", user=" + user : ""));
            if (response.getStatus() == 401) {
                throw new AccessControlException();
            }
            throw new Exception("HTTP " + response.getStatus() + " Error: " + resp.getMessage());
        }
        if (response == null) {
            throw new Exception("unknown error during createRole. roleName=" + request.getName());
        }
        ret = JsonUtilsV2.readResponse(response, RangerRole.class);
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== RangerAdminRESTClient.createRole(" + request + ")");
        }
        return ret;
    }

    @Override
    public void dropRole(String execUser, String roleName) throws Exception {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> RangerAdminRESTClient.dropRole(" + roleName + ")");
        }
        ClientResponse response = null;
        UserGroupInformation user = MiscUtil.getUGILoginUser();
        boolean isSecureMode = this.isKerberosEnabled(user);
        final HashMap<String, String> queryParams = new HashMap<String, String>();
        queryParams.put("serviceName", this.serviceNameUrlParam);
        queryParams.put("execUser", execUser);
        final String relativeURL = "/service/public/v2/api/roles/name/" + roleName;
        if (isSecureMode) {
            PrivilegedAction<ClientResponse> action = new PrivilegedAction<ClientResponse>(){

                @Override
                public ClientResponse run() {
                    ClientResponse clientRes = null;
                    try {
                        clientRes = RangerAdminRESTClient.this.restClient.delete(relativeURL, queryParams);
                    }
                    catch (Exception e) {
                        LOG.error("Failed to get response, Error is : " + e.getMessage());
                    }
                    return clientRes;
                }
            };
            if (LOG.isDebugEnabled()) {
                LOG.debug("drop role as user " + user);
            }
            response = (ClientResponse)user.doAs((PrivilegedAction)action);
        } else {
            response = this.restClient.delete(relativeURL, queryParams);
        }
        if (response == null) {
            throw new Exception("unknown error during deleteRole. roleName=" + roleName);
        }
        if (response.getStatus() != 200 && response.getStatus() != 204) {
            RESTResponse resp = RESTResponse.fromClientResponse(response);
            LOG.error("createRole() failed: HTTP status=" + response.getStatus() + ", message=" + resp.getMessage() + ", isSecure=" + isSecureMode + (isSecureMode ? ", user=" + user : ""));
            if (response.getStatus() == 401) {
                throw new AccessControlException();
            }
            throw new Exception("HTTP " + response.getStatus() + " Error: " + resp.getMessage());
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== RangerAdminRESTClient.deleteRole(" + roleName + ")");
        }
    }

    @Override
    public List<String> getUserRoles(String execUser) throws Exception {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> RangerAdminRESTClient.getUserRoles(" + execUser + ")");
        }
        List<String> ret = null;
        String emptyString = "";
        ClientResponse response = null;
        UserGroupInformation user = MiscUtil.getUGILoginUser();
        boolean isSecureMode = this.isKerberosEnabled(user);
        final String relativeURL = "/service/public/v2/api/roles/user/" + execUser;
        if (isSecureMode) {
            PrivilegedAction<ClientResponse> action = new PrivilegedAction<ClientResponse>(){

                @Override
                public ClientResponse run() {
                    ClientResponse clientRes = null;
                    try {
                        clientRes = RangerAdminRESTClient.this.restClient.get(relativeURL, null);
                    }
                    catch (Exception e) {
                        LOG.error("Failed to get response, Error is : " + e.getMessage());
                    }
                    return clientRes;
                }
            };
            if (LOG.isDebugEnabled()) {
                LOG.debug("get roles as user " + user);
            }
            response = (ClientResponse)user.doAs((PrivilegedAction)action);
        } else {
            response = this.restClient.get(relativeURL, null);
        }
        if (response != null) {
            if (response.getStatus() != 200) {
                RESTResponse resp = RESTResponse.fromClientResponse(response);
                LOG.error("getUserRoles() failed: HTTP status=" + response.getStatus() + ", message=" + resp.getMessage() + ", isSecure=" + isSecureMode + (isSecureMode ? ", user=" + user : ""));
                if (response.getStatus() == 401) {
                    throw new AccessControlException();
                }
                throw new Exception("HTTP " + response.getStatus() + " Error: " + resp.getMessage());
            }
        } else {
            throw new Exception("unknown error during getUserRoles. execUser=" + execUser);
        }
        ret = JsonUtilsV2.readResponse(response, TYPE_LIST_STRING);
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== RangerAdminRESTClient.getUserRoles(" + execUser + ")");
        }
        return ret;
    }

    @Override
    public List<String> getAllRoles(String execUser) throws Exception {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> RangerAdminRESTClient.getAllRoles()");
        }
        List<String> ret = null;
        String emptyString = "";
        ClientResponse response = null;
        UserGroupInformation user = MiscUtil.getUGILoginUser();
        boolean isSecureMode = this.isKerberosEnabled(user);
        final String relativeURL = "/service/public/v2/api/roles/names/";
        final HashMap<String, String> queryParams = new HashMap<String, String>();
        queryParams.put("serviceName", this.serviceNameUrlParam);
        queryParams.put("execUser", execUser);
        if (isSecureMode) {
            PrivilegedAction<ClientResponse> action = new PrivilegedAction<ClientResponse>(){

                @Override
                public ClientResponse run() {
                    ClientResponse clientRes = null;
                    try {
                        clientRes = RangerAdminRESTClient.this.restClient.get(relativeURL, queryParams);
                    }
                    catch (Exception e) {
                        LOG.error("Failed to get response, Error is : " + e.getMessage());
                    }
                    return clientRes;
                }
            };
            if (LOG.isDebugEnabled()) {
                LOG.debug("get roles as user " + user);
            }
            response = (ClientResponse)user.doAs((PrivilegedAction)action);
        } else {
            response = this.restClient.get(relativeURL, queryParams);
        }
        if (response != null) {
            if (response.getStatus() != 200) {
                RESTResponse resp = RESTResponse.fromClientResponse(response);
                LOG.error("getAllRoles() failed: HTTP status=" + response.getStatus() + ", message=" + resp.getMessage() + ", isSecure=" + isSecureMode + (isSecureMode ? ", user=" + user : ""));
                if (response.getStatus() == 401) {
                    throw new AccessControlException();
                }
                throw new Exception("HTTP " + response.getStatus() + " Error: " + resp.getMessage());
            }
        } else {
            throw new Exception("unknown error during getAllRoles.");
        }
        ret = JsonUtilsV2.readResponse(response, TYPE_LIST_STRING);
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== RangerAdminRESTClient.getAllRoles()");
        }
        return ret;
    }

    @Override
    public RangerRole getRole(String execUser, String roleName) throws Exception {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> RangerAdminRESTClient.getPrincipalsForRole(" + roleName + ")");
        }
        RangerRole ret = null;
        ClientResponse response = null;
        UserGroupInformation user = MiscUtil.getUGILoginUser();
        boolean isSecureMode = this.isKerberosEnabled(user);
        final String relativeURL = "/service/public/v2/api/roles/name/" + roleName;
        final HashMap<String, String> queryParams = new HashMap<String, String>();
        queryParams.put("serviceName", this.serviceNameUrlParam);
        queryParams.put("execUser", execUser);
        if (isSecureMode) {
            PrivilegedAction<ClientResponse> action = new PrivilegedAction<ClientResponse>(){

                @Override
                public ClientResponse run() {
                    ClientResponse clientResp = null;
                    try {
                        clientResp = RangerAdminRESTClient.this.restClient.get(relativeURL, queryParams);
                    }
                    catch (Exception e) {
                        LOG.error("Failed to get response, Error is : " + e.getMessage());
                    }
                    return clientResp;
                }
            };
            if (LOG.isDebugEnabled()) {
                LOG.debug("get role info as user " + user);
            }
            response = (ClientResponse)user.doAs((PrivilegedAction)action);
        } else {
            response = this.restClient.get(relativeURL, queryParams);
        }
        if (response != null) {
            if (response.getStatus() != 200) {
                RESTResponse resp = RESTResponse.fromClientResponse(response);
                LOG.error("getPrincipalsForRole() failed: HTTP status=" + response.getStatus() + ", message=" + resp.getMessage() + ", isSecure=" + isSecureMode + (isSecureMode ? ", user=" + user : ""));
                if (response.getStatus() == 401) {
                    throw new AccessControlException();
                }
                throw new Exception("HTTP " + response.getStatus() + " Error: " + resp.getMessage());
            }
        } else {
            throw new Exception("unknown error during getPrincipalsForRole. roleName=" + roleName);
        }
        ret = JsonUtilsV2.readResponse(response, RangerRole.class);
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== RangerAdminRESTClient.getPrincipalsForRole(" + roleName + ")");
        }
        return ret;
    }

    @Override
    public void grantRole(final GrantRevokeRoleRequest request) throws Exception {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> RangerAdminRESTClient.grantRole(" + request + ")");
        }
        ClientResponse response = null;
        UserGroupInformation user = MiscUtil.getUGILoginUser();
        boolean isSecureMode = this.isKerberosEnabled(user);
        final String relativeURL = "/service/public/v2/api/roles/grant/" + this.serviceNameUrlParam;
        if (isSecureMode) {
            PrivilegedAction<ClientResponse> action = new PrivilegedAction<ClientResponse>(){

                @Override
                public ClientResponse run() {
                    ClientResponse clientResp = null;
                    try {
                        clientResp = RangerAdminRESTClient.this.restClient.put(relativeURL, null, request);
                    }
                    catch (Exception e) {
                        LOG.error("Failed to get response, Error is : " + e.getMessage());
                    }
                    return clientResp;
                }
            };
            if (LOG.isDebugEnabled()) {
                LOG.debug("grant role as user " + user);
            }
            response = (ClientResponse)user.doAs((PrivilegedAction)action);
        } else {
            response = this.restClient.put(relativeURL, null, request);
        }
        if (response != null && response.getStatus() != 200) {
            RESTResponse resp = RESTResponse.fromClientResponse(response);
            LOG.error("grantRole() failed: HTTP status=" + response.getStatus() + ", message=" + resp.getMessage() + ", isSecure=" + isSecureMode + (isSecureMode ? ", user=" + user : ""));
            if (response.getStatus() == 401) {
                throw new AccessControlException();
            }
            throw new Exception("HTTP " + response.getStatus() + " Error: " + resp.getMessage());
        }
        if (response == null) {
            throw new Exception("unknown error during grantRole. serviceName=" + this.serviceName);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== RangerAdminRESTClient.grantRole(" + request + ")");
        }
    }

    @Override
    public void revokeRole(final GrantRevokeRoleRequest request) throws Exception {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> RangerAdminRESTClient.revokeRole(" + request + ")");
        }
        ClientResponse response = null;
        UserGroupInformation user = MiscUtil.getUGILoginUser();
        boolean isSecureMode = this.isKerberosEnabled(user);
        final String relativeURL = "/service/public/v2/api/roles/revoke/" + this.serviceNameUrlParam;
        if (isSecureMode) {
            PrivilegedAction<ClientResponse> action = new PrivilegedAction<ClientResponse>(){

                @Override
                public ClientResponse run() {
                    ClientResponse clientResp = null;
                    try {
                        clientResp = RangerAdminRESTClient.this.restClient.put(relativeURL, null, request);
                    }
                    catch (Exception e) {
                        LOG.error("Failed to get response, Error is : " + e.getMessage());
                    }
                    return clientResp;
                }
            };
            if (LOG.isDebugEnabled()) {
                LOG.debug("revoke role as user " + user);
            }
            response = (ClientResponse)user.doAs((PrivilegedAction)action);
        } else {
            response = this.restClient.put(relativeURL, null, request);
        }
        if (response != null && response.getStatus() != 200) {
            RESTResponse resp = RESTResponse.fromClientResponse(response);
            LOG.error("revokeRole() failed: HTTP status=" + response.getStatus() + ", message=" + resp.getMessage() + ", isSecure=" + isSecureMode + (isSecureMode ? ", user=" + user : ""));
            if (response.getStatus() == 401) {
                throw new AccessControlException();
            }
            throw new Exception("HTTP " + response.getStatus() + " Error: " + resp.getMessage());
        }
        if (response == null) {
            throw new Exception("unknown error during revokeRole. serviceName=" + this.serviceName);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== RangerAdminRESTClient.revokeRole(" + request + ")");
        }
    }

    @Override
    public void grantAccess(final GrantRevokeRequest request) throws Exception {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> RangerAdminRESTClient.grantAccess(" + request + ")");
        }
        ClientResponse response = null;
        UserGroupInformation user = MiscUtil.getUGILoginUser();
        boolean isSecureMode = this.isKerberosEnabled(user);
        final HashMap<String, String> queryParams = new HashMap<String, String>();
        queryParams.put("pluginId", this.pluginId);
        if (isSecureMode) {
            PrivilegedAction<ClientResponse> action = new PrivilegedAction<ClientResponse>(){

                @Override
                public ClientResponse run() {
                    String relativeURL = "/service/plugins/secure/services/grant/" + RangerAdminRESTClient.this.serviceNameUrlParam;
                    ClientResponse clientResp = null;
                    try {
                        clientResp = RangerAdminRESTClient.this.restClient.post(relativeURL, queryParams, request);
                    }
                    catch (Exception e) {
                        LOG.error("Failed to get response, Error is : " + e.getMessage());
                    }
                    return clientResp;
                }
            };
            if (LOG.isDebugEnabled()) {
                LOG.debug("grantAccess as user " + user);
            }
            response = (ClientResponse)user.doAs((PrivilegedAction)action);
        } else {
            String relativeURL = "/service/plugins/services/grant/" + this.serviceNameUrlParam;
            response = this.restClient.post(relativeURL, queryParams, request);
        }
        if (response != null && response.getStatus() != 200) {
            RESTResponse resp = RESTResponse.fromClientResponse(response);
            LOG.error("grantAccess() failed: HTTP status=" + response.getStatus() + ", message=" + resp.getMessage() + ", isSecure=" + isSecureMode + (isSecureMode ? ", user=" + user : ""));
            if (response.getStatus() == 401) {
                throw new AccessControlException();
            }
            throw new Exception("HTTP " + response.getStatus() + " Error: " + resp.getMessage());
        }
        if (response == null) {
            throw new Exception("unknown error during grantAccess. serviceName=" + this.serviceName);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== RangerAdminRESTClient.grantAccess(" + request + ")");
        }
    }

    @Override
    public void revokeAccess(final GrantRevokeRequest request) throws Exception {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> RangerAdminRESTClient.revokeAccess(" + request + ")");
        }
        ClientResponse response = null;
        UserGroupInformation user = MiscUtil.getUGILoginUser();
        boolean isSecureMode = this.isKerberosEnabled(user);
        final HashMap<String, String> queryParams = new HashMap<String, String>();
        queryParams.put("pluginId", this.pluginId);
        if (isSecureMode) {
            PrivilegedAction<ClientResponse> action = new PrivilegedAction<ClientResponse>(){

                @Override
                public ClientResponse run() {
                    String relativeURL = "/service/plugins/secure/services/revoke/" + RangerAdminRESTClient.this.serviceNameUrlParam;
                    ClientResponse clientResp = null;
                    try {
                        clientResp = RangerAdminRESTClient.this.restClient.post(relativeURL, queryParams, request);
                    }
                    catch (Exception e) {
                        LOG.error("Failed to get response, Error is : " + e.getMessage());
                    }
                    return clientResp;
                }
            };
            if (LOG.isDebugEnabled()) {
                LOG.debug("revokeAccess as user " + user);
            }
            response = (ClientResponse)user.doAs((PrivilegedAction)action);
        } else {
            String relativeURL = "/service/plugins/services/revoke/" + this.serviceNameUrlParam;
            response = this.restClient.post(relativeURL, queryParams, request);
        }
        if (response != null && response.getStatus() != 200) {
            RESTResponse resp = RESTResponse.fromClientResponse(response);
            LOG.error("revokeAccess() failed: HTTP status=" + response.getStatus() + ", message=" + resp.getMessage() + ", isSecure=" + isSecureMode + (isSecureMode ? ", user=" + user : ""));
            if (response.getStatus() == 401) {
                throw new AccessControlException();
            }
            throw new Exception("HTTP " + response.getStatus() + " Error: " + resp.getMessage());
        }
        if (response == null) {
            throw new Exception("unknown error. revokeAccess(). serviceName=" + this.serviceName);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== RangerAdminRESTClient.revokeAccess(" + request + ")");
        }
    }

    private void init(String url, String sslConfigFileName, int restClientConnTimeOutMs, int restClientReadTimeOutMs, int restClientMaxRetryAttempts, int restClientRetryIntervalMs, Configuration config) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> RangerAdminRESTClient.init(" + url + ", " + sslConfigFileName + ")");
        }
        this.restClient = new RangerRESTClient(url, sslConfigFileName, config);
        this.restClient.setRestClientConnTimeOutMs(restClientConnTimeOutMs);
        this.restClient.setRestClientReadTimeOutMs(restClientReadTimeOutMs);
        this.restClient.setMaxRetryAttempts(restClientMaxRetryAttempts);
        this.restClient.setRetryIntervalMs(restClientRetryIntervalMs);
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== RangerAdminRESTClient.init(" + url + ", " + sslConfigFileName + ")");
        }
    }

    @Override
    public ServiceTags getServiceTagsIfUpdated(long lastKnownVersion, long lastActivationTimeInMillis) throws Exception {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> RangerAdminRESTClient.getServiceTagsIfUpdated(" + lastKnownVersion + ", " + lastActivationTimeInMillis + "): ");
        }
        ServiceTags ret = this.isRangerCookieEnabled && this.tagDownloadSessionId != null && this.isValidTagDownloadSessionCookie ? this.getServiceTagsIfUpdatedWithCookie(lastKnownVersion, lastActivationTimeInMillis) : this.getServiceTagsIfUpdatedWithCred(lastKnownVersion, lastActivationTimeInMillis);
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== RangerAdminRESTClient.getServiceTagsIfUpdated(" + lastKnownVersion + ", " + lastActivationTimeInMillis + "): ");
        }
        return ret;
    }

    @Override
    public List<String> getTagTypes(String pattern) throws Exception {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> RangerAdminRESTClient.getTagTypes(" + pattern + "): ");
        }
        List<String> ret = null;
        String emptyString = "";
        UserGroupInformation user = MiscUtil.getUGILoginUser();
        boolean isSecureMode = this.isKerberosEnabled(user);
        final HashMap<String, String> queryParams = new HashMap<String, String>();
        queryParams.put("serviceName", this.serviceNameUrlParam);
        queryParams.put("pattern", pattern);
        final String relativeURL = "/service/tags/lookup";
        ClientResponse response = null;
        if (isSecureMode) {
            PrivilegedAction<ClientResponse> action = new PrivilegedAction<ClientResponse>(){

                @Override
                public ClientResponse run() {
                    ClientResponse clientResp = null;
                    try {
                        clientResp = RangerAdminRESTClient.this.restClient.get(relativeURL, queryParams);
                    }
                    catch (Exception e) {
                        LOG.error("Failed to get response, Error is : " + e.getMessage());
                    }
                    return clientResp;
                }
            };
            if (LOG.isDebugEnabled()) {
                LOG.debug("getTagTypes as user " + user);
            }
            response = (ClientResponse)user.doAs((PrivilegedAction)action);
        } else {
            response = this.restClient.get(relativeURL, queryParams);
        }
        if (response == null || response.getStatus() != 200) {
            RESTResponse resp = RESTResponse.fromClientResponse(response);
            LOG.error("Error getting tags. response=" + resp + ", serviceName=" + this.serviceName + ", pattern=" + pattern);
            throw new Exception(resp.getMessage());
        }
        ret = JsonUtilsV2.readResponse(response, TYPE_LIST_STRING);
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== RangerAdminRESTClient.getTagTypes(" + pattern + "): " + ret);
        }
        return ret;
    }

    @Override
    public RangerUserStore getUserStoreIfUpdated(long lastKnownUserStoreVersion, long lastActivationTimeInMillis) throws Exception {
        RangerUserStore ret;
        RESTResponse resp;
        ClientResponse response;
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> RangerAdminRESTClient.getUserStoreIfUpdated(" + lastKnownUserStoreVersion + ", " + lastActivationTimeInMillis + ")");
        }
        UserGroupInformation user = MiscUtil.getUGILoginUser();
        boolean isSecureMode = this.isKerberosEnabled(user);
        final HashMap<String, String> queryParams = new HashMap<String, String>();
        queryParams.put("lastKnownUserStoreVersion", Long.toString(lastKnownUserStoreVersion));
        queryParams.put("lastActivationTime", Long.toString(lastActivationTimeInMillis));
        queryParams.put("pluginId", this.pluginId);
        queryParams.put("clusterName", this.clusterName);
        queryParams.put("pluginCapabilities", this.pluginCapabilities);
        if (isSecureMode) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Checking UserStore updated as user : " + user);
            }
            PrivilegedAction<ClientResponse> action = new PrivilegedAction<ClientResponse>(){

                @Override
                public ClientResponse run() {
                    ClientResponse clientRes = null;
                    String relativeURL = "/service/xusers/secure/download/" + RangerAdminRESTClient.this.serviceNameUrlParam;
                    try {
                        clientRes = RangerAdminRESTClient.this.restClient.get(relativeURL, queryParams);
                    }
                    catch (Exception e) {
                        LOG.error("Failed to get response, Error is : " + e.getMessage());
                    }
                    return clientRes;
                }
            };
            response = (ClientResponse)user.doAs((PrivilegedAction)action);
        } else {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Checking UserStore updated as user : " + user);
            }
            String relativeURL = "/service/xusers/download/" + this.serviceNameUrlParam;
            response = this.restClient.get(relativeURL, queryParams);
        }
        if (response == null || response.getStatus() == 304) {
            if (response == null) {
                LOG.error("Error getting UserStore; Received NULL response!!. secureMode=" + isSecureMode + ", user=" + user + ", serviceName=" + this.serviceName);
            } else {
                resp = RESTResponse.fromClientResponse(response);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("No change in UserStore. secureMode=" + isSecureMode + ", user=" + user + ", response=" + resp + ", serviceName=" + this.serviceName + ", lastKnownUserStoreVersion=" + lastKnownUserStoreVersion + ", lastActivationTimeInMillis=" + lastActivationTimeInMillis);
                }
            }
            ret = null;
        } else if (response.getStatus() == 200) {
            ret = JsonUtilsV2.readResponse(response, RangerUserStore.class);
        } else if (response.getStatus() == 404) {
            ret = null;
            LOG.error("Error getting UserStore; service not found. secureMode=" + isSecureMode + ", user=" + user + ", response=" + response.getStatus() + ", serviceName=" + this.serviceName + ", lastKnownUserStoreVersion=" + lastKnownUserStoreVersion + ", lastActivationTimeInMillis=" + lastActivationTimeInMillis);
            String exceptionMsg = response.hasEntity() ? response.getEntity(String.class) : null;
            RangerServiceNotFoundException.throwExceptionIfServiceNotFound(this.serviceName, exceptionMsg);
            LOG.warn("Received 404 error code with body:[" + exceptionMsg + "], Ignoring");
        } else {
            resp = RESTResponse.fromClientResponse(response);
            LOG.warn("Error getting UserStore. secureMode=" + isSecureMode + ", user=" + user + ", response=" + resp + ", serviceName=" + this.serviceName);
            ret = null;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== RangerAdminRESTClient.getUserStoreIfUpdated(" + lastKnownUserStoreVersion + ", " + lastActivationTimeInMillis + "): ");
        }
        return ret;
    }

    private ServicePolicies getServicePoliciesIfUpdatedWithCred(long lastKnownVersion, long lastActivationTimeInMillis) throws Exception {
        ServicePolicies ret;
        boolean isSecureMode;
        UserGroupInformation user;
        ClientResponse response;
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> RangerAdminRESTClient.getServicePoliciesIfUpdatedWithCred(" + lastKnownVersion + ", " + lastActivationTimeInMillis + ")");
        }
        if ((response = this.getRangerAdminPolicyDownloadResponse(lastKnownVersion, lastActivationTimeInMillis, user = MiscUtil.getUGILoginUser(), isSecureMode = this.isKerberosEnabled(user))) == null || response.getStatus() == 304 || response.getStatus() == 204) {
            if (response == null) {
                this.policyDownloadSessionId = null;
                LOG.error("Error getting policies; Received NULL response!!. secureMode=" + isSecureMode + ", user=" + user + ", serviceName=" + this.serviceName);
            } else {
                this.setCookieReceivedFromCredSession(response);
                RESTResponse resp = RESTResponse.fromClientResponse(response);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("No change in policies. secureMode=" + isSecureMode + ", user=" + user + ", response=" + resp + ", serviceName=" + this.serviceName);
                }
            }
            ret = null;
        } else if (response.getStatus() == 200) {
            this.setCookieReceivedFromCredSession(response);
            ret = JsonUtilsV2.readResponse(response, ServicePolicies.class);
        } else if (response.getStatus() == 404) {
            this.policyDownloadSessionId = null;
            ret = null;
            LOG.error("Error getting policies; service not found. secureMode=" + isSecureMode + ", user=" + user + ", response=" + response.getStatus() + ", serviceName=" + this.serviceName + ", lastKnownVersion=" + lastKnownVersion + ", lastActivationTimeInMillis=" + lastActivationTimeInMillis);
            String exceptionMsg = response.hasEntity() ? response.getEntity(String.class) : null;
            RangerServiceNotFoundException.throwExceptionIfServiceNotFound(this.serviceName, exceptionMsg);
            LOG.warn("Received 404 error code with body:[" + exceptionMsg + "], Ignoring");
        } else {
            this.policyDownloadSessionId = null;
            ret = null;
            RESTResponse resp = RESTResponse.fromClientResponse(response);
            LOG.warn("Error getting policies. secureMode=" + isSecureMode + ", user=" + user + ", response=" + resp + ", serviceName=" + this.serviceName);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== RangerAdminRESTClient.getServicePoliciesIfUpdatedWithCred(" + lastKnownVersion + ", " + lastActivationTimeInMillis + "): " + ret);
        }
        return ret;
    }

    private ServicePolicies getServicePoliciesIfUpdatedWithCookie(long lastKnownVersion, long lastActivationTimeInMillis) throws Exception {
        ServicePolicies ret;
        boolean isSecureMode;
        UserGroupInformation user;
        ClientResponse response;
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> RangerAdminRESTClient.getServicePoliciesIfUpdatedWithCookie(" + lastKnownVersion + ", " + lastActivationTimeInMillis + ")");
        }
        if ((response = this.getRangerAdminPolicyDownloadResponse(lastKnownVersion, lastActivationTimeInMillis, user = MiscUtil.getUGILoginUser(), isSecureMode = this.isKerberosEnabled(user))) == null || response.getStatus() == 304 || response.getStatus() == 204) {
            if (response == null) {
                this.policyDownloadSessionId = null;
                this.isValidPolicyDownloadSessionCookie = false;
                LOG.error("Error getting policies; Received NULL response!!. secureMode=" + isSecureMode + ", user=" + user + ", serviceName=" + this.serviceName);
            } else {
                this.checkAndResetSessionCookie(response);
                RESTResponse resp = RESTResponse.fromClientResponse(response);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("No change in policies. secureMode=" + isSecureMode + ", user=" + user + ", response=" + resp + ", serviceName=" + this.serviceName);
                }
            }
            ret = null;
        } else if (response.getStatus() == 200) {
            this.checkAndResetSessionCookie(response);
            ret = JsonUtilsV2.readResponse(response, ServicePolicies.class);
        } else if (response.getStatus() == 404) {
            this.policyDownloadSessionId = null;
            this.isValidPolicyDownloadSessionCookie = false;
            ret = null;
            LOG.error("Error getting policies; service not found. secureMode=" + isSecureMode + ", user=" + user + ", response=" + response.getStatus() + ", serviceName=" + this.serviceName + ", lastKnownVersion=" + lastKnownVersion + ", lastActivationTimeInMillis=" + lastActivationTimeInMillis);
            String exceptionMsg = response.hasEntity() ? response.getEntity(String.class) : null;
            RangerServiceNotFoundException.throwExceptionIfServiceNotFound(this.serviceName, exceptionMsg);
            LOG.warn("Received 404 error code with body:[" + exceptionMsg + "], Ignoring");
        } else {
            this.policyDownloadSessionId = null;
            this.isValidPolicyDownloadSessionCookie = false;
            ret = null;
            RESTResponse resp = RESTResponse.fromClientResponse(response);
            LOG.warn("Error getting policies. secureMode=" + isSecureMode + ", user=" + user + ", response=" + resp + ", serviceName=" + this.serviceName);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== RangerAdminRESTClient.getServicePoliciesIfUpdatedWithCookie(" + lastKnownVersion + ", " + lastActivationTimeInMillis + "): " + ret);
        }
        return ret;
    }

    private ClientResponse getRangerAdminPolicyDownloadResponse(long lastKnownVersion, long lastActivationTimeInMillis, UserGroupInformation user, boolean isSecureMode) throws Exception {
        ClientResponse ret;
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> RangerAdminRESTClient.getRangerAdminPolicyDownloadResponse(" + lastKnownVersion + ", " + lastActivationTimeInMillis + ")");
        }
        final HashMap<String, String> queryParams = new HashMap<String, String>();
        queryParams.put("lastKnownVersion", Long.toString(lastKnownVersion));
        queryParams.put("lastActivationTime", Long.toString(lastActivationTimeInMillis));
        queryParams.put("pluginId", this.pluginId);
        queryParams.put("clusterName", this.clusterName);
        queryParams.put("supportsPolicyDeltas", Boolean.toString(this.supportsPolicyDeltas));
        queryParams.put("pluginCapabilities", this.pluginCapabilities);
        if (isSecureMode) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Checking Service policy if updated as user : " + user);
            }
            PrivilegedAction<ClientResponse> action = new PrivilegedAction<ClientResponse>(){

                @Override
                public ClientResponse run() {
                    String relativeURL = "/service/plugins/secure/policies/download/" + RangerAdminRESTClient.this.serviceNameUrlParam;
                    ClientResponse clientResp = null;
                    try {
                        clientResp = RangerAdminRESTClient.this.restClient.get(relativeURL, queryParams, RangerAdminRESTClient.this.policyDownloadSessionId);
                    }
                    catch (Exception e) {
                        LOG.error("Failed to get response, Error is : " + e.getMessage());
                    }
                    return clientResp;
                }
            };
            ret = (ClientResponse)user.doAs((PrivilegedAction)action);
        } else {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Checking Service policy if updated with old api call");
            }
            String relativeURL = "/service/plugins/policies/download/" + this.serviceNameUrlParam;
            ret = this.restClient.get(relativeURL, queryParams, this.policyDownloadSessionId);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== RangerAdminRESTClient.getRangerAdminPolicyDownloadResponse(" + lastKnownVersion + ", " + lastActivationTimeInMillis + "): " + ret);
        }
        return ret;
    }

    private void checkAndResetSessionCookie(ClientResponse response) {
        List<NewCookie> respCookieList = response.getCookies();
        for (NewCookie respCookie : respCookieList) {
            if (!respCookie.getName().equalsIgnoreCase(this.rangerAdminCookieName)) continue;
            this.policyDownloadSessionId = respCookie;
            this.isValidPolicyDownloadSessionCookie = this.policyDownloadSessionId != null;
            break;
        }
    }

    private void setCookieReceivedFromCredSession(ClientResponse clientResponse) {
        if (this.isRangerCookieEnabled) {
            Cookie sessionCookie = null;
            List<NewCookie> cookieList = clientResponse.getCookies();
            for (NewCookie cookie : cookieList) {
                if (!cookie.getName().equalsIgnoreCase(this.rangerAdminCookieName)) continue;
                sessionCookie = cookie.toCookie();
                break;
            }
            this.policyDownloadSessionId = sessionCookie;
            this.isValidPolicyDownloadSessionCookie = this.policyDownloadSessionId != null;
        }
    }

    private ServiceTags getServiceTagsIfUpdatedWithCred(long lastKnownVersion, long lastActivationTimeInMillis) throws Exception {
        ServiceTags ret;
        boolean isSecureMode;
        UserGroupInformation user;
        ClientResponse response;
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> RangerAdminRESTClient.getServiceTagsIfUpdatedWithCred(" + lastKnownVersion + ", " + lastActivationTimeInMillis + ")");
        }
        if ((response = this.getRangerAdminTagDownloadResponse(lastKnownVersion, lastActivationTimeInMillis, user = MiscUtil.getUGILoginUser(), isSecureMode = this.isKerberosEnabled(user))) == null || response.getStatus() == 304) {
            if (response == null) {
                this.tagDownloadSessionId = null;
                LOG.error("Error getting tags; Received NULL response!!. secureMode=" + isSecureMode + ", user=" + user + ", serviceName=" + this.serviceName);
            } else {
                this.setCookieReceivedFromTagDownloadSession(response);
                RESTResponse resp = RESTResponse.fromClientResponse(response);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("No change in tags. secureMode=" + isSecureMode + ", user=" + user + ", response=" + resp + ", serviceName=" + this.serviceName + ", lastKnownVersion=" + lastKnownVersion + ", lastActivationTimeInMillis=" + lastActivationTimeInMillis);
                }
            }
            ret = null;
        } else if (response.getStatus() == 200) {
            this.setCookieReceivedFromTagDownloadSession(response);
            ret = JsonUtilsV2.readResponse(response, ServiceTags.class);
        } else if (response.getStatus() == 404) {
            this.tagDownloadSessionId = null;
            ret = null;
            LOG.error("Error getting tags; service not found. secureMode=" + isSecureMode + ", user=" + user + ", response=" + response.getStatus() + ", serviceName=" + this.serviceName + ", lastKnownVersion=" + lastKnownVersion + ", lastActivationTimeInMillis=" + lastActivationTimeInMillis);
            String exceptionMsg = response.hasEntity() ? response.getEntity(String.class) : null;
            RangerServiceNotFoundException.throwExceptionIfServiceNotFound(this.serviceName, exceptionMsg);
            LOG.warn("Received 404 error code with body:[" + exceptionMsg + "], Ignoring");
        } else {
            RESTResponse resp = RESTResponse.fromClientResponse(response);
            LOG.warn("Error getting tags. secureMode=" + isSecureMode + ", user=" + user + ", response=" + resp + ", serviceName=" + this.serviceName);
            this.tagDownloadSessionId = null;
            ret = null;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== RangerAdminRESTClient.getServiceTagsIfUpdatedWithCred(" + lastKnownVersion + ", " + lastActivationTimeInMillis + "): " + ret);
        }
        return ret;
    }

    private ServiceTags getServiceTagsIfUpdatedWithCookie(long lastKnownVersion, long lastActivationTimeInMillis) throws Exception {
        ServiceTags ret;
        boolean isSecureMode;
        UserGroupInformation user;
        ClientResponse response;
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> RangerAdminRESTClient.getServiceTagsIfUpdatedWithCookie(" + lastKnownVersion + ", " + lastActivationTimeInMillis + ")");
        }
        if ((response = this.getRangerAdminTagDownloadResponse(lastKnownVersion, lastActivationTimeInMillis, user = MiscUtil.getUGILoginUser(), isSecureMode = this.isKerberosEnabled(user))) == null || response.getStatus() == 304) {
            if (response == null) {
                this.tagDownloadSessionId = null;
                this.isValidTagDownloadSessionCookie = false;
                LOG.error("Error getting tags; Received NULL response!!. secureMode=" + isSecureMode + ", user=" + user + ", serviceName=" + this.serviceName);
            } else {
                this.checkAndResetTagDownloadSessionCookie(response);
                RESTResponse resp = RESTResponse.fromClientResponse(response);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("No change in tags. secureMode=" + isSecureMode + ", user=" + user + ", response=" + resp + ", serviceName=" + this.serviceName + ", lastKnownVersion=" + lastKnownVersion + ", lastActivationTimeInMillis=" + lastActivationTimeInMillis);
                }
            }
            ret = null;
        } else if (response.getStatus() == 200) {
            this.checkAndResetTagDownloadSessionCookie(response);
            ret = JsonUtilsV2.readResponse(response, ServiceTags.class);
        } else if (response.getStatus() == 404) {
            this.tagDownloadSessionId = null;
            this.isValidTagDownloadSessionCookie = false;
            ret = null;
            LOG.error("Error getting tags; service not found. secureMode=" + isSecureMode + ", user=" + user + ", response=" + response.getStatus() + ", serviceName=" + this.serviceName + ", lastKnownVersion=" + lastKnownVersion + ", lastActivationTimeInMillis=" + lastActivationTimeInMillis);
            String exceptionMsg = response.hasEntity() ? response.getEntity(String.class) : null;
            RangerServiceNotFoundException.throwExceptionIfServiceNotFound(this.serviceName, exceptionMsg);
            LOG.warn("Received 404 error code with body:[" + exceptionMsg + "], Ignoring");
        } else {
            RESTResponse resp = RESTResponse.fromClientResponse(response);
            LOG.warn("Error getting tags. secureMode=" + isSecureMode + ", user=" + user + ", response=" + resp + ", serviceName=" + this.serviceName);
            this.tagDownloadSessionId = null;
            this.isValidTagDownloadSessionCookie = false;
            ret = null;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== RangerAdminRESTClient.getServiceTagsIfUpdatedWithCookie(" + lastKnownVersion + ", " + lastActivationTimeInMillis + "): " + ret);
        }
        return ret;
    }

    private ClientResponse getRangerAdminTagDownloadResponse(long lastKnownVersion, long lastActivationTimeInMillis, UserGroupInformation user, boolean isSecureMode) throws Exception {
        ClientResponse ret;
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> RangerAdminRESTClient.getRangerAdminTagDownloadResponse(" + lastKnownVersion + ", " + lastActivationTimeInMillis + ")");
        }
        final HashMap<String, String> queryParams = new HashMap<String, String>();
        queryParams.put("lastKnownVersion", Long.toString(lastKnownVersion));
        queryParams.put("lastActivationTime", Long.toString(lastActivationTimeInMillis));
        queryParams.put("pluginId", this.pluginId);
        queryParams.put("supportsTagDeltas", Boolean.toString(this.supportsTagDeltas));
        queryParams.put("pluginCapabilities", this.pluginCapabilities);
        if (isSecureMode) {
            PrivilegedAction<ClientResponse> action = new PrivilegedAction<ClientResponse>(){

                @Override
                public ClientResponse run() {
                    String relativeURL = "/service/tags/secure/download/" + RangerAdminRESTClient.this.serviceNameUrlParam;
                    ClientResponse clientResp = null;
                    try {
                        clientResp = RangerAdminRESTClient.this.restClient.get(relativeURL, queryParams, RangerAdminRESTClient.this.tagDownloadSessionId);
                    }
                    catch (Exception e) {
                        LOG.error("Failed to get response, Error is : " + e.getMessage());
                    }
                    return clientResp;
                }
            };
            if (LOG.isDebugEnabled()) {
                LOG.debug("getServiceTagsIfUpdated as user " + user);
            }
            ret = (ClientResponse)user.doAs((PrivilegedAction)action);
        } else {
            String relativeURL = "/service/tags/download/" + this.serviceNameUrlParam;
            ret = this.restClient.get(relativeURL, queryParams);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== RangerAdminRESTClient.getRangerAdminTagDownloadResponse(" + lastKnownVersion + ", " + lastActivationTimeInMillis + "): " + ret);
        }
        return ret;
    }

    private void checkAndResetTagDownloadSessionCookie(ClientResponse response) {
        List<NewCookie> respCookieList = response.getCookies();
        for (NewCookie respCookie : respCookieList) {
            if (!respCookie.getName().equalsIgnoreCase(this.rangerAdminCookieName)) continue;
            this.tagDownloadSessionId = respCookie;
            this.isValidTagDownloadSessionCookie = this.tagDownloadSessionId != null;
            break;
        }
    }

    private void setCookieReceivedFromTagDownloadSession(ClientResponse clientResponse) {
        if (this.isRangerCookieEnabled) {
            Cookie sessionCookie = null;
            List<NewCookie> cookieList = clientResponse.getCookies();
            for (NewCookie cookie : cookieList) {
                if (!cookie.getName().equalsIgnoreCase(this.rangerAdminCookieName)) continue;
                sessionCookie = cookie.toCookie();
                break;
            }
            this.tagDownloadSessionId = sessionCookie;
            this.isValidTagDownloadSessionCookie = this.tagDownloadSessionId != null;
        }
    }

    private RangerRoles getRolesIfUpdatedWithCred(long lastKnownRoleVersion, long lastActivationTimeInMillis) throws Exception {
        RangerRoles ret;
        boolean isSecureMode;
        UserGroupInformation user;
        ClientResponse response;
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> RangerAdminRESTClient.getRolesIfUpdatedWithCred(" + lastKnownRoleVersion + ", " + lastActivationTimeInMillis + ")");
        }
        if ((response = this.getRangerRolesDownloadResponse(lastKnownRoleVersion, lastActivationTimeInMillis, user = MiscUtil.getUGILoginUser(), isSecureMode = this.isKerberosEnabled(user))) == null || response.getStatus() == 304 || response.getStatus() == 204) {
            if (response == null) {
                this.roleDownloadSessionId = null;
                LOG.error("Error getting Roles; Received NULL response!!. secureMode=" + isSecureMode + ", user=" + user + ", serviceName=" + this.serviceName);
            } else {
                this.setCookieReceivedFromRoleDownloadSession(response);
                RESTResponse resp = RESTResponse.fromClientResponse(response);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("No change in Roles. secureMode=" + isSecureMode + ", user=" + user + ", response=" + resp + ", serviceName=" + this.serviceName + ", lastKnownRoleVersion=" + lastKnownRoleVersion + ", lastActivationTimeInMillis=" + lastActivationTimeInMillis);
                }
            }
            ret = null;
        } else if (response.getStatus() == 200) {
            this.setCookieReceivedFromRoleDownloadSession(response);
            ret = JsonUtilsV2.readResponse(response, RangerRoles.class);
        } else if (response.getStatus() == 404) {
            this.roleDownloadSessionId = null;
            ret = null;
            LOG.error("Error getting Roles; service not found. secureMode=" + isSecureMode + ", user=" + user + ", response=" + response.getStatus() + ", serviceName=" + this.serviceName + ", lastKnownRoleVersion=" + lastKnownRoleVersion + ", lastActivationTimeInMillis=" + lastActivationTimeInMillis);
            String exceptionMsg = response.hasEntity() ? response.getEntity(String.class) : null;
            RangerServiceNotFoundException.throwExceptionIfServiceNotFound(this.serviceName, exceptionMsg);
            LOG.warn("Received 404 error code with body:[" + exceptionMsg + "], Ignoring");
        } else {
            RESTResponse resp = RESTResponse.fromClientResponse(response);
            LOG.warn("Error getting Roles. secureMode=" + isSecureMode + ", user=" + user + ", response=" + resp + ", serviceName=" + this.serviceName);
            this.roleDownloadSessionId = null;
            ret = null;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== RangerAdminRESTClient.getRolesIfUpdatedWithCred(" + lastKnownRoleVersion + ", " + lastActivationTimeInMillis + "): " + ret);
        }
        return ret;
    }

    private RangerRoles getRolesIfUpdatedWithCookie(long lastKnownRoleVersion, long lastActivationTimeInMillis) throws Exception {
        RangerRoles ret;
        boolean isSecureMode;
        UserGroupInformation user;
        ClientResponse response;
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> RangerAdminRESTClient.getRolesIfUpdatedWithCookie(" + lastKnownRoleVersion + ", " + lastActivationTimeInMillis + ")");
        }
        if ((response = this.getRangerRolesDownloadResponse(lastKnownRoleVersion, lastActivationTimeInMillis, user = MiscUtil.getUGILoginUser(), isSecureMode = this.isKerberosEnabled(user))) == null || response.getStatus() == 304 || response.getStatus() == 204) {
            if (response == null) {
                this.roleDownloadSessionId = null;
                this.isValidRoleDownloadSessionCookie = false;
                LOG.error("Error getting Roles; Received NULL response!!. secureMode=" + isSecureMode + ", user=" + user + ", serviceName=" + this.serviceName);
            } else {
                this.checkAndResetRoleDownloadSessionCookie(response);
                RESTResponse resp = RESTResponse.fromClientResponse(response);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("No change in Roles. secureMode=" + isSecureMode + ", user=" + user + ", response=" + resp + ", serviceName=" + this.serviceName + ", lastKnownRoleVersion=" + lastKnownRoleVersion + ", lastActivationTimeInMillis=" + lastActivationTimeInMillis);
                }
            }
            ret = null;
        } else if (response.getStatus() == 200) {
            this.checkAndResetRoleDownloadSessionCookie(response);
            ret = JsonUtilsV2.readResponse(response, RangerRoles.class);
        } else if (response.getStatus() == 404) {
            this.roleDownloadSessionId = null;
            this.isValidRoleDownloadSessionCookie = false;
            ret = null;
            LOG.error("Error getting Roles; service not found. secureMode=" + isSecureMode + ", user=" + user + ", response=" + response.getStatus() + ", serviceName=" + this.serviceName + ", lastKnownRoleVersion=" + lastKnownRoleVersion + ", lastActivationTimeInMillis=" + lastActivationTimeInMillis);
            String exceptionMsg = response.hasEntity() ? response.getEntity(String.class) : null;
            RangerServiceNotFoundException.throwExceptionIfServiceNotFound(this.serviceName, exceptionMsg);
            LOG.warn("Received 404 error code with body:[" + exceptionMsg + "], Ignoring");
        } else {
            RESTResponse resp = RESTResponse.fromClientResponse(response);
            LOG.warn("Error getting Roles. secureMode=" + isSecureMode + ", user=" + user + ", response=" + resp + ", serviceName=" + this.serviceName);
            this.roleDownloadSessionId = null;
            this.isValidRoleDownloadSessionCookie = false;
            ret = null;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== RangerAdminRESTClient.getRolesIfUpdatedWithCookie(" + lastKnownRoleVersion + ", " + lastActivationTimeInMillis + "): " + ret);
        }
        return ret;
    }

    private ClientResponse getRangerRolesDownloadResponse(long lastKnownRoleVersion, long lastActivationTimeInMillis, UserGroupInformation user, boolean isSecureMode) throws Exception {
        ClientResponse ret;
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> RangerAdminRESTClient.getRangerRolesDownloadResponse(" + lastKnownRoleVersion + ", " + lastActivationTimeInMillis + ")");
        }
        final HashMap<String, String> queryParams = new HashMap<String, String>();
        queryParams.put("lastKnownRoleVersion", Long.toString(lastKnownRoleVersion));
        queryParams.put("lastActivationTime", Long.toString(lastActivationTimeInMillis));
        queryParams.put("pluginId", this.pluginId);
        queryParams.put("clusterName", this.clusterName);
        queryParams.put("pluginCapabilities", this.pluginCapabilities);
        if (isSecureMode) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Checking Roles updated as user : " + user);
            }
            PrivilegedAction<ClientResponse> action = new PrivilegedAction<ClientResponse>(){

                @Override
                public ClientResponse run() {
                    ClientResponse clientRes = null;
                    String relativeURL = "/service/roles/secure/download/" + RangerAdminRESTClient.this.serviceNameUrlParam;
                    try {
                        clientRes = RangerAdminRESTClient.this.restClient.get(relativeURL, queryParams, RangerAdminRESTClient.this.roleDownloadSessionId);
                    }
                    catch (Exception e) {
                        LOG.error("Failed to get response, Error is : " + e.getMessage());
                    }
                    return clientRes;
                }
            };
            ret = (ClientResponse)user.doAs((PrivilegedAction)action);
        } else {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Checking Roles updated as user : " + user);
            }
            String relativeURL = "/service/roles/download/" + this.serviceNameUrlParam;
            ret = this.restClient.get(relativeURL, queryParams);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== RangerAdminRESTClient.getRangerRolesDownloadResponse(" + lastKnownRoleVersion + ", " + lastActivationTimeInMillis + "): " + ret);
        }
        return ret;
    }

    private void checkAndResetRoleDownloadSessionCookie(ClientResponse response) {
        List<NewCookie> respCookieList = response.getCookies();
        for (NewCookie respCookie : respCookieList) {
            if (!respCookie.getName().equalsIgnoreCase(this.rangerAdminCookieName)) continue;
            this.roleDownloadSessionId = respCookie;
            this.isValidRoleDownloadSessionCookie = this.roleDownloadSessionId != null;
            break;
        }
    }

    private void setCookieReceivedFromRoleDownloadSession(ClientResponse clientResponse) {
        if (this.isRangerCookieEnabled) {
            Cookie sessionCookie = null;
            List<NewCookie> cookieList = clientResponse.getCookies();
            for (NewCookie cookie : cookieList) {
                if (!cookie.getName().equalsIgnoreCase(this.rangerAdminCookieName)) continue;
                sessionCookie = cookie.toCookie();
                break;
            }
            this.roleDownloadSessionId = sessionCookie;
            this.isValidRoleDownloadSessionCookie = this.roleDownloadSessionId != null;
        }
    }
}

