/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.admin.client.datatype;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.kyuubi.shade.com.fasterxml.jackson.annotation.JsonAutoDetect;
import org.apache.kyuubi.shade.com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import org.apache.kyuubi.shade.com.fasterxml.jackson.annotation.JsonInclude;
import org.apache.ranger.authorization.utils.StringUtil;
import org.apache.ranger.plugin.util.JsonUtilsV2;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.NONE, setterVisibility=JsonAutoDetect.Visibility.NONE, fieldVisibility=JsonAutoDetect.Visibility.ANY)
@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonIgnoreProperties(ignoreUnknown=true)
public class GrantRevokeData
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String grantor;
    private String repositoryName;
    private String repositoryType;
    private String databases;
    private String tables;
    private String columns;
    private String columnFamilies;
    private List<PermMap> permMapList = new ArrayList<PermMap>();
    private static String WILDCARD_ASTERISK = "*";

    public String getGrantor() {
        return this.grantor;
    }

    public void setGrantor(String grantor) {
        this.grantor = grantor;
    }

    public String getRepositoryName() {
        return this.repositoryName;
    }

    public void setRepositoryName(String repositoryName) {
        this.repositoryName = repositoryName;
    }

    public String getRepositoryType() {
        return this.repositoryType;
    }

    public void setRepositoryType(String repositoryType) {
        this.repositoryType = repositoryType;
    }

    public String getDatabases() {
        return this.databases;
    }

    public void setDatabases(String databases) {
        this.databases = databases;
    }

    public String getTables() {
        return this.tables;
    }

    public void setTables(String tables) {
        this.tables = tables;
    }

    public String getColumns() {
        return this.columns;
    }

    public void setColumns(String columns) {
        this.columns = columns;
    }

    public String getColumnFamilies() {
        return this.columnFamilies;
    }

    public void setColumnFamilies(String columnFamilies) {
        this.columnFamilies = columnFamilies;
    }

    public List<PermMap> getPermMapList() {
        return this.permMapList;
    }

    public void setPermMapList(List<PermMap> permMapList) {
        this.permMapList = permMapList;
    }

    public void setHiveData(String grantor, String repositoryName, String databases, String tables, String columns, PermMap permMap) {
        this.grantor = grantor;
        this.repositoryName = repositoryName;
        this.repositoryType = "hive";
        this.databases = StringUtil.isEmpty(databases) ? WILDCARD_ASTERISK : databases;
        this.tables = StringUtil.isEmpty(tables) ? WILDCARD_ASTERISK : tables;
        this.columns = StringUtil.isEmpty(columns) ? WILDCARD_ASTERISK : columns;
        this.permMapList.add(permMap);
    }

    public void setHBaseData(String grantor, String repositoryName, String tables, String columns, String columnFamilies, PermMap permMap) {
        this.grantor = grantor;
        this.repositoryName = repositoryName;
        this.repositoryType = "hbase";
        this.tables = StringUtil.isEmpty(tables) ? WILDCARD_ASTERISK : tables;
        this.columns = StringUtil.isEmpty(columns) ? WILDCARD_ASTERISK : columns;
        this.columnFamilies = StringUtil.isEmpty(columnFamilies) ? WILDCARD_ASTERISK : columnFamilies;
        this.permMapList.add(permMap);
    }

    public String toJson() {
        try {
            return JsonUtilsV2.objToJson(this);
        }
        catch (Exception e) {
            e.printStackTrace();
            return "";
        }
    }

    public String toString() {
        return this.toJson();
    }

    public static void main(String[] args) {
        GrantRevokeData grData = new GrantRevokeData();
        System.out.println(grData.toString());
    }

    @JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.NONE, setterVisibility=JsonAutoDetect.Visibility.NONE, fieldVisibility=JsonAutoDetect.Visibility.ANY)
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class PermMap
    implements Serializable {
        private List<String> userList = new ArrayList<String>();
        private List<String> groupList = new ArrayList<String>();
        private List<String> permList = new ArrayList<String>();

        public PermMap() {
        }

        public PermMap(String user, String group, String perm) {
            this.addUser(user);
            this.addGroup(group);
            this.addPerm(perm);
        }

        public PermMap(List<String> userList, List<String> groupList, List<String> permList) {
            this.copyList(userList, this.userList);
            this.copyList(groupList, this.groupList);
            this.copyList(permList, this.permList);
        }

        public List<String> getUserList() {
            return this.userList;
        }

        public List<String> getGroupList() {
            return this.groupList;
        }

        public List<String> getPermList() {
            return this.permList;
        }

        public void addUser(String user) {
            this.addToList(user, this.userList);
        }

        public void addGroup(String group) {
            this.addToList(group, this.groupList);
        }

        public void addPerm(String perm) {
            this.addToList(perm, this.permList);
        }

        private void addToList(String str, List<String> list) {
            if (list != null && !StringUtil.isEmpty(str)) {
                list.add(str);
            }
        }

        private void copyList(List<String> fromList, List<String> toList) {
            if (fromList != null && toList != null) {
                for (String str : fromList) {
                    this.addToList(str, toList);
                }
            }
        }

        public String toJson() {
            try {
                return JsonUtilsV2.objToJson(this);
            }
            catch (Exception e) {
                e.printStackTrace();
                return "";
            }
        }

        public String toString() {
            return this.toJson();
        }
    }
}

