/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.authorization.utils;

import java.io.Reader;
import java.io.Writer;
import java.text.SimpleDateFormat;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.kyuubi.shade.com.fasterxml.jackson.core.JsonParser;
import org.apache.kyuubi.shade.com.fasterxml.jackson.core.JsonProcessingException;
import org.apache.kyuubi.shade.com.fasterxml.jackson.core.type.TypeReference;
import org.apache.kyuubi.shade.com.fasterxml.jackson.databind.DeserializationFeature;
import org.apache.kyuubi.shade.com.fasterxml.jackson.databind.JsonMappingException;
import org.apache.kyuubi.shade.com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.ranger.plugin.model.AuditFilter;
import org.apache.ranger.plugin.model.RangerPolicy;
import org.apache.ranger.plugin.model.RangerPrincipal;
import org.apache.ranger.plugin.model.RangerTag;
import org.apache.ranger.plugin.model.RangerValidityRecurrence;
import org.apache.ranger.plugin.model.RangerValiditySchedule;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonUtils {
    private static final Logger LOG = LoggerFactory.getLogger(JsonUtils.class);
    private static final TypeReference TYPE_MAP_STRING_STRING = new TypeReference<Map<String, String>>(){};
    private static final TypeReference TYPE_SET_STRING = new TypeReference<Set<String>>(){};
    private static final TypeReference TYPE_LIST_STRING = new TypeReference<List<String>>(){};
    private static final TypeReference TYPE_LIST_RANGER_VALIDITY_SCHEDULE = new TypeReference<List<RangerValiditySchedule>>(){};
    private static final TypeReference TYPE_LIST_AUDIT_FILTER = new TypeReference<List<AuditFilter>>(){};
    private static final TypeReference TYPE_LIST_RANGER_VALIDITY_RECURRENCE = new TypeReference<List<RangerValidityRecurrence>>(){};
    private static final TypeReference TYPE_LIST_RANGER_PRINCIPAL = new TypeReference<List<RangerPrincipal>>(){};
    private static final TypeReference TYPE_MAP_RANGER_MASK_INFO = new TypeReference<Map<String, RangerPolicy.RangerPolicyItemDataMaskInfo>>(){};
    private static final TypeReference TYPE_MAP_RANGER_POLICY_RESOURCE = new TypeReference<Map<String, RangerPolicy.RangerPolicyResource>>(){};
    private static final TypeReference TYPE_LIST_RANGER_TAG = new TypeReference<List<RangerTag>>(){};
    private static final ThreadLocal<ObjectMapper> MAPPER = new ThreadLocal<ObjectMapper>(){

        @Override
        protected ObjectMapper initialValue() {
            ObjectMapper objectMapper = new ObjectMapper();
            objectMapper.setDateFormat(new SimpleDateFormat("yyyyMMdd-HH:mm:ss.SSS-Z"));
            objectMapper.configure(JsonParser.Feature.ALLOW_SINGLE_QUOTES, true);
            objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
            return objectMapper;
        }
    };

    public static ObjectMapper getMapper() {
        return MAPPER.get();
    }

    public static String mapToJson(Map<?, ?> map) {
        String ret = null;
        if (MapUtils.isNotEmpty(map)) {
            try {
                ret = JsonUtils.getMapper().writeValueAsString(map);
            }
            catch (Exception e) {
                LOG.error("Invalid input data: ", (Throwable)e);
            }
        }
        return ret;
    }

    public static String listToJson(List<?> list) {
        String ret = null;
        if (CollectionUtils.isNotEmpty(list)) {
            try {
                ret = JsonUtils.getMapper().writeValueAsString(list);
            }
            catch (Exception e) {
                LOG.error("Invalid input data: ", (Throwable)e);
            }
        }
        return ret;
    }

    public static String setToJson(Set<?> set) {
        String ret = null;
        if (CollectionUtils.isNotEmpty(set)) {
            try {
                ret = JsonUtils.getMapper().writeValueAsString(set);
            }
            catch (Exception e) {
                LOG.error("Invalid input data: ", (Throwable)e);
            }
        }
        return ret;
    }

    public static String objectToJson(Object object) {
        String ret = null;
        if (object != null) {
            try {
                ret = JsonUtils.getMapper().writeValueAsString(object);
            }
            catch (Exception excp) {
                LOG.warn("objectToJson() failed to convert object to Json", (Throwable)excp);
            }
        }
        return ret;
    }

    public static <T> T jsonToObject(Reader reader, Class<T> clz) {
        T ret = null;
        if (null != reader) {
            try {
                ret = JsonUtils.getMapper().readValue(reader, clz);
            }
            catch (Exception excp) {
                LOG.warn("jsonToObject() failed to convert json to object: class " + clz + " reader ", (Throwable)excp);
            }
        }
        return ret;
    }

    public static <T> void objectToWriter(Writer writer, T object) {
        if (null != writer) {
            try {
                JsonUtils.getMapper().writeValue(writer, object);
            }
            catch (Exception excp) {
                LOG.warn("objectToWriter() failed to write oject to writer: class " + object + " writer ", (Throwable)excp);
            }
        }
    }

    public static <T> T jsonToObject(String jsonStr, Class<T> clz) {
        T ret = null;
        if (StringUtils.isNotEmpty((String)jsonStr)) {
            try {
                ret = JsonUtils.getMapper().readValue(jsonStr, clz);
            }
            catch (Exception excp) {
                LOG.warn("jsonToObject() failed to convert json to object: class " + clz + " JSON " + jsonStr, (Throwable)excp);
            }
        }
        return ret;
    }

    public static <T> T jsonToObject(String jsonStr, TypeReference<T> valueTypeRef) throws JsonProcessingException, JsonMappingException {
        T ret = null;
        if (StringUtils.isNotEmpty((String)jsonStr)) {
            try {
                ret = JsonUtils.getMapper().readValue(jsonStr, valueTypeRef);
            }
            catch (Exception excp) {
                LOG.warn("jsonToObject() failed to convert json to object: " + jsonStr, (Throwable)excp);
            }
        }
        return ret;
    }

    public static Map<String, String> jsonToMapStringString(String jsonStr) {
        Map ret = null;
        if (StringUtils.isNotEmpty((String)jsonStr)) {
            try {
                ret = (Map)JsonUtils.getMapper().readValue(jsonStr, TYPE_MAP_STRING_STRING);
            }
            catch (Exception excp) {
                LOG.warn("jsonToMapStringString() failed to convert json to object: " + jsonStr, (Throwable)excp);
            }
        }
        return ret;
    }

    public static Set<String> jsonToSetString(String jsonStr) {
        Set ret = null;
        if (StringUtils.isNotEmpty((String)jsonStr)) {
            try {
                ret = (Set)JsonUtils.getMapper().readValue(jsonStr, TYPE_SET_STRING);
            }
            catch (Exception excp) {
                LOG.warn("jsonToSetString() failed to convert json to object: " + jsonStr, (Throwable)excp);
            }
        }
        return ret;
    }

    public static List<String> jsonToListString(String jsonStr) {
        List ret = null;
        if (StringUtils.isNotEmpty((String)jsonStr)) {
            try {
                ret = (List)JsonUtils.getMapper().readValue(jsonStr, TYPE_LIST_STRING);
            }
            catch (Exception excp) {
                LOG.warn("jsonToListString() failed to convert json to object: " + jsonStr, (Throwable)excp);
            }
        }
        return ret;
    }

    public static List<RangerValiditySchedule> jsonToRangerValiditySchedule(String jsonStr) {
        try {
            return (List)JsonUtils.getMapper().readValue(jsonStr, TYPE_LIST_RANGER_VALIDITY_SCHEDULE);
        }
        catch (Exception e) {
            LOG.error("Cannot get List<RangerValiditySchedule> from " + jsonStr, (Throwable)e);
            return null;
        }
    }

    public static List<AuditFilter> jsonToAuditFilterList(String jsonStr) {
        try {
            return (List)JsonUtils.getMapper().readValue(jsonStr, TYPE_LIST_AUDIT_FILTER);
        }
        catch (Exception e) {
            LOG.error("failed to create audit filters from: " + jsonStr, (Throwable)e);
            return null;
        }
    }

    public static List<RangerValidityRecurrence> jsonToRangerValidityRecurringSchedule(String jsonStr) {
        try {
            return (List)JsonUtils.getMapper().readValue(jsonStr, TYPE_LIST_RANGER_VALIDITY_RECURRENCE);
        }
        catch (Exception e) {
            LOG.error("Cannot get List<RangerValidityRecurrence> from " + jsonStr, (Throwable)e);
            return null;
        }
    }

    public static List<RangerPrincipal> jsonToRangerPrincipalList(String jsonStr) {
        try {
            return (List)JsonUtils.getMapper().readValue(jsonStr, TYPE_LIST_RANGER_PRINCIPAL);
        }
        catch (Exception e) {
            LOG.error("Cannot get List<RangerPrincipal> from " + jsonStr, (Throwable)e);
            return null;
        }
    }

    public static List<RangerTag> jsonToRangerTagList(String jsonStr) {
        try {
            return (List)JsonUtils.getMapper().readValue(jsonStr, TYPE_LIST_RANGER_TAG);
        }
        catch (Exception e) {
            LOG.error("Cannot get List<RangerTag> from " + jsonStr, (Throwable)e);
            return null;
        }
    }

    public static Map<String, RangerPolicy.RangerPolicyItemDataMaskInfo> jsonToMapMaskInfo(String jsonStr) {
        try {
            return (Map)JsonUtils.getMapper().readValue(jsonStr, TYPE_MAP_RANGER_MASK_INFO);
        }
        catch (Exception e) {
            LOG.error("Cannot get Map<String, RangerPolicyItemDataMaskInfo> from " + jsonStr, (Throwable)e);
            return null;
        }
    }

    public static Map<String, RangerPolicy.RangerPolicyResource> jsonToMapPolicyResource(String jsonStr) {
        try {
            return (Map)JsonUtils.getMapper().readValue(jsonStr, TYPE_MAP_RANGER_POLICY_RESOURCE);
        }
        catch (Exception e) {
            LOG.error("Cannot get Map<String, RangerPolicyResource> from " + jsonStr, (Throwable)e);
            return null;
        }
    }
}

