/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.plugin.model;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.kyuubi.shade.com.fasterxml.jackson.annotation.JsonAutoDetect;
import org.apache.kyuubi.shade.com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import org.apache.kyuubi.shade.com.fasterxml.jackson.annotation.JsonInclude;
import org.apache.ranger.authorization.utils.StringUtil;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.NONE, setterVisibility=JsonAutoDetect.Visibility.NONE, fieldVisibility=JsonAutoDetect.Visibility.ANY)
@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonIgnoreProperties(ignoreUnknown=true)
public class RangerBaseModelObject
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String NULL_SAFE_SUPPLIER_V2 = "v2";
    private static NullSafeSupplier NULL_SAFE_SUPPLIER = NullSafeSupplierV1.INSTANCE;
    private Long id;
    private String guid;
    private Boolean isEnabled;
    private String createdBy;
    private String updatedBy;
    private Date createTime;
    private Date updateTime;
    private Long version;

    public RangerBaseModelObject() {
        this.setIsEnabled(null);
    }

    public void updateFrom(RangerBaseModelObject other) {
        this.setIsEnabled(other.getIsEnabled());
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getGuid() {
        return this.guid;
    }

    public void setGuid(String guid) {
        this.guid = guid;
    }

    public Boolean getIsEnabled() {
        return this.isEnabled;
    }

    public void setIsEnabled(Boolean isEnabled) {
        this.isEnabled = isEnabled == null ? Boolean.TRUE : isEnabled;
    }

    public String getCreatedBy() {
        return this.createdBy;
    }

    public void setCreatedBy(String createdBy) {
        this.createdBy = createdBy;
    }

    public String getUpdatedBy() {
        return this.updatedBy;
    }

    public void setUpdatedBy(String updatedBy) {
        this.updatedBy = updatedBy;
    }

    public Date getCreateTime() {
        return this.createTime;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    public Date getUpdateTime() {
        return this.updateTime;
    }

    public void setUpdateTime(Date updateTime) {
        this.updateTime = updateTime;
    }

    public Long getVersion() {
        return this.version;
    }

    public void setVersion(Long version) {
        this.version = version;
    }

    public void dedupStrings(Map<String, String> strTbl) {
        this.createdBy = StringUtil.dedupString(this.createdBy, strTbl);
        this.updatedBy = StringUtil.dedupString(this.updatedBy, strTbl);
    }

    public static <T> List<T> nullSafeList(List<T> coll) {
        return NULL_SAFE_SUPPLIER.toList(coll);
    }

    public static <T> Set<T> nullSafeSet(Set<T> coll) {
        return NULL_SAFE_SUPPLIER.toSet(coll);
    }

    public static <K, V> Map<K, V> nullSafeMap(Map<K, V> coll) {
        return NULL_SAFE_SUPPLIER.toMap(coll);
    }

    public static <T> List<T> getUpdatableList(List<T> curr) {
        List<Object> ret = curr instanceof ArrayList ? curr : (curr != null ? new ArrayList<T>(curr) : new ArrayList());
        return ret;
    }

    public static <T> Set<T> getUpdatableSet(Set<T> curr) {
        Set<Object> ret = curr instanceof HashSet ? curr : (curr != null ? new HashSet<T>(curr) : new HashSet());
        return ret;
    }

    public static <K, V> Map<K, V> getUpdatableMap(Map<K, V> curr) {
        Map<K, V> ret = curr instanceof HashMap ? curr : (curr != null ? new HashMap<K, V>(curr) : new HashMap());
        return ret;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        this.toString(sb);
        return sb.toString();
    }

    public StringBuilder toString(StringBuilder sb) {
        sb.append("id={").append(this.id).append("} ");
        sb.append("guid={").append(this.guid).append("} ");
        sb.append("isEnabled={").append(this.isEnabled).append("} ");
        sb.append("createdBy={").append(this.createdBy).append("} ");
        sb.append("updatedBy={").append(this.updatedBy).append("} ");
        sb.append("createTime={").append(this.createTime).append("} ");
        sb.append("updateTime={").append(this.updateTime).append("} ");
        sb.append("version={").append(this.version).append("} ");
        return sb;
    }

    protected NullSafeSupplier getNullSafeSupplier() {
        return NULL_SAFE_SUPPLIER;
    }

    public static void setNullSafeSupplier(NullSafeSupplier supplier) {
        NULL_SAFE_SUPPLIER = supplier == null ? NullSafeSupplierV1.INSTANCE : supplier;
    }

    public static void setNullSafeSupplier(String supplier) {
        NULL_SAFE_SUPPLIER = NULL_SAFE_SUPPLIER_V2.equalsIgnoreCase(supplier) ? NullSafeSupplierV2.INSTANCE : NullSafeSupplierV1.INSTANCE;
    }

    public static class NullSafeSupplierV2
    extends NullSafeSupplier {
        public static final NullSafeSupplierV2 INSTANCE = new NullSafeSupplierV2();

        private NullSafeSupplierV2() {
        }

        @Override
        public <T> List<T> toList(List<T> coll) {
            return coll == null || coll.isEmpty() ? Collections.emptyList() : coll;
        }

        @Override
        public <T> Set<T> toSet(Set<T> coll) {
            return coll == null || coll.isEmpty() ? Collections.emptySet() : coll;
        }

        @Override
        public <K, V> Map<K, V> toMap(Map<K, V> coll) {
            return coll == null || coll.isEmpty() ? Collections.emptyMap() : coll;
        }
    }

    public static class NullSafeSupplierV1
    extends NullSafeSupplier {
        public static final NullSafeSupplierV1 INSTANCE = new NullSafeSupplierV1();

        private NullSafeSupplierV1() {
        }

        @Override
        public <T> List<T> toList(List<T> coll) {
            return coll == null || coll.isEmpty() ? new ArrayList<T>() : new ArrayList<T>(coll);
        }

        @Override
        public <T> Set<T> toSet(Set<T> coll) {
            return coll == null || coll.isEmpty() ? new HashSet<T>() : new HashSet<T>(coll);
        }

        @Override
        public <K, V> Map<K, V> toMap(Map<K, V> coll) {
            return coll == null || coll.isEmpty() ? new HashMap<K, V>() : new HashMap<K, V>(coll);
        }
    }

    public static abstract class NullSafeSupplier {
        public abstract <T> List<T> toList(List<T> var1);

        public abstract <T> Set<T> toSet(Set<T> var1);

        public abstract <K, V> Map<K, V> toMap(Map<K, V> var1);
    }
}

