/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.plugin.model;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.kyuubi.shade.com.fasterxml.jackson.annotation.JsonAutoDetect;
import org.apache.kyuubi.shade.com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import org.apache.kyuubi.shade.com.fasterxml.jackson.annotation.JsonInclude;
import org.apache.ranger.plugin.model.RangerBaseModelObject;
import org.apache.ranger.plugin.model.RangerPrincipal;
import org.apache.ranger.plugin.model.RangerSecurityZoneV2;

@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY)
@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonIgnoreProperties(ignoreUnknown=true)
public class RangerSecurityZone
extends RangerBaseModelObject
implements Serializable {
    public static final long RANGER_UNZONED_SECURITY_ZONE_ID = 1L;
    private static final long serialVersionUID = 1L;
    private String name;
    private Map<String, RangerSecurityZoneService> services;
    private List<String> tagServices;
    private List<String> adminUsers;
    private List<String> adminUserGroups;
    private List<String> adminRoles;
    private List<String> auditUsers;
    private List<String> auditUserGroups;
    private List<String> auditRoles;
    private String description;

    public RangerSecurityZone() {
        this(null, null, null, null, null, null, null, null, null, null);
    }

    public RangerSecurityZone(String name, Map<String, RangerSecurityZoneService> services, List<String> tagServices, List<String> adminUsers, List<String> adminUserGroups, List<String> auditUsers, List<String> auditUserGroups, String description) {
        this(name, services, tagServices, adminUsers, adminUserGroups, null, auditUsers, auditUserGroups, null, description);
    }

    public RangerSecurityZone(String name, Map<String, RangerSecurityZoneService> services, List<String> tagServices, List<String> adminUsers, List<String> adminUserGroups, List<String> adminRoles, List<String> auditUsers, List<String> auditUserGroups, List<String> auditRoles, String description) {
        this.setName(name);
        this.setServices(services);
        this.setAdminUsers(adminUsers);
        this.setAdminUserGroups(adminUserGroups);
        this.setAdminRoles(adminRoles);
        this.setAuditUsers(auditUsers);
        this.setAuditUserGroups(auditUserGroups);
        this.setAuditRoles(auditRoles);
        this.setDescription(description);
        this.setTagServices(tagServices);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Map<String, RangerSecurityZoneService> getServices() {
        return this.services;
    }

    public void setServices(Map<String, RangerSecurityZoneService> services) {
        this.services = services == null ? new HashMap() : services;
    }

    public List<String> getAdminUsers() {
        return this.adminUsers;
    }

    public void setAdminUsers(List<String> adminUsers) {
        this.adminUsers = adminUsers == null ? new ArrayList() : adminUsers;
    }

    public List<String> getAdminUserGroups() {
        return this.adminUserGroups;
    }

    public void setAdminUserGroups(List<String> adminUserGroups) {
        this.adminUserGroups = adminUserGroups == null ? new ArrayList() : adminUserGroups;
    }

    public List<String> getAdminRoles() {
        return this.adminRoles;
    }

    public void setAdminRoles(List<String> adminRoles) {
        this.adminRoles = adminRoles == null ? new ArrayList() : adminRoles;
    }

    public List<String> getAuditUsers() {
        return this.auditUsers;
    }

    public void setAuditUsers(List<String> auditUsers) {
        this.auditUsers = auditUsers == null ? new ArrayList() : auditUsers;
    }

    public List<String> getAuditUserGroups() {
        return this.auditUserGroups;
    }

    public void setAuditUserGroups(List<String> auditUserGroups) {
        this.auditUserGroups = auditUserGroups == null ? new ArrayList() : auditUserGroups;
    }

    public List<String> getAuditRoles() {
        return this.auditRoles;
    }

    public void setAuditRoles(List<String> auditRoles) {
        this.auditRoles = auditRoles == null ? new ArrayList() : auditRoles;
    }

    public List<String> getTagServices() {
        return this.tagServices;
    }

    public void setTagServices(List<String> tagServices) {
        this.tagServices = tagServices != null ? tagServices : new ArrayList();
    }

    @Override
    public String toString() {
        return "{name=" + this.name + ", services=" + this.services + ", tagServices=" + this.tagServices + ", adminUsers=" + this.adminUsers + ", adminUserGroups=" + this.adminUserGroups + ", adminRoles=" + this.adminRoles + ", auditUsers=" + this.auditUsers + ", auditUserGroups=" + this.auditUserGroups + ", auditRoles=" + this.auditRoles + ", description=" + this.description + "}";
    }

    public static class ZoneServiceSummary
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private Long id;
        private String name;
        private String type;
        private String displayName;
        private Long resourceCount;

        public Long getId() {
            return this.id;
        }

        public void setId(Long id) {
            this.id = id;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getType() {
            return this.type;
        }

        public void setType(String type) {
            this.type = type;
        }

        public Long getResourceCount() {
            return this.resourceCount;
        }

        public void setResourceCount(Long resourceCount) {
            this.resourceCount = resourceCount;
        }

        public String getDisplayName() {
            return this.displayName;
        }

        public void setDisplayName(String displayName) {
            this.displayName = displayName;
        }
    }

    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY)
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class SecurityZoneSummary
    extends RangerBaseModelObject
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private String name;
        private String description;
        private Long totalResourceCount;
        private Map<RangerPrincipal.PrincipalType, Integer> adminCount;
        private Map<RangerPrincipal.PrincipalType, Integer> auditorCount;
        private List<String> tagServices;
        private List<ZoneServiceSummary> services;

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getDescription() {
            return this.description;
        }

        public void setDescription(String description) {
            this.description = description;
        }

        public Long getTotalResourceCount() {
            return this.totalResourceCount;
        }

        public void setTotalResourceCount(Long totalResourceCount) {
            this.totalResourceCount = totalResourceCount;
        }

        public Map<RangerPrincipal.PrincipalType, Integer> getAdminCount() {
            return this.adminCount;
        }

        public void setAdminCount(Map<RangerPrincipal.PrincipalType, Integer> adminCount) {
            this.adminCount = adminCount;
        }

        public Map<RangerPrincipal.PrincipalType, Integer> getAuditorCount() {
            return this.auditorCount;
        }

        public void setAuditorCount(Map<RangerPrincipal.PrincipalType, Integer> auditorCount) {
            this.auditorCount = auditorCount;
        }

        public List<String> getTagServices() {
            return this.tagServices;
        }

        public void setTagServices(List<String> tagServices) {
            this.tagServices = tagServices;
        }

        public List<ZoneServiceSummary> getServices() {
            return this.services;
        }

        public void setServices(List<ZoneServiceSummary> services) {
            this.services = services;
        }
    }

    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY)
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class RangerSecurityZoneService
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private List<HashMap<String, List<String>>> resources;
        private List<RangerSecurityZoneV2.RangerSecurityZoneResourceBase> resourcesBaseInfo;

        public RangerSecurityZoneService() {
            this(null, null);
        }

        public RangerSecurityZoneService(List<HashMap<String, List<String>>> resources) {
            this(resources, null);
        }

        public RangerSecurityZoneService(List<HashMap<String, List<String>>> resources, List<RangerSecurityZoneV2.RangerSecurityZoneResourceBase> resourcesBaseInfo) {
            this.setResources(resources);
            this.setResourcesBaseInfo(resourcesBaseInfo);
        }

        public List<HashMap<String, List<String>>> getResources() {
            return this.resources;
        }

        public void setResources(List<HashMap<String, List<String>>> resources) {
            this.resources = resources == null ? new ArrayList() : resources;
        }

        public List<RangerSecurityZoneV2.RangerSecurityZoneResourceBase> getResourcesBaseInfo() {
            return this.resourcesBaseInfo;
        }

        public void setResourcesBaseInfo(List<RangerSecurityZoneV2.RangerSecurityZoneResourceBase> resourcesBaseInfo) {
            this.resourcesBaseInfo = resourcesBaseInfo == null ? new ArrayList() : resourcesBaseInfo;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("{resources=[");
            if (this.resources != null) {
                for (int i = 0; i < this.resources.size(); ++i) {
                    HashMap<String, List<String>> resource = this.resources.get(i);
                    RangerSecurityZoneV2.RangerSecurityZoneResourceBase baseInfo = this.resourcesBaseInfo != null && this.resourcesBaseInfo.size() > i ? this.resourcesBaseInfo.get(i) : null;
                    sb.append("{resource=");
                    if (resource != null) {
                        for (Map.Entry<String, List<String>> entry : resource.entrySet()) {
                            sb.append("{resource-def-name=").append(entry.getKey()).append(", values=").append(entry.getValue()).append("} ");
                        }
                    }
                    sb.append("} ");
                    sb.append("{baseInfo=");
                    if (baseInfo != null) {
                        baseInfo.toString(sb);
                    }
                    sb.append("} ");
                }
            }
            sb.append("]}");
            return sb.toString();
        }
    }
}

