/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.plugin.model;

import java.io.Serializable;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.kyuubi.shade.com.fasterxml.jackson.annotation.JsonAutoDetect;
import org.apache.kyuubi.shade.com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import org.apache.kyuubi.shade.com.fasterxml.jackson.annotation.JsonInclude;
import org.apache.ranger.authorization.utils.StringUtil;
import org.apache.ranger.plugin.model.RangerBaseModelObject;

@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY)
@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonIgnoreProperties(ignoreUnknown=true)
public class RangerTagDef
extends RangerBaseModelObject {
    private static final long serialVersionUID = 1L;
    private String name;
    private String source;
    private List<RangerTagAttributeDef> attributeDefs;

    public RangerTagDef() {
        this(null, "Internal");
    }

    public RangerTagDef(String name) {
        this(name, "Internal");
    }

    public RangerTagDef(String name, String source) {
        this.setName(name);
        this.setSource(source);
        this.setAttributeDefs(null);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name == null ? "" : name;
    }

    public String getSource() {
        return this.source;
    }

    public void setSource(String source) {
        this.source = source == null ? "" : source;
    }

    public List<RangerTagAttributeDef> getAttributeDefs() {
        return this.attributeDefs;
    }

    public void setAttributeDefs(List<RangerTagAttributeDef> attributeDefs) {
        this.attributeDefs = attributeDefs;
    }

    @Override
    public void dedupStrings(Map<String, String> strTbl) {
        super.dedupStrings(strTbl);
        this.name = StringUtil.dedupString(this.name, strTbl);
        this.source = StringUtil.dedupString(this.source, strTbl);
        if (this.attributeDefs != null) {
            for (RangerTagAttributeDef attributeDef : this.attributeDefs) {
                attributeDef.dedupStrings(strTbl);
            }
        }
    }

    public int hashCode() {
        return Objects.hash(this.name, this.source, this.attributeDefs);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RangerTagDef other = (RangerTagDef)obj;
        return Objects.equals(this.name, other.name) && Objects.equals(this.source, other.source) && Objects.equals(this.attributeDefs, other.attributeDefs);
    }

    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY)
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class RangerTagAttributeDef
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private String name;
        private String type;

        public RangerTagAttributeDef() {
            this(null, null);
        }

        public RangerTagAttributeDef(String name, String type) {
            this.setName(name);
            this.setType(type);
        }

        public String getName() {
            return this.name;
        }

        public String getType() {
            return this.type;
        }

        public void setName(String name) {
            this.name = name == null ? "" : name;
        }

        public void setType(String type) {
            this.type = type == null ? "" : type;
        }

        public void dedupStrings(Map<String, String> strTbl) {
            this.name = StringUtil.dedupString(this.name, strTbl);
            this.type = StringUtil.dedupString(this.type, strTbl);
        }

        public int hashCode() {
            return Objects.hash(this.name, this.type);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            RangerTagAttributeDef other = (RangerTagAttributeDef)obj;
            return Objects.equals(this.name, other.name) && Objects.equals(this.type, other.type);
        }
    }
}

