/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.plugin.util;

import java.io.IOException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.Map;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.PBEParameterSpec;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.thirdparty.com.google.common.base.Splitter;
import org.apache.hadoop.thirdparty.com.google.common.collect.Lists;
import org.apache.kyuubi.shade.com.sun.jersey.core.util.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PasswordUtils {
    private static final Logger LOG = LoggerFactory.getLogger(PasswordUtils.class);
    private final String cryptAlgo;
    private String password;
    private final int iterationCount;
    private final char[] encryptKey;
    private final byte[] salt;
    private final byte[] iv;
    private static final String LEN_SEPARATOR_STR = ":";
    public static final String PBE_SHA512_AES_128 = "PBEWITHHMACSHA512ANDAES_128";
    public static final String DEFAULT_CRYPT_ALGO = "PBEWithMD5AndDES";
    public static final String DEFAULT_ENCRYPT_KEY = "tzL1AKl5uc4NKYaoQ4P3WLGIBFPXWPWdu1fRm9004jtQiV";
    public static final String DEFAULT_SALT = "f77aLYLo";
    public static final int DEFAULT_ITERATION_COUNT = 17;
    public static final byte[] DEFAULT_INITIAL_VECTOR = new byte[16];

    public static String encryptPassword(String aPassword) throws IOException {
        return PasswordUtils.build(aPassword).encrypt();
    }

    public static PasswordUtils build(String aPassword) {
        return new PasswordUtils(aPassword);
    }

    private String encrypt() throws IOException {
        String ret = null;
        String strToEncrypt = null;
        strToEncrypt = this.password == null ? "" : this.password.length() + LEN_SEPARATOR_STR + this.password;
        try {
            Cipher engine = Cipher.getInstance(this.cryptAlgo);
            PBEKeySpec keySpec = new PBEKeySpec(this.encryptKey);
            SecretKeyFactory skf = SecretKeyFactory.getInstance(this.cryptAlgo);
            SecretKey key = skf.generateSecret(keySpec);
            engine.init(1, (Key)key, new PBEParameterSpec(this.salt, this.iterationCount, new IvParameterSpec(this.iv)));
            byte[] encryptedStr = engine.doFinal(strToEncrypt.getBytes());
            ret = new String(Base64.encode(encryptedStr));
        }
        catch (Throwable t) {
            LOG.error("Unable to encrypt password due to error", t);
            throw new IOException("Unable to encrypt password due to error", t);
        }
        return ret;
    }

    PasswordUtils(String aPassword) {
        Map<String, String> env;
        String encryptKeyStr;
        byte[] SALT;
        char[] ENCRYPT_KEY;
        String[] crypt_algo_array = null;
        if (aPassword != null && aPassword.contains(",")) {
            crypt_algo_array = Lists.newArrayList((Iterable)Splitter.on((String)",").split((CharSequence)aPassword)).toArray(new String[0]);
        }
        if (crypt_algo_array != null && crypt_algo_array.length > 4) {
            int index = 0;
            this.cryptAlgo = crypt_algo_array[index++];
            ENCRYPT_KEY = crypt_algo_array[index++].toCharArray();
            SALT = crypt_algo_array[index++].getBytes();
            this.iterationCount = Integer.parseInt(crypt_algo_array[index++]);
            this.iv = PasswordUtils.needsIv(this.cryptAlgo) ? Base64.decode(crypt_algo_array[index++]) : DEFAULT_INITIAL_VECTOR;
            this.password = crypt_algo_array[index++];
            if (crypt_algo_array.length > index) {
                for (int i = index; i < crypt_algo_array.length; ++i) {
                    this.password = this.password + "," + crypt_algo_array[i];
                }
            }
        } else {
            this.cryptAlgo = DEFAULT_CRYPT_ALGO;
            ENCRYPT_KEY = DEFAULT_ENCRYPT_KEY.toCharArray();
            SALT = DEFAULT_SALT.getBytes();
            this.iterationCount = 17;
            this.iv = DEFAULT_INITIAL_VECTOR;
            this.password = aPassword;
        }
        this.encryptKey = (encryptKeyStr = (env = System.getenv()).get("ENCRYPT_KEY")) == null ? ENCRYPT_KEY : encryptKeyStr.toCharArray();
        String saltStr = env.get("ENCRYPT_SALT");
        this.salt = saltStr == null ? SALT : saltStr.getBytes();
    }

    public static String decryptPassword(String aPassword) throws IOException {
        return PasswordUtils.build(aPassword).decrypt();
    }

    private String decrypt() throws IOException {
        String ret = null;
        try {
            byte[] decodedPassword = Base64.decode(this.password);
            Cipher engine = Cipher.getInstance(this.cryptAlgo);
            PBEKeySpec keySpec = new PBEKeySpec(this.encryptKey);
            SecretKeyFactory skf = SecretKeyFactory.getInstance(this.cryptAlgo);
            SecretKey key = skf.generateSecret(keySpec);
            engine.init(2, (Key)key, new PBEParameterSpec(this.salt, this.iterationCount, new IvParameterSpec(this.iv)));
            String decrypted = new String(engine.doFinal(decodedPassword));
            int foundAt = decrypted.indexOf(LEN_SEPARATOR_STR);
            ret = foundAt > -1 ? (decrypted.length() > foundAt ? decrypted.substring(foundAt + 1) : "") : null;
        }
        catch (Throwable t) {
            LOG.error("Unable to decrypt password due to error", t);
            throw new IOException("Unable to decrypt password due to error", t);
        }
        return ret;
    }

    public static boolean needsIv(String cryptoAlgo) {
        if (StringUtils.isEmpty((CharSequence)cryptoAlgo)) {
            return false;
        }
        return PBE_SHA512_AES_128.toLowerCase().equals(cryptoAlgo.toLowerCase()) || cryptoAlgo.toLowerCase().contains("aes_128") || cryptoAlgo.toLowerCase().contains("aes_256");
    }

    public static String generateIvIfNeeded(String cryptAlgo) throws NoSuchAlgorithmException {
        if (!PasswordUtils.needsIv(cryptAlgo)) {
            return null;
        }
        return PasswordUtils.generateBase64EncodedIV();
    }

    private static String generateBase64EncodedIV() throws NoSuchAlgorithmException {
        byte[] iv = new byte[16];
        SecureRandom.getInstance("NativePRNGNonBlocking").nextBytes(iv);
        return new String(Base64.encode(iv));
    }

    public String getCryptAlgo() {
        return this.cryptAlgo;
    }

    public String getPassword() {
        return this.password;
    }

    public int getIterationCount() {
        return this.iterationCount;
    }

    public char[] getEncryptKey() {
        return this.encryptKey;
    }

    public byte[] getSalt() {
        return this.salt;
    }

    public byte[] getIv() {
        return this.iv;
    }

    public String getIvAsString() {
        return new String(Base64.encode(this.getIv()));
    }

    public static String getDecryptPassword(String password) {
        String decryptedPwd = null;
        try {
            decryptedPwd = PasswordUtils.decryptPassword(password);
        }
        catch (Exception ex) {
            LOG.warn("Password decryption failed, trying original password string.");
            decryptedPwd = null;
        }
        finally {
            if (decryptedPwd == null) {
                decryptedPwd = password;
            }
        }
        return decryptedPwd;
    }
}

