/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.plugin.util;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import org.apache.commons.lang3.tuple.MutablePair;
import org.apache.kyuubi.shade.com.fasterxml.jackson.annotation.JsonAutoDetect;
import org.apache.kyuubi.shade.com.fasterxml.jackson.annotation.JsonIgnore;
import org.apache.kyuubi.shade.com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import org.apache.kyuubi.shade.com.fasterxml.jackson.annotation.JsonInclude;
import org.apache.ranger.authorization.utils.StringUtil;
import org.apache.ranger.plugin.model.RangerServiceResource;
import org.apache.ranger.plugin.model.RangerTag;
import org.apache.ranger.plugin.model.RangerTagDef;

@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY)
@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonIgnoreProperties(ignoreUnknown=true)
public class ServiceTags
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String OP_ADD_OR_UPDATE = "add_or_update";
    public static final String OP_DELETE = "delete";
    public static final String OP_REPLACE = "replace";
    private String op = "add_or_update";
    private String serviceName;
    private Long tagVersion;
    private Date tagUpdateTime;
    private Map<Long, RangerTagDef> tagDefinitions;
    private Map<Long, RangerTag> tags;
    private List<RangerServiceResource> serviceResources;
    private Map<Long, List<Long>> resourceToTagIds;
    private Boolean isDelta;
    private TagsChangeExtent tagsChangeExtent;
    private Boolean isTagsDeduped;
    @JsonIgnore
    Map<RangerTag, MutablePair<Long, Long>> cachedTags = new HashMap<RangerTag, MutablePair<Long, Long>>();

    public ServiceTags() {
        this(OP_ADD_OR_UPDATE, null, 0L, null, null, null, null, null);
    }

    public ServiceTags(String op, String serviceName, Long tagVersion, Date tagUpdateTime, Map<Long, RangerTagDef> tagDefinitions, Map<Long, RangerTag> tags, List<RangerServiceResource> serviceResources, Map<Long, List<Long>> resourceToTagIds) {
        this(op, serviceName, tagVersion, tagUpdateTime, tagDefinitions, tags, serviceResources, resourceToTagIds, false, TagsChangeExtent.ALL, false);
    }

    public ServiceTags(String op, String serviceName, Long tagVersion, Date tagUpdateTime, Map<Long, RangerTagDef> tagDefinitions, Map<Long, RangerTag> tags, List<RangerServiceResource> serviceResources, Map<Long, List<Long>> resourceToTagIds, Boolean isDelta, TagsChangeExtent tagsChangeExtent, Boolean isTagsDeduped) {
        this.setOp(op);
        this.setServiceName(serviceName);
        this.setTagVersion(tagVersion);
        this.setTagUpdateTime(tagUpdateTime);
        this.setTagDefinitions(tagDefinitions);
        this.setTags(tags);
        this.setServiceResources(serviceResources);
        this.setResourceToTagIds(resourceToTagIds);
        this.setIsDelta(isDelta);
        this.setTagsChangeExtent(tagsChangeExtent);
        this.setIsTagsDeduped(isTagsDeduped);
    }

    public ServiceTags(ServiceTags other) {
        this.setOp(other.getOp());
        this.setServiceName(other.getServiceName());
        this.setTagVersion(other.getTagVersion());
        this.setTagUpdateTime(other.getTagUpdateTime());
        this.setTagDefinitions((Map<Long, RangerTagDef>)(other.getTagDefinitions() != null ? new HashMap<Long, RangerTagDef>(other.getTagDefinitions()) : null));
        this.setTags((Map<Long, RangerTag>)(other.getTags() != null ? new HashMap<Long, RangerTag>(other.getTags()) : null));
        this.setServiceResources((List<RangerServiceResource>)(other.getServiceResources() != null ? new ArrayList<RangerServiceResource>(other.getServiceResources()) : null));
        this.setResourceToTagIds((Map<Long, List<Long>>)(other.getResourceToTagIds() != null ? new HashMap<Long, List<Long>>(other.getResourceToTagIds()) : null));
        this.setIsDelta(other.getIsDelta());
        this.setIsTagsDeduped(other.getIsTagsDeduped());
        this.setTagsChangeExtent(other.getTagsChangeExtent());
        this.cachedTags = new HashMap<RangerTag, MutablePair<Long, Long>>(other.cachedTags);
    }

    public String getOp() {
        return this.op;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public void setOp(String op) {
        this.op = op;
    }

    public void setServiceName(String serviceName) {
        this.serviceName = serviceName;
    }

    public Long getTagVersion() {
        return this.tagVersion;
    }

    public void setTagVersion(Long tagVersion) {
        this.tagVersion = tagVersion;
    }

    public Date getTagUpdateTime() {
        return this.tagUpdateTime;
    }

    public void setTagUpdateTime(Date tagUpdateTime) {
        this.tagUpdateTime = tagUpdateTime;
    }

    public Map<Long, RangerTagDef> getTagDefinitions() {
        return this.tagDefinitions;
    }

    public void setTagDefinitions(Map<Long, RangerTagDef> tagDefinitions) {
        this.tagDefinitions = tagDefinitions == null ? new HashMap() : tagDefinitions;
    }

    public Map<Long, RangerTag> getTags() {
        return this.tags;
    }

    public void setTags(Map<Long, RangerTag> tags) {
        this.tags = tags == null ? new HashMap() : tags;
    }

    public List<RangerServiceResource> getServiceResources() {
        return this.serviceResources;
    }

    public void setServiceResources(List<RangerServiceResource> serviceResources) {
        this.serviceResources = serviceResources == null ? new ArrayList() : serviceResources;
    }

    public Map<Long, List<Long>> getResourceToTagIds() {
        return this.resourceToTagIds;
    }

    public void setResourceToTagIds(Map<Long, List<Long>> resourceToTagIds) {
        this.resourceToTagIds = resourceToTagIds == null ? new HashMap() : resourceToTagIds;
    }

    public Boolean getIsDelta() {
        return this.isDelta == null ? Boolean.FALSE : this.isDelta;
    }

    public void setIsDelta(Boolean isDelta) {
        this.isDelta = isDelta;
    }

    public Boolean getIsTagsDeduped() {
        return this.isTagsDeduped == null ? Boolean.FALSE : this.isTagsDeduped;
    }

    public void setIsTagsDeduped(Boolean isTagsDeduped) {
        this.isTagsDeduped = isTagsDeduped;
    }

    public TagsChangeExtent getTagsChangeExtent() {
        return this.tagsChangeExtent;
    }

    public void setTagsChangeExtent(TagsChangeExtent tagsChangeExtent) {
        this.tagsChangeExtent = tagsChangeExtent;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        this.toString(sb);
        return sb.toString();
    }

    public StringBuilder toString(StringBuilder sb) {
        sb.append("ServiceTags={").append("op=").append(this.op).append(", ").append("serviceName=").append(this.serviceName).append(", ").append("tagVersion=").append(this.tagVersion).append(", ").append("tagUpdateTime={").append(this.tagUpdateTime).append("}").append("isDelta={").append(this.isDelta).append("}").append("tagsChangeExtent={").append((Object)this.tagsChangeExtent).append("}").append(", serviceResources={").append(this.serviceResources).append("}").append(", tags={").append(this.tags).append("}").append(", resourceToTagIds={").append(this.resourceToTagIds).append("}").append(", isTagsDeduped={").append(this.isTagsDeduped).append("}").append(", cachedTags={").append(this.cachedTags).append("}").append("}");
        return sb;
    }

    public int dedupTags() {
        HashMap<Object, Object> replacedIds = new HashMap<Object, Object>();
        int initialTagsCount = this.tags.size();
        ArrayList<Object> tagIdsToRemove = new ArrayList<Object>();
        Iterator<Map.Entry<Long, RangerTag>> iter = this.tags.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry<Long, RangerTag> entry = iter.next();
            Long tagId = entry.getKey();
            RangerTag tag = entry.getValue();
            MutablePair<Long, Long> cachedTag = this.cachedTags.get(tag);
            if (cachedTag == null) {
                this.cachedTags.put(tag, (MutablePair<Long, Long>)new MutablePair((Object)tagId, (Object)0L));
                continue;
            }
            if (tagId < (Long)cachedTag.left) {
                replacedIds.put(cachedTag.left, tagId);
                tagIdsToRemove.add(cachedTag.left);
                cachedTag.left = tagId;
                continue;
            }
            replacedIds.put(tagId, cachedTag.left);
            iter.remove();
        }
        for (Long l : tagIdsToRemove) {
            this.tags.remove(l);
        }
        int finalTagsCount = this.tags.size();
        for (Map.Entry<Long, List<Long>> resourceEntry : this.resourceToTagIds.entrySet()) {
            ListIterator<Long> listIter = resourceEntry.getValue().listIterator();
            while (listIter.hasNext()) {
                MutablePair<Long, Long> cachedTag;
                Long tagId = listIter.next();
                Long replacerTagId = (Long)replacedIds.get(tagId);
                while (replacerTagId != null) {
                    tagId = replacerTagId;
                    replacerTagId = (Long)replacedIds.get(tagId);
                }
                listIter.set(tagId);
                RangerTag tag = this.tags.get(tagId);
                if (tag == null || (cachedTag = this.cachedTags.get(tag)) == null) continue;
                MutablePair<Long, Long> mutablePair = cachedTag;
                Long l = (Long)mutablePair.right;
                mutablePair.right = (Long)mutablePair.right + 1L;
                Long l2 = mutablePair.right;
            }
        }
        int ret = initialTagsCount - finalTagsCount;
        return ret;
    }

    public void dedupStrings() {
        HashMap<String, String> strTbl = new HashMap<String, String>();
        this.op = StringUtil.dedupString(this.op, strTbl);
        this.serviceName = StringUtil.dedupString(this.serviceName, strTbl);
        if (this.tagDefinitions != null) {
            for (RangerTagDef tagDef : this.tagDefinitions.values()) {
                tagDef.dedupStrings(strTbl);
            }
        }
        if (this.tags != null) {
            for (RangerTag tag : this.tags.values()) {
                tag.dedupStrings(strTbl);
            }
        }
        if (this.serviceResources != null) {
            for (RangerServiceResource resource : this.serviceResources) {
                resource.dedupStrings(strTbl);
            }
        }
    }

    public static enum TagsChangeType {
        NONE,
        SERVICE_RESOURCE_UPDATE,
        TAG_UPDATE,
        TAG_RESOURCE_MAP_UPDATE,
        RANGER_ADMIN_START,
        INVALIDATE_TAG_DELTAS,
        ALL;

    }

    public static enum TagsChangeExtent {
        NONE,
        TAGS,
        SERVICE_RESOURCE,
        ALL;

    }
}

