/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.common.exception;

import java.util.HashMap;
import java.util.Map;
import org.apache.linkis.common.exception.ExceptionLevel;

public abstract class LinkisException
extends Exception {
    static String applicationName;
    static String hostname;
    static int hostPort;
    private int errCode;
    private String desc;
    private String ip;
    private int port;
    private String serviceKind;

    public LinkisException(int errCode, String desc) {
        this(errCode, desc, hostname, hostPort, applicationName);
    }

    public LinkisException(int errCode, String desc, String ip, int port, String serviceKind) {
        super("errCode: " + errCode + " ,desc: " + desc + " ,ip: " + ip + " ,port: " + port + " ,serviceKind: " + serviceKind);
        this.errCode = errCode;
        this.desc = desc;
        this.ip = ip;
        this.port = port;
        this.serviceKind = serviceKind;
    }

    public static void setApplicationName(String applicationName) {
        LinkisException.applicationName = applicationName;
    }

    public static void setHostname(String hostname) {
        LinkisException.hostname = hostname;
    }

    public static void setHostPort(int hostPort) {
        LinkisException.hostPort = hostPort;
    }

    public int getErrCode() {
        return this.errCode;
    }

    public void setErrCode(int errCode) {
        this.errCode = errCode;
    }

    public String getDesc() {
        return this.desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }

    public String getIp() {
        return this.ip;
    }

    public void setIp(String ip) {
        this.ip = ip;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public String getServiceKind() {
        return this.serviceKind;
    }

    public void setServiceKind(String serviceKind) {
        this.serviceKind = serviceKind;
    }

    public Map<String, Object> toMap() {
        HashMap<String, Object> retMap = new HashMap<String, Object>();
        retMap.put("level", this.getLevel().getLevel());
        retMap.put("errCode", this.getErrCode());
        retMap.put("desc", this.getDesc());
        retMap.put("ip", this.getIp());
        retMap.put("port", this.getPort());
        retMap.put("serviceKind", this.getServiceKind());
        return retMap;
    }

    abstract ExceptionLevel getLevel();

    @Override
    public String toString() {
        return "LinkisException{errCode=" + this.errCode + ", desc='" + this.desc + "', ip='" + this.ip + "', port=" + this.port + ", serviceKind='" + this.serviceKind + "'" + '}';
    }
}

