/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.engineplugin.spark.client.deployment;

import java.io.Closeable;
import org.apache.linkis.engineplugin.spark.client.context.ExecutionContext;
import org.apache.spark.launcher.CustomSparkSubmitLauncher;
import org.apache.spark.launcher.SparkAppHandle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ClusterDescriptorAdapter
implements Closeable {
    protected static final Logger logger = LoggerFactory.getLogger(ClusterDescriptorAdapter.class);
    protected final ExecutionContext executionContext;
    protected String applicationId;
    protected CustomSparkSubmitLauncher sparkLauncher;
    protected SparkAppHandle sparkAppHandle;
    protected SparkAppHandle.State jobState;

    public String getApplicationId() {
        return this.applicationId;
    }

    public ClusterDescriptorAdapter(ExecutionContext executionContext) {
        this.executionContext = executionContext;
    }

    public SparkAppHandle.State getJobState() {
        return this.jobState;
    }

    public boolean isDisposed() {
        return this.sparkLauncher.isDisposed();
    }

    public String toString() {
        return "ClusterDescriptorAdapter{applicationId=" + this.sparkAppHandle.getAppId() + '}';
    }

    @Override
    public void close() {
        if (this.sparkAppHandle != null) {
            logger.info("Start to close job {}.", (Object)this.sparkAppHandle.getAppId());
            this.stopJob();
        } else {
            logger.warn("Close job: sparkAppHandle is null");
        }
    }

    private void stopJob() {
        if (this.sparkAppHandle == null) {
            return;
        }
        if (this.isDisposed()) {
            logger.info("Job has finished, stop action return.");
            return;
        }
        try {
            logger.info("Try to stop job {}.", (Object)this.sparkAppHandle.getAppId());
            this.sparkAppHandle.stop();
        }
        catch (Exception e) {
            logger.error("Stop job failed.", (Throwable)e);
            try {
                logger.info("Try to kill job {}.", (Object)this.sparkAppHandle.getAppId());
                this.sparkAppHandle.kill();
            }
            catch (Exception ex) {
                logger.error("Kill job failed.", (Throwable)ex);
            }
        }
    }
}

