/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.engineplugin.spark.datacalc;

import java.text.MessageFormat;
import org.apache.commons.lang3.StringUtils;
import org.apache.linkis.engineplugin.spark.datacalc.DataCalcExecution;
import org.apache.linkis.engineplugin.spark.datacalc.DataCalcTempData$;
import org.apache.linkis.engineplugin.spark.datacalc.api.DataCalcSink;
import org.apache.linkis.engineplugin.spark.datacalc.api.DataCalcSource;
import org.apache.linkis.engineplugin.spark.datacalc.api.DataCalcTransform;
import org.apache.linkis.engineplugin.spark.datacalc.exception.ConfigRuntimeException;
import org.apache.linkis.engineplugin.spark.datacalc.model.DataCalcArrayData;
import org.apache.linkis.engineplugin.spark.datacalc.model.DataCalcDataConfig;
import org.apache.linkis.engineplugin.spark.datacalc.model.DataCalcGroupData;
import org.apache.linkis.engineplugin.spark.datacalc.model.DataCalcPluginConfig;
import org.apache.linkis.engineplugin.spark.datacalc.model.ResultTableConfig;
import org.apache.linkis.engineplugin.spark.datacalc.model.SinkConfig;
import org.apache.linkis.engineplugin.spark.datacalc.model.SourceConfig;
import org.apache.linkis.engineplugin.spark.datacalc.model.TransformConfig;
import org.apache.linkis.engineplugin.spark.datacalc.util.PluginUtil;
import org.apache.linkis.engineplugin.spark.errorcode.SparkErrorCodeSummary;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.storage.StorageLevel$;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Array$;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple3;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;

public final class DataCalcExecution$ {
    public static final DataCalcExecution$ MODULE$;
    private final Logger org$apache$linkis$engineplugin$spark$datacalc$DataCalcExecution$$log;

    static {
        new DataCalcExecution$();
    }

    public Logger org$apache$linkis$engineplugin$spark$datacalc$DataCalcExecution$$log() {
        return this.org$apache$linkis$engineplugin$spark$datacalc$DataCalcExecution$$log;
    }

    public <SR extends SourceConfig, TR extends TransformConfig, SK extends SinkConfig> Tuple3<DataCalcSource<SR>[], DataCalcTransform<TR>[], DataCalcSink<SK>[]> getPlugins(DataCalcGroupData mapleData) {
        DataCalcSource[] sources = (DataCalcSource[])Predef$.MODULE$.refArrayOps((Object[])mapleData.getSources()).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final DataCalcSource<SR> apply(DataCalcDataConfig source) {
                return PluginUtil.createSource(source.getName(), source.getConfig());
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(DataCalcSource.class)));
        DataCalcTransform[] transformations = (DataCalcTransform[])Predef$.MODULE$.refArrayOps((Object[])mapleData.getTransformations()).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final DataCalcTransform<TR> apply(DataCalcDataConfig sink) {
                return PluginUtil.createTransform(sink.getName(), sink.getConfig());
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(DataCalcTransform.class)));
        DataCalcSink[] sinks = (DataCalcSink[])Predef$.MODULE$.refArrayOps((Object[])mapleData.getSinks()).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final DataCalcSink<SK> apply(DataCalcDataConfig sink) {
                return PluginUtil.createSink(sink.getName(), sink.getConfig());
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(DataCalcSink.class)));
        DataCalcExecution.CheckResult checkResult = new DataCalcExecution.CheckResult();
        Predef$.MODULE$.refArrayOps((Object[])sources).foreach((Function1)new Serializable(mapleData, checkResult){
            public static final long serialVersionUID = 0L;
            private final DataCalcGroupData mapleData$1;
            private final DataCalcExecution.CheckResult checkResult$1;

            public final void apply(DataCalcSource<SR> source) {
                ((DataCalcPluginConfig)source.getConfig()).setVariables(this.mapleData$1.getVariables());
                this.checkResult$1.checkResultTable(source);
            }
            {
                this.mapleData$1 = mapleData$1;
                this.checkResult$1 = checkResult$1;
            }
        });
        Predef$.MODULE$.refArrayOps((Object[])transformations).foreach((Function1)new Serializable(mapleData, checkResult){
            public static final long serialVersionUID = 0L;
            private final DataCalcGroupData mapleData$1;
            private final DataCalcExecution.CheckResult checkResult$1;

            public final void apply(DataCalcTransform<TR> transformation) {
                ((DataCalcPluginConfig)transformation.getConfig()).setVariables(this.mapleData$1.getVariables());
                this.checkResult$1.checkResultTable(transformation);
            }
            {
                this.mapleData$1 = mapleData$1;
                this.checkResult$1 = checkResult$1;
            }
        });
        Predef$.MODULE$.refArrayOps((Object[])sinks).foreach((Function1)new Serializable(mapleData, checkResult){
            public static final long serialVersionUID = 0L;
            private final DataCalcGroupData mapleData$1;
            private final DataCalcExecution.CheckResult checkResult$1;

            public final void apply(DataCalcSink<SK> sink) {
                ((DataCalcPluginConfig)sink.getConfig()).setVariables(this.mapleData$1.getVariables());
                this.checkResult$1.checkPluginConfig(sink);
            }
            {
                this.mapleData$1 = mapleData$1;
                this.checkResult$1 = checkResult$1;
            }
        });
        checkResult.check();
        return new Tuple3((Object)sources, (Object)transformations, (Object)sinks);
    }

    public <SR extends SourceConfig, TR extends TransformConfig, SK extends SinkConfig> void execute(SparkSession spark, DataCalcSource<SR>[] sources, DataCalcTransform<TR>[] transformations, DataCalcSink<SK>[] sinks) {
        if (sources != null && !Predef$.MODULE$.refArrayOps((Object[])sources).isEmpty()) {
            Predef$.MODULE$.refArrayOps((Object[])sources).foreach((Function1)new Serializable(spark){
                public static final long serialVersionUID = 0L;
                private final SparkSession spark$1;

                public final void apply(DataCalcSource<SR> source) {
                    DataCalcExecution$.MODULE$.org$apache$linkis$engineplugin$spark$datacalc$DataCalcExecution$$sourceProcess(this.spark$1, source);
                }
                {
                    this.spark$1 = spark$1;
                }
            });
        }
        if (transformations != null && !Predef$.MODULE$.refArrayOps((Object[])transformations).isEmpty()) {
            Predef$.MODULE$.refArrayOps((Object[])transformations).foreach((Function1)new Serializable(spark){
                public static final long serialVersionUID = 0L;
                private final SparkSession spark$1;

                public final void apply(DataCalcTransform<TR> transformation) {
                    DataCalcExecution$.MODULE$.org$apache$linkis$engineplugin$spark$datacalc$DataCalcExecution$$transformProcess(this.spark$1, transformation);
                }
                {
                    this.spark$1 = spark$1;
                }
            });
        }
        if (sinks != null && !Predef$.MODULE$.refArrayOps((Object[])sinks).isEmpty()) {
            Predef$.MODULE$.refArrayOps((Object[])sinks).foreach((Function1)new Serializable(spark){
                public static final long serialVersionUID = 0L;
                private final SparkSession spark$1;

                public final void apply(DataCalcSink<SK> sink) {
                    DataCalcExecution$.MODULE$.org$apache$linkis$engineplugin$spark$datacalc$DataCalcExecution$$sinkProcess(this.spark$1, sink);
                }
                {
                    this.spark$1 = spark$1;
                }
            });
        }
        DataCalcTempData$.MODULE$.clean(spark.sqlContext());
    }

    /*
     * WARNING - void declaration
     */
    public <SR extends SourceConfig, TR extends TransformConfig, SK extends SinkConfig, T> Object[] getPlugins(DataCalcArrayData mapleData) {
        void var3_3;
        DataCalcExecution.CheckResult checkResult = new DataCalcExecution.CheckResult();
        Object[] plugins = new Object[mapleData.getPlugins().length];
        Predef$.MODULE$.refArrayOps((Object[])mapleData.getPlugins()).indices().foreach$mVc$sp((Function1)new Serializable(mapleData, checkResult, plugins){
            public static final long serialVersionUID = 0L;
            private final DataCalcArrayData mapleData$2;
            private final DataCalcExecution.CheckResult checkResult$2;
            private final Object[] plugins$1;

            public final void apply(int i) {
                this.apply$mcVI$sp(i);
            }

            public void apply$mcVI$sp(int i) {
                String string;
                block7: {
                    block5: {
                        DataCalcDataConfig config;
                        block6: {
                            block4: {
                                config = this.mapleData$2.getPlugins()[i];
                                string = config.getType();
                                if (!"source".equals(string)) break block4;
                                DataCalcSource<T> source = PluginUtil.createSource(config.getName(), config.getConfig());
                                ((DataCalcPluginConfig)source.getConfig()).setVariables(this.mapleData$2.getVariables());
                                this.checkResult$2.checkResultTable(source);
                                this.plugins$1[i] = source;
                                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                break block5;
                            }
                            if (!"transformation".equals(string)) break block6;
                            DataCalcTransform<T> transformation = PluginUtil.createTransform(config.getName(), config.getConfig());
                            ((DataCalcPluginConfig)transformation.getConfig()).setVariables(this.mapleData$2.getVariables());
                            this.checkResult$2.checkResultTable(transformation);
                            this.plugins$1[i] = transformation;
                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                            break block5;
                        }
                        if (!"sink".equals(string)) break block7;
                        DataCalcSink<T> sink = PluginUtil.createSink(config.getName(), config.getConfig());
                        ((DataCalcPluginConfig)sink.getConfig()).setVariables(this.mapleData$2.getVariables());
                        this.checkResult$2.checkPluginConfig(sink);
                        this.plugins$1[i] = sink;
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    }
                    return;
                }
                if (string != null) {
                    String string2 = string;
                    throw new ConfigRuntimeException(SparkErrorCodeSummary.DATA_CALC_CONFIG_TYPE_NOT_VALID.getErrorCode(), MessageFormat.format(SparkErrorCodeSummary.DATA_CALC_CONFIG_TYPE_NOT_VALID.getErrorDesc(), string2));
                }
                throw new MatchError((Object)string);
            }
            {
                this.mapleData$2 = mapleData$2;
                this.checkResult$2 = checkResult$2;
                this.plugins$1 = plugins$1;
            }
        });
        checkResult.check();
        return var3_3;
    }

    public <SR extends SourceConfig, TR extends TransformConfig, SK extends SinkConfig, T> void execute(SparkSession spark, Object[] plugins) {
        if (plugins == null || Predef$.MODULE$.genericArrayOps((Object)plugins).isEmpty()) {
            return;
        }
        Predef$.MODULE$.genericArrayOps((Object)plugins).foreach((Function1)new Serializable(spark){
            public static final long serialVersionUID = 0L;
            private final SparkSession spark$2;

            public final void apply(Object x0$1) {
                Object object = x0$1;
                if (object instanceof DataCalcSource) {
                    DataCalcSource dataCalcSource = (DataCalcSource)object;
                    DataCalcExecution$.MODULE$.org$apache$linkis$engineplugin$spark$datacalc$DataCalcExecution$$sourceProcess(this.spark$2, dataCalcSource);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                } else if (object instanceof DataCalcTransform) {
                    DataCalcTransform dataCalcTransform = (DataCalcTransform)object;
                    DataCalcExecution$.MODULE$.org$apache$linkis$engineplugin$spark$datacalc$DataCalcExecution$$transformProcess(this.spark$2, dataCalcTransform);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                } else if (object instanceof DataCalcSink) {
                    DataCalcSink dataCalcSink = (DataCalcSink)object;
                    DataCalcExecution$.MODULE$.org$apache$linkis$engineplugin$spark$datacalc$DataCalcExecution$$sinkProcess(this.spark$2, dataCalcSink);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                } else {
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                }
            }
            {
                this.spark$2 = spark$2;
            }
        });
        DataCalcTempData$.MODULE$.clean(spark.sqlContext());
    }

    public <T extends SourceConfig> void org$apache$linkis$engineplugin$spark$datacalc$DataCalcExecution$$sourceProcess(SparkSession spark, DataCalcSource<T> source) {
        source.prepare(spark);
        Dataset<Row> ds = source.getData(spark);
        this.tempSaveResultTable(ds, (ResultTableConfig)source.getConfig());
    }

    public <T extends TransformConfig> void org$apache$linkis$engineplugin$spark$datacalc$DataCalcExecution$$transformProcess(SparkSession spark, DataCalcTransform<T> transform) {
        transform.prepare(spark);
        Dataset fromDs = StringUtils.isNotBlank((CharSequence)((TransformConfig)transform.getConfig()).getSourceTable()) ? spark.read().table(((TransformConfig)transform.getConfig()).getSourceTable()) : null;
        Dataset<Row> ds = transform.process(spark, fromDs);
        this.tempSaveResultTable(ds, (ResultTableConfig)transform.getConfig());
    }

    public <T extends SinkConfig> void org$apache$linkis$engineplugin$spark$datacalc$DataCalcExecution$$sinkProcess(SparkSession spark, DataCalcSink<T> sink) {
        sink.prepare(spark);
        Dataset fromDs = StringUtils.isBlank((CharSequence)((SinkConfig)sink.getConfig()).getSourceQuery()) ? spark.read().table(((SinkConfig)sink.getConfig()).getSourceTable()) : spark.sql(((SinkConfig)sink.getConfig()).getSourceQuery());
        sink.output(spark, (Dataset<Row>)fromDs);
    }

    private void tempSaveResultTable(Dataset<Row> ds, ResultTableConfig resultTableConfig) {
        if (ds != null) {
            ds.createOrReplaceTempView(resultTableConfig.getResultTable());
            DataCalcTempData$.MODULE$.putResultTable(resultTableConfig.getResultTable());
            if (Predef$.MODULE$.Boolean2boolean(resultTableConfig.getPersist())) {
                ds.persist(StorageLevel$.MODULE$.fromString(resultTableConfig.getStorageLevel()));
                DataCalcTempData$.MODULE$.putPersistDataSet(ds);
            }
        }
    }

    private DataCalcExecution$() {
        MODULE$ = this;
        this.org$apache$linkis$engineplugin$spark$datacalc$DataCalcExecution$$log = LoggerFactory.getLogger(this.getClass());
    }
}

