/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.engineplugin.spark.datacalc.sink;

import org.apache.commons.lang3.StringUtils;
import org.apache.linkis.common.utils.Logging;
import org.apache.linkis.engineplugin.spark.datacalc.api.DataCalcPlugin$class;
import org.apache.linkis.engineplugin.spark.datacalc.api.DataCalcSink;
import org.apache.linkis.engineplugin.spark.datacalc.exception.HiveSinkException;
import org.apache.linkis.engineplugin.spark.datacalc.model.DataCalcPluginConfig;
import org.apache.linkis.engineplugin.spark.datacalc.model.SinkConfig;
import org.apache.linkis.engineplugin.spark.datacalc.sink.FileFormat$;
import org.apache.linkis.engineplugin.spark.datacalc.sink.HiveSinkConfig;
import org.apache.linkis.engineplugin.spark.errorcode.SparkErrorCodeSummary;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.DataFrameWriter;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.execution.datasources.FileFormat;
import org.apache.spark.sql.execution.datasources.HadoopFsRelation;
import org.apache.spark.sql.execution.datasources.LogicalRelation;
import org.apache.spark.sql.execution.datasources.parquet.ParquetFileFormat;
import org.apache.spark.sql.functions$;
import org.apache.spark.sql.sources.BaseRelation;
import org.apache.spark.sql.sources.DataSourceRegister;
import org.apache.spark.sql.types.StructField;
import org.slf4j.Logger;
import scala.Array$;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.collection.immutable.Set;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.TraitSetter;

@ScalaSignature(bytes="\u0006\u0001\u0005]b\u0001B\u0001\u0003\u0001E\u0011\u0001\u0002S5wKNKgn\u001b\u0006\u0003\u0007\u0011\tAa]5oW*\u0011QAB\u0001\tI\u0006$\u0018mY1mG*\u0011q\u0001C\u0001\u0006gB\f'o\u001b\u0006\u0003\u0013)\tA\"\u001a8hS:,\u0007\u000f\\;hS:T!a\u0003\u0007\u0002\r1Lgn[5t\u0015\tia\"\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002\u001f\u0005\u0019qN]4\u0004\u0001M!\u0001A\u0005\r#!\t\u0019b#D\u0001\u0015\u0015\u0005)\u0012!B:dC2\f\u0017BA\f\u0015\u0005\u0019\te.\u001f*fMB\u0019\u0011\u0004\b\u0010\u000e\u0003iQ!a\u0007\u0003\u0002\u0007\u0005\u0004\u0018.\u0003\u0002\u001e5\taA)\u0019;b\u0007\u0006d7mU5oWB\u0011q\u0004I\u0007\u0002\u0005%\u0011\u0011E\u0001\u0002\u000f\u0011&4XmU5oW\u000e{gNZ5h!\t\u0019\u0003&D\u0001%\u0015\t)c%A\u0003vi&d7O\u0003\u0002(\u0015\u000511m\\7n_:L!!\u000b\u0013\u0003\u000f1{wmZ5oO\")1\u0006\u0001C\u0001Y\u00051A(\u001b8jiz\"\u0012!\f\t\u0003?\u0001AQa\f\u0001\u0005\u0002A\naa\\;uaV$HcA\u00195yA\u00111CM\u0005\u0003gQ\u0011A!\u00168ji\")qA\fa\u0001kA\u0011aGO\u0007\u0002o)\u0011\u0001(O\u0001\u0004gFd'BA\u0004\r\u0013\tYtG\u0001\u0007Ta\u0006\u00148nU3tg&|g\u000eC\u0003>]\u0001\u0007a(\u0001\u0002egB\u0019agP!\n\u0005\u0001;$a\u0002#bi\u0006\u001cX\r\u001e\t\u0003m\tK!aQ\u001c\u0003\u0007I{w\u000fC\u0003F\u0001\u0011\u0005a)A\u0007hKR\u001c\u0016M^3Xe&$XM\u001d\u000b\u0005\u000f*[e\u000bE\u00027\u0011\u0006K!!S\u001c\u0003\u001f\u0011\u000bG/\u0019$sC6,wK]5uKJDQ!\u0010#A\u0002yBQ\u0001\u0014#A\u00025\u000bA\u0002^1sO\u0016$h)[3mIN\u00042a\u0005(Q\u0013\tyECA\u0003BeJ\f\u0017\u0010\u0005\u0002R)6\t!K\u0003\u0002To\u0005)A/\u001f9fg&\u0011QK\u0015\u0002\f'R\u0014Xo\u0019;GS\u0016dG\rC\u0003X\t\u0002\u0007\u0001,A\u0006uCJ<W\r\u001e+bE2,\u0007CA-]\u001d\t\u0019\",\u0003\u0002\\)\u00051\u0001K]3eK\u001aL!!\u00180\u0003\rM#(/\u001b8h\u0015\tYF\u0003C\u0003a\u0001\u0011\u0005\u0011-A\u0005m_\u001e4\u0015.\u001a7egR\u0019\u0011G\u00193\t\u000b\r|\u0006\u0019A'\u0002\u0019M|WO]2f\r&,G\u000eZ:\t\u000b1{\u0006\u0019A'\t\u000b\u0019\u0004A\u0011A4\u0002\u001dM,\u0017/^3oG\u00164\u0015.\u001a7egR)\u0001N\u001f?~}B\u0011\u0011n\u001e\b\u0003UVt!a\u001b;\u000f\u00051\u001chBA7s\u001d\tq\u0017/D\u0001p\u0015\t\u0001\b#\u0001\u0004=e>|GOP\u0005\u0002\u001f%\u0011QBD\u0005\u0003\u000f1I!\u0001O\u001d\n\u0005Y<\u0014a\u00029bG.\fw-Z\u0005\u0003qf\u0014\u0011\u0002R1uC\u001a\u0013\u0018-\\3\u000b\u0005Y<\u0004\"B>f\u0001\u0004q\u0014\u0001\u00033t'>,(oY3\t\u000b\r,\u0007\u0019A'\t\u000b1+\u0007\u0019A'\t\u000b]+\u0007\u0019\u0001-\t\u000f\u0005\u0005\u0001\u0001\"\u0001\u0002\u0004\u0005Yq-\u001a;M_\u000e\fG/[8o)\u001dA\u0016QAA\u0004\u0003\u0013AQaB@A\u0002UBQaV@A\u0002aCq!a\u0003\u0000\u0001\u0004\ti!A\tqCJ$\u0018\u000e^5p]N\u001cu\u000e\\;n]N\u00042a\u0005(Y\u0011\u001d\t\t\u0002\u0001C\u0001\u0003'\t!cZ3u)\u0006\u0014G.\u001a$jY\u00164uN]7biR1\u0011QCA\u0013\u0003O\u0001B!a\u0006\u0002\u001e9\u0019q$!\u0007\n\u0007\u0005m!!\u0001\u0006GS2,gi\u001c:nCRLA!a\b\u0002\"\t)a+\u00197vK&\u0019\u00111\u0005\u000b\u0003\u0017\u0015sW/\\3sCRLwN\u001c\u0005\u0007\u000f\u0005=\u0001\u0019A\u001b\t\r]\u000by\u00011\u0001Y\u0011\u001d\tY\u0003\u0001C\u0001\u0003[\t\u0001C]3ge\u0016\u001c\b\u000eU1si&$\u0018n\u001c8\u0015\u000fE\ny#!\r\u00024!1q!!\u000bA\u0002UBaaVA\u0015\u0001\u0004A\u0006bBA\u001b\u0003S\u0001\r\u0001W\u0001\na\u0006\u0014H/\u001b;j_:\u0004")
public class HiveSink
implements DataCalcSink<HiveSinkConfig>,
Logging {
    private final Logger logger;
    private Object config;
    private volatile boolean bitmap$0;

    private Logger logger$lzycompute() {
        HiveSink hiveSink = this;
        synchronized (hiveSink) {
            if (!this.bitmap$0) {
                this.logger = Logging.class.logger((Logging)this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    public void trace(Function0<String> message) {
        Logging.class.trace((Logging)this, message);
    }

    public void debug(Function0<String> message) {
        Logging.class.debug((Logging)this, message);
    }

    public void info(Function0<String> message) {
        Logging.class.info((Logging)this, message);
    }

    public void info(Function0<String> message, Throwable t) {
        Logging.class.info((Logging)this, message, (Throwable)t);
    }

    public void warn(Function0<String> message) {
        Logging.class.warn((Logging)this, message);
    }

    public void warn(Function0<String> message, Throwable t) {
        Logging.class.warn((Logging)this, message, (Throwable)t);
    }

    public void error(Function0<String> message, Throwable t) {
        Logging.class.error((Logging)this, message, (Throwable)t);
    }

    public void error(Function0<String> message) {
        Logging.class.error((Logging)this, message);
    }

    @Override
    public Object config() {
        return this.config;
    }

    @Override
    @TraitSetter
    public void config_$eq(Object x$1) {
        this.config = x$1;
    }

    @Override
    public Object getConfig() {
        return DataCalcPlugin$class.getConfig(this);
    }

    @Override
    public void setConfig(Object config) {
        DataCalcPlugin$class.setConfig(this, config);
    }

    @Override
    public void prepare(SparkSession spark) {
        DataCalcPlugin$class.prepare(this, spark);
    }

    @Override
    public void output(SparkSession spark, Dataset<Row> ds) {
        String targetTable = StringUtils.isBlank((CharSequence)((HiveSinkConfig)this.config()).getTargetDatabase()) ? ((HiveSinkConfig)this.config()).getTargetTable() : new StringBuilder().append((Object)((HiveSinkConfig)this.config()).getTargetDatabase()).append((Object)".").append((Object)((HiveSinkConfig)this.config()).getTargetTable()).toString();
        StructField[] targetFields = spark.table(targetTable).schema().fields();
        if (((HiveSinkConfig)this.config()).getWriteAsFile() != null && Predef$.MODULE$.Boolean2boolean(((HiveSinkConfig)this.config()).getWriteAsFile())) {
            String[] partitionsColumns = (String[])Predef$.MODULE$.refArrayOps((Object[])spark.catalog().listColumns(targetTable).where(functions$.MODULE$.col("isPartition").$eq$eq$eq((Object)BoxesRunTime.boxToBoolean((boolean)true))).select("name", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0])).collect()).map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply(Row x$1) {
                    return (String)x$1.getAs("name");
                }
            }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)));
            String location = this.getLocation(spark, targetTable, partitionsColumns);
            Enumeration.Value fileFormat = this.getTableFileFormat(spark, targetTable);
            this.logger().info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Write ", " into target table: ", ", location: ", ", file format: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{fileFormat, targetTable, location, fileFormat})));
            DataFrameWriter<Row> writer = this.getSaveWriter(ds, (StructField[])Predef$.MODULE$.refArrayOps((Object[])targetFields).filter((Function1)new Serializable(this, partitionsColumns){
                public static final long serialVersionUID = 0L;
                private final String[] partitionsColumns$1;

                public final boolean apply(StructField field) {
                    return !Predef$.MODULE$.refArrayOps((Object[])this.partitionsColumns$1).contains((Object)field.name());
                }
                {
                    this.partitionsColumns$1 = partitionsColumns$1;
                }
            }), targetTable);
            Enumeration.Value value = fileFormat;
            Enumeration.Value value2 = FileFormat$.MODULE$.PARQUET();
            Enumeration.Value value3 = value;
            if (!(value2 != null ? !value2.equals(value3) : value3 != null)) {
                writer.parquet(location);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else {
                Enumeration.Value value4 = FileFormat$.MODULE$.ORC();
                Enumeration.Value value5 = value;
                if (!(value4 != null ? !value4.equals(value5) : value5 != null)) {
                    writer.orc(location);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                } else {
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                }
            }
            String partition = Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])partitionsColumns).map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ HiveSink $outer;

                public final String apply(String colName) {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "='", "'"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{colName, ((DataCalcPluginConfig)this.$outer.config()).getVariables().get(colName)}));
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)))).mkString(",");
            if (StringUtils.isNotBlank((CharSequence)partition)) {
                this.logger().info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Refresh table partition: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{partition})));
                this.refreshPartition(spark, targetTable, partition);
            }
        } else {
            DataFrameWriter<Row> writer = this.getSaveWriter(ds, targetFields, targetTable);
            this.logger().info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"InsertInto data to hive table: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{targetTable})));
            writer.format("hive").insertInto(targetTable);
        }
    }

    public DataFrameWriter<Row> getSaveWriter(Dataset<Row> ds, StructField[] targetFields, String targetTable) {
        Dataset<Row> dsSource = this.sequenceFields(ds, ds.schema().fields(), targetFields, targetTable);
        StructField[] sourceFields = dsSource.schema().fields();
        if (((HiveSinkConfig)this.config()).getStrongCheck() != null && Predef$.MODULE$.Boolean2boolean(((HiveSinkConfig)this.config()).getStrongCheck())) {
            Predef$.MODULE$.refArrayOps((Object[])sourceFields).indices().foreach$mVc$sp((Function1)new Serializable(this, targetFields, sourceFields){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ HiveSink $outer;
                private final StructField[] targetFields$1;
                private final StructField[] sourceFields$1;

                public final void apply(int i) {
                    this.apply$mcVI$sp(i);
                }

                public void apply$mcVI$sp(int i) {
                    StructField targetField = this.targetFields$1[i];
                    StructField sourceField = this.sourceFields$1[i];
                    if (targetField.dataType().equals(sourceField.dataType())) {
                        return;
                    }
                    this.$outer.logFields(this.sourceFields$1, this.targetFields$1);
                    throw new HiveSinkException(SparkErrorCodeSummary.DATA_CALC_COLUMN_NOT_MATCH.getErrorCode(), new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "st column (", "[", "]) name or data type does not match target table column (", "[", "])"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)(i + 1)), sourceField.name(), sourceField.dataType(), targetField.name(), targetField.dataType()})));
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.targetFields$1 = targetFields$1;
                    this.sourceFields$1 = sourceFields$1;
                }
            });
        }
        DataFrameWriter writer = dsSource.repartition(Predef$.MODULE$.Integer2int(((HiveSinkConfig)this.config()).getNumPartitions())).write().mode(((HiveSinkConfig)this.config()).getSaveMode());
        Object object = ((SinkConfig)this.config()).getOptions() == null || ((SinkConfig)this.config()).getOptions().isEmpty() ? BoxedUnit.UNIT : writer.options(((SinkConfig)this.config()).getOptions());
        return writer;
    }

    public void logFields(StructField[] sourceFields, StructField[] targetFields) {
        this.logger().info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"sourceFields: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Predef$.MODULE$.refArrayOps((Object[])sourceFields).mkString("Array(", ", ", ")")})));
        this.logger().info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"targetFields: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Predef$.MODULE$.refArrayOps((Object[])targetFields).mkString("Array(", ", ", ")")})));
    }

    public Dataset<Row> sequenceFields(Dataset<Row> dsSource, StructField[] sourceFields, StructField[] targetFields, String targetTable) {
        Set subSet;
        block6: {
            Dataset dataset;
            block5: {
                Map targetFieldMap;
                block4: {
                    if (targetFields.length != sourceFields.length) {
                        this.logFields(sourceFields, targetFields);
                        throw new HiveSinkException(SparkErrorCodeSummary.DATA_CALC_COLUMN_NUM_NOT_MATCH.getErrorCode(), new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " requires that the data to be inserted have the same number of columns "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{targetTable}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"as the target table: target table has ", " column(s) "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)targetFields.length)}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"but the inserted data has ", " column(s)"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)sourceFields.length)}))).toString());
                    }
                    Map sourceFieldMap = Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])sourceFields).map((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final Tuple2<String, StructField> apply(StructField field) {
                            return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)field.name().toLowerCase()), (Object)field);
                        }
                    }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)))).toMap(Predef$.MODULE$.$conforms());
                    targetFieldMap = Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])targetFields).map((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final Tuple2<String, StructField> apply(StructField field) {
                            return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)field.name().toLowerCase()), (Object)field);
                        }
                    }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)))).toMap(Predef$.MODULE$.$conforms());
                    subSet = (Set)targetFieldMap.keySet().$minus$minus((GenTraversableOnce)sourceFieldMap.keySet());
                    if (!subSet.isEmpty()) break block4;
                    dataset = dsSource.select((Seq)Predef$.MODULE$.wrapRefArray((Object[])Predef$.MODULE$.refArrayOps((Object[])targetFields).map((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final Column apply(StructField field) {
                            return functions$.MODULE$.col(field.name());
                        }
                    }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Column.class)))));
                    break block5;
                }
                if (subSet.size() != targetFieldMap.size()) break block6;
                this.logger().info("None target table fields match with source fields, write in order");
                dataset = dsSource.toDF((Seq)Predef$.MODULE$.wrapRefArray((Object[])Predef$.MODULE$.refArrayOps((Object[])targetFields).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply(StructField field) {
                        return field.name();
                    }
                }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)))));
            }
            return dataset;
        }
        throw new HiveSinkException(SparkErrorCodeSummary.DATA_CALC_FIELD_NOT_EXIST.getErrorCode(), new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " fields(", ") are not exist in source fields"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{targetTable, subSet.mkString(",")})));
    }

    public String getLocation(SparkSession spark, String targetTable, String[] partitionsColumns) {
        Row[] locations = (Row[])spark.sql(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"desc formatted ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{targetTable}))).filter(functions$.MODULE$.col("col_name").$eq$eq$eq((Object)"Location")).collect();
        ObjectRef location = ObjectRef.create((Object)locations[0].getString(1));
        Predef$.MODULE$.refArrayOps((Object[])partitionsColumns).foreach((Function1)new Serializable(this, partitionsColumns, location){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ HiveSink $outer;
            private final String[] partitionsColumns$2;
            private final ObjectRef location$1;

            public final void apply(String partitionColName) {
                if (((DataCalcPluginConfig)this.$outer.config()).getVariables().containsKey(partitionColName) && !StringUtils.isBlank((CharSequence)((DataCalcPluginConfig)this.$outer.config()).getVariables().get(partitionColName))) {
                    this.location$1.elem = new StringBuilder().append((Object)((String)this.location$1.elem)).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"/", "=", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{partitionColName, ((DataCalcPluginConfig)this.$outer.config()).getVariables().get(partitionColName)}))).toString();
                    return;
                }
                throw new HiveSinkException(SparkErrorCodeSummary.DATA_CALC_VARIABLE_NOT_EXIST.getErrorCode(), new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Please set [", "] in variables"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Predef$.MODULE$.refArrayOps((Object[])this.partitionsColumns$2).mkString(", ")})));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.partitionsColumns$2 = partitionsColumns$2;
                this.location$1 = location$1;
            }
        });
        return (String)location.elem;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Enumeration.Value getTableFileFormat(SparkSession spark, String targetTable) {
        Enumeration.Value value;
        try {
            void var3_3;
            Enumeration.Value fileFormat = FileFormat$.MODULE$.OTHER();
            LogicalPlan logicalPlan = spark.table(targetTable).queryExecution().optimizedPlan();
            if (logicalPlan instanceof LogicalRelation) {
                LogicalRelation logicalRelation = (LogicalRelation)logicalPlan;
                BaseRelation baseRelation = logicalRelation.relation();
                if (!(baseRelation instanceof HadoopFsRelation)) throw new MatchError((Object)baseRelation);
                HadoopFsRelation hadoopFsRelation = (HadoopFsRelation)baseRelation;
                FileFormat fileFormat2 = hadoopFsRelation.fileFormat();
                if (fileFormat2 instanceof ParquetFileFormat) {
                    fileFormat = FileFormat$.MODULE$.PARQUET();
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                } else if (fileFormat2 instanceof DataSourceRegister) {
                    FileFormat fileFormat3 = fileFormat2;
                    fileFormat = FileFormat$.MODULE$.withName(((DataSourceRegister)fileFormat3).shortName().toUpperCase());
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                } else {
                    BoxedUnit boxedUnit;
                    if (hadoopFsRelation.fileFormat().getClass().getSimpleName().equals("OrcFileFormat")) {
                        fileFormat = FileFormat$.MODULE$.ORC();
                        boxedUnit = BoxedUnit.UNIT;
                    } else {
                        boxedUnit = BoxedUnit.UNIT;
                    }
                    BoxedUnit boxedUnit2 = boxedUnit;
                }
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                BoxedUnit boxedUnit3 = BoxedUnit.UNIT;
            } else {
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
            value = var3_3;
            return value;
        }
        catch (Exception exception) {
            value = FileFormat$.MODULE$.OTHER();
        }
        return value;
    }

    public void refreshPartition(SparkSession spark, String targetTable, String partition) {
        spark.sql(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"ALTER TABLE ", " DROP IF EXISTS partition(", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{targetTable, partition})));
        spark.sql(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"ALTER TABLE ", " ADD IF NOT EXISTS partition(", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{targetTable, partition})));
    }

    public HiveSink() {
        DataCalcPlugin$class.$init$(this);
        Logging.class.$init$((Logging)this);
    }
}

