/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.engineplugin.spark.datacalc.sink;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import org.apache.commons.lang3.StringUtils;
import org.apache.linkis.common.utils.ClassUtils$;
import org.apache.linkis.common.utils.Logging;
import org.apache.linkis.engineplugin.spark.datacalc.api.DataCalcPlugin$class;
import org.apache.linkis.engineplugin.spark.datacalc.api.DataCalcSink;
import org.apache.linkis.engineplugin.spark.datacalc.model.SinkConfig;
import org.apache.linkis.engineplugin.spark.datacalc.sink.JdbcSink$;
import org.apache.linkis.engineplugin.spark.datacalc.sink.JdbcSinkConfig;
import org.apache.spark.package$;
import org.apache.spark.sql.DataFrameWriter;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.execution.datasources.jdbc.JDBCOptions;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.IterableLike;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.TraitSetter;

@ScalaSignature(bytes="\u0006\u0001\u00154A!\u0001\u0002\u0001#\tA!\n\u001a2d'&t7N\u0003\u0002\u0004\t\u0005!1/\u001b8l\u0015\t)a!\u0001\u0005eCR\f7-\u00197d\u0015\t9\u0001\"A\u0003ta\u0006\u00148N\u0003\u0002\n\u0015\u0005aQM\\4j]\u0016\u0004H.^4j]*\u00111\u0002D\u0001\u0007Y&t7.[:\u000b\u00055q\u0011AB1qC\u000eDWMC\u0001\u0010\u0003\ry'oZ\u0002\u0001'\u0011\u0001!\u0003\u0007\u0012\u0011\u0005M1R\"\u0001\u000b\u000b\u0003U\tQa]2bY\u0006L!a\u0006\u000b\u0003\r\u0005s\u0017PU3g!\rIBDH\u0007\u00025)\u00111\u0004B\u0001\u0004CBL\u0017BA\u000f\u001b\u00051!\u0015\r^1DC2\u001c7+\u001b8l!\ty\u0002%D\u0001\u0003\u0013\t\t#A\u0001\bKI\n\u001c7+\u001b8l\u0007>tg-[4\u0011\u0005\rBS\"\u0001\u0013\u000b\u0005\u00152\u0013!B;uS2\u001c(BA\u0014\u000b\u0003\u0019\u0019w.\\7p]&\u0011\u0011\u0006\n\u0002\b\u0019><w-\u001b8h\u0011\u0015Y\u0003\u0001\"\u0001-\u0003\u0019a\u0014N\\5u}Q\tQ\u0006\u0005\u0002 \u0001!)q\u0006\u0001C\u0001a\u00051q.\u001e;qkR$2!\r\u001b=!\t\u0019\"'\u0003\u00024)\t!QK\\5u\u0011\u00159a\u00061\u00016!\t1$(D\u00018\u0015\tA\u0014(A\u0002tc2T!a\u0002\u0007\n\u0005m:$\u0001D*qCJ\\7+Z:tS>t\u0007\"B\u001f/\u0001\u0004q\u0014A\u00013t!\r1t(Q\u0005\u0003\u0001^\u0012q\u0001R1uCN,G\u000f\u0005\u00027\u0005&\u00111i\u000e\u0002\u0004%><\b\"B#\u0001\t\u00131\u0015aB3yK\u000e,H/\u001a\u000b\u0005c\u001d\u0003F\fC\u0003I\t\u0002\u0007\u0011*\u0001\u0003d_:t\u0007C\u0001&O\u001b\u0005Y%B\u0001\u001dM\u0015\u0005i\u0015\u0001\u00026bm\u0006L!aT&\u0003\u0015\r{gN\\3di&|g\u000eC\u0003R\t\u0002\u0007!+A\u0006kI\n\u001cw\n\u001d;j_:\u001c\bCA*[\u001b\u0005!&BA+W\u0003\u0011QGMY2\u000b\u0005]C\u0016a\u00033bi\u0006\u001cx.\u001e:dKNT!!W\u001c\u0002\u0013\u0015DXmY;uS>t\u0017BA.U\u0005-QEIQ\"PaRLwN\\:\t\u000bu#\u0005\u0019\u00010\u0002\u000bE,XM]=\u0011\u0005}\u0013gBA\na\u0013\t\tG#\u0001\u0004Qe\u0016$WMZ\u0005\u0003G\u0012\u0014aa\u0015;sS:<'BA1\u0015\u0001")
public class JdbcSink
implements DataCalcSink<JdbcSinkConfig>,
Logging {
    private final Logger logger;
    private Object config;
    private volatile boolean bitmap$0;

    private Logger logger$lzycompute() {
        JdbcSink jdbcSink = this;
        synchronized (jdbcSink) {
            if (!this.bitmap$0) {
                this.logger = Logging.class.logger((Logging)this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    public void trace(Function0<String> message) {
        Logging.class.trace((Logging)this, message);
    }

    public void debug(Function0<String> message) {
        Logging.class.debug((Logging)this, message);
    }

    public void info(Function0<String> message) {
        Logging.class.info((Logging)this, message);
    }

    public void info(Function0<String> message, Throwable t) {
        Logging.class.info((Logging)this, message, (Throwable)t);
    }

    public void warn(Function0<String> message) {
        Logging.class.warn((Logging)this, message);
    }

    public void warn(Function0<String> message, Throwable t) {
        Logging.class.warn((Logging)this, message, (Throwable)t);
    }

    public void error(Function0<String> message, Throwable t) {
        Logging.class.error((Logging)this, message, (Throwable)t);
    }

    public void error(Function0<String> message) {
        Logging.class.error((Logging)this, message);
    }

    @Override
    public Object config() {
        return this.config;
    }

    @Override
    @TraitSetter
    public void config_$eq(Object x$1) {
        this.config = x$1;
    }

    @Override
    public Object getConfig() {
        return DataCalcPlugin$class.getConfig(this);
    }

    @Override
    public void setConfig(Object config) {
        DataCalcPlugin$class.setConfig(this, config);
    }

    @Override
    public void prepare(SparkSession spark) {
        DataCalcPlugin$class.prepare(this, spark);
    }

    @Override
    public void output(SparkSession spark, Dataset<Row> ds) {
        String targetTable = StringUtils.isBlank((CharSequence)((JdbcSinkConfig)this.config()).getTargetDatabase()) ? ((JdbcSinkConfig)this.config()).getTargetTable() : new StringBuilder().append((Object)((JdbcSinkConfig)this.config()).getTargetDatabase()).append((Object)".").append((Object)((JdbcSinkConfig)this.config()).getTargetTable()).toString();
        ObjectRef options = ObjectRef.create((Object)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"url"), (Object)((JdbcSinkConfig)this.config()).getUrl()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"driver"), (Object)((JdbcSinkConfig)this.config()).getDriver()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"user"), (Object)((JdbcSinkConfig)this.config()).getUser()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"password"), (Object)((JdbcSinkConfig)this.config()).getPassword()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"dbtable"), (Object)targetTable), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"connectionCollation"), (Object)"utf8mb4_unicode_ci")}))));
        if (((SinkConfig)this.config()).getOptions() != null && !((SinkConfig)this.config()).getOptions().isEmpty()) {
            options.elem = ((TraversableOnce)JavaConverters$.MODULE$.mapAsScalaMapConverter(((SinkConfig)this.config()).getOptions()).asScala()).toMap(Predef$.MODULE$.$conforms()).$plus$plus((GenTraversableOnce)((scala.collection.immutable.Map)options.elem));
        }
        options.elem = ((scala.collection.immutable.Map)options.elem).$plus$plus((GenTraversableOnce)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"isolationLevel"), ((scala.collection.immutable.Map)options.elem).getOrElse((Object)"isolationLevel", (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "NONE";
            }
        })), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"batchsize"), ((scala.collection.immutable.Map)options.elem).getOrElse((Object)"batchsize", (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "5000";
            }
        }))})));
        if (((JdbcSinkConfig)this.config()).getPreQueries() != null && !((JdbcSinkConfig)this.config()).getPreQueries().isEmpty()) {
            spark.sql("select 1").repartition(1).foreachPartition((Function1)new Serializable(this, options){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ JdbcSink $outer;
                private final ObjectRef options$1;

                public final void apply(Iterator<Row> x$1) {
                    JDBCOptions jdbcOptions = new JDBCOptions((scala.collection.immutable.Map)this.options$1.elem);
                    try (Connection conn = DriverManager.getConnection(((JdbcSinkConfig)this.$outer.config()).getUrl(), ((JdbcSinkConfig)this.$outer.config()).getUser(), ((JdbcSinkConfig)this.$outer.config()).getPassword());){
                        try {
                            ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(((JdbcSinkConfig)this.$outer.config()).getPreQueries()).asScala()).foreach((Function1)new Serializable(this, jdbcOptions, conn){
                                public static final long serialVersionUID = 0L;
                                private final /* synthetic */ $anonfun$output$3 $outer;
                                private final JDBCOptions jdbcOptions$1;
                                private final Connection conn$1;

                                public final void apply(String query) {
                                    this.$outer.org$apache$linkis$engineplugin$spark$datacalc$sink$JdbcSink$$anonfun$$$outer().logger().info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Execute pre query: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{query})));
                                    this.$outer.org$apache$linkis$engineplugin$spark$datacalc$sink$JdbcSink$$anonfun$$$outer().org$apache$linkis$engineplugin$spark$datacalc$sink$JdbcSink$$execute(this.conn$1, this.jdbcOptions$1, query);
                                }
                                {
                                    if ($outer == null) {
                                        throw null;
                                    }
                                    this.$outer = $outer;
                                    this.jdbcOptions$1 = jdbcOptions$1;
                                    this.conn$1 = conn$1;
                                }
                            });
                        }
                        catch (Exception exception) {
                            this.$outer.logger().error("Execute preQueries failed. ", (Throwable)exception);
                        }
                    }
                }

                public /* synthetic */ JdbcSink org$apache$linkis$engineplugin$spark$datacalc$sink$JdbcSink$$anonfun$$$outer() {
                    return this.$outer;
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.options$1 = options$1;
                }
            });
        }
        DataFrameWriter writer = ds.repartition(Predef$.MODULE$.Integer2int(((JdbcSinkConfig)this.config()).getNumPartitions())).write().format("jdbc");
        Object object = StringUtils.isNotBlank((CharSequence)((JdbcSinkConfig)this.config()).getSaveMode()) ? writer.mode(((JdbcSinkConfig)this.config()).getSaveMode()) : BoxedUnit.UNIT;
        this.logger().info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Save data to jdbc url: ", ", driver: ", ", username: ", ", table: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{((JdbcSinkConfig)this.config()).getUrl(), ((JdbcSinkConfig)this.config()).getDriver(), ((JdbcSinkConfig)this.config()).getUser(), targetTable})));
        writer.options((Map)((scala.collection.immutable.Map)options.elem)).save();
    }

    public void org$apache$linkis$engineplugin$spark$datacalc$sink$JdbcSink$$execute(Connection conn, JDBCOptions jdbcOptions, String query) {
        this.logger().info("Execute query: {}", new Object[]{query});
        try (PreparedStatement statement = conn.prepareStatement(query);){
            try {
                if (new StringOps(Predef$.MODULE$.augmentString(package$.MODULE$.SPARK_VERSION())).$greater$eq((Object)"2.4")) {
                    int queryTimeout = BoxesRunTime.unboxToInt((Object)ClassUtils$.MODULE$.getFieldVal((Object)jdbcOptions, "queryTimeout"));
                    statement.setQueryTimeout(queryTimeout);
                }
                int rows = statement.executeUpdate();
                this.logger().info("{} rows affected", (Object)BoxesRunTime.boxToInteger((int)rows));
            }
            catch (Exception exception) {
                this.logger().error("Execute query failed. ", (Throwable)exception);
            }
        }
    }

    public JdbcSink() {
        DataCalcPlugin$class.$init$(this);
        Logging.class.$init$((Logging)this);
    }
}

