/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.engineplugin.spark.datacalc.sink;

import java.text.MessageFormat;
import org.apache.linkis.common.utils.Logging;
import org.apache.linkis.engineplugin.spark.datacalc.api.DataCalcPlugin$class;
import org.apache.linkis.engineplugin.spark.datacalc.api.DataCalcSink;
import org.apache.linkis.engineplugin.spark.datacalc.exception.DataSourceNotConfigException;
import org.apache.linkis.engineplugin.spark.datacalc.model.DataCalcDataSource;
import org.apache.linkis.engineplugin.spark.datacalc.model.DataCalcPluginConfig;
import org.apache.linkis.engineplugin.spark.datacalc.model.SinkConfig;
import org.apache.linkis.engineplugin.spark.datacalc.service.LinkisDataSourceService;
import org.apache.linkis.engineplugin.spark.datacalc.sink.JdbcSink;
import org.apache.linkis.engineplugin.spark.datacalc.sink.JdbcSinkConfig;
import org.apache.linkis.engineplugin.spark.datacalc.sink.ManagedJdbcSinkConfig;
import org.apache.linkis.engineplugin.spark.errorcode.SparkErrorCodeSummary;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.slf4j.Logger;
import scala.Function0;
import scala.reflect.ScalaSignature;
import scala.runtime.TraitSetter;

@ScalaSignature(bytes="\u0006\u0001\u00113A!\u0001\u0002\u0001#\tyQ*\u00198bO\u0016$'\n\u001a2d'&t7N\u0003\u0002\u0004\t\u0005!1/\u001b8l\u0015\t)a!\u0001\u0005eCR\f7-\u00197d\u0015\t9\u0001\"A\u0003ta\u0006\u00148N\u0003\u0002\n\u0015\u0005aQM\\4j]\u0016\u0004H.^4j]*\u00111\u0002D\u0001\u0007Y&t7.[:\u000b\u00055q\u0011AB1qC\u000eDWMC\u0001\u0010\u0003\ry'oZ\u0002\u0001'\u0011\u0001!\u0003\u0007\u0012\u0011\u0005M1R\"\u0001\u000b\u000b\u0003U\tQa]2bY\u0006L!a\u0006\u000b\u0003\r\u0005s\u0017PU3g!\rIBDH\u0007\u00025)\u00111\u0004B\u0001\u0004CBL\u0017BA\u000f\u001b\u00051!\u0015\r^1DC2\u001c7+\u001b8l!\ty\u0002%D\u0001\u0003\u0013\t\t#AA\u000bNC:\fw-\u001a3KI\n\u001c7+\u001b8l\u0007>tg-[4\u0011\u0005\rBS\"\u0001\u0013\u000b\u0005\u00152\u0013!B;uS2\u001c(BA\u0014\u000b\u0003\u0019\u0019w.\\7p]&\u0011\u0011\u0006\n\u0002\b\u0019><w-\u001b8h\u0011\u0015Y\u0003\u0001\"\u0001-\u0003\u0019a\u0014N\\5u}Q\tQ\u0006\u0005\u0002 \u0001!)q\u0006\u0001C\u0001a\u00051q.\u001e;qkR$2!\r\u001b=!\t\u0019\"'\u0003\u00024)\t!QK\\5u\u0011\u00159a\u00061\u00016!\t1$(D\u00018\u0015\tA\u0014(A\u0002tc2T!a\u0002\u0007\n\u0005m:$\u0001D*qCJ\\7+Z:tS>t\u0007\"B\u001f/\u0001\u0004q\u0014A\u00013t!\r1t(Q\u0005\u0003\u0001^\u0012q\u0001R1uCN,G\u000f\u0005\u00027\u0005&\u00111i\u000e\u0002\u0004%><\b")
public class ManagedJdbcSink
implements DataCalcSink<ManagedJdbcSinkConfig>,
Logging {
    private final Logger logger;
    private Object config;
    private volatile boolean bitmap$0;

    private Logger logger$lzycompute() {
        ManagedJdbcSink managedJdbcSink = this;
        synchronized (managedJdbcSink) {
            if (!this.bitmap$0) {
                this.logger = Logging.class.logger((Logging)this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    public void trace(Function0<String> message) {
        Logging.class.trace((Logging)this, message);
    }

    public void debug(Function0<String> message) {
        Logging.class.debug((Logging)this, message);
    }

    public void info(Function0<String> message) {
        Logging.class.info((Logging)this, message);
    }

    public void info(Function0<String> message, Throwable t) {
        Logging.class.info((Logging)this, message, (Throwable)t);
    }

    public void warn(Function0<String> message) {
        Logging.class.warn((Logging)this, message);
    }

    public void warn(Function0<String> message, Throwable t) {
        Logging.class.warn((Logging)this, message, (Throwable)t);
    }

    public void error(Function0<String> message, Throwable t) {
        Logging.class.error((Logging)this, message, (Throwable)t);
    }

    public void error(Function0<String> message) {
        Logging.class.error((Logging)this, message);
    }

    @Override
    public Object config() {
        return this.config;
    }

    @Override
    @TraitSetter
    public void config_$eq(Object x$1) {
        this.config = x$1;
    }

    @Override
    public Object getConfig() {
        return DataCalcPlugin$class.getConfig(this);
    }

    @Override
    public void setConfig(Object config) {
        DataCalcPlugin$class.setConfig(this, config);
    }

    @Override
    public void prepare(SparkSession spark) {
        DataCalcPlugin$class.prepare(this, spark);
    }

    @Override
    public void output(SparkSession spark, Dataset<Row> ds) {
        DataCalcDataSource db = LinkisDataSourceService.getDatasource(((ManagedJdbcSinkConfig)this.config()).getTargetDatasource());
        if (db == null) {
            throw new DataSourceNotConfigException(SparkErrorCodeSummary.DATA_CALC_DATASOURCE_NOT_CONFIG.getErrorCode(), MessageFormat.format(SparkErrorCodeSummary.DATA_CALC_DATASOURCE_NOT_CONFIG.getErrorDesc(), ((ManagedJdbcSinkConfig)this.config()).getTargetDatasource()));
        }
        JdbcSinkConfig jdbcConfig = new JdbcSinkConfig();
        jdbcConfig.setUrl(db.getUrl());
        jdbcConfig.setDriver(db.getDriver());
        jdbcConfig.setUser(db.getUser());
        jdbcConfig.setPassword(db.getPassword());
        jdbcConfig.setTargetDatabase(((ManagedJdbcSinkConfig)this.config()).getTargetDatabase());
        jdbcConfig.setTargetTable(((ManagedJdbcSinkConfig)this.config()).getTargetTable());
        jdbcConfig.setSaveMode(((ManagedJdbcSinkConfig)this.config()).getSaveMode());
        jdbcConfig.setPreQueries(((ManagedJdbcSinkConfig)this.config()).getPreQueries());
        jdbcConfig.setNumPartitions(((ManagedJdbcSinkConfig)this.config()).getNumPartitions());
        jdbcConfig.setOptions(((SinkConfig)this.config()).getOptions());
        jdbcConfig.setSourceTable(((SinkConfig)this.config()).getSourceTable());
        jdbcConfig.setSourceQuery(((SinkConfig)this.config()).getSourceQuery());
        jdbcConfig.setVariables(((DataCalcPluginConfig)this.config()).getVariables());
        JdbcSink sinkPlugin = new JdbcSink();
        sinkPlugin.setConfig(jdbcConfig);
        sinkPlugin.output(spark, ds);
    }

    public ManagedJdbcSink() {
        DataCalcPlugin$class.$init$(this);
        Logging.class.$init$((Logging)this);
    }
}

