/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.engineplugin.spark.executor;

import java.math.BigDecimal;
import java.text.NumberFormat;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import org.apache.commons.lang3.StringUtils;
import org.apache.linkis.common.io.MetaData;
import org.apache.linkis.common.io.Record;
import org.apache.linkis.common.io.resultset.ResultSetWriter;
import org.apache.linkis.common.utils.ByteTimeUtils;
import org.apache.linkis.common.utils.Logging;
import org.apache.linkis.common.utils.Utils$;
import org.apache.linkis.engineconn.computation.executor.execute.EngineExecutionContext;
import org.apache.linkis.engineplugin.spark.config.SparkConfiguration$;
import org.apache.linkis.engineplugin.spark.errorcode.SparkErrorCodeSummary;
import org.apache.linkis.engineplugin.spark.exception.SparkEngineException;
import org.apache.linkis.engineplugin.spark.executor.SQLSession$;
import org.apache.linkis.engineplugin.spark.utils.EngineUtils$;
import org.apache.linkis.governance.common.exception.LinkisJobRetryException;
import org.apache.linkis.storage.LineMetaData;
import org.apache.linkis.storage.LineRecord;
import org.apache.linkis.storage.domain.Column;
import org.apache.linkis.storage.domain.DataType$;
import org.apache.linkis.storage.resultset.ResultSetFactory$;
import org.apache.linkis.storage.resultset.table.TableMetaData;
import org.apache.linkis.storage.resultset.table.TableRecord;
import org.apache.spark.SparkContext;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.catalyst.expressions.Attribute;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DecimalType$;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.MapType;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.GenIterable;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.Iterable$;
import scala.collection.immutable.Map;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.StringBuilder;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.Nothing$;
import scala.runtime.ObjectRef;

public final class SQLSession$
implements Logging {
    public static final SQLSession$ MODULE$;
    private final NumberFormat nf;
    private final Logger logger;
    private volatile boolean bitmap$0;

    static {
        new SQLSession$();
    }

    private Logger logger$lzycompute() {
        SQLSession$ sQLSession$ = this;
        synchronized (sQLSession$) {
            if (!this.bitmap$0) {
                this.logger = Logging.class.logger((Logging)this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    public void trace(Function0<String> message) {
        Logging.class.trace((Logging)this, message);
    }

    public void debug(Function0<String> message) {
        Logging.class.debug((Logging)this, message);
    }

    public void info(Function0<String> message) {
        Logging.class.info((Logging)this, message);
    }

    public void info(Function0<String> message, Throwable t) {
        Logging.class.info((Logging)this, message, (Throwable)t);
    }

    public void warn(Function0<String> message) {
        Logging.class.warn((Logging)this, message);
    }

    public void warn(Function0<String> message, Throwable t) {
        Logging.class.warn((Logging)this, message, (Throwable)t);
    }

    public void error(Function0<String> message, Throwable t) {
        Logging.class.error((Logging)this, message, (Throwable)t);
    }

    public void error(Function0<String> message) {
        Logging.class.error((Logging)this, message);
    }

    public NumberFormat nf() {
        return this.nf;
    }

    public void showDF(SparkContext sc, String jobGroup, Dataset<Row> dataFrame, String alias, int maxResult, EngineExecutionContext engineExecutionContext) {
        if (sc.isStopped()) {
            this.logger().error("Spark application has already stopped in showDF, please restart it.");
            throw new LinkisJobRetryException("Spark application sc has already stopped, please restart it.");
        }
        long startTime = System.currentTimeMillis();
        Iterator iterator = (Iterator)Utils$.MODULE$.tryThrow((Function0)new Serializable(dataFrame){
            public static final long serialVersionUID = 0L;
            private final Dataset dataFrame$1;

            public final Iterator<Row> apply() {
                return this.dataFrame$1.toLocalIterator();
            }
            {
                this.dataFrame$1 = dataFrame$1;
            }
        }, (Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Nothing$ apply(Throwable t) {
                throw new SparkEngineException(SparkErrorCodeSummary.DATAFRAME_EXCEPTION.getErrorCode(), SparkErrorCodeSummary.DATAFRAME_EXCEPTION.getErrorDesc(), t);
            }
        });
        HashSet colSet = new HashSet();
        StructType schema = dataFrame.schema();
        ObjectRef columnsSet = ObjectRef.create(null);
        schema.foreach((Function1)new Serializable(colSet){
            public static final long serialVersionUID = 0L;
            private final HashSet colSet$1;

            public final boolean apply(StructField s) {
                return this.colSet$1.add(s.name());
            }
            {
                this.colSet$1 = colSet$1;
            }
        });
        if (colSet.size() < schema.size()) {
            ArrayBuffer arr = new ArrayBuffer();
            HashSet tmpSet = new HashSet();
            ArrayBuffer tmpArr = new ArrayBuffer();
            dataFrame.queryExecution().analyzed().output().foreach((Function1)new Serializable(tmpSet, tmpArr){
                public static final long serialVersionUID = 0L;
                private final HashSet tmpSet$1;
                private final ArrayBuffer tmpArr$1;

                public final ArrayBuffer<StructField> apply(Attribute attri) {
                    StructField tempAttri = new StructField(attri.qualifiedName(), attri.dataType(), attri.nullable(), attri.metadata());
                    this.tmpSet$1.add(tempAttri);
                    return this.tmpArr$1.$plus$eq((Object)tempAttri);
                }
                {
                    this.tmpSet$1 = tmpSet$1;
                    this.tmpArr$1 = tmpArr$1;
                }
            });
            if (tmpSet.size() < schema.size()) {
                dataFrame.queryExecution().analyzed().output().foreach((Function1)new Serializable(arr){
                    public static final long serialVersionUID = 0L;
                    private final ArrayBuffer arr$1;

                    public final ArrayBuffer<StructField> apply(Attribute attri) {
                        StructField tempAttri = new StructField(attri.toString(), attri.dataType(), attri.nullable(), attri.metadata());
                        return this.arr$1.$plus$eq((Object)tempAttri);
                    }
                    {
                        this.arr$1 = arr$1;
                    }
                });
            } else {
                tmpArr.foreach((Function1)new Serializable(arr){
                    public static final long serialVersionUID = 0L;
                    private final ArrayBuffer arr$1;

                    public final ArrayBuffer<StructField> apply(StructField x$1) {
                        return this.arr$1.$plus$eq((Object)x$1);
                    }
                    {
                        this.arr$1 = arr$1;
                    }
                });
            }
            columnsSet.elem = new StructType((StructField[])arr.toArray(ClassTag$.MODULE$.apply(StructField.class)));
        } else {
            columnsSet.elem = schema;
        }
        Column[] columns = (Column[])((TraversableOnce)((StructType)columnsSet.elem).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Column apply(StructField c) {
                return new Column(c.name(), DataType$.MODULE$.toDataType(c.dataType().typeName().toLowerCase(Locale.getDefault())), (String)c.getComment().orNull(Predef$.MODULE$.$conforms()));
            }
        }, Seq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(Column.class));
        Predef$.MODULE$.refArrayOps((Object[])columns).foreach((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final void apply(Column c) {
                SQLSession$.MODULE$.logger().info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"c is ", ", comment is ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{c.columnName(), c.comment()})));
            }
        });
        if (columns == null || Predef$.MODULE$.refArrayOps((Object[])columns).isEmpty()) {
            return;
        }
        TableMetaData metaData = new TableMetaData(columns);
        ResultSetWriter writer = StringUtils.isNotBlank((CharSequence)alias) ? engineExecutionContext.createResultSetWriter(ResultSetFactory$.MODULE$.TABLE_TYPE(), alias) : engineExecutionContext.createResultSetWriter(ResultSetFactory$.MODULE$.TABLE_TYPE());
        writer.addMetaData((MetaData)metaData);
        IntRef index = IntRef.create((int)0);
        Utils$.MODULE$.tryThrow((Function0)new Serializable(maxResult, iterator, columnsSet, columns, writer, index){
            public static final long serialVersionUID = 0L;
            private final int maxResult$1;
            private final Iterator iterator$1;
            public final ObjectRef columnsSet$1;
            private final Column[] columns$1;
            private final ResultSetWriter writer$1;
            private final IntRef index$1;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                while (this.index$1.elem < this.maxResult$1 && this.iterator$1.hasNext()) {
                    Row row = (Row)this.iterator$1.next();
                    Object[] r = (Object[])((TraversableOnce)Predef$.MODULE$.refArrayOps((Object[])this.columns$1).indices().map((Function1)new Serializable(this, row){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ anonfun.showDF.1 $outer;
                        private final Row row$1;

                        public final String apply(int i) {
                            return SQLSession$.MODULE$.org$apache$linkis$engineplugin$spark$executor$SQLSession$$toHiveString((Tuple2<Object, DataType>)new Tuple2(this.row$1.apply(i), (Object)((StructType)this.$outer.columnsSet$1.elem).fields()[i].dataType()));
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                            this.row$1 = row$1;
                        }
                    }, IndexedSeq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.Any());
                    this.writer$1.addRecord((Record)new TableRecord(r));
                    ++this.index$1.elem;
                }
            }
            {
                this.maxResult$1 = maxResult$1;
                this.iterator$1 = iterator$1;
                this.columnsSet$1 = columnsSet$1;
                this.columns$1 = columns$1;
                this.writer$1 = writer$1;
                this.index$1 = index$1;
            }
        }, (Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Nothing$ apply(Throwable t) {
                throw new SparkEngineException(SparkErrorCodeSummary.READ_RECORD_EXCEPTION.getErrorCode(), SparkErrorCodeSummary.READ_RECORD_EXCEPTION.getErrorDesc(), t);
            }
        });
        String taken = ByteTimeUtils.msDurationToString((long)(System.currentTimeMillis() - startTime));
        this.logger().warn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Time taken: ", ", Fetched ", " row(s)."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{taken, BoxesRunTime.boxToInteger((int)index.elem)})));
        engineExecutionContext.appendStdout(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " >> Time taken: ", ", Fetched ", " row(s)."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{EngineUtils$.MODULE$.getName(), taken, BoxesRunTime.boxToInteger((int)index.elem)})));
        engineExecutionContext.sendResultSet(writer);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String org$apache$linkis$engineplugin$spark$executor$SQLSession$$toHiveString(Tuple2<Object, DataType> a) {
        Tuple2<Object, DataType> tuple2 = a;
        if (tuple2 != null) {
            Object struct = tuple2._1();
            DataType dataType = (DataType)tuple2._2();
            if (struct instanceof Row) {
                Row row = (Row)struct;
                if (dataType instanceof StructType) {
                    StructType structType = (StructType)dataType;
                    StructField[] fields = structType.fields();
                    return ((TraversableOnce)((TraversableLike)row.toSeq().zip((GenIterable)Predef$.MODULE$.wrapRefArray((Object[])fields), Seq$.MODULE$.canBuildFrom())).map((Function1)new Serializable(){
                        public static final long serialVersionUID = 0L;

                        public final String apply(Tuple2<Object, StructField> x0$3) {
                            Tuple2<Object, StructField> tuple2 = x0$3;
                            if (tuple2 != null) {
                                Object v = tuple2._1();
                                StructField t = (StructField)tuple2._2();
                                String string = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\"", "\":", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{t.name(), SQLSession$.MODULE$.org$apache$linkis$engineplugin$spark$executor$SQLSession$$toHiveStructString$1(new Tuple2(v, (Object)t.dataType()))}));
                                return string;
                            }
                            throw new MatchError(tuple2);
                        }
                    }, Seq$.MODULE$.canBuildFrom())).mkString("{", ",", "}");
                }
            }
        }
        if (tuple2 != null) {
            Object seq = tuple2._1();
            DataType dataType = (DataType)tuple2._2();
            if (seq instanceof Seq) {
                Seq seq2 = (Seq)seq;
                if (dataType instanceof ArrayType) {
                    ArrayType arrayType = (ArrayType)dataType;
                    DataType typ = arrayType.elementType();
                    return ((TraversableOnce)((TraversableLike)seq2.map((Function1)new Serializable(typ){
                        public static final long serialVersionUID = 0L;
                        private final DataType typ$2;

                        public final Tuple2<Object, DataType> apply(Object v) {
                            return new Tuple2(v, (Object)this.typ$2);
                        }
                        {
                            this.typ$2 = typ$2;
                        }
                    }, Seq$.MODULE$.canBuildFrom())).map((Function1)new Serializable(){
                        public static final long serialVersionUID = 0L;

                        public final String apply(Tuple2<Object, DataType> a) {
                            return SQLSession$.MODULE$.org$apache$linkis$engineplugin$spark$executor$SQLSession$$toHiveStructString$1(a);
                        }
                    }, Seq$.MODULE$.canBuildFrom())).mkString("[", ",", "]");
                }
            }
        }
        if (tuple2 != null) {
            Object map = tuple2._1();
            DataType dataType = (DataType)tuple2._2();
            if (map instanceof Map) {
                Map map2 = (Map)map;
                if (dataType instanceof MapType) {
                    MapType mapType = (MapType)dataType;
                    DataType kType = mapType.keyType();
                    DataType vType = mapType.valueType();
                    return ((TraversableOnce)((TraversableOnce)map2.map((Function1)new Serializable(kType, vType){
                        public static final long serialVersionUID = 0L;
                        private final DataType kType$2;
                        private final DataType vType$2;

                        public final String apply(Tuple2<Object, Object> x0$4) {
                            Tuple2<Object, Object> tuple2 = x0$4;
                            if (tuple2 != null) {
                                Object key = tuple2._1();
                                Object value = tuple2._2();
                                String string = new StringBuilder().append((Object)SQLSession$.MODULE$.org$apache$linkis$engineplugin$spark$executor$SQLSession$$toHiveStructString$1(new Tuple2(key, (Object)this.kType$2))).append((Object)":").append((Object)SQLSession$.MODULE$.org$apache$linkis$engineplugin$spark$executor$SQLSession$$toHiveStructString$1(new Tuple2(value, (Object)this.vType$2))).toString();
                                return string;
                            }
                            throw new MatchError(tuple2);
                        }
                        {
                            this.kType$2 = kType$2;
                            this.vType$2 = vType$2;
                        }
                    }, Iterable$.MODULE$.canBuildFrom())).toSeq().sorted((Ordering)Ordering.String$.MODULE$)).mkString("{", ",", "}");
                }
            }
        }
        if (tuple2 != null) {
            Object str = tuple2._1();
            DataType dataType = (DataType)tuple2._2();
            if (str instanceof String) {
                String string = (String)str;
                if (StringType$.MODULE$.equals(dataType)) {
                    return string.replaceAll("\n|\t", " ");
                }
            }
        }
        if (tuple2 != null) {
            Object object = tuple2._1();
            DataType dataType = (DataType)tuple2._2();
            if (object instanceof Double) {
                double d = BoxesRunTime.unboxToDouble((Object)object);
                if (DoubleType$.MODULE$.equals(dataType)) {
                    return this.nf().format(d);
                }
            }
        }
        if (tuple2 != null) {
            Object decimal = tuple2._1();
            DataType dataType = (DataType)tuple2._2();
            if (decimal instanceof BigDecimal) {
                BigDecimal bigDecimal = (BigDecimal)decimal;
                if (DecimalType$.MODULE$.unapply(dataType)) {
                    return this.formatDecimal$1(bigDecimal);
                }
            }
        }
        if (tuple2 == null) return null;
        Object other = tuple2._1();
        if (!(other instanceof Object)) return null;
        Object object = other;
        return object.toString();
    }

    public void showHTML(SparkContext sc, String jobGroup, Object htmlContent, EngineExecutionContext engineExecutionContext) {
        long startTime = System.currentTimeMillis();
        ResultSetWriter writer = engineExecutionContext.createResultSetWriter(ResultSetFactory$.MODULE$.HTML_TYPE());
        LineMetaData metaData = new LineMetaData(null);
        writer.addMetaData((MetaData)metaData);
        writer.addRecord((Record)new LineRecord(htmlContent.toString()));
        this.logger().warn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Time taken: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{ByteTimeUtils.msDurationToString((long)(System.currentTimeMillis() - startTime))})));
        engineExecutionContext.sendResultSet(writer);
    }

    private final String formatDecimal$1(BigDecimal d) {
        return d.compareTo(BigDecimal.ZERO) == 0 ? BigDecimal.ZERO.toPlainString() : d.stripTrailingZeros().toPlainString();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final String org$apache$linkis$engineplugin$spark$executor$SQLSession$$toHiveStructString$1(Tuple2 a) {
        Object object;
        Tuple2 tuple2 = a;
        if (tuple2 != null) {
            Object struct = tuple2._1();
            DataType dataType = (DataType)tuple2._2();
            if (struct instanceof Row) {
                Row row = (Row)struct;
                if (dataType instanceof StructType) {
                    StructType structType = (StructType)dataType;
                    StructField[] fields = structType.fields();
                    return ((TraversableOnce)((TraversableLike)row.toSeq().zip((GenIterable)Predef$.MODULE$.wrapRefArray((Object[])fields), Seq$.MODULE$.canBuildFrom())).map((Function1)new Serializable(){
                        public static final long serialVersionUID = 0L;

                        public final String apply(Tuple2<Object, StructField> x0$1) {
                            Tuple2<Object, StructField> tuple2 = x0$1;
                            if (tuple2 != null) {
                                Object v = tuple2._1();
                                StructField t = (StructField)tuple2._2();
                                String string = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\"", "\":", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{t.name(), SQLSession$.MODULE$.org$apache$linkis$engineplugin$spark$executor$SQLSession$$toHiveStructString$1(new Tuple2(v, (Object)t.dataType()))}));
                                return string;
                            }
                            throw new MatchError(tuple2);
                        }
                    }, Seq$.MODULE$.canBuildFrom())).mkString("{", ",", "}");
                }
            }
        }
        if (tuple2 != null) {
            Object seq = tuple2._1();
            DataType dataType = (DataType)tuple2._2();
            if (seq instanceof Seq) {
                Seq seq2 = (Seq)seq;
                if (dataType instanceof ArrayType) {
                    ArrayType arrayType = (ArrayType)dataType;
                    DataType typ = arrayType.elementType();
                    return ((TraversableOnce)((TraversableLike)seq2.map((Function1)new Serializable(typ){
                        public static final long serialVersionUID = 0L;
                        private final DataType typ$1;

                        public final Tuple2<Object, DataType> apply(Object v) {
                            return new Tuple2(v, (Object)this.typ$1);
                        }
                        {
                            this.typ$1 = typ$1;
                        }
                    }, Seq$.MODULE$.canBuildFrom())).map((Function1)new Serializable(){
                        public static final long serialVersionUID = 0L;

                        public final String apply(Tuple2<Object, DataType> a) {
                            return SQLSession$.MODULE$.org$apache$linkis$engineplugin$spark$executor$SQLSession$$toHiveStructString$1(a);
                        }
                    }, Seq$.MODULE$.canBuildFrom())).mkString("[", ",", "]");
                }
            }
        }
        if (tuple2 != null) {
            Object map = tuple2._1();
            DataType dataType = (DataType)tuple2._2();
            if (map instanceof Map) {
                Map map2 = (Map)map;
                if (dataType instanceof MapType) {
                    MapType mapType = (MapType)dataType;
                    DataType kType = mapType.keyType();
                    DataType vType = mapType.valueType();
                    return ((TraversableOnce)((TraversableOnce)map2.map((Function1)new Serializable(kType, vType){
                        public static final long serialVersionUID = 0L;
                        private final DataType kType$1;
                        private final DataType vType$1;

                        public final String apply(Tuple2<Object, Object> x0$2) {
                            Tuple2<Object, Object> tuple2 = x0$2;
                            if (tuple2 != null) {
                                Object key = tuple2._1();
                                Object value = tuple2._2();
                                String string = new StringBuilder().append((Object)SQLSession$.MODULE$.org$apache$linkis$engineplugin$spark$executor$SQLSession$$toHiveStructString$1(new Tuple2(key, (Object)this.kType$1))).append((Object)":").append((Object)SQLSession$.MODULE$.org$apache$linkis$engineplugin$spark$executor$SQLSession$$toHiveStructString$1(new Tuple2(value, (Object)this.vType$1))).toString();
                                return string;
                            }
                            throw new MatchError(tuple2);
                        }
                        {
                            this.kType$1 = kType$1;
                            this.vType$1 = vType$1;
                        }
                    }, Iterable$.MODULE$.canBuildFrom())).toSeq().sorted((Ordering)Ordering.String$.MODULE$)).mkString("{", ",", "}");
                }
            }
        }
        if (tuple2 != null && (object = tuple2._1()) == null) {
            return "null";
        }
        if (tuple2 != null) {
            Object str = tuple2._1();
            DataType dataType = (DataType)tuple2._2();
            if (str instanceof String) {
                String string = (String)str;
                if (StringType$.MODULE$.equals(dataType)) {
                    return string.replaceAll("\n|\t", " ");
                }
            }
        }
        if (tuple2 != null) {
            Object object2 = tuple2._1();
            DataType dataType = (DataType)tuple2._2();
            if (object2 instanceof Double) {
                double d = BoxesRunTime.unboxToDouble((Object)object2);
                if (DoubleType$.MODULE$.equals(dataType)) {
                    return this.nf().format(d);
                }
            }
        }
        if (tuple2 != null) {
            Object decimal = tuple2._1();
            DataType dataType = (DataType)tuple2._2();
            if (decimal instanceof BigDecimal) {
                BigDecimal bigDecimal = (BigDecimal)decimal;
                if (DecimalType$.MODULE$.unapply(dataType)) {
                    return this.formatDecimal$1(bigDecimal);
                }
            }
        }
        if (tuple2 == null) return null;
        Object other = tuple2._1();
        if (!(other instanceof Object)) return null;
        Object object3 = other;
        return object3.toString();
    }

    private SQLSession$() {
        MODULE$ = this;
        Logging.class.$init$((Logging)this);
        this.nf = NumberFormat.getInstance();
        this.nf().setGroupingUsed(false);
        this.nf().setMaximumFractionDigits(BoxesRunTime.unboxToInt((Object)SparkConfiguration$.MODULE$.SPARK_NF_FRACTION_LENGTH().getValue()));
    }
}

