/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.engineplugin.spark.utils;

import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;
import org.apache.linkis.common.utils.JsonUtils$;
import org.apache.linkis.common.utils.Logging;
import org.apache.linkis.engineconn.launch.EngineConnServer$;
import org.apache.linkis.engineplugin.spark.config.SparkConfiguration$;
import org.apache.linkis.protocol.engine.JobProgressInfo;
import org.slf4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;

public final class SparkJobProgressUtil$
implements Logging {
    public static final SparkJobProgressUtil$ MODULE$;
    private final Logger logger;
    private volatile boolean bitmap$0;

    static {
        new SparkJobProgressUtil$();
    }

    private Logger logger$lzycompute() {
        SparkJobProgressUtil$ sparkJobProgressUtil$ = this;
        synchronized (sparkJobProgressUtil$) {
            if (!this.bitmap$0) {
                this.logger = Logging.class.logger((Logging)this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    public void trace(Function0<String> message) {
        Logging.class.trace((Logging)this, message);
    }

    public void debug(Function0<String> message) {
        Logging.class.debug((Logging)this, message);
    }

    public void info(Function0<String> message) {
        Logging.class.info((Logging)this, message);
    }

    public void info(Function0<String> message, Throwable t) {
        Logging.class.info((Logging)this, message, (Throwable)t);
    }

    public void warn(Function0<String> message) {
        Logging.class.warn((Logging)this, message);
    }

    public void warn(Function0<String> message, Throwable t) {
        Logging.class.warn((Logging)this, message, (Throwable)t);
    }

    public void error(Function0<String> message, Throwable t) {
        Logging.class.error((Logging)this, message, (Throwable)t);
    }

    public void error(Function0<String> message) {
        Logging.class.error((Logging)this, message);
    }

    public float getProgress(String applicationId) {
        if (StringUtils.isBlank((CharSequence)applicationId)) {
            return 0.0f;
        }
        Map<String, Object>[] sparkJobsResult = this.getSparkJobInfo(applicationId);
        if (Predef$.MODULE$.refArrayOps((Object[])sparkJobsResult).isEmpty()) {
            return 0.0f;
        }
        Tuple2 tuple = (Tuple2)Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])sparkJobsResult).filter((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Map<String, Object> sparkJobResult) {
                String status = (String)sparkJobResult.getOrDefault("status", "");
                return "RUNNING".equals(status) || "SUCCEEDED".equals(status);
            }
        })).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Tuple2<Integer, Integer> apply(Map<String, Object> result) {
                return new Tuple2((Object)((Integer)result.get("numTasks")), (Object)((Integer)result.get("numCompletedTasks")));
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)))).reduce((Function2)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Tuple2<Integer, Integer> apply(Tuple2<Integer, Integer> total, Tuple2<Integer, Integer> completed) {
                return new Tuple2((Object)Predef$.MODULE$.int2Integer(Predef$.MODULE$.Integer2int((Integer)total._1()) + Predef$.MODULE$.Integer2int((Integer)completed._1())), (Object)Predef$.MODULE$.int2Integer(Predef$.MODULE$.Integer2int((Integer)total._2()) + Predef$.MODULE$.Integer2int((Integer)completed._2())));
            }
        });
        return (float)Predef$.MODULE$.Integer2int((Integer)tuple._2()) / (float)Predef$.MODULE$.Integer2int((Integer)tuple._1());
    }

    public JobProgressInfo[] getSparkJobProgressInfo(String applicationId) {
        Map<String, Object>[] sparkJobsResult = this.getSparkJobInfo(applicationId);
        return Predef$.MODULE$.refArrayOps((Object[])sparkJobsResult).isEmpty() ? (JobProgressInfo[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(JobProgressInfo.class)) : (JobProgressInfo[])Predef$.MODULE$.refArrayOps((Object[])sparkJobsResult).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final JobProgressInfo apply(Map<String, Object> sparkJobResult) {
                return new JobProgressInfo(SparkJobProgressUtil$.MODULE$.org$apache$linkis$engineplugin$spark$utils$SparkJobProgressUtil$$getJobId(Predef$.MODULE$.Integer2int((Integer)sparkJobResult.get("jobId")), (String)sparkJobResult.get("jobGroup")), Predef$.MODULE$.Integer2int((Integer)sparkJobResult.get("numTasks")), Predef$.MODULE$.Integer2int((Integer)sparkJobResult.get("numActiveTasks")), Predef$.MODULE$.Integer2int((Integer)sparkJobResult.get("numFailedTasks")), Predef$.MODULE$.Integer2int((Integer)sparkJobResult.get("numCompletedTasks")));
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(JobProgressInfo.class)));
    }

    public Map<String, Object>[] getSparkJobInfo(String applicationId) {
        Map[] mapArray;
        if (StringUtils.isBlank((CharSequence)applicationId)) {
            mapArray = (Map[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(Map.class));
        } else {
            String yarnRestfulUrl = (String)SparkConfiguration$.MODULE$.SPARK_ONCE_YARN_RESTFUL_URL().getValue(EngineConnServer$.MODULE$.getEngineCreationContext().getOptions());
            String getAppUrl = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "/ws/v1/cluster/apps/", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{yarnRestfulUrl, applicationId}));
            this.logger().info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"get yarn app, url: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{getAppUrl})));
            Map appResult = (Map)JsonUtils$.MODULE$.jackson().readValue(this.get(getAppUrl), Map.class);
            Map app = (Map)appResult.get("app");
            if (app == null) {
                return (Map[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(Map.class));
            }
            String trackingUrl = app.getOrDefault("trackingUrl", "");
            String state = app.getOrDefault("state", "");
            if (StringUtils.isBlank((CharSequence)trackingUrl) || "FINISHED".equals(state)) {
                return (Map[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(Map.class));
            }
            String getSparkJobsUrl = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "api/v1/applications/", "/jobs"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{trackingUrl, applicationId}));
            this.logger().info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"get spark jobs, url: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{getSparkJobsUrl})));
            String jobs = this.get(getSparkJobsUrl);
            if (StringUtils.isBlank((CharSequence)jobs)) {
                return (Map[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(Map.class));
            }
            mapArray = (Map[])JsonUtils$.MODULE$.jackson().readValue(this.get(getSparkJobsUrl), Map[].class);
        }
        return mapArray;
    }

    public String get(String url) {
        String string;
        HttpGet httpGet = new HttpGet(url);
        CloseableHttpClient client = HttpClients.createDefault();
        CloseableHttpResponse response = client.execute((HttpUriRequest)httpGet);
        if (response.getStatusLine().getStatusCode() == 200) {
            String str = EntityUtils.toString((HttpEntity)response.getEntity(), (String)"UTF-8");
            this.logger().info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"url: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{url})));
            this.logger().info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"response: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{str})));
            string = str;
        } else {
            string = "";
        }
        return string;
    }

    public String org$apache$linkis$engineplugin$spark$utils$SparkJobProgressUtil$$getJobId(int jobId, String jobGroup) {
        return new StringBuilder().append((Object)"jobId-").append((Object)BoxesRunTime.boxToInteger((int)jobId)).append((Object)"(").append((Object)jobGroup).append((Object)")").toString();
    }

    private SparkJobProgressUtil$() {
        MODULE$ = this;
        Logging.class.$init$((Logging)this);
    }
}

