/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to you under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.log4j.builders.filter;

import org.apache.log4j.bridge.FilterWrapper;
import org.apache.log4j.config.PropertiesConfiguration;
import org.apache.log4j.spi.Filter;
import org.apache.log4j.xml.XmlConfiguration;
import org.apache.logging.log4j.core.filter.DenyAllFilter;
import org.apache.logging.log4j.plugins.Namespace;
import org.apache.logging.log4j.plugins.Plugin;
import org.w3c.dom.Element;

import static org.apache.log4j.builders.BuilderManager.NAMESPACE;

/**
 * Build a Pattern Layout
 */
@Namespace(NAMESPACE)
@Plugin("org.apache.log4j.varia.DenyAllFilter")
public class DenyAllFilterBuilder implements FilterBuilder {

    @Override
    public Filter parse(final Element filterElement, final XmlConfiguration config) {
        return new FilterWrapper(DenyAllFilter.newBuilder().build());
    }

    @Override
    public Filter parse(final PropertiesConfiguration config) {
        return new FilterWrapper(DenyAllFilter.newBuilder().build());
    }
}
