/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j;

import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.MarkerManager;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.message.ObjectMessage;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.apache.logging.log4j.message.SimpleMessage;
import org.apache.logging.log4j.spi.AbstractLogger;
import org.junit.Assert;
import org.junit.Test;

public class AbstractLoggerTest
extends AbstractLogger {
    private static final long serialVersionUID = 1L;
    private static Level currentLevel;
    private LogEvent currentEvent;
    private static Throwable t;
    private static Class<AbstractLogger> obj;
    private static String pattern;
    private static String p1;
    private static String p2;
    private static Message simple;
    private static Message object;
    private static Message param;
    private static String marker;
    private static LogEvent[] events;

    public Level getLevel() {
        return currentLevel;
    }

    public boolean isEnabled(Level level, Marker marker, Message data, Throwable t) {
        Assert.assertTrue((String)("Incorrect Level. Expected " + currentLevel + ", actual " + level), (boolean)level.equals((Object)currentLevel));
        if (marker == null) {
            if (this.currentEvent.markerName != null) {
                Assert.fail((String)("Incorrect marker. Expected " + this.currentEvent.markerName + ", actual is null"));
            }
        } else if (this.currentEvent.markerName == null) {
            Assert.fail((String)("Incorrect marker. Expected null. Actual is " + marker.getName()));
        } else {
            Assert.assertTrue((String)("Incorrect marker. Expected " + this.currentEvent.markerName + ", actual " + marker.getName()), (boolean)this.currentEvent.markerName.equals(marker.getName()));
        }
        if (data == null) {
            if (this.currentEvent.data != null) {
                Assert.fail((String)("Incorrect message. Expected " + this.currentEvent.data + ", actual is null"));
            }
        } else if (this.currentEvent.data == null) {
            Assert.fail((String)("Incorrect message. Expected null. Actual is " + data.getFormattedMessage()));
        } else {
            Assert.assertTrue((String)("Incorrect message type. Expected " + this.currentEvent.data + ", actual " + data), (boolean)data.getClass().isAssignableFrom(this.currentEvent.data.getClass()));
            Assert.assertTrue((String)("Incorrect message. Expected " + this.currentEvent.data.getFormattedMessage() + ", actual " + data.getFormattedMessage()), (boolean)this.currentEvent.data.getFormattedMessage().equals(data.getFormattedMessage()));
        }
        if (t == null) {
            if (this.currentEvent.t != null) {
                Assert.fail((String)("Incorrect Throwable. Expected " + this.currentEvent.t + ", actual is null"));
            }
        } else if (this.currentEvent.t == null) {
            Assert.fail((String)("Incorrect Throwable. Expected null. Actual is " + t));
        } else {
            Assert.assertTrue((String)("Incorrect Throwable. Expected " + this.currentEvent.t + ", actual " + t), (boolean)this.currentEvent.t.equals(t));
        }
        return true;
    }

    public boolean isEnabled(Level level, Marker marker, Object data, Throwable t) {
        return this.isEnabled(level, marker, (Message)new ObjectMessage(data), t);
    }

    public boolean isEnabled(Level level, Marker marker, String data) {
        return this.isEnabled(level, marker, (Message)new SimpleMessage(data), (Throwable)null);
    }

    public boolean isEnabled(Level level, Marker marker, String data, Object ... p1) {
        return this.isEnabled(level, marker, (Message)new ParameterizedMessage(data, p1), (Throwable)null);
    }

    public boolean isEnabled(Level level, Marker marker, String data, Throwable t) {
        return this.isEnabled(level, marker, (Message)new SimpleMessage(data), t);
    }

    public void logMessage(String fqcn, Level level, Marker marker, Message data, Throwable t) {
        Assert.assertTrue((String)("Incorrect Level. Expected " + currentLevel + ", actual " + level), (boolean)level.equals((Object)currentLevel));
        if (marker == null) {
            if (this.currentEvent.markerName != null) {
                Assert.fail((String)("Incorrect marker. Expected " + this.currentEvent.markerName + ", actual is null"));
            }
        } else if (this.currentEvent.markerName == null) {
            Assert.fail((String)("Incorrect marker. Expected null. Actual is " + marker.getName()));
        } else {
            Assert.assertTrue((String)("Incorrect marker. Expected " + this.currentEvent.markerName + ", actual " + marker.getName()), (boolean)this.currentEvent.markerName.equals(marker.getName()));
        }
        if (data == null) {
            if (this.currentEvent.data != null) {
                Assert.fail((String)("Incorrect message. Expected " + this.currentEvent.data + ", actual is null"));
            }
        } else if (this.currentEvent.data == null) {
            Assert.fail((String)("Incorrect message. Expected null. Actual is " + data.getFormattedMessage()));
        } else {
            Assert.assertTrue((String)("Incorrect message type. Expected " + this.currentEvent.data + ", actual " + data), (boolean)data.getClass().isAssignableFrom(this.currentEvent.data.getClass()));
            Assert.assertTrue((String)("Incorrect message. Expected " + this.currentEvent.data.getFormattedMessage() + ", actual " + data.getFormattedMessage()), (boolean)this.currentEvent.data.getFormattedMessage().equals(data.getFormattedMessage()));
        }
        if (t == null) {
            if (this.currentEvent.t != null) {
                Assert.fail((String)("Incorrect Throwable. Expected " + this.currentEvent.t + ", actual is null"));
            }
        } else if (this.currentEvent.t == null) {
            Assert.fail((String)("Incorrect Throwable. Expected null. Actual is " + t));
        } else {
            Assert.assertTrue((String)("Incorrect Throwable. Expected " + this.currentEvent.t + ", actual " + t), (boolean)this.currentEvent.t.equals(t));
        }
    }

    @Test
    public void testDebug() {
        currentLevel = Level.DEBUG;
        this.currentEvent = events[0];
        this.debug("Hello");
        this.debug(null, "Hello");
        this.currentEvent = events[1];
        this.debug(MarkerManager.getMarker((String)"TEST"), "Hello");
        this.currentEvent = events[2];
        this.debug("Hello", t);
        this.debug(null, "Hello", t);
        this.currentEvent = events[3];
        this.debug(MarkerManager.getMarker((String)"TEST"), "Hello", t);
        this.currentEvent = events[4];
        this.debug(obj);
        this.currentEvent = events[5];
        this.debug(MarkerManager.getMarker((String)"TEST"), obj);
        this.currentEvent = events[6];
        this.debug(obj, t);
        this.debug(null, obj, t);
        this.currentEvent = events[7];
        this.debug(MarkerManager.getMarker((String)"TEST"), obj, t);
        this.currentEvent = events[8];
        this.debug(pattern, new Object[]{p1, p2});
        this.currentEvent = events[9];
        this.debug(MarkerManager.getMarker((String)"TEST"), pattern, new Object[]{p1, p2});
        this.currentEvent = events[10];
        this.debug(simple);
        this.debug(null, simple);
        this.debug(null, simple, null);
        this.currentEvent = events[11];
        this.debug(simple, t);
        this.debug(null, simple, t);
        this.currentEvent = events[12];
        this.debug(MarkerManager.getMarker((String)"TEST"), simple, null);
        this.currentEvent = events[13];
        this.debug(MarkerManager.getMarker((String)"TEST"), simple, t);
        this.currentEvent = events[14];
        this.debug(MarkerManager.getMarker((String)"TEST"), simple);
    }

    @Test
    public void testError() {
        currentLevel = Level.ERROR;
        this.currentEvent = events[0];
        this.error("Hello");
        this.error(null, "Hello");
        this.currentEvent = events[1];
        this.error(MarkerManager.getMarker((String)"TEST"), "Hello");
        this.currentEvent = events[2];
        this.error("Hello", t);
        this.error(null, "Hello", t);
        this.currentEvent = events[3];
        this.error(MarkerManager.getMarker((String)"TEST"), "Hello", t);
        this.currentEvent = events[4];
        this.error(obj);
        this.currentEvent = events[5];
        this.error(MarkerManager.getMarker((String)"TEST"), obj);
        this.currentEvent = events[6];
        this.error(obj, t);
        this.error(null, obj, t);
        this.currentEvent = events[7];
        this.error(MarkerManager.getMarker((String)"TEST"), obj, t);
        this.currentEvent = events[8];
        this.error(pattern, new Object[]{p1, p2});
        this.currentEvent = events[9];
        this.error(MarkerManager.getMarker((String)"TEST"), pattern, new Object[]{p1, p2});
        this.currentEvent = events[10];
        this.error(simple);
        this.error(null, simple);
        this.error(null, simple, null);
        this.currentEvent = events[11];
        this.error(simple, t);
        this.error(null, simple, t);
        this.currentEvent = events[12];
        this.error(MarkerManager.getMarker((String)"TEST"), simple, null);
        this.currentEvent = events[13];
        this.error(MarkerManager.getMarker((String)"TEST"), simple, t);
        this.currentEvent = events[14];
        this.error(MarkerManager.getMarker((String)"TEST"), simple);
    }

    @Test
    public void testFatal() {
        currentLevel = Level.FATAL;
        this.currentEvent = events[0];
        this.fatal("Hello");
        this.fatal(null, "Hello");
        this.currentEvent = events[1];
        this.fatal(MarkerManager.getMarker((String)"TEST"), "Hello");
        this.currentEvent = events[2];
        this.fatal("Hello", t);
        this.fatal(null, "Hello", t);
        this.currentEvent = events[3];
        this.fatal(MarkerManager.getMarker((String)"TEST"), "Hello", t);
        this.currentEvent = events[4];
        this.fatal(obj);
        this.currentEvent = events[5];
        this.fatal(MarkerManager.getMarker((String)"TEST"), obj);
        this.currentEvent = events[6];
        this.fatal(obj, t);
        this.fatal(null, obj, t);
        this.currentEvent = events[7];
        this.fatal(MarkerManager.getMarker((String)"TEST"), obj, t);
        this.currentEvent = events[8];
        this.fatal(pattern, new Object[]{p1, p2});
        this.currentEvent = events[9];
        this.fatal(MarkerManager.getMarker((String)"TEST"), pattern, new Object[]{p1, p2});
        this.currentEvent = events[10];
        this.fatal(simple);
        this.fatal(null, simple);
        this.fatal(null, simple, null);
        this.currentEvent = events[11];
        this.fatal(simple, t);
        this.fatal(null, simple, t);
        this.currentEvent = events[12];
        this.fatal(MarkerManager.getMarker((String)"TEST"), simple, null);
        this.currentEvent = events[13];
        this.fatal(MarkerManager.getMarker((String)"TEST"), simple, t);
        this.currentEvent = events[14];
        this.fatal(MarkerManager.getMarker((String)"TEST"), simple);
    }

    @Test
    public void testInfo() {
        currentLevel = Level.INFO;
        this.currentEvent = events[0];
        this.info("Hello");
        this.info(null, "Hello");
        this.currentEvent = events[1];
        this.info(MarkerManager.getMarker((String)"TEST"), "Hello");
        this.currentEvent = events[2];
        this.info("Hello", t);
        this.info(null, "Hello", t);
        this.currentEvent = events[3];
        this.info(MarkerManager.getMarker((String)"TEST"), "Hello", t);
        this.currentEvent = events[4];
        this.info(obj);
        this.currentEvent = events[5];
        this.info(MarkerManager.getMarker((String)"TEST"), obj);
        this.currentEvent = events[6];
        this.info(obj, t);
        this.info(null, obj, t);
        this.currentEvent = events[7];
        this.info(MarkerManager.getMarker((String)"TEST"), obj, t);
        this.currentEvent = events[8];
        this.info(pattern, new Object[]{p1, p2});
        this.currentEvent = events[9];
        this.info(MarkerManager.getMarker((String)"TEST"), pattern, new Object[]{p1, p2});
        this.currentEvent = events[10];
        this.info(simple);
        this.info(null, simple);
        this.info(null, simple, null);
        this.currentEvent = events[11];
        this.info(simple, t);
        this.info(null, simple, t);
        this.currentEvent = events[12];
        this.info(MarkerManager.getMarker((String)"TEST"), simple, null);
        this.currentEvent = events[13];
        this.info(MarkerManager.getMarker((String)"TEST"), simple, t);
        this.currentEvent = events[14];
        this.info(MarkerManager.getMarker((String)"TEST"), simple);
    }

    @Test
    public void testLogDebug() {
        currentLevel = Level.DEBUG;
        this.currentEvent = events[0];
        this.log(Level.DEBUG, "Hello");
        this.log(Level.DEBUG, null, "Hello");
        this.currentEvent = events[1];
        this.log(Level.DEBUG, MarkerManager.getMarker((String)"TEST"), "Hello");
        this.currentEvent = events[2];
        this.log(Level.DEBUG, "Hello", t);
        this.log(Level.DEBUG, null, "Hello", t);
        this.currentEvent = events[3];
        this.log(Level.DEBUG, MarkerManager.getMarker((String)"TEST"), "Hello", t);
        this.currentEvent = events[4];
        this.log(Level.DEBUG, obj);
        this.currentEvent = events[5];
        this.log(Level.DEBUG, MarkerManager.getMarker((String)"TEST"), obj);
        this.currentEvent = events[6];
        this.log(Level.DEBUG, obj, t);
        this.log(Level.DEBUG, null, obj, t);
        this.currentEvent = events[7];
        this.log(Level.DEBUG, MarkerManager.getMarker((String)"TEST"), obj, t);
        this.currentEvent = events[8];
        this.log(Level.DEBUG, pattern, new Object[]{p1, p2});
        this.currentEvent = events[9];
        this.log(Level.DEBUG, MarkerManager.getMarker((String)"TEST"), pattern, new Object[]{p1, p2});
        this.currentEvent = events[10];
        this.log(Level.DEBUG, simple);
        this.log(Level.DEBUG, null, simple);
        this.log(Level.DEBUG, null, simple, null);
        this.currentEvent = events[11];
        this.log(Level.DEBUG, simple, t);
        this.log(Level.DEBUG, null, simple, t);
        this.currentEvent = events[12];
        this.log(Level.DEBUG, MarkerManager.getMarker((String)"TEST"), simple, null);
        this.currentEvent = events[13];
        this.log(Level.DEBUG, MarkerManager.getMarker((String)"TEST"), simple, t);
        this.currentEvent = events[14];
        this.log(Level.DEBUG, MarkerManager.getMarker((String)"TEST"), simple);
    }

    @Test
    public void testLogError() {
        currentLevel = Level.ERROR;
        this.currentEvent = events[0];
        this.log(Level.ERROR, "Hello");
        this.log(Level.ERROR, null, "Hello");
        this.currentEvent = events[1];
        this.log(Level.ERROR, MarkerManager.getMarker((String)"TEST"), "Hello");
        this.currentEvent = events[2];
        this.log(Level.ERROR, "Hello", t);
        this.log(Level.ERROR, null, "Hello", t);
        this.currentEvent = events[3];
        this.log(Level.ERROR, MarkerManager.getMarker((String)"TEST"), "Hello", t);
        this.currentEvent = events[4];
        this.log(Level.ERROR, obj);
        this.currentEvent = events[5];
        this.log(Level.ERROR, MarkerManager.getMarker((String)"TEST"), obj);
        this.currentEvent = events[6];
        this.log(Level.ERROR, obj, t);
        this.log(Level.ERROR, null, obj, t);
        this.currentEvent = events[7];
        this.log(Level.ERROR, MarkerManager.getMarker((String)"TEST"), obj, t);
        this.currentEvent = events[8];
        this.log(Level.ERROR, pattern, new Object[]{p1, p2});
        this.currentEvent = events[9];
        this.log(Level.ERROR, MarkerManager.getMarker((String)"TEST"), pattern, new Object[]{p1, p2});
        this.currentEvent = events[10];
        this.log(Level.ERROR, simple);
        this.log(Level.ERROR, null, simple);
        this.log(Level.ERROR, null, simple, null);
        this.currentEvent = events[11];
        this.log(Level.ERROR, simple, t);
        this.log(Level.ERROR, null, simple, t);
        this.currentEvent = events[12];
        this.log(Level.ERROR, MarkerManager.getMarker((String)"TEST"), simple, null);
        this.currentEvent = events[13];
        this.log(Level.ERROR, MarkerManager.getMarker((String)"TEST"), simple, t);
        this.currentEvent = events[14];
        this.log(Level.ERROR, MarkerManager.getMarker((String)"TEST"), simple);
    }

    @Test
    public void testLogFatal() {
        currentLevel = Level.FATAL;
        this.currentEvent = events[0];
        this.log(Level.FATAL, "Hello");
        this.log(Level.FATAL, null, "Hello");
        this.currentEvent = events[1];
        this.log(Level.FATAL, MarkerManager.getMarker((String)"TEST"), "Hello");
        this.currentEvent = events[2];
        this.log(Level.FATAL, "Hello", t);
        this.log(Level.FATAL, null, "Hello", t);
        this.currentEvent = events[3];
        this.log(Level.FATAL, MarkerManager.getMarker((String)"TEST"), "Hello", t);
        this.currentEvent = events[4];
        this.log(Level.FATAL, obj);
        this.currentEvent = events[5];
        this.log(Level.FATAL, MarkerManager.getMarker((String)"TEST"), obj);
        this.currentEvent = events[6];
        this.log(Level.FATAL, obj, t);
        this.log(Level.FATAL, null, obj, t);
        this.currentEvent = events[7];
        this.log(Level.FATAL, MarkerManager.getMarker((String)"TEST"), obj, t);
        this.currentEvent = events[8];
        this.log(Level.FATAL, pattern, new Object[]{p1, p2});
        this.currentEvent = events[9];
        this.log(Level.FATAL, MarkerManager.getMarker((String)"TEST"), pattern, new Object[]{p1, p2});
        this.currentEvent = events[10];
        this.log(Level.FATAL, simple);
        this.log(Level.FATAL, null, simple);
        this.log(Level.FATAL, null, simple, null);
        this.currentEvent = events[11];
        this.log(Level.FATAL, simple, t);
        this.log(Level.FATAL, null, simple, t);
        this.currentEvent = events[12];
        this.log(Level.FATAL, MarkerManager.getMarker((String)"TEST"), simple, null);
        this.currentEvent = events[13];
        this.log(Level.FATAL, MarkerManager.getMarker((String)"TEST"), simple, t);
        this.currentEvent = events[14];
        this.log(Level.FATAL, MarkerManager.getMarker((String)"TEST"), simple);
    }

    @Test
    public void testLogInfo() {
        currentLevel = Level.INFO;
        this.currentEvent = events[0];
        this.log(Level.INFO, "Hello");
        this.log(Level.INFO, null, "Hello");
        this.currentEvent = events[1];
        this.log(Level.INFO, MarkerManager.getMarker((String)"TEST"), "Hello");
        this.currentEvent = events[2];
        this.log(Level.INFO, "Hello", t);
        this.log(Level.INFO, null, "Hello", t);
        this.currentEvent = events[3];
        this.log(Level.INFO, MarkerManager.getMarker((String)"TEST"), "Hello", t);
        this.currentEvent = events[4];
        this.log(Level.INFO, obj);
        this.currentEvent = events[5];
        this.log(Level.INFO, MarkerManager.getMarker((String)"TEST"), obj);
        this.currentEvent = events[6];
        this.log(Level.INFO, obj, t);
        this.log(Level.INFO, null, obj, t);
        this.currentEvent = events[7];
        this.log(Level.INFO, MarkerManager.getMarker((String)"TEST"), obj, t);
        this.currentEvent = events[8];
        this.log(Level.INFO, pattern, new Object[]{p1, p2});
        this.currentEvent = events[9];
        this.log(Level.INFO, MarkerManager.getMarker((String)"TEST"), pattern, new Object[]{p1, p2});
        this.currentEvent = events[10];
        this.log(Level.INFO, simple);
        this.log(Level.INFO, null, simple);
        this.log(Level.INFO, null, simple, null);
        this.currentEvent = events[11];
        this.log(Level.INFO, simple, t);
        this.log(Level.INFO, null, simple, t);
        this.currentEvent = events[12];
        this.log(Level.INFO, MarkerManager.getMarker((String)"TEST"), simple, null);
        this.currentEvent = events[13];
        this.log(Level.INFO, MarkerManager.getMarker((String)"TEST"), simple, t);
        this.currentEvent = events[14];
        this.log(Level.INFO, MarkerManager.getMarker((String)"TEST"), simple);
    }

    @Test
    public void testLogTrace() {
        currentLevel = Level.TRACE;
        this.currentEvent = events[0];
        this.log(Level.TRACE, "Hello");
        this.log(Level.TRACE, null, "Hello");
        this.currentEvent = events[1];
        this.log(Level.TRACE, MarkerManager.getMarker((String)"TEST"), "Hello");
        this.currentEvent = events[2];
        this.log(Level.TRACE, "Hello", t);
        this.log(Level.TRACE, null, "Hello", t);
        this.currentEvent = events[3];
        this.log(Level.TRACE, MarkerManager.getMarker((String)"TEST"), "Hello", t);
        this.currentEvent = events[4];
        this.log(Level.TRACE, obj);
        this.currentEvent = events[5];
        this.log(Level.TRACE, MarkerManager.getMarker((String)"TEST"), obj);
        this.currentEvent = events[6];
        this.log(Level.TRACE, obj, t);
        this.log(Level.TRACE, null, obj, t);
        this.currentEvent = events[7];
        this.log(Level.TRACE, MarkerManager.getMarker((String)"TEST"), obj, t);
        this.currentEvent = events[8];
        this.log(Level.TRACE, pattern, new Object[]{p1, p2});
        this.currentEvent = events[9];
        this.log(Level.TRACE, MarkerManager.getMarker((String)"TEST"), pattern, new Object[]{p1, p2});
        this.currentEvent = events[10];
        this.log(Level.TRACE, simple);
        this.log(Level.TRACE, null, simple);
        this.log(Level.TRACE, null, simple, null);
        this.currentEvent = events[11];
        this.log(Level.TRACE, simple, t);
        this.log(Level.TRACE, null, simple, t);
        this.currentEvent = events[12];
        this.log(Level.TRACE, MarkerManager.getMarker((String)"TEST"), simple, null);
        this.currentEvent = events[13];
        this.log(Level.TRACE, MarkerManager.getMarker((String)"TEST"), simple, t);
        this.currentEvent = events[14];
        this.log(Level.TRACE, MarkerManager.getMarker((String)"TEST"), simple);
    }

    @Test
    public void testLogWarn() {
        currentLevel = Level.WARN;
        this.currentEvent = events[0];
        this.log(Level.WARN, "Hello");
        this.log(Level.WARN, null, "Hello");
        this.currentEvent = events[1];
        this.log(Level.WARN, MarkerManager.getMarker((String)"TEST"), "Hello");
        this.currentEvent = events[2];
        this.log(Level.WARN, "Hello", t);
        this.log(Level.WARN, null, "Hello", t);
        this.currentEvent = events[3];
        this.log(Level.WARN, MarkerManager.getMarker((String)"TEST"), "Hello", t);
        this.currentEvent = events[4];
        this.log(Level.WARN, obj);
        this.currentEvent = events[5];
        this.log(Level.WARN, MarkerManager.getMarker((String)"TEST"), obj);
        this.currentEvent = events[6];
        this.log(Level.WARN, obj, t);
        this.log(Level.WARN, null, obj, t);
        this.currentEvent = events[7];
        this.log(Level.WARN, MarkerManager.getMarker((String)"TEST"), obj, t);
        this.currentEvent = events[8];
        this.log(Level.WARN, pattern, new Object[]{p1, p2});
        this.currentEvent = events[9];
        this.log(Level.WARN, MarkerManager.getMarker((String)"TEST"), pattern, new Object[]{p1, p2});
        this.currentEvent = events[10];
        this.log(Level.WARN, simple);
        this.log(Level.WARN, null, simple);
        this.log(Level.WARN, null, simple, null);
        this.currentEvent = events[11];
        this.log(Level.WARN, simple, t);
        this.log(Level.WARN, null, simple, t);
        this.currentEvent = events[12];
        this.log(Level.WARN, MarkerManager.getMarker((String)"TEST"), simple, null);
        this.currentEvent = events[13];
        this.log(Level.WARN, MarkerManager.getMarker((String)"TEST"), simple, t);
        this.currentEvent = events[14];
        this.log(Level.WARN, MarkerManager.getMarker((String)"TEST"), simple);
    }

    @Test
    public void testTrace() {
        currentLevel = Level.TRACE;
        this.currentEvent = events[0];
        this.trace("Hello");
        this.trace(null, "Hello");
        this.currentEvent = events[1];
        this.trace(MarkerManager.getMarker((String)"TEST"), "Hello");
        this.currentEvent = events[2];
        this.trace("Hello", t);
        this.trace(null, "Hello", t);
        this.currentEvent = events[3];
        this.trace(MarkerManager.getMarker((String)"TEST"), "Hello", t);
        this.currentEvent = events[4];
        this.trace(obj);
        this.currentEvent = events[5];
        this.trace(MarkerManager.getMarker((String)"TEST"), obj);
        this.currentEvent = events[6];
        this.trace(obj, t);
        this.trace(null, obj, t);
        this.currentEvent = events[7];
        this.trace(MarkerManager.getMarker((String)"TEST"), obj, t);
        this.currentEvent = events[8];
        this.trace(pattern, new Object[]{p1, p2});
        this.currentEvent = events[9];
        this.trace(MarkerManager.getMarker((String)"TEST"), pattern, new Object[]{p1, p2});
        this.currentEvent = events[10];
        this.trace(simple);
        this.trace(null, simple);
        this.trace(null, simple, null);
        this.currentEvent = events[11];
        this.trace(simple, t);
        this.trace(null, simple, t);
        this.currentEvent = events[12];
        this.trace(MarkerManager.getMarker((String)"TEST"), simple, null);
        this.currentEvent = events[13];
        this.trace(MarkerManager.getMarker((String)"TEST"), simple, t);
        this.currentEvent = events[14];
        this.trace(MarkerManager.getMarker((String)"TEST"), simple);
    }

    @Test
    public void testWarn() {
        currentLevel = Level.WARN;
        this.currentEvent = events[0];
        this.warn("Hello");
        this.warn(null, "Hello");
        this.currentEvent = events[1];
        this.warn(MarkerManager.getMarker((String)"TEST"), "Hello");
        this.currentEvent = events[2];
        this.warn("Hello", t);
        this.warn(null, "Hello", t);
        this.currentEvent = events[3];
        this.warn(MarkerManager.getMarker((String)"TEST"), "Hello", t);
        this.currentEvent = events[4];
        this.warn(obj);
        this.currentEvent = events[5];
        this.warn(MarkerManager.getMarker((String)"TEST"), obj);
        this.currentEvent = events[6];
        this.warn(obj, t);
        this.warn(null, obj, t);
        this.currentEvent = events[7];
        this.warn(MarkerManager.getMarker((String)"TEST"), obj, t);
        this.currentEvent = events[8];
        this.warn(pattern, new Object[]{p1, p2});
        this.currentEvent = events[9];
        this.warn(MarkerManager.getMarker((String)"TEST"), pattern, new Object[]{p1, p2});
        this.currentEvent = events[10];
        this.warn(simple);
        this.warn(null, simple);
        this.warn(null, simple, null);
        this.currentEvent = events[11];
        this.warn(simple, t);
        this.warn(null, simple, t);
        this.currentEvent = events[12];
        this.warn(MarkerManager.getMarker((String)"TEST"), simple, null);
        this.currentEvent = events[13];
        this.warn(MarkerManager.getMarker((String)"TEST"), simple, t);
        this.currentEvent = events[14];
        this.warn(MarkerManager.getMarker((String)"TEST"), simple);
    }

    static {
        t = new UnsupportedOperationException("Test");
        obj = AbstractLogger.class;
        pattern = "{}, {}";
        p1 = "Long Beach";
        p2 = "California";
        simple = new SimpleMessage("Hello");
        object = new ObjectMessage(obj);
        param = new ParameterizedMessage(pattern, (Object)p1, (Object)p2);
        marker = "TEST";
        events = new LogEvent[]{new LogEvent(null, simple, null), new LogEvent(marker, simple, null), new LogEvent(null, simple, t), new LogEvent(marker, simple, t), new LogEvent(null, object, null), new LogEvent(marker, object, null), new LogEvent(null, object, t), new LogEvent(marker, object, t), new LogEvent(null, param, null), new LogEvent(marker, param, null), new LogEvent(null, simple, null), new LogEvent(null, simple, t), new LogEvent(marker, simple, null), new LogEvent(marker, simple, t), new LogEvent(marker, simple, null)};
    }

    private static class LogEvent {
        String markerName;
        Message data;
        Throwable t;

        public LogEvent(String markerName, Message data, Throwable t) {
            this.markerName = markerName;
            this.data = data;
            this.t = t;
        }
    }
}

