/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j;

import java.io.Serializable;
import java.text.DecimalFormat;

public class Timer
implements Serializable {
    private static final long serialVersionUID = 9175191792439630013L;
    private final String m_name;
    private String m_status;
    private long m_startTime;
    private long m_elapsedTime;
    private final int m_iterations;
    private static long NANO_PER_SECOND = 1000000000L;
    private static long NANO_PER_MINUTE = NANO_PER_SECOND * 60L;
    private static long NANO_PER_HOUR = NANO_PER_MINUTE * 60L;

    public Timer(String name) {
        this(name, 0);
    }

    public Timer(String name, int iterations) {
        this.m_name = name;
        this.m_startTime = 0L;
        this.m_status = "Stopped";
        this.m_iterations = iterations > 0 ? iterations : 0;
    }

    public void start() {
        this.m_startTime = System.nanoTime();
        this.m_elapsedTime = 0L;
        this.m_status = "Start";
    }

    public void stop() {
        this.m_elapsedTime += System.nanoTime() - this.m_startTime;
        this.m_startTime = 0L;
        this.m_status = "Stop";
    }

    public void pause() {
        this.m_elapsedTime += System.nanoTime() - this.m_startTime;
        this.m_startTime = 0L;
        this.m_status = "Pause";
    }

    public void resume() {
        this.m_startTime = System.nanoTime();
        this.m_status = "Resume";
    }

    public String getName() {
        return this.m_name;
    }

    public long getElapsedTime() {
        return this.m_elapsedTime / 1000000L;
    }

    public long getElapsedNanoTime() {
        return this.m_elapsedTime;
    }

    public String getStatus() {
        return this.m_status;
    }

    public String toString() {
        StringBuilder result = new StringBuilder("Timer ").append(this.m_name);
        if (this.m_status.equals("Start")) {
            result.append(" started");
        } else if (this.m_status.equals("Pause")) {
            result.append(" paused");
        } else if (this.m_status.equals("Resume")) {
            result.append(" resumed");
        } else if (this.m_status.equals("Stop")) {
            long nanoseconds = this.m_elapsedTime;
            long hours = nanoseconds / NANO_PER_HOUR;
            long minutes = (nanoseconds %= NANO_PER_HOUR) / NANO_PER_MINUTE;
            long seconds = (nanoseconds %= NANO_PER_MINUTE) / NANO_PER_SECOND;
            nanoseconds %= NANO_PER_SECOND;
            String elapsed = "";
            if (hours > 0L) {
                elapsed = elapsed + hours + " hours ";
            }
            if (minutes > 0L || hours > 0L) {
                elapsed = elapsed + minutes + " minutes ";
            }
            DecimalFormat numFormat = null;
            numFormat = new DecimalFormat("#0");
            elapsed = elapsed + numFormat.format(seconds) + '.';
            numFormat = new DecimalFormat("000000000");
            elapsed = elapsed + numFormat.format(nanoseconds) + " seconds";
            result.append(" stopped. Elapsed time: ").append(elapsed);
            if (this.m_iterations > 0) {
                nanoseconds = this.m_elapsedTime / (long)this.m_iterations;
                hours = nanoseconds / NANO_PER_HOUR;
                minutes = (nanoseconds %= NANO_PER_HOUR) / NANO_PER_MINUTE;
                seconds = (nanoseconds %= NANO_PER_MINUTE) / NANO_PER_SECOND;
                nanoseconds %= NANO_PER_SECOND;
                elapsed = "";
                if (hours > 0L) {
                    elapsed = elapsed + hours + " hours ";
                }
                if (minutes > 0L || hours > 0L) {
                    elapsed = elapsed + minutes + " minutes ";
                }
                numFormat = new DecimalFormat("#0");
                elapsed = elapsed + numFormat.format(seconds) + '.';
                numFormat = new DecimalFormat("000000000");
                elapsed = elapsed + numFormat.format(nanoseconds) + " seconds";
                result.append(" Average per iteration: ").append(elapsed);
            }
        } else {
            result.append(' ').append(this.m_status);
        }
        return result.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Timer)) {
            return false;
        }
        Timer timer = (Timer)o;
        if (this.m_elapsedTime != timer.m_elapsedTime) {
            return false;
        }
        if (this.m_startTime != timer.m_startTime) {
            return false;
        }
        if (this.m_name != null ? !this.m_name.equals(timer.m_name) : timer.m_name != null) {
            return false;
        }
        return !(this.m_status != null ? !this.m_status.equals(timer.m_status) : timer.m_status != null);
    }

    public int hashCode() {
        int result = this.m_name != null ? this.m_name.hashCode() : 0;
        result = 29 * result + (this.m_status != null ? this.m_status.hashCode() : 0);
        result = 29 * result + (int)(this.m_startTime ^ this.m_startTime >>> 32);
        result = 29 * result + (int)(this.m_elapsedTime ^ this.m_elapsedTime >>> 32);
        return result;
    }
}

