/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.junit;

import org.apache.logging.log4j.ThreadContext;
import org.apache.logging.log4j.ThreadContextHolder;
import org.junit.rules.ExternalResource;

public class ThreadContextRule
extends ExternalResource {
    private final boolean restoreMap;
    private final boolean restoreStack;
    private ThreadContextHolder threadContextHolder;

    public ThreadContextRule() {
        this(true, true);
    }

    public ThreadContextRule(boolean restoreMap, boolean restoreStack) {
        this.restoreMap = restoreMap;
        this.restoreStack = restoreStack;
    }

    protected void after() {
        if (this.threadContextHolder != null) {
            this.threadContextHolder.restore();
        }
    }

    protected void before() throws Throwable {
        this.threadContextHolder = new ThreadContextHolder(this.restoreMap, this.restoreStack);
        if (this.restoreMap) {
            ThreadContext.clearMap();
        }
        if (this.restoreStack) {
            ThreadContext.clearStack();
        }
    }
}

