/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.util;

import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.message.SimpleMessage;
import org.apache.logging.log4j.util.LambdaUtil;
import org.apache.logging.log4j.util.MessageSupplier;
import org.apache.logging.log4j.util.Supplier;
import org.junit.Assert;
import org.junit.Test;

public class LambdaUtilTest {
    @Test
    public void testGetSupplierResultOfSupplier() {
        String expected = "result";
        Object actual = LambdaUtil.get((Supplier)new Supplier<String>(){

            public String get() {
                return "result";
            }
        });
        Assert.assertSame((Object)"result", (Object)actual);
    }

    @Test
    public void testGetMessageSupplierResultOfSupplier() {
        SimpleMessage expected = new SimpleMessage("hi");
        Message actual = LambdaUtil.get((MessageSupplier)new MessageSupplier((Message)expected){
            final /* synthetic */ Message val$expected;
            {
                this.val$expected = message;
            }

            public Message get() {
                return this.val$expected;
            }
        });
        Assert.assertSame((Object)expected, (Object)actual);
    }

    @Test
    public void testGetSupplierReturnsNullIfSupplierNull() {
        Object actual = LambdaUtil.get((Supplier)null);
        Assert.assertNull((Object)actual);
    }

    @Test
    public void testGetMessageSupplierReturnsNullIfSupplierNull() {
        Message actual = LambdaUtil.get((MessageSupplier)null);
        Assert.assertNull((Object)actual);
    }

    @Test(expected=RuntimeException.class)
    public void testGetSupplierExceptionIfSupplierThrowsException() {
        LambdaUtil.get((Supplier)new Supplier<String>(){

            public String get() {
                throw new RuntimeException();
            }
        });
    }

    @Test(expected=RuntimeException.class)
    public void testGetMessageSupplierExceptionIfSupplierThrowsException() {
        LambdaUtil.get((MessageSupplier)new MessageSupplier(){

            public Message get() {
                throw new RuntimeException();
            }
        });
    }

    @Test
    public void testGetAllReturnsResultOfSuppliers() {
        String expected1 = "result1";
        Supplier<String> function1 = new Supplier<String>(){

            public String get() {
                return "result1";
            }
        };
        String expected2 = "result2";
        Supplier<String> function2 = new Supplier<String>(){

            public String get() {
                return "result2";
            }
        };
        Supplier[] functions = new Supplier[]{function1, function2};
        Object[] actual = LambdaUtil.getAll((Supplier[])functions);
        Assert.assertEquals((long)actual.length, (long)functions.length);
        Assert.assertSame((Object)"result1", (Object)actual[0]);
        Assert.assertSame((Object)"result2", (Object)actual[1]);
    }

    @Test
    public void testGetAllReturnsNullArrayIfSupplierArrayNull() {
        Object[] actual = LambdaUtil.getAll((Supplier[])null);
        Assert.assertNull((Object)actual);
    }

    @Test
    public void testGetAllReturnsNullElementsIfSupplierArrayContainsNulls() {
        Supplier[] functions = new Supplier[3];
        Object[] actual = LambdaUtil.getAll((Supplier[])functions);
        Assert.assertEquals((long)actual.length, (long)functions.length);
        for (Object object : actual) {
            Assert.assertNull((Object)object);
        }
    }

    @Test(expected=RuntimeException.class)
    public void testGetAllThrowsExceptionIfAnyOfTheSuppliersThrowsException() {
        Supplier<String> function1 = new Supplier<String>(){

            public String get() {
                return "abc";
            }
        };
        Supplier<String> function2 = new Supplier<String>(){

            public String get() {
                throw new RuntimeException();
            }
        };
        Supplier[] functions = new Supplier[]{function1, function2};
        LambdaUtil.getAll((Supplier[])functions);
    }
}

