/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.util;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.logging.log4j.util.PropertySource;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class PropertySourceCamelCaseTest {
    private final CharSequence expected;
    private final List<String> tokens;

    public PropertySourceCamelCaseTest(CharSequence expected, List<String> tokens) {
        this.expected = expected;
        this.tokens = tokens;
    }

    @Parameterized.Parameters(name="{0}")
    public static Object[][] data() {
        return new Object[][]{{"", Collections.singletonList("")}, {"foo", Collections.singletonList("foo")}, {"fooBar", Arrays.asList("foo", "bar")}, {"oneTwoThree", Arrays.asList("one", "two", "three")}};
    }

    @Test
    public void testJoinAsCamelCase() throws Exception {
        Assert.assertEquals((Object)this.expected, (Object)PropertySource.Util.joinAsCamelCase(this.tokens));
    }
}

