/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.message;

import org.apache.logging.log4j.message.ReusableSimpleMessage;
import org.junit.Assert;
import org.junit.Test;

public class ReusableSimpleMessageTest {
    @Test
    public void testSet_InitializesFormattedMessage() throws Exception {
        ReusableSimpleMessage msg = new ReusableSimpleMessage();
        msg.set("abc");
        Assert.assertEquals((Object)"abc", (Object)msg.getFormattedMessage());
    }

    @Test
    public void testGetFormattedMessage_InitiallyStringNull() throws Exception {
        Assert.assertEquals((Object)"null", (Object)new ReusableSimpleMessage().getFormattedMessage());
    }

    @Test
    public void testGetFormattedMessage_ReturnsLatestSetString() throws Exception {
        ReusableSimpleMessage msg = new ReusableSimpleMessage();
        msg.set("abc");
        Assert.assertEquals((Object)"abc", (Object)msg.getFormattedMessage());
        msg.set("def");
        Assert.assertEquals((Object)"def", (Object)msg.getFormattedMessage());
        msg.set("xyz");
        Assert.assertEquals((Object)"xyz", (Object)msg.getFormattedMessage());
    }

    @Test
    public void testGetFormat_InitiallyStringNull() throws Exception {
        Assert.assertNull((Object)new ReusableSimpleMessage().getFormat());
    }

    @Test
    public void testGetFormat_ReturnsLatestSetString() throws Exception {
        ReusableSimpleMessage msg = new ReusableSimpleMessage();
        msg.set("abc");
        Assert.assertEquals((Object)"abc", (Object)msg.getFormat());
        msg.set("def");
        Assert.assertEquals((Object)"def", (Object)msg.getFormat());
        msg.set("xyz");
        Assert.assertEquals((Object)"xyz", (Object)msg.getFormat());
    }

    @Test
    public void testGetParameters_InitiallyReturnsEmptyArray() throws Exception {
        Assert.assertArrayEquals((Object[])new Object[0], (Object[])new ReusableSimpleMessage().getParameters());
    }

    @Test
    public void testGetParameters_ReturnsEmptyArrayAfterMessageSet() throws Exception {
        ReusableSimpleMessage msg = new ReusableSimpleMessage();
        msg.set("abc");
        Assert.assertArrayEquals((Object[])new Object[0], (Object[])msg.getParameters());
        msg.set("def");
        Assert.assertArrayEquals((Object[])new Object[0], (Object[])msg.getParameters());
    }

    @Test
    public void testGetThrowable_InitiallyReturnsNull() throws Exception {
        Assert.assertNull((Object)new ReusableSimpleMessage().getThrowable());
    }

    @Test
    public void testGetThrowable_ReturnsNullAfterMessageSet() throws Exception {
        ReusableSimpleMessage msg = new ReusableSimpleMessage();
        msg.set("abc");
        Assert.assertNull((Object)msg.getThrowable());
        msg.set("def");
        Assert.assertNull((Object)msg.getThrowable());
    }

    @Test
    public void testFormatTo_InitiallyWritesNull() throws Exception {
        ReusableSimpleMessage msg = new ReusableSimpleMessage();
        StringBuilder sb = new StringBuilder();
        msg.formatTo(sb);
        Assert.assertEquals((Object)"null", (Object)sb.toString());
    }

    @Test
    public void testFormatTo_WritesLatestSetString() throws Exception {
        ReusableSimpleMessage msg = new ReusableSimpleMessage();
        StringBuilder sb = new StringBuilder();
        msg.formatTo(sb);
        Assert.assertEquals((Object)"null", (Object)sb.toString());
        sb.setLength(0);
        msg.set("abc");
        msg.formatTo(sb);
        Assert.assertEquals((Object)"abc", (Object)sb.toString());
        sb.setLength(0);
        msg.set("def");
        msg.formatTo(sb);
        Assert.assertEquals((Object)"def", (Object)sb.toString());
        sb.setLength(0);
        msg.set("xyz");
        msg.formatTo(sb);
        Assert.assertEquals((Object)"xyz", (Object)sb.toString());
    }
}

