/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.util;

import org.apache.logging.log4j.util.Constants;
import org.apache.logging.log4j.util.StringBuilders;
import org.junit.Assert;
import org.junit.Test;

public class StringBuildersTest {
    @Test
    public void trimToMaxSize() throws Exception {
        StringBuilder sb = new StringBuilder();
        char[] value = new char[4096];
        sb.append(value);
        Assert.assertTrue((String)"needs trimming", (sb.length() > Constants.MAX_REUSABLE_MESSAGE_SIZE ? 1 : 0) != 0);
        StringBuilders.trimToMaxSize((StringBuilder)sb, (int)Constants.MAX_REUSABLE_MESSAGE_SIZE);
        Assert.assertTrue((String)"trimmed OK", (sb.length() <= Constants.MAX_REUSABLE_MESSAGE_SIZE ? 1 : 0) != 0);
    }

    @Test
    public void trimToMaxSizeWithLargeCapacity() throws Exception {
        StringBuilder sb = new StringBuilder();
        char[] value = new char[4096];
        sb.append(value);
        sb.setLength(0);
        Assert.assertTrue((String)"needs trimming", (sb.capacity() > Constants.MAX_REUSABLE_MESSAGE_SIZE ? 1 : 0) != 0);
        StringBuilders.trimToMaxSize((StringBuilder)sb, (int)Constants.MAX_REUSABLE_MESSAGE_SIZE);
        Assert.assertTrue((String)"trimmed OK", (sb.capacity() <= Constants.MAX_REUSABLE_MESSAGE_SIZE ? 1 : 0) != 0);
    }

    @Test
    public void escapeJsonCharactersCorrectly() {
        String jsonValueNotEscaped = "{\"field\n1\":\"value_1\"}";
        String jsonValueEscaped = "{\\\"field\\n1\\\":\\\"value_1\\\"}";
        StringBuilder sb = new StringBuilder();
        sb.append("{\"field\n1\":\"value_1\"}");
        Assert.assertEquals((Object)"{\"field\n1\":\"value_1\"}", (Object)sb.toString());
        StringBuilders.escapeJson((StringBuilder)sb, (int)0);
        Assert.assertEquals((Object)"{\\\"field\\n1\\\":\\\"value_1\\\"}", (Object)sb.toString());
        sb = new StringBuilder();
        String jsonValuePartiallyEscaped = "{\"field\n1\":\\\"value_1\\\"}";
        sb.append("{\"field\n1\":\"value_1\"}");
        Assert.assertEquals((Object)"{\"field\n1\":\"value_1\"}", (Object)sb.toString());
        StringBuilders.escapeJson((StringBuilder)sb, (int)10);
        Assert.assertEquals((Object)"{\"field\n1\":\\\"value_1\\\"}", (Object)sb.toString());
    }

    @Test
    public void escapeJsonCharactersISOControl() {
        String jsonValueNotEscaped = "{\"field\n1\":\"value\u008f_1\"}";
        String jsonValueEscaped = "{\\\"field\\n1\\\":\\\"value\\u008F_1\\\"}";
        StringBuilder sb = new StringBuilder();
        sb.append("{\"field\n1\":\"value\u008f_1\"}");
        Assert.assertEquals((Object)"{\"field\n1\":\"value\u008f_1\"}", (Object)sb.toString());
        StringBuilders.escapeJson((StringBuilder)sb, (int)0);
        Assert.assertEquals((Object)"{\\\"field\\n1\\\":\\\"value\\u008F_1\\\"}", (Object)sb.toString());
    }

    @Test
    public void escapeXMLCharactersCorrectly() {
        String xmlValueNotEscaped = "<\"Salt&Peppa'\">";
        String xmlValueEscaped = "&lt;&quot;Salt&amp;Peppa&apos;&quot;&gt;";
        StringBuilder sb = new StringBuilder();
        sb.append("<\"Salt&Peppa'\">");
        Assert.assertEquals((Object)"<\"Salt&Peppa'\">", (Object)sb.toString());
        StringBuilders.escapeXml((StringBuilder)sb, (int)0);
        Assert.assertEquals((Object)"&lt;&quot;Salt&amp;Peppa&apos;&quot;&gt;", (Object)sb.toString());
    }
}

