/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j;

import java.util.Arrays;
import java.util.HashMap;
import org.apache.logging.log4j.ThreadContext;
import org.apache.logging.log4j.ThreadContextUtilityClass;
import org.apache.logging.log4j.junit.UsingAnyThreadContext;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;

@UsingAnyThreadContext
public class ThreadContextTest {
    public static void reinitThreadContext() {
        ThreadContext.init();
    }

    @Test
    public void testPush() {
        ThreadContext.push((String)"Hello");
        ThreadContext.push((String)"{} is {}", (Object[])new Object[]{ThreadContextTest.class.getSimpleName(), "running"});
        Assertions.assertEquals((Object)ThreadContext.pop(), (Object)"ThreadContextTest is running", (String)"Incorrect parameterized stack value");
        Assertions.assertEquals((Object)ThreadContext.pop(), (Object)"Hello", (String)"Incorrect simple stack value");
    }

    @Test
    public void testInheritanceSwitchedOffByDefault() throws Exception {
        ThreadContext.put((String)"Greeting", (String)"Hello");
        StringBuilder sb = new StringBuilder();
        TestThread thread = new TestThread(sb);
        thread.start();
        thread.join();
        String str = sb.toString();
        Assertions.assertEquals((Object)"null", (Object)str, (String)("Unexpected ThreadContext value. Expected null. Actual " + str));
        sb = new StringBuilder();
        thread = new TestThread(sb);
        thread.start();
        thread.join();
        str = sb.toString();
        Assertions.assertEquals((Object)"null", (Object)str, (String)("Unexpected ThreadContext value. Expected null. Actual " + str));
    }

    @Test
    @Tag(value="performance")
    public void perfTest() {
        ThreadContextUtilityClass.perfTest();
    }

    @Test
    public void testGetContextReturnsEmptyMapIfEmpty() {
        ThreadContextUtilityClass.testGetContextReturnsEmptyMapIfEmpty();
    }

    @Test
    public void testGetContextReturnsMutableCopy() {
        ThreadContextUtilityClass.testGetContextReturnsMutableCopy();
    }

    @Test
    public void testGetImmutableContextReturnsEmptyMapIfEmpty() {
        ThreadContextUtilityClass.testGetImmutableContextReturnsEmptyMapIfEmpty();
    }

    @Test
    public void testGetImmutableContextReturnsImmutableMapIfNonEmpty() {
        ThreadContextUtilityClass.testGetImmutableContextReturnsImmutableMapIfNonEmpty();
    }

    @Test
    public void testGetImmutableContextReturnsImmutableMapIfEmpty() {
        ThreadContextUtilityClass.testGetImmutableContextReturnsImmutableMapIfEmpty();
    }

    @Test
    public void testGetImmutableStackReturnsEmptyStackIfEmpty() {
        ThreadContextUtilityClass.testGetImmutableStackReturnsEmptyStackIfEmpty();
    }

    @Test
    public void testPut() {
        ThreadContextUtilityClass.testPut();
    }

    @Test
    public void testPutIfNotNull() {
        ThreadContext.clearMap();
        Assertions.assertNull((Object)ThreadContext.get((String)"testKey"));
        ThreadContext.put((String)"testKey", (String)"testValue");
        Assertions.assertEquals((Object)"testValue", (Object)ThreadContext.get((String)"testKey"));
        Assertions.assertEquals((Object)"testValue", (Object)ThreadContext.get((String)"testKey"), (String)"Incorrect value in test key");
        ThreadContext.putIfNull((String)"testKey", (String)"new Value");
        Assertions.assertEquals((Object)"testValue", (Object)ThreadContext.get((String)"testKey"), (String)"Incorrect value in test key");
        ThreadContext.clearMap();
    }

    @Test
    public void testPutAll() {
        int i;
        Assertions.assertTrue((boolean)ThreadContext.isEmpty());
        Assertions.assertFalse((boolean)ThreadContext.containsKey((String)"key"));
        int mapSize = 10;
        HashMap<String, String> newMap = new HashMap<String, String>(10);
        for (i = 1; i <= 10; ++i) {
            newMap.put("key" + i, "value" + i);
        }
        ThreadContext.putAll(newMap);
        Assertions.assertFalse((boolean)ThreadContext.isEmpty());
        for (i = 1; i <= 10; ++i) {
            Assertions.assertTrue((boolean)ThreadContext.containsKey((String)("key" + i)));
            Assertions.assertEquals((Object)("value" + i), (Object)ThreadContext.get((String)("key" + i)));
        }
    }

    @Test
    public void testRemove() {
        Assertions.assertNull((Object)ThreadContext.get((String)"testKey"));
        ThreadContext.put((String)"testKey", (String)"testValue");
        Assertions.assertEquals((Object)"testValue", (Object)ThreadContext.get((String)"testKey"));
        ThreadContext.remove((String)"testKey");
        Assertions.assertNull((Object)ThreadContext.get((String)"testKey"));
        Assertions.assertTrue((boolean)ThreadContext.isEmpty());
    }

    @Test
    public void testRemoveAll() {
        ThreadContext.put((String)"testKey1", (String)"testValue1");
        ThreadContext.put((String)"testKey2", (String)"testValue2");
        Assertions.assertEquals((Object)"testValue1", (Object)ThreadContext.get((String)"testKey1"));
        Assertions.assertEquals((Object)"testValue2", (Object)ThreadContext.get((String)"testKey2"));
        Assertions.assertFalse((boolean)ThreadContext.isEmpty());
        ThreadContext.removeAll(Arrays.asList("testKey1", "testKey2"));
        Assertions.assertNull((Object)ThreadContext.get((String)"testKey1"));
        Assertions.assertNull((Object)ThreadContext.get((String)"testKey2"));
        Assertions.assertTrue((boolean)ThreadContext.isEmpty());
    }

    @Test
    public void testContainsKey() {
        Assertions.assertFalse((boolean)ThreadContext.containsKey((String)"testKey"));
        ThreadContext.put((String)"testKey", (String)"testValue");
        Assertions.assertTrue((boolean)ThreadContext.containsKey((String)"testKey"));
        ThreadContext.remove((String)"testKey");
        Assertions.assertFalse((boolean)ThreadContext.containsKey((String)"testKey"));
    }

    private static class TestThread
    extends Thread {
        private final StringBuilder sb;

        public TestThread(StringBuilder sb) {
            this.sb = sb;
        }

        @Override
        public void run() {
            String greeting = ThreadContext.get((String)"Greeting");
            if (greeting == null) {
                this.sb.append("null");
            } else {
                this.sb.append(greeting);
            }
            ThreadContext.clearMap();
        }
    }
}

