/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j;

import org.apache.logging.log4j.Level;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class LevelTest {
    @Test
    public void testDefault() {
        Level level = Level.toLevel((String)"Information", (Level)Level.ERROR);
        Assertions.assertNotNull((Object)level);
        Assertions.assertEquals((Object)Level.ERROR, (Object)level);
    }

    @Test
    public void testForNameEquals() {
        String name = "Foo";
        boolean intValue = true;
        Level level = Level.forName((String)"Foo", (int)1);
        Assertions.assertNotNull((Object)level);
        Assertions.assertEquals((Object)level, (Object)Level.forName((String)"Foo", (int)1));
        Assertions.assertEquals((Object)level, (Object)Level.getLevel((String)"Foo"));
        Assertions.assertEquals((int)1, (int)Level.getLevel((String)"Foo").intLevel());
    }

    @Test
    public void testGoodLevels() {
        Level level = Level.toLevel((String)"INFO");
        Assertions.assertNotNull((Object)level);
        Assertions.assertEquals((Object)Level.INFO, (Object)level);
    }

    @Test
    public void testIsInRangeErrorToDebug() {
        Assertions.assertFalse((boolean)Level.OFF.isInRange(Level.ERROR, Level.DEBUG));
        Assertions.assertFalse((boolean)Level.FATAL.isInRange(Level.ERROR, Level.DEBUG));
        Assertions.assertTrue((boolean)Level.ERROR.isInRange(Level.ERROR, Level.DEBUG));
        Assertions.assertTrue((boolean)Level.WARN.isInRange(Level.ERROR, Level.DEBUG));
        Assertions.assertTrue((boolean)Level.INFO.isInRange(Level.ERROR, Level.DEBUG));
        Assertions.assertTrue((boolean)Level.DEBUG.isInRange(Level.ERROR, Level.DEBUG));
        Assertions.assertFalse((boolean)Level.TRACE.isInRange(Level.ERROR, Level.DEBUG));
        Assertions.assertFalse((boolean)Level.ALL.isInRange(Level.ERROR, Level.DEBUG));
    }

    @Test
    public void testIsInRangeFatalToTrace() {
        Assertions.assertFalse((boolean)Level.OFF.isInRange(Level.FATAL, Level.TRACE));
        Assertions.assertTrue((boolean)Level.FATAL.isInRange(Level.FATAL, Level.TRACE));
        Assertions.assertTrue((boolean)Level.ERROR.isInRange(Level.FATAL, Level.TRACE));
        Assertions.assertTrue((boolean)Level.WARN.isInRange(Level.FATAL, Level.TRACE));
        Assertions.assertTrue((boolean)Level.INFO.isInRange(Level.FATAL, Level.TRACE));
        Assertions.assertTrue((boolean)Level.DEBUG.isInRange(Level.FATAL, Level.TRACE));
        Assertions.assertTrue((boolean)Level.TRACE.isInRange(Level.FATAL, Level.TRACE));
        Assertions.assertFalse((boolean)Level.ALL.isInRange(Level.FATAL, Level.TRACE));
    }

    @Test
    public void testIsInRangeOffToAll() {
        Assertions.assertTrue((boolean)Level.OFF.isInRange(Level.OFF, Level.ALL));
        Assertions.assertTrue((boolean)Level.FATAL.isInRange(Level.OFF, Level.ALL));
        Assertions.assertTrue((boolean)Level.ERROR.isInRange(Level.OFF, Level.ALL));
        Assertions.assertTrue((boolean)Level.WARN.isInRange(Level.OFF, Level.ALL));
        Assertions.assertTrue((boolean)Level.INFO.isInRange(Level.OFF, Level.ALL));
        Assertions.assertTrue((boolean)Level.DEBUG.isInRange(Level.OFF, Level.ALL));
        Assertions.assertTrue((boolean)Level.TRACE.isInRange(Level.OFF, Level.ALL));
        Assertions.assertTrue((boolean)Level.ALL.isInRange(Level.OFF, Level.ALL));
    }

    @Test
    public void testIsInRangeSameLevels() {
        Assertions.assertTrue((boolean)Level.OFF.isInRange(Level.OFF, Level.OFF));
        Assertions.assertFalse((boolean)Level.OFF.isInRange(Level.FATAL, Level.FATAL));
        Assertions.assertFalse((boolean)Level.OFF.isInRange(Level.ERROR, Level.ERROR));
        Assertions.assertFalse((boolean)Level.OFF.isInRange(Level.WARN, Level.WARN));
        Assertions.assertFalse((boolean)Level.OFF.isInRange(Level.INFO, Level.INFO));
        Assertions.assertFalse((boolean)Level.OFF.isInRange(Level.DEBUG, Level.DEBUG));
        Assertions.assertFalse((boolean)Level.OFF.isInRange(Level.TRACE, Level.TRACE));
        Assertions.assertFalse((boolean)Level.OFF.isInRange(Level.ALL, Level.ALL));
        Assertions.assertFalse((boolean)Level.FATAL.isInRange(Level.OFF, Level.OFF));
        Assertions.assertTrue((boolean)Level.FATAL.isInRange(Level.FATAL, Level.FATAL));
        Assertions.assertFalse((boolean)Level.FATAL.isInRange(Level.ERROR, Level.ERROR));
        Assertions.assertFalse((boolean)Level.FATAL.isInRange(Level.WARN, Level.WARN));
        Assertions.assertFalse((boolean)Level.FATAL.isInRange(Level.INFO, Level.INFO));
        Assertions.assertFalse((boolean)Level.FATAL.isInRange(Level.DEBUG, Level.DEBUG));
        Assertions.assertFalse((boolean)Level.FATAL.isInRange(Level.TRACE, Level.TRACE));
        Assertions.assertFalse((boolean)Level.FATAL.isInRange(Level.ALL, Level.ALL));
        Assertions.assertFalse((boolean)Level.ERROR.isInRange(Level.OFF, Level.OFF));
        Assertions.assertFalse((boolean)Level.ERROR.isInRange(Level.FATAL, Level.FATAL));
        Assertions.assertTrue((boolean)Level.ERROR.isInRange(Level.ERROR, Level.ERROR));
        Assertions.assertFalse((boolean)Level.ERROR.isInRange(Level.WARN, Level.WARN));
        Assertions.assertFalse((boolean)Level.ERROR.isInRange(Level.INFO, Level.INFO));
        Assertions.assertFalse((boolean)Level.ERROR.isInRange(Level.DEBUG, Level.DEBUG));
        Assertions.assertFalse((boolean)Level.ERROR.isInRange(Level.TRACE, Level.TRACE));
        Assertions.assertFalse((boolean)Level.ERROR.isInRange(Level.ALL, Level.ALL));
        Assertions.assertFalse((boolean)Level.WARN.isInRange(Level.OFF, Level.OFF));
        Assertions.assertFalse((boolean)Level.WARN.isInRange(Level.FATAL, Level.FATAL));
        Assertions.assertFalse((boolean)Level.WARN.isInRange(Level.ERROR, Level.ERROR));
        Assertions.assertTrue((boolean)Level.WARN.isInRange(Level.WARN, Level.WARN));
        Assertions.assertFalse((boolean)Level.WARN.isInRange(Level.INFO, Level.INFO));
        Assertions.assertFalse((boolean)Level.WARN.isInRange(Level.DEBUG, Level.DEBUG));
        Assertions.assertFalse((boolean)Level.WARN.isInRange(Level.TRACE, Level.TRACE));
        Assertions.assertFalse((boolean)Level.WARN.isInRange(Level.ALL, Level.ALL));
        Assertions.assertFalse((boolean)Level.INFO.isInRange(Level.OFF, Level.OFF));
        Assertions.assertFalse((boolean)Level.INFO.isInRange(Level.FATAL, Level.FATAL));
        Assertions.assertFalse((boolean)Level.INFO.isInRange(Level.ERROR, Level.ERROR));
        Assertions.assertFalse((boolean)Level.INFO.isInRange(Level.WARN, Level.WARN));
        Assertions.assertTrue((boolean)Level.INFO.isInRange(Level.INFO, Level.INFO));
        Assertions.assertFalse((boolean)Level.INFO.isInRange(Level.DEBUG, Level.DEBUG));
        Assertions.assertFalse((boolean)Level.INFO.isInRange(Level.TRACE, Level.TRACE));
        Assertions.assertFalse((boolean)Level.INFO.isInRange(Level.ALL, Level.ALL));
        Assertions.assertFalse((boolean)Level.DEBUG.isInRange(Level.OFF, Level.OFF));
        Assertions.assertFalse((boolean)Level.DEBUG.isInRange(Level.FATAL, Level.FATAL));
        Assertions.assertFalse((boolean)Level.DEBUG.isInRange(Level.ERROR, Level.ERROR));
        Assertions.assertFalse((boolean)Level.DEBUG.isInRange(Level.WARN, Level.WARN));
        Assertions.assertFalse((boolean)Level.DEBUG.isInRange(Level.INFO, Level.INFO));
        Assertions.assertTrue((boolean)Level.DEBUG.isInRange(Level.DEBUG, Level.DEBUG));
        Assertions.assertFalse((boolean)Level.DEBUG.isInRange(Level.TRACE, Level.TRACE));
        Assertions.assertFalse((boolean)Level.DEBUG.isInRange(Level.ALL, Level.ALL));
        Assertions.assertFalse((boolean)Level.TRACE.isInRange(Level.OFF, Level.OFF));
        Assertions.assertFalse((boolean)Level.TRACE.isInRange(Level.FATAL, Level.FATAL));
        Assertions.assertFalse((boolean)Level.TRACE.isInRange(Level.ERROR, Level.ERROR));
        Assertions.assertFalse((boolean)Level.TRACE.isInRange(Level.WARN, Level.WARN));
        Assertions.assertFalse((boolean)Level.TRACE.isInRange(Level.INFO, Level.INFO));
        Assertions.assertFalse((boolean)Level.TRACE.isInRange(Level.DEBUG, Level.DEBUG));
        Assertions.assertTrue((boolean)Level.TRACE.isInRange(Level.TRACE, Level.TRACE));
        Assertions.assertFalse((boolean)Level.TRACE.isInRange(Level.ALL, Level.ALL));
        Assertions.assertFalse((boolean)Level.ALL.isInRange(Level.OFF, Level.OFF));
        Assertions.assertFalse((boolean)Level.ALL.isInRange(Level.FATAL, Level.FATAL));
        Assertions.assertFalse((boolean)Level.ALL.isInRange(Level.ERROR, Level.ERROR));
        Assertions.assertFalse((boolean)Level.ALL.isInRange(Level.WARN, Level.WARN));
        Assertions.assertFalse((boolean)Level.ALL.isInRange(Level.INFO, Level.INFO));
        Assertions.assertFalse((boolean)Level.ALL.isInRange(Level.DEBUG, Level.DEBUG));
        Assertions.assertFalse((boolean)Level.ALL.isInRange(Level.TRACE, Level.TRACE));
        Assertions.assertTrue((boolean)Level.ALL.isInRange(Level.ALL, Level.ALL));
    }

    @Test
    public void testIsInRangeWarnToInfo() {
        Assertions.assertFalse((boolean)Level.OFF.isInRange(Level.WARN, Level.INFO));
        Assertions.assertFalse((boolean)Level.FATAL.isInRange(Level.WARN, Level.INFO));
        Assertions.assertFalse((boolean)Level.ERROR.isInRange(Level.WARN, Level.INFO));
        Assertions.assertTrue((boolean)Level.WARN.isInRange(Level.WARN, Level.INFO));
        Assertions.assertTrue((boolean)Level.INFO.isInRange(Level.WARN, Level.INFO));
        Assertions.assertFalse((boolean)Level.DEBUG.isInRange(Level.WARN, Level.INFO));
        Assertions.assertFalse((boolean)Level.TRACE.isInRange(Level.WARN, Level.INFO));
        Assertions.assertFalse((boolean)Level.ALL.isInRange(Level.WARN, Level.INFO));
    }

    @Test
    public void testIsLessSpecificThan() {
        Assertions.assertTrue((boolean)Level.OFF.isLessSpecificThan(Level.OFF));
        Assertions.assertFalse((boolean)Level.OFF.isLessSpecificThan(Level.FATAL));
        Assertions.assertFalse((boolean)Level.OFF.isLessSpecificThan(Level.ERROR));
        Assertions.assertFalse((boolean)Level.OFF.isLessSpecificThan(Level.WARN));
        Assertions.assertFalse((boolean)Level.OFF.isLessSpecificThan(Level.INFO));
        Assertions.assertFalse((boolean)Level.OFF.isLessSpecificThan(Level.DEBUG));
        Assertions.assertFalse((boolean)Level.OFF.isLessSpecificThan(Level.TRACE));
        Assertions.assertFalse((boolean)Level.OFF.isLessSpecificThan(Level.ALL));
        Assertions.assertTrue((boolean)Level.FATAL.isLessSpecificThan(Level.OFF));
        Assertions.assertTrue((boolean)Level.FATAL.isLessSpecificThan(Level.FATAL));
        Assertions.assertFalse((boolean)Level.FATAL.isLessSpecificThan(Level.ERROR));
        Assertions.assertFalse((boolean)Level.FATAL.isLessSpecificThan(Level.WARN));
        Assertions.assertFalse((boolean)Level.FATAL.isLessSpecificThan(Level.INFO));
        Assertions.assertFalse((boolean)Level.FATAL.isLessSpecificThan(Level.DEBUG));
        Assertions.assertFalse((boolean)Level.FATAL.isLessSpecificThan(Level.TRACE));
        Assertions.assertFalse((boolean)Level.FATAL.isLessSpecificThan(Level.ALL));
        Assertions.assertTrue((boolean)Level.ERROR.isLessSpecificThan(Level.OFF));
        Assertions.assertTrue((boolean)Level.ERROR.isLessSpecificThan(Level.FATAL));
        Assertions.assertTrue((boolean)Level.ERROR.isLessSpecificThan(Level.ERROR));
        Assertions.assertFalse((boolean)Level.ERROR.isLessSpecificThan(Level.WARN));
        Assertions.assertFalse((boolean)Level.ERROR.isLessSpecificThan(Level.INFO));
        Assertions.assertFalse((boolean)Level.ERROR.isLessSpecificThan(Level.DEBUG));
        Assertions.assertFalse((boolean)Level.ERROR.isLessSpecificThan(Level.TRACE));
        Assertions.assertFalse((boolean)Level.ERROR.isLessSpecificThan(Level.ALL));
        Assertions.assertTrue((boolean)Level.WARN.isLessSpecificThan(Level.OFF));
        Assertions.assertTrue((boolean)Level.WARN.isLessSpecificThan(Level.FATAL));
        Assertions.assertTrue((boolean)Level.WARN.isLessSpecificThan(Level.ERROR));
        Assertions.assertTrue((boolean)Level.WARN.isLessSpecificThan(Level.WARN));
        Assertions.assertFalse((boolean)Level.WARN.isLessSpecificThan(Level.INFO));
        Assertions.assertFalse((boolean)Level.WARN.isLessSpecificThan(Level.DEBUG));
        Assertions.assertFalse((boolean)Level.WARN.isLessSpecificThan(Level.TRACE));
        Assertions.assertFalse((boolean)Level.WARN.isLessSpecificThan(Level.ALL));
        Assertions.assertTrue((boolean)Level.WARN.isLessSpecificThan(Level.OFF));
        Assertions.assertTrue((boolean)Level.WARN.isLessSpecificThan(Level.FATAL));
        Assertions.assertTrue((boolean)Level.WARN.isLessSpecificThan(Level.ERROR));
        Assertions.assertTrue((boolean)Level.WARN.isLessSpecificThan(Level.WARN));
        Assertions.assertFalse((boolean)Level.WARN.isLessSpecificThan(Level.INFO));
        Assertions.assertFalse((boolean)Level.WARN.isLessSpecificThan(Level.DEBUG));
        Assertions.assertFalse((boolean)Level.WARN.isLessSpecificThan(Level.TRACE));
        Assertions.assertFalse((boolean)Level.WARN.isLessSpecificThan(Level.ALL));
        Assertions.assertTrue((boolean)Level.INFO.isLessSpecificThan(Level.OFF));
        Assertions.assertTrue((boolean)Level.INFO.isLessSpecificThan(Level.FATAL));
        Assertions.assertTrue((boolean)Level.INFO.isLessSpecificThan(Level.ERROR));
        Assertions.assertTrue((boolean)Level.INFO.isLessSpecificThan(Level.WARN));
        Assertions.assertTrue((boolean)Level.INFO.isLessSpecificThan(Level.INFO));
        Assertions.assertFalse((boolean)Level.INFO.isLessSpecificThan(Level.DEBUG));
        Assertions.assertFalse((boolean)Level.INFO.isLessSpecificThan(Level.TRACE));
        Assertions.assertFalse((boolean)Level.INFO.isLessSpecificThan(Level.ALL));
        Assertions.assertTrue((boolean)Level.DEBUG.isLessSpecificThan(Level.OFF));
        Assertions.assertTrue((boolean)Level.DEBUG.isLessSpecificThan(Level.FATAL));
        Assertions.assertTrue((boolean)Level.DEBUG.isLessSpecificThan(Level.ERROR));
        Assertions.assertTrue((boolean)Level.DEBUG.isLessSpecificThan(Level.WARN));
        Assertions.assertTrue((boolean)Level.DEBUG.isLessSpecificThan(Level.INFO));
        Assertions.assertTrue((boolean)Level.DEBUG.isLessSpecificThan(Level.DEBUG));
        Assertions.assertFalse((boolean)Level.DEBUG.isLessSpecificThan(Level.TRACE));
        Assertions.assertFalse((boolean)Level.DEBUG.isLessSpecificThan(Level.ALL));
        Assertions.assertTrue((boolean)Level.TRACE.isLessSpecificThan(Level.OFF));
        Assertions.assertTrue((boolean)Level.TRACE.isLessSpecificThan(Level.FATAL));
        Assertions.assertTrue((boolean)Level.TRACE.isLessSpecificThan(Level.ERROR));
        Assertions.assertTrue((boolean)Level.TRACE.isLessSpecificThan(Level.WARN));
        Assertions.assertTrue((boolean)Level.TRACE.isLessSpecificThan(Level.INFO));
        Assertions.assertTrue((boolean)Level.TRACE.isLessSpecificThan(Level.DEBUG));
        Assertions.assertTrue((boolean)Level.TRACE.isLessSpecificThan(Level.TRACE));
        Assertions.assertFalse((boolean)Level.TRACE.isLessSpecificThan(Level.ALL));
        Assertions.assertTrue((boolean)Level.ALL.isLessSpecificThan(Level.OFF));
        Assertions.assertTrue((boolean)Level.ALL.isLessSpecificThan(Level.FATAL));
        Assertions.assertTrue((boolean)Level.ALL.isLessSpecificThan(Level.ERROR));
        Assertions.assertTrue((boolean)Level.ALL.isLessSpecificThan(Level.WARN));
        Assertions.assertTrue((boolean)Level.ALL.isLessSpecificThan(Level.INFO));
        Assertions.assertTrue((boolean)Level.ALL.isLessSpecificThan(Level.DEBUG));
        Assertions.assertTrue((boolean)Level.ALL.isLessSpecificThan(Level.TRACE));
        Assertions.assertTrue((boolean)Level.ALL.isLessSpecificThan(Level.ALL));
    }
}

