/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.util;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectOutputStream;
import java.lang.reflect.Field;
import java.net.URL;
import java.net.URLDecoder;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.ConcurrentModificationException;
import java.util.HashMap;
import org.apache.logging.log4j.util.BiConsumer;
import org.apache.logging.log4j.util.DeserializerHelper;
import org.apache.logging.log4j.util.FilteredObjectInputStream;
import org.apache.logging.log4j.util.ReadOnlyStringMap;
import org.apache.logging.log4j.util.SortedArrayStringMap;
import org.apache.logging.log4j.util.TriConsumer;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.runner.Result;

public class SortedArrayStringMapTest {
    static TriConsumer<String, String, State> COUNTER = (key, value, state) -> {
        Assertions.assertEquals((Object)key, (Object)state.data.getKeyAt(state.count), (String)"key");
        Assertions.assertEquals((Object)value, (Object)state.data.getValueAt(state.count), (String)"val");
        ++state.count;
        Assertions.assertTrue((state.count <= state.data.size() ? 1 : 0) != 0, (String)("count should not exceed size but was " + state.count));
    };

    @Test
    public void testConstructorDisallowsNegativeCapacity() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> new SortedArrayStringMap(-1));
    }

    @Test
    public void testConstructorAllowsZeroCapacity() {
        SortedArrayStringMap sortedArrayStringMap = new SortedArrayStringMap(0);
        Assertions.assertEquals((int)0, (int)sortedArrayStringMap.size());
    }

    @Test
    public void testConstructorIgnoresNull() {
        Assertions.assertEquals((int)0, (int)new SortedArrayStringMap((ReadOnlyStringMap)((SortedArrayStringMap)null)).size());
    }

    @Test
    public void testConstructorNonStringKeys() {
        HashMap<Long, Integer> map = new HashMap<Long, Integer>(1);
        map.put(Long.MAX_VALUE, 1);
        map.put(null, null);
        SortedArrayStringMap sMap = new SortedArrayStringMap(map);
        Assertions.assertEquals((int)1, (int)((Integer)sMap.getValue(Long.toString(Long.MAX_VALUE))));
        Assertions.assertEquals((Integer)null, (Integer)((Integer)sMap.getValue(null)));
    }

    @Test
    public void testToString() {
        SortedArrayStringMap original = new SortedArrayStringMap();
        original.putValue("a", (Object)"avalue");
        original.putValue("B", (Object)"Bvalue");
        original.putValue("3", (Object)"3value");
        Assertions.assertEquals((Object)"{3=3value, B=Bvalue, a=avalue}", (Object)original.toString());
    }

    @Test
    public void testSerialization() throws Exception {
        SortedArrayStringMap original = new SortedArrayStringMap();
        original.putValue("a", (Object)"avalue");
        original.putValue("B", null);
        original.putValue("3", (Object)"3value");
        byte[] binary = this.serialize(original);
        SortedArrayStringMap copy = this.deserialize(binary);
        Assertions.assertEquals((Object)original, (Object)copy);
    }

    @Test
    public void testSerializationOfEmptyMap() throws Exception {
        SortedArrayStringMap original = new SortedArrayStringMap();
        byte[] binary = this.serialize(original);
        SortedArrayStringMap copy = this.deserialize(binary);
        Assertions.assertEquals((Object)original, (Object)copy);
    }

    @Test
    public void testSerializationOfNonSerializableValue() throws Exception {
        SortedArrayStringMap original = new SortedArrayStringMap();
        original.putValue("a", (Object)"avalue");
        original.putValue("B", (Object)"Bvalue");
        original.putValue("unserializable", new Object());
        byte[] binary = this.serialize(original);
        SortedArrayStringMap copy = this.deserialize(binary);
        SortedArrayStringMap expected = new SortedArrayStringMap();
        expected.putValue("a", (Object)"avalue");
        expected.putValue("B", (Object)"Bvalue");
        expected.putValue("unserializable", null);
        Assertions.assertEquals((Object)expected, (Object)copy);
    }

    @Test
    public void testDeserializationOfUnknownClass() throws Exception {
        SortedArrayStringMap original = new SortedArrayStringMap();
        original.putValue("a", (Object)"avalue");
        original.putValue("serializableButNotInClasspathOfDeserializer", (Object)new Result());
        original.putValue("zz", (Object)"last");
        File file = new File("target/SortedArrayStringMap.ser");
        try (FileOutputStream fout = new FileOutputStream(file, false);){
            fout.write(this.serialize(original));
            fout.flush();
        }
        String classpath = this.createClassPath(SortedArrayStringMap.class, DeserializerHelper.class);
        Process process = new ProcessBuilder("java", "-cp", classpath, DeserializerHelper.class.getName(), file.getPath()).start();
        BufferedReader in = new BufferedReader(new InputStreamReader(process.getErrorStream()));
        int exitValue = process.waitFor();
        file.delete();
        if (exitValue != 0) {
            StringBuilder sb = new StringBuilder();
            sb.append("DeserializerHelper exited with error code ").append(exitValue);
            sb.append(". Classpath='").append(classpath);
            sb.append("'. Process output: ");
            int c = -1;
            while ((c = in.read()) != -1) {
                sb.append((char)c);
            }
            Assertions.fail((String)sb.toString());
        }
    }

    private String createClassPath(Class<?> ... classes) throws Exception {
        StringBuilder result = new StringBuilder();
        for (Class<?> cls : classes) {
            if (result.length() > 0) {
                result.append(File.pathSeparator);
            }
            result.append(this.createClassPath(cls));
        }
        return result.toString();
    }

    private String createClassPath(Class<?> cls) throws Exception {
        String resource = "/" + cls.getName().replace('.', '/') + ".class";
        URL url = cls.getResource(resource);
        String location = url.toString();
        if (location.startsWith("jar:")) {
            location = location.substring("jar:".length(), location.indexOf(33));
        }
        if (location.startsWith("file:/")) {
            location = location.substring("file:/".length());
        }
        if (location.endsWith(resource)) {
            location = location.substring(0, location.length() - resource.length());
        }
        if (!new File(location).exists()) {
            location = File.separator + location;
        }
        return (location = URLDecoder.decode(location, Charset.defaultCharset().name())).isEmpty() ? "." : location;
    }

    private byte[] serialize(SortedArrayStringMap data) throws IOException {
        ByteArrayOutputStream arr = new ByteArrayOutputStream();
        ObjectOutputStream out = new ObjectOutputStream(arr);
        out.writeObject(data);
        return arr.toByteArray();
    }

    private SortedArrayStringMap deserialize(byte[] binary) throws IOException, ClassNotFoundException {
        ByteArrayInputStream inArr = new ByteArrayInputStream(binary);
        try (FilteredObjectInputStream in = new FilteredObjectInputStream((InputStream)inArr);){
            SortedArrayStringMap sortedArrayStringMap = (SortedArrayStringMap)in.readObject();
            return sortedArrayStringMap;
        }
    }

    @Test
    public void testPutAll() {
        SortedArrayStringMap original = new SortedArrayStringMap();
        original.putValue("a", (Object)"avalue");
        original.putValue("B", (Object)"Bvalue");
        original.putValue("3", (Object)"3value");
        SortedArrayStringMap other = new SortedArrayStringMap();
        other.putAll((ReadOnlyStringMap)original);
        Assertions.assertEquals((Object)original, (Object)other);
        other.putValue("3", (Object)"otherValue");
        Assertions.assertNotEquals((Object)original, (Object)other);
        other.putValue("3", null);
        Assertions.assertNotEquals((Object)original, (Object)other);
        other.putValue("3", (Object)"3value");
        Assertions.assertEquals((Object)original, (Object)other);
    }

    @Test
    public void testPutAll_overwritesSameKeys2() {
        SortedArrayStringMap original = new SortedArrayStringMap();
        original.putValue("a", (Object)"aORIG");
        original.putValue("b", (Object)"bORIG");
        original.putValue("c", (Object)"cORIG");
        original.putValue("d", (Object)"dORIG");
        original.putValue("e", (Object)"eORIG");
        SortedArrayStringMap other = new SortedArrayStringMap();
        other.putValue("1", (Object)"11");
        other.putValue("2", (Object)"22");
        other.putValue("a", (Object)"aa");
        other.putValue("c", (Object)"cc");
        original.putAll((ReadOnlyStringMap)other);
        Assertions.assertEquals((int)7, (int)original.size(), (String)"size after put other");
        Assertions.assertEquals((Object)"aa", (Object)original.getValue("a"));
        Assertions.assertEquals((Object)"bORIG", (Object)original.getValue("b"));
        Assertions.assertEquals((Object)"cc", (Object)original.getValue("c"));
        Assertions.assertEquals((Object)"dORIG", (Object)original.getValue("d"));
        Assertions.assertEquals((Object)"eORIG", (Object)original.getValue("e"));
        Assertions.assertEquals((Object)"11", (Object)original.getValue("1"));
        Assertions.assertEquals((Object)"22", (Object)original.getValue("2"));
    }

    @Test
    public void testPutAll_nullKeyInLargeOriginal() {
        SortedArrayStringMap original = new SortedArrayStringMap();
        original.putValue(null, (Object)"nullORIG");
        original.putValue("a", (Object)"aORIG");
        original.putValue("b", (Object)"bORIG");
        original.putValue("c", (Object)"cORIG");
        original.putValue("d", (Object)"dORIG");
        original.putValue("e", (Object)"eORIG");
        SortedArrayStringMap other = new SortedArrayStringMap();
        other.putValue("1", (Object)"11");
        other.putValue("a", (Object)"aa");
        original.putAll((ReadOnlyStringMap)other);
        Assertions.assertEquals((int)7, (int)original.size(), (String)"size after put other");
        Assertions.assertEquals((Object)"aa", (Object)original.getValue("a"));
        Assertions.assertEquals((Object)"bORIG", (Object)original.getValue("b"));
        Assertions.assertEquals((Object)"cORIG", (Object)original.getValue("c"));
        Assertions.assertEquals((Object)"dORIG", (Object)original.getValue("d"));
        Assertions.assertEquals((Object)"eORIG", (Object)original.getValue("e"));
        Assertions.assertEquals((Object)"11", (Object)original.getValue("1"));
        Assertions.assertEquals((Object)"nullORIG", (Object)original.getValue(null));
    }

    @Test
    public void testPutAll_nullKeyInSmallOriginal() {
        SortedArrayStringMap original = new SortedArrayStringMap();
        original.putValue(null, (Object)"nullORIG");
        original.putValue("a", (Object)"aORIG");
        original.putValue("b", (Object)"bORIG");
        SortedArrayStringMap other = new SortedArrayStringMap();
        other.putValue("1", (Object)"11");
        other.putValue("2", (Object)"22");
        other.putValue("3", (Object)"33");
        other.putValue("a", (Object)"aa");
        original.putAll((ReadOnlyStringMap)other);
        Assertions.assertEquals((int)6, (int)original.size(), (String)"size after put other");
        Assertions.assertEquals((Object)"aa", (Object)original.getValue("a"));
        Assertions.assertEquals((Object)"bORIG", (Object)original.getValue("b"));
        Assertions.assertEquals((Object)"11", (Object)original.getValue("1"));
        Assertions.assertEquals((Object)"22", (Object)original.getValue("2"));
        Assertions.assertEquals((Object)"33", (Object)original.getValue("3"));
        Assertions.assertEquals((Object)"nullORIG", (Object)original.getValue(null));
    }

    @Test
    public void testPutAll_nullKeyInSmallAdditional() {
        SortedArrayStringMap original = new SortedArrayStringMap();
        original.putValue("a", (Object)"aORIG");
        original.putValue("b", (Object)"bORIG");
        original.putValue("c", (Object)"cORIG");
        original.putValue("d", (Object)"dORIG");
        original.putValue("e", (Object)"eORIG");
        SortedArrayStringMap other = new SortedArrayStringMap();
        other.putValue(null, (Object)"nullNEW");
        other.putValue("1", (Object)"11");
        other.putValue("a", (Object)"aa");
        original.putAll((ReadOnlyStringMap)other);
        Assertions.assertEquals((int)7, (int)original.size(), (String)"size after put other");
        Assertions.assertEquals((Object)"aa", (Object)original.getValue("a"));
        Assertions.assertEquals((Object)"bORIG", (Object)original.getValue("b"));
        Assertions.assertEquals((Object)"cORIG", (Object)original.getValue("c"));
        Assertions.assertEquals((Object)"dORIG", (Object)original.getValue("d"));
        Assertions.assertEquals((Object)"eORIG", (Object)original.getValue("e"));
        Assertions.assertEquals((Object)"11", (Object)original.getValue("1"));
        Assertions.assertEquals((Object)"nullNEW", (Object)original.getValue(null));
    }

    @Test
    public void testPutAll_nullKeyInLargeAdditional() {
        SortedArrayStringMap original = new SortedArrayStringMap();
        original.putValue("a", (Object)"aORIG");
        original.putValue("b", (Object)"bORIG");
        SortedArrayStringMap other = new SortedArrayStringMap();
        other.putValue(null, (Object)"nullNEW");
        other.putValue("1", (Object)"11");
        other.putValue("2", (Object)"22");
        other.putValue("3", (Object)"33");
        other.putValue("a", (Object)"aa");
        original.putAll((ReadOnlyStringMap)other);
        Assertions.assertEquals((int)6, (int)original.size(), (String)"size after put other");
        Assertions.assertEquals((Object)"aa", (Object)original.getValue("a"));
        Assertions.assertEquals((Object)"bORIG", (Object)original.getValue("b"));
        Assertions.assertEquals((Object)"11", (Object)original.getValue("1"));
        Assertions.assertEquals((Object)"22", (Object)original.getValue("2"));
        Assertions.assertEquals((Object)"33", (Object)original.getValue("3"));
        Assertions.assertEquals((Object)"nullNEW", (Object)original.getValue(null));
    }

    @Test
    public void testPutAll_nullKeyInBoth_LargeOriginal() {
        SortedArrayStringMap original = new SortedArrayStringMap();
        original.putValue(null, (Object)"nullORIG");
        original.putValue("a", (Object)"aORIG");
        original.putValue("b", (Object)"bORIG");
        original.putValue("c", (Object)"cORIG");
        original.putValue("d", (Object)"dORIG");
        original.putValue("e", (Object)"eORIG");
        SortedArrayStringMap other = new SortedArrayStringMap();
        other.putValue(null, (Object)"nullNEW");
        other.putValue("1", (Object)"11");
        other.putValue("a", (Object)"aa");
        original.putAll((ReadOnlyStringMap)other);
        Assertions.assertEquals((int)7, (int)original.size(), (String)"size after put other");
        Assertions.assertEquals((Object)"aa", (Object)original.getValue("a"));
        Assertions.assertEquals((Object)"bORIG", (Object)original.getValue("b"));
        Assertions.assertEquals((Object)"cORIG", (Object)original.getValue("c"));
        Assertions.assertEquals((Object)"dORIG", (Object)original.getValue("d"));
        Assertions.assertEquals((Object)"eORIG", (Object)original.getValue("e"));
        Assertions.assertEquals((Object)"11", (Object)original.getValue("1"));
        Assertions.assertEquals((Object)"nullNEW", (Object)original.getValue(null));
    }

    @Test
    public void testPutAll_nullKeyInBoth_SmallOriginal() {
        SortedArrayStringMap original = new SortedArrayStringMap();
        original.putValue(null, (Object)"nullORIG");
        original.putValue("a", (Object)"aORIG");
        original.putValue("b", (Object)"bORIG");
        SortedArrayStringMap other = new SortedArrayStringMap();
        other.putValue(null, (Object)"nullNEW");
        other.putValue("1", (Object)"11");
        other.putValue("2", (Object)"22");
        other.putValue("3", (Object)"33");
        other.putValue("a", (Object)"aa");
        original.putAll((ReadOnlyStringMap)other);
        Assertions.assertEquals((int)6, (int)original.size(), (String)"size after put other");
        Assertions.assertEquals((Object)"aa", (Object)original.getValue("a"));
        Assertions.assertEquals((Object)"bORIG", (Object)original.getValue("b"));
        Assertions.assertEquals((Object)"11", (Object)original.getValue("1"));
        Assertions.assertEquals((Object)"22", (Object)original.getValue("2"));
        Assertions.assertEquals((Object)"33", (Object)original.getValue("3"));
        Assertions.assertEquals((Object)"nullNEW", (Object)original.getValue(null));
    }

    @Test
    public void testPutAll_overwritesSameKeys1() {
        SortedArrayStringMap original = new SortedArrayStringMap();
        original.putValue("a", (Object)"aORIG");
        original.putValue("b", (Object)"bORIG");
        original.putValue("c", (Object)"cORIG");
        SortedArrayStringMap other = new SortedArrayStringMap();
        other.putValue("1", (Object)"11");
        other.putValue("2", (Object)"22");
        other.putValue("a", (Object)"aa");
        other.putValue("c", (Object)"cc");
        original.putAll((ReadOnlyStringMap)other);
        Assertions.assertEquals((int)5, (int)original.size(), (String)"size after put other");
        Assertions.assertEquals((Object)"aa", (Object)original.getValue("a"));
        Assertions.assertEquals((Object)"bORIG", (Object)original.getValue("b"));
        Assertions.assertEquals((Object)"cc", (Object)original.getValue("c"));
        Assertions.assertEquals((Object)"11", (Object)original.getValue("1"));
        Assertions.assertEquals((Object)"22", (Object)original.getValue("2"));
    }

    @Test
    public void testEquals() {
        SortedArrayStringMap original = new SortedArrayStringMap();
        SortedArrayStringMap other = new SortedArrayStringMap();
        Assertions.assertEquals((Object)other, (Object)original, (String)"Empty maps are equal");
        Assertions.assertEquals((int)other.hashCode(), (int)original.hashCode(), (String)"Empty maps have equal hashcode");
        Assertions.assertNotEquals((Object)original, (Object)"Object other than SortedArrayStringMap");
        original.putValue("a", (Object)"avalue");
        original.putValue("B", (Object)"Bvalue");
        original.putValue("3", (Object)"3value");
        Assertions.assertEquals((Object)original, (Object)original);
        other.putValue("a", (Object)"avalue");
        Assertions.assertNotEquals((Object)original, (Object)other);
        other.putValue("B", (Object)"Bvalue");
        Assertions.assertNotEquals((Object)original, (Object)other);
        other.putValue("3", (Object)"3value");
        Assertions.assertEquals((Object)original, (Object)other);
        Assertions.assertEquals((int)original.hashCode(), (int)other.hashCode());
        other.putValue("3", (Object)"otherValue");
        Assertions.assertNotEquals((Object)original, (Object)other);
        other.putValue("3", null);
        Assertions.assertNotEquals((Object)original, (Object)other);
        Assertions.assertNotEquals((int)original.hashCode(), (int)other.hashCode());
        other.putValue("3", (Object)"3value");
        Assertions.assertEquals((Object)original, (Object)other);
        Assertions.assertEquals((Object)other, (Object)original);
        original.putValue("key not in other", (Object)"4value");
        other.putValue("key not in original", (Object)"4value");
        Assertions.assertNotEquals((Object)original, (Object)other);
        Assertions.assertNotEquals((Object)other, (Object)original);
    }

    @Test
    public void testToMap() {
        SortedArrayStringMap original = new SortedArrayStringMap();
        original.putValue("a", (Object)"avalue");
        original.putValue("B", (Object)"Bvalue");
        original.putValue("3", (Object)"3value");
        HashMap<String, String> expected = new HashMap<String, String>();
        expected.put("a", "avalue");
        expected.put("B", "Bvalue");
        expected.put("3", "3value");
        Assertions.assertEquals(expected, (Object)original.toMap());
        Assertions.assertDoesNotThrow(() -> original.toMap().put("abc", "xyz"), (String)"Expected map to be mutable");
    }

    @Test
    public void testPutAll_KeepsExistingValues() {
        SortedArrayStringMap original = new SortedArrayStringMap();
        original.putValue("a", (Object)"aaa");
        original.putValue("b", (Object)"bbb");
        original.putValue("c", (Object)"ccc");
        Assertions.assertEquals((int)3, (int)original.size(), (String)"size");
        original.putAll((ReadOnlyStringMap)new SortedArrayStringMap());
        Assertions.assertEquals((int)3, (int)original.size(), (String)"size after put empty");
        Assertions.assertEquals((Object)"aaa", (Object)original.getValue("a"));
        Assertions.assertEquals((Object)"bbb", (Object)original.getValue("b"));
        Assertions.assertEquals((Object)"ccc", (Object)original.getValue("c"));
        SortedArrayStringMap other = new SortedArrayStringMap();
        other.putValue("1", (Object)"111");
        other.putValue("2", (Object)"222");
        other.putValue("3", (Object)"333");
        original.putAll((ReadOnlyStringMap)other);
        Assertions.assertEquals((int)6, (int)original.size(), (String)"size after put other");
        Assertions.assertEquals((Object)"aaa", (Object)original.getValue("a"));
        Assertions.assertEquals((Object)"bbb", (Object)original.getValue("b"));
        Assertions.assertEquals((Object)"ccc", (Object)original.getValue("c"));
        Assertions.assertEquals((Object)"111", (Object)original.getValue("1"));
        Assertions.assertEquals((Object)"222", (Object)original.getValue("2"));
        Assertions.assertEquals((Object)"333", (Object)original.getValue("3"));
    }

    @Test
    public void testPutAll_sizePowerOfTwo() {
        SortedArrayStringMap original = new SortedArrayStringMap();
        original.putValue("a", (Object)"aaa");
        original.putValue("b", (Object)"bbb");
        original.putValue("c", (Object)"ccc");
        original.putValue("d", (Object)"ddd");
        Assertions.assertEquals((int)4, (int)original.size(), (String)"size");
        original.putAll((ReadOnlyStringMap)new SortedArrayStringMap());
        Assertions.assertEquals((int)4, (int)original.size(), (String)"size after put empty");
        Assertions.assertEquals((Object)"aaa", (Object)original.getValue("a"));
        Assertions.assertEquals((Object)"bbb", (Object)original.getValue("b"));
        Assertions.assertEquals((Object)"ccc", (Object)original.getValue("c"));
        Assertions.assertEquals((Object)"ddd", (Object)original.getValue("d"));
        SortedArrayStringMap other = new SortedArrayStringMap();
        other.putValue("1", (Object)"111");
        other.putValue("2", (Object)"222");
        other.putValue("3", (Object)"333");
        other.putValue("4", (Object)"444");
        original.putAll((ReadOnlyStringMap)other);
        Assertions.assertEquals((int)8, (int)original.size(), (String)"size after put other");
        Assertions.assertEquals((Object)"aaa", (Object)original.getValue("a"));
        Assertions.assertEquals((Object)"bbb", (Object)original.getValue("b"));
        Assertions.assertEquals((Object)"ccc", (Object)original.getValue("c"));
        Assertions.assertEquals((Object)"ddd", (Object)original.getValue("d"));
        Assertions.assertEquals((Object)"111", (Object)original.getValue("1"));
        Assertions.assertEquals((Object)"222", (Object)original.getValue("2"));
        Assertions.assertEquals((Object)"333", (Object)original.getValue("3"));
        Assertions.assertEquals((Object)"444", (Object)original.getValue("4"));
    }

    @Test
    public void testPutAll_largeAddition() {
        int i;
        SortedArrayStringMap original = new SortedArrayStringMap();
        original.putValue(null, (Object)"nullVal");
        original.putValue("a", (Object)"aaa");
        original.putValue("b", (Object)"bbb");
        original.putValue("c", (Object)"ccc");
        original.putValue("d", (Object)"ddd");
        Assertions.assertEquals((int)5, (int)original.size(), (String)"size");
        SortedArrayStringMap other = new SortedArrayStringMap();
        for (i = 0; i < 500; ++i) {
            other.putValue(String.valueOf(i), (Object)String.valueOf(i));
        }
        other.putValue(null, (Object)"otherVal");
        original.putAll((ReadOnlyStringMap)other);
        Assertions.assertEquals((int)505, (int)original.size(), (String)"size after put other");
        Assertions.assertEquals((Object)"otherVal", (Object)original.getValue(null));
        Assertions.assertEquals((Object)"aaa", (Object)original.getValue("a"));
        Assertions.assertEquals((Object)"bbb", (Object)original.getValue("b"));
        Assertions.assertEquals((Object)"ccc", (Object)original.getValue("c"));
        Assertions.assertEquals((Object)"ddd", (Object)original.getValue("d"));
        for (i = 0; i < 500; ++i) {
            Assertions.assertEquals((Object)String.valueOf(i), (Object)original.getValue(String.valueOf(i)));
        }
    }

    @Test
    public void testPutAllSelfDoesNotModify() {
        SortedArrayStringMap original = new SortedArrayStringMap();
        original.putValue("a", (Object)"aaa");
        original.putValue("b", (Object)"bbb");
        original.putValue("c", (Object)"ccc");
        Assertions.assertEquals((int)3, (int)original.size(), (String)"size");
        original.putAll((ReadOnlyStringMap)original);
        Assertions.assertEquals((int)3, (int)original.size(), (String)"size after put empty");
        Assertions.assertEquals((Object)"aaa", (Object)original.getValue("a"));
        Assertions.assertEquals((Object)"bbb", (Object)original.getValue("b"));
        Assertions.assertEquals((Object)"ccc", (Object)original.getValue("c"));
    }

    @Test
    public void testConcurrentModificationBiConsumerPut() {
        SortedArrayStringMap original = new SortedArrayStringMap();
        original.putValue("a", (Object)"aaa");
        Assertions.assertThrows(ConcurrentModificationException.class, () -> original.forEach((s, o) -> original.putValue("c", (Object)"other")));
    }

    @Test
    public void testConcurrentModificationBiConsumerPutValue() {
        SortedArrayStringMap original = new SortedArrayStringMap();
        original.putValue("a", (Object)"aaa");
        Assertions.assertThrows(ConcurrentModificationException.class, () -> original.forEach((s, o) -> original.putValue("c", (Object)"other")));
    }

    @Test
    public void testConcurrentModificationBiConsumerRemove() {
        SortedArrayStringMap original = new SortedArrayStringMap();
        original.putValue("a", (Object)"aaa");
        Assertions.assertThrows(ConcurrentModificationException.class, () -> original.forEach((s, o) -> original.remove("a")));
    }

    @Test
    public void testConcurrentModificationBiConsumerClear() {
        SortedArrayStringMap original = new SortedArrayStringMap();
        original.putValue("a", (Object)"aaa");
        Assertions.assertThrows(ConcurrentModificationException.class, () -> original.forEach((s, o) -> original.clear()));
    }

    @Test
    public void testConcurrentModificationTriConsumerPut() {
        SortedArrayStringMap original = new SortedArrayStringMap();
        original.putValue("a", (Object)"aaa");
        Assertions.assertThrows(ConcurrentModificationException.class, () -> original.forEach((s, o, o2) -> original.putValue("c", (Object)"other"), null));
    }

    @Test
    public void testConcurrentModificationTriConsumerPutValue() {
        SortedArrayStringMap original = new SortedArrayStringMap();
        original.putValue("a", (Object)"aaa");
        Assertions.assertThrows(ConcurrentModificationException.class, () -> original.forEach((s, o, o2) -> original.putValue("c", (Object)"other"), null));
    }

    @Test
    public void testConcurrentModificationTriConsumerRemove() {
        SortedArrayStringMap original = new SortedArrayStringMap();
        original.putValue("a", (Object)"aaa");
        Assertions.assertThrows(ConcurrentModificationException.class, () -> original.forEach((s, o, o2) -> original.remove("a"), null));
    }

    @Test
    public void testConcurrentModificationTriConsumerClear() {
        SortedArrayStringMap original = new SortedArrayStringMap();
        original.putValue("a", (Object)"aaa");
        Assertions.assertThrows(ConcurrentModificationException.class, () -> original.forEach((s, o, o2) -> original.clear(), null));
    }

    @Test
    public void testInitiallyNotFrozen() {
        Assertions.assertFalse((boolean)new SortedArrayStringMap().isFrozen());
    }

    @Test
    public void testIsFrozenAfterCallingFreeze() {
        SortedArrayStringMap original = new SortedArrayStringMap();
        Assertions.assertFalse((boolean)original.isFrozen(), (String)"before freeze");
        original.freeze();
        Assertions.assertTrue((boolean)original.isFrozen(), (String)"after freeze");
    }

    @Test
    public void testFreezeProhibitsPutValue() {
        SortedArrayStringMap original = new SortedArrayStringMap();
        original.freeze();
        Assertions.assertThrows(UnsupportedOperationException.class, () -> original.putValue("a", (Object)"aaa"));
    }

    @Test
    public void testFreezeProhibitsRemove() {
        SortedArrayStringMap original = new SortedArrayStringMap();
        original.putValue("b", (Object)"bbb");
        original.freeze();
        Assertions.assertThrows(UnsupportedOperationException.class, () -> original.remove("b"));
    }

    @Test
    public void testFreezeAllowsRemoveOfNonExistingKey() {
        SortedArrayStringMap original = new SortedArrayStringMap();
        original.putValue("b", (Object)"bbb");
        original.freeze();
        Assertions.assertDoesNotThrow(() -> original.remove("a"));
    }

    @Test
    public void testFreezeAllowsRemoveIfEmpty() {
        SortedArrayStringMap original = new SortedArrayStringMap();
        original.freeze();
        Assertions.assertDoesNotThrow(() -> original.remove("a"));
    }

    @Test
    public void testFreezeProhibitsClear() {
        SortedArrayStringMap original = new SortedArrayStringMap();
        original.putValue("a", (Object)"aaa");
        original.freeze();
        Assertions.assertThrows(UnsupportedOperationException.class, () -> ((SortedArrayStringMap)original).clear());
    }

    @Test
    public void testFreezeAllowsClearIfEmpty() {
        SortedArrayStringMap original = new SortedArrayStringMap();
        original.freeze();
        Assertions.assertDoesNotThrow(() -> ((SortedArrayStringMap)original).clear());
    }

    @Test
    public void testPutInsertsInAlphabeticOrder() {
        SortedArrayStringMap original = new SortedArrayStringMap();
        original.putValue("a", (Object)"avalue");
        original.putValue("B", (Object)"Bvalue");
        original.putValue("3", (Object)"3value");
        original.putValue("c", (Object)"cvalue");
        original.putValue("d", (Object)"dvalue");
        Assertions.assertEquals((Object)"avalue", (Object)original.getValue("a"));
        Assertions.assertEquals((Object)"avalue", (Object)original.getValueAt(2));
        Assertions.assertEquals((Object)"Bvalue", (Object)original.getValue("B"));
        Assertions.assertEquals((Object)"Bvalue", (Object)original.getValueAt(1));
        Assertions.assertEquals((Object)"3value", (Object)original.getValue("3"));
        Assertions.assertEquals((Object)"3value", (Object)original.getValueAt(0));
        Assertions.assertEquals((Object)"cvalue", (Object)original.getValue("c"));
        Assertions.assertEquals((Object)"cvalue", (Object)original.getValueAt(3));
        Assertions.assertEquals((Object)"dvalue", (Object)original.getValue("d"));
        Assertions.assertEquals((Object)"dvalue", (Object)original.getValueAt(4));
    }

    @Test
    public void testPutValueInsertsInAlphabeticOrder() {
        SortedArrayStringMap original = new SortedArrayStringMap();
        original.putValue("a", (Object)"avalue");
        original.putValue("B", (Object)"Bvalue");
        original.putValue("3", (Object)"3value");
        original.putValue("c", (Object)"cvalue");
        original.putValue("d", (Object)"dvalue");
        Assertions.assertEquals((Object)"avalue", (Object)original.getValue("a"));
        Assertions.assertEquals((Object)"avalue", (Object)original.getValueAt(2));
        Assertions.assertEquals((Object)"Bvalue", (Object)original.getValue("B"));
        Assertions.assertEquals((Object)"Bvalue", (Object)original.getValueAt(1));
        Assertions.assertEquals((Object)"3value", (Object)original.getValue("3"));
        Assertions.assertEquals((Object)"3value", (Object)original.getValueAt(0));
        Assertions.assertEquals((Object)"cvalue", (Object)original.getValue("c"));
        Assertions.assertEquals((Object)"cvalue", (Object)original.getValueAt(3));
        Assertions.assertEquals((Object)"dvalue", (Object)original.getValue("d"));
        Assertions.assertEquals((Object)"dvalue", (Object)original.getValueAt(4));
    }

    @Test
    public void testNullKeysAllowed() {
        SortedArrayStringMap original = new SortedArrayStringMap();
        original.putValue("a", (Object)"avalue");
        original.putValue("B", (Object)"Bvalue");
        original.putValue("3", (Object)"3value");
        original.putValue("c", (Object)"cvalue");
        original.putValue("d", (Object)"dvalue");
        Assertions.assertEquals((int)5, (int)original.size());
        Assertions.assertEquals((Object)"{3=3value, B=Bvalue, a=avalue, c=cvalue, d=dvalue}", (Object)original.toString());
        original.putValue(null, (Object)"nullvalue");
        Assertions.assertEquals((int)6, (int)original.size());
        Assertions.assertEquals((Object)"{null=nullvalue, 3=3value, B=Bvalue, a=avalue, c=cvalue, d=dvalue}", (Object)original.toString());
        original.putValue(null, (Object)"otherNullvalue");
        Assertions.assertEquals((Object)"{null=otherNullvalue, 3=3value, B=Bvalue, a=avalue, c=cvalue, d=dvalue}", (Object)original.toString());
        Assertions.assertEquals((int)6, (int)original.size());
        original.putValue(null, (Object)"nullvalue");
        Assertions.assertEquals((int)6, (int)original.size());
        Assertions.assertEquals((Object)"{null=nullvalue, 3=3value, B=Bvalue, a=avalue, c=cvalue, d=dvalue}", (Object)original.toString());
        original.putValue(null, (Object)"abc");
        Assertions.assertEquals((int)6, (int)original.size());
        Assertions.assertEquals((Object)"{null=abc, 3=3value, B=Bvalue, a=avalue, c=cvalue, d=dvalue}", (Object)original.toString());
    }

    @Test
    public void testNullKeysCopiedToAsMap() {
        SortedArrayStringMap original = new SortedArrayStringMap();
        original.putValue("a", (Object)"avalue");
        original.putValue("B", (Object)"Bvalue");
        original.putValue("3", (Object)"3value");
        original.putValue("c", (Object)"cvalue");
        original.putValue("d", (Object)"dvalue");
        Assertions.assertEquals((int)5, (int)original.size());
        HashMap<String, String> expected = new HashMap<String, String>();
        expected.put("a", "avalue");
        expected.put("B", "Bvalue");
        expected.put("3", "3value");
        expected.put("c", "cvalue");
        expected.put("d", "dvalue");
        Assertions.assertEquals(expected, (Object)original.toMap(), (String)"initial");
        original.putValue(null, (Object)"nullvalue");
        expected.put(null, "nullvalue");
        Assertions.assertEquals((int)6, (int)original.size());
        Assertions.assertEquals(expected, (Object)original.toMap(), (String)"with null key");
        original.putValue(null, (Object)"otherNullvalue");
        expected.put(null, "otherNullvalue");
        Assertions.assertEquals((int)6, (int)original.size());
        Assertions.assertEquals(expected, (Object)original.toMap(), (String)"with null key value2");
        original.putValue(null, (Object)"nullvalue");
        expected.put(null, "nullvalue");
        Assertions.assertEquals((int)6, (int)original.size());
        Assertions.assertEquals(expected, (Object)original.toMap(), (String)"with null key value1 again");
        original.putValue(null, (Object)"abc");
        expected.put(null, "abc");
        Assertions.assertEquals((int)6, (int)original.size());
        Assertions.assertEquals(expected, (Object)original.toMap(), (String)"with null key value3");
    }

    @Test
    public void testRemove() {
        SortedArrayStringMap original = new SortedArrayStringMap();
        original.putValue("a", (Object)"avalue");
        Assertions.assertEquals((int)1, (int)original.size());
        Assertions.assertEquals((Object)"avalue", (Object)original.getValue("a"));
        original.remove("a");
        Assertions.assertEquals((int)0, (int)original.size());
        Assertions.assertNull((Object)original.getValue("a"), (String)"no a val");
        original.remove("B");
        Assertions.assertEquals((int)0, (int)original.size());
        Assertions.assertNull((Object)original.getValue("B"), (String)"no B val");
    }

    @Test
    public void testRemoveNullsOutRemovedSlot() throws Exception {
        SortedArrayStringMap original = new SortedArrayStringMap();
        original.putValue("a", (Object)"avalue");
        original.putValue("b", (Object)"bvalue");
        original.putValue("c", (Object)"cvalue");
        original.putValue("d", (Object)"dvalue");
        original.remove("a");
        original.remove("b");
        original.remove("c");
        original.remove("d");
        Assertions.assertNull((Object)original.getValueAt(0));
        Field f = SortedArrayStringMap.class.getDeclaredField("values");
        f.setAccessible(true);
        Object[] values = (Object[])f.get(original);
        Assertions.assertAll(Arrays.stream(values).map(value -> () -> Assertions.assertNull((Object)value)));
    }

    @Test
    public void testRemoveWhenFull() {
        SortedArrayStringMap original = new SortedArrayStringMap();
        original.putValue("a", (Object)"avalue");
        original.putValue("b", (Object)"bvalue");
        original.putValue("c", (Object)"cvalue");
        original.putValue("d", (Object)"dvalue");
        original.remove("d");
    }

    @Test
    public void testNullValuesArePreserved() {
        SortedArrayStringMap original = new SortedArrayStringMap();
        original.putValue("a", (Object)"avalue");
        Assertions.assertEquals((int)1, (int)original.size());
        Assertions.assertEquals((Object)"avalue", (Object)original.getValue("a"));
        original.putValue("a", null);
        Assertions.assertEquals((int)1, (int)original.size());
        Assertions.assertNull((Object)original.getValue("a"), (String)"no a val");
        original.putValue("B", null);
        Assertions.assertEquals((int)2, (int)original.size());
        Assertions.assertNull((Object)original.getValue("B"), (String)"no B val");
    }

    @Test
    public void testGet() {
        SortedArrayStringMap original = new SortedArrayStringMap();
        original.putValue("a", (Object)"avalue");
        original.putValue("B", (Object)"Bvalue");
        original.putValue("3", (Object)"3value");
        Assertions.assertEquals((Object)"avalue", (Object)original.getValue("a"));
        Assertions.assertEquals((Object)"Bvalue", (Object)original.getValue("B"));
        Assertions.assertEquals((Object)"3value", (Object)original.getValue("3"));
        original.putValue("0", (Object)"0value");
        Assertions.assertEquals((Object)"0value", (Object)original.getValue("0"));
        Assertions.assertEquals((Object)"3value", (Object)original.getValue("3"));
        Assertions.assertEquals((Object)"Bvalue", (Object)original.getValue("B"));
        Assertions.assertEquals((Object)"avalue", (Object)original.getValue("a"));
    }

    @Test
    public void testGetValue_GetValueAt() {
        SortedArrayStringMap original = new SortedArrayStringMap();
        original.putValue("a", (Object)"avalue");
        original.putValue("B", (Object)"Bvalue");
        original.putValue("3", (Object)"3value");
        Assertions.assertEquals((Object)"avalue", (Object)original.getValue("a"));
        Assertions.assertEquals((Object)"avalue", (Object)original.getValueAt(2));
        Assertions.assertEquals((Object)"Bvalue", (Object)original.getValue("B"));
        Assertions.assertEquals((Object)"Bvalue", (Object)original.getValueAt(1));
        Assertions.assertEquals((Object)"3value", (Object)original.getValue("3"));
        Assertions.assertEquals((Object)"3value", (Object)original.getValueAt(0));
        original.putValue("0", (Object)"0value");
        Assertions.assertEquals((Object)"0value", (Object)original.getValue("0"));
        Assertions.assertEquals((Object)"0value", (Object)original.getValueAt(0));
        Assertions.assertEquals((Object)"3value", (Object)original.getValue("3"));
        Assertions.assertEquals((Object)"3value", (Object)original.getValueAt(1));
        Assertions.assertEquals((Object)"Bvalue", (Object)original.getValue("B"));
        Assertions.assertEquals((Object)"Bvalue", (Object)original.getValueAt(2));
        Assertions.assertEquals((Object)"avalue", (Object)original.getValue("a"));
        Assertions.assertEquals((Object)"avalue", (Object)original.getValueAt(3));
    }

    @Test
    public void testClear() throws Exception {
        SortedArrayStringMap original = new SortedArrayStringMap();
        original.putValue("a", (Object)"avalue");
        original.putValue("B", (Object)"Bvalue");
        original.putValue("3", (Object)"3value");
        Assertions.assertEquals((int)3, (int)original.size());
        original.clear();
        Assertions.assertEquals((int)0, (int)original.size());
        Field f = SortedArrayStringMap.class.getDeclaredField("values");
        f.setAccessible(true);
        Object[] values = (Object[])f.get(original);
        Assertions.assertAll(Arrays.stream(values).map(value -> () -> Assertions.assertNull((Object)value)));
    }

    @Test
    public void testIndexOfKey() {
        SortedArrayStringMap original = new SortedArrayStringMap();
        original.putValue("a", (Object)"avalue");
        Assertions.assertEquals((int)0, (int)original.indexOfKey("a"));
        original.putValue("B", (Object)"Bvalue");
        Assertions.assertEquals((int)1, (int)original.indexOfKey("a"));
        Assertions.assertEquals((int)0, (int)original.indexOfKey("B"));
        original.putValue("3", (Object)"3value");
        Assertions.assertEquals((int)2, (int)original.indexOfKey("a"));
        Assertions.assertEquals((int)1, (int)original.indexOfKey("B"));
        Assertions.assertEquals((int)0, (int)original.indexOfKey("3"));
        original.putValue("A", (Object)"AAA");
        Assertions.assertEquals((int)3, (int)original.indexOfKey("a"));
        Assertions.assertEquals((int)2, (int)original.indexOfKey("B"));
        Assertions.assertEquals((int)1, (int)original.indexOfKey("A"));
        Assertions.assertEquals((int)0, (int)original.indexOfKey("3"));
        original.putValue("C", (Object)"CCC");
        Assertions.assertEquals((int)4, (int)original.indexOfKey("a"));
        Assertions.assertEquals((int)3, (int)original.indexOfKey("C"));
        Assertions.assertEquals((int)2, (int)original.indexOfKey("B"));
        Assertions.assertEquals((int)1, (int)original.indexOfKey("A"));
        Assertions.assertEquals((int)0, (int)original.indexOfKey("3"));
        original.putValue("2", (Object)"222");
        Assertions.assertEquals((int)5, (int)original.indexOfKey("a"));
        Assertions.assertEquals((int)4, (int)original.indexOfKey("C"));
        Assertions.assertEquals((int)3, (int)original.indexOfKey("B"));
        Assertions.assertEquals((int)2, (int)original.indexOfKey("A"));
        Assertions.assertEquals((int)1, (int)original.indexOfKey("3"));
        Assertions.assertEquals((int)0, (int)original.indexOfKey("2"));
    }

    @Test
    public void testContainsKey() {
        SortedArrayStringMap original = new SortedArrayStringMap();
        Assertions.assertFalse((boolean)original.containsKey("a"), (String)"a");
        Assertions.assertFalse((boolean)original.containsKey("B"), (String)"B");
        Assertions.assertFalse((boolean)original.containsKey("3"), (String)"3");
        Assertions.assertFalse((boolean)original.containsKey("A"), (String)"A");
        original.putValue("a", (Object)"avalue");
        Assertions.assertTrue((boolean)original.containsKey("a"), (String)"a");
        Assertions.assertFalse((boolean)original.containsKey("B"), (String)"B");
        Assertions.assertFalse((boolean)original.containsKey("3"), (String)"3");
        Assertions.assertFalse((boolean)original.containsKey("A"), (String)"A");
        original.putValue("B", (Object)"Bvalue");
        Assertions.assertTrue((boolean)original.containsKey("a"), (String)"a");
        Assertions.assertTrue((boolean)original.containsKey("B"), (String)"B");
        Assertions.assertFalse((boolean)original.containsKey("3"), (String)"3");
        Assertions.assertFalse((boolean)original.containsKey("A"), (String)"A");
        original.putValue("3", (Object)"3value");
        Assertions.assertTrue((boolean)original.containsKey("a"), (String)"a");
        Assertions.assertTrue((boolean)original.containsKey("B"), (String)"B");
        Assertions.assertTrue((boolean)original.containsKey("3"), (String)"3");
        Assertions.assertFalse((boolean)original.containsKey("A"), (String)"A");
        original.putValue("A", (Object)"AAA");
        Assertions.assertTrue((boolean)original.containsKey("a"), (String)"a");
        Assertions.assertTrue((boolean)original.containsKey("B"), (String)"B");
        Assertions.assertTrue((boolean)original.containsKey("3"), (String)"3");
        Assertions.assertTrue((boolean)original.containsKey("A"), (String)"A");
    }

    @Test
    public void testGetValueAt() {
        SortedArrayStringMap original = new SortedArrayStringMap();
        original.putValue("a", (Object)"avalue");
        Assertions.assertEquals((Object)"a", (Object)original.getKeyAt(0));
        Assertions.assertEquals((Object)"avalue", (Object)original.getValueAt(0));
        original.putValue("B", (Object)"Bvalue");
        Assertions.assertEquals((Object)"B", (Object)original.getKeyAt(0));
        Assertions.assertEquals((Object)"Bvalue", (Object)original.getValueAt(0));
        Assertions.assertEquals((Object)"a", (Object)original.getKeyAt(1));
        Assertions.assertEquals((Object)"avalue", (Object)original.getValueAt(1));
        original.putValue("3", (Object)"3value");
        Assertions.assertEquals((Object)"3", (Object)original.getKeyAt(0));
        Assertions.assertEquals((Object)"3value", (Object)original.getValueAt(0));
        Assertions.assertEquals((Object)"B", (Object)original.getKeyAt(1));
        Assertions.assertEquals((Object)"Bvalue", (Object)original.getValueAt(1));
        Assertions.assertEquals((Object)"a", (Object)original.getKeyAt(2));
        Assertions.assertEquals((Object)"avalue", (Object)original.getValueAt(2));
    }

    @Test
    public void testSizeAndIsEmpty() {
        SortedArrayStringMap original = new SortedArrayStringMap();
        Assertions.assertEquals((int)0, (int)original.size());
        Assertions.assertTrue((boolean)original.isEmpty(), (String)"initial");
        original.putValue("a", (Object)"avalue");
        Assertions.assertEquals((int)1, (int)original.size());
        Assertions.assertFalse((boolean)original.isEmpty(), (String)("size=" + original.size()));
        original.putValue("B", (Object)"Bvalue");
        Assertions.assertEquals((int)2, (int)original.size());
        Assertions.assertFalse((boolean)original.isEmpty(), (String)("size=" + original.size()));
        original.putValue("3", (Object)"3value");
        Assertions.assertEquals((int)3, (int)original.size());
        Assertions.assertFalse((boolean)original.isEmpty(), (String)("size=" + original.size()));
        original.remove("B");
        Assertions.assertEquals((int)2, (int)original.size());
        Assertions.assertFalse((boolean)original.isEmpty(), (String)("size=" + original.size()));
        original.remove("3");
        Assertions.assertEquals((int)1, (int)original.size());
        Assertions.assertFalse((boolean)original.isEmpty(), (String)("size=" + original.size()));
        original.remove("a");
        Assertions.assertEquals((int)0, (int)original.size());
        Assertions.assertTrue((boolean)original.isEmpty(), (String)("size=" + original.size()));
    }

    @Test
    public void testForEachBiConsumer() {
        final SortedArrayStringMap original = new SortedArrayStringMap();
        original.putValue("a", (Object)"avalue");
        original.putValue("B", (Object)"Bvalue");
        original.putValue("3", (Object)"3value");
        original.forEach((BiConsumer)new BiConsumer<String, String>(){
            int count = 0;

            public void accept(String key, String value) {
                Assertions.assertEquals((Object)key, (Object)original.getKeyAt(this.count), (String)"key");
                Assertions.assertEquals((Object)value, (Object)original.getValueAt(this.count), (String)"val");
                ++this.count;
                Assertions.assertTrue((this.count <= original.size() ? 1 : 0) != 0, (String)("count should not exceed size but was " + this.count));
            }
        });
    }

    @Test
    public void testForEachTriConsumer() {
        SortedArrayStringMap original = new SortedArrayStringMap();
        original.putValue("a", (Object)"avalue");
        original.putValue("B", (Object)"Bvalue");
        original.putValue("3", (Object)"3value");
        State state = new State();
        state.data = original;
        original.forEach(COUNTER, (Object)state);
        Assertions.assertEquals((int)state.count, (int)original.size());
    }

    static class State {
        SortedArrayStringMap data;
        int count;

        State() {
        }
    }
}

