/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.message;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.logging.log4j.message.ParameterFormatter;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class ParameterFormatterTest {
    @Test
    public void testCountArgumentPlaceholders() {
        Assertions.assertEquals((int)0, (int)ParameterFormatter.countArgumentPlaceholders((String)""));
        Assertions.assertEquals((int)0, (int)ParameterFormatter.countArgumentPlaceholders((String)"aaa"));
        Assertions.assertEquals((int)0, (int)ParameterFormatter.countArgumentPlaceholders((String)"\\{}"));
        Assertions.assertEquals((int)1, (int)ParameterFormatter.countArgumentPlaceholders((String)"{}"));
        Assertions.assertEquals((int)1, (int)ParameterFormatter.countArgumentPlaceholders((String)"{}\\{}"));
        Assertions.assertEquals((int)2, (int)ParameterFormatter.countArgumentPlaceholders((String)"{}{}"));
        Assertions.assertEquals((int)3, (int)ParameterFormatter.countArgumentPlaceholders((String)"{}{}{}"));
        Assertions.assertEquals((int)4, (int)ParameterFormatter.countArgumentPlaceholders((String)"{}{}{}aa{}"));
        Assertions.assertEquals((int)4, (int)ParameterFormatter.countArgumentPlaceholders((String)"{}{}{}a{]b{}"));
        Assertions.assertEquals((int)5, (int)ParameterFormatter.countArgumentPlaceholders((String)"{}{}{}a{}b{}"));
    }

    @Test
    public void testFormat3StringArgs() {
        String testMsg = "Test message {}{} {}";
        Object[] args = new String[]{"a", "b", "c"};
        String result = ParameterFormatter.format((String)"Test message {}{} {}", (Object[])args);
        Assertions.assertEquals((Object)"Test message ab c", (Object)result);
    }

    @Test
    public void testFormatNullArgs() {
        String testMsg = "Test message {} {} {} {} {} {}";
        Object[] args = new String[]{"a", null, "c", null, null, null};
        String result = ParameterFormatter.format((String)"Test message {} {} {} {} {} {}", (Object[])args);
        Assertions.assertEquals((Object)"Test message a null c null null null", (Object)result);
    }

    @Test
    public void testFormatStringArgsIgnoresSuperfluousArgs() {
        String testMsg = "Test message {}{} {}";
        Object[] args = new String[]{"a", "b", "c", "unnecessary", "superfluous"};
        String result = ParameterFormatter.format((String)"Test message {}{} {}", (Object[])args);
        Assertions.assertEquals((Object)"Test message ab c", (Object)result);
    }

    @Test
    public void testFormatStringArgsWithEscape() {
        String testMsg = "Test message \\{}{} {}";
        Object[] args = new String[]{"a", "b", "c"};
        String result = ParameterFormatter.format((String)"Test message \\{}{} {}", (Object[])args);
        Assertions.assertEquals((Object)"Test message {}a b", (Object)result);
    }

    @Test
    public void testFormatStringArgsWithTrailingEscape() {
        String testMsg = "Test message {}{} {}\\";
        Object[] args = new String[]{"a", "b", "c"};
        String result = ParameterFormatter.format((String)"Test message {}{} {}\\", (Object[])args);
        Assertions.assertEquals((Object)"Test message ab c\\", (Object)result);
    }

    @Test
    public void testFormatStringArgsWithTrailingEscapedEscape() {
        String testMsg = "Test message {}{} {}\\\\";
        Object[] args = new String[]{"a", "b", "c"};
        String result = ParameterFormatter.format((String)"Test message {}{} {}\\\\", (Object[])args);
        Assertions.assertEquals((Object)"Test message ab c\\\\", (Object)result);
    }

    @Test
    public void testFormatStringArgsWithEscapedEscape() {
        String testMsg = "Test message \\\\{}{} {}";
        Object[] args = new String[]{"a", "b", "c"};
        String result = ParameterFormatter.format((String)"Test message \\\\{}{} {}", (Object[])args);
        Assertions.assertEquals((Object)"Test message \\ab c", (Object)result);
    }

    @Test
    public void testFormatMessage3StringArgs() {
        String testMsg = "Test message {}{} {}";
        Object[] args = new String[]{"a", "b", "c"};
        StringBuilder sb = new StringBuilder();
        ParameterFormatter.formatMessage((StringBuilder)sb, (String)"Test message {}{} {}", (Object[])args, (int)3);
        String result = sb.toString();
        Assertions.assertEquals((Object)"Test message ab c", (Object)result);
    }

    @Test
    public void testFormatMessageNullArgs() {
        String testMsg = "Test message {} {} {} {} {} {}";
        Object[] args = new String[]{"a", null, "c", null, null, null};
        StringBuilder sb = new StringBuilder();
        ParameterFormatter.formatMessage((StringBuilder)sb, (String)"Test message {} {} {} {} {} {}", (Object[])args, (int)6);
        String result = sb.toString();
        Assertions.assertEquals((Object)"Test message a null c null null null", (Object)result);
    }

    @Test
    public void testFormatMessageStringArgsIgnoresSuperfluousArgs() {
        String testMsg = "Test message {}{} {}";
        Object[] args = new String[]{"a", "b", "c", "unnecessary", "superfluous"};
        StringBuilder sb = new StringBuilder();
        ParameterFormatter.formatMessage((StringBuilder)sb, (String)"Test message {}{} {}", (Object[])args, (int)5);
        String result = sb.toString();
        Assertions.assertEquals((Object)"Test message ab c", (Object)result);
    }

    @Test
    public void testFormatMessageStringArgsWithEscape() {
        String testMsg = "Test message \\{}{} {}";
        Object[] args = new String[]{"a", "b", "c"};
        StringBuilder sb = new StringBuilder();
        ParameterFormatter.formatMessage((StringBuilder)sb, (String)"Test message \\{}{} {}", (Object[])args, (int)3);
        String result = sb.toString();
        Assertions.assertEquals((Object)"Test message {}a b", (Object)result);
    }

    @Test
    public void testFormatMessageStringArgsWithTrailingEscape() {
        String testMsg = "Test message {}{} {}\\";
        Object[] args = new String[]{"a", "b", "c"};
        StringBuilder sb = new StringBuilder();
        ParameterFormatter.formatMessage((StringBuilder)sb, (String)"Test message {}{} {}\\", (Object[])args, (int)3);
        String result = sb.toString();
        Assertions.assertEquals((Object)"Test message ab c\\", (Object)result);
    }

    @Test
    public void testFormatMessageStringArgsWithTrailingEscapedEscape() {
        String testMsg = "Test message {}{} {}\\\\";
        Object[] args = new String[]{"a", "b", "c"};
        StringBuilder sb = new StringBuilder();
        ParameterFormatter.formatMessage((StringBuilder)sb, (String)"Test message {}{} {}\\\\", (Object[])args, (int)3);
        String result = sb.toString();
        Assertions.assertEquals((Object)"Test message ab c\\\\", (Object)result);
    }

    @Test
    public void testFormatMessageStringArgsWithEscapedEscape() {
        String testMsg = "Test message \\\\{}{} {}";
        Object[] args = new String[]{"a", "b", "c"};
        StringBuilder sb = new StringBuilder();
        ParameterFormatter.formatMessage((StringBuilder)sb, (String)"Test message \\\\{}{} {}", (Object[])args, (int)3);
        String result = sb.toString();
        Assertions.assertEquals((Object)"Test message \\ab c", (Object)result);
    }

    @Test
    public void testDeepToString() {
        ArrayList<Serializable> list = new ArrayList<Serializable>();
        list.add(Integer.valueOf(1));
        list.add(list);
        list.add(Integer.valueOf(2));
        String actual = ParameterFormatter.deepToString(list);
        String expected = "[1, [..." + ParameterFormatter.identityToString(list) + "...], 2]";
        Assertions.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testDeepToStringUsingNonRecursiveButConsequentObjects() {
        ArrayList<Object> list = new ArrayList<Object>();
        List<Integer> item = Collections.singletonList(0);
        list.add(1);
        list.add(item);
        list.add(2);
        list.add(item);
        list.add(3);
        String actual = ParameterFormatter.deepToString(list);
        String expected = "[1, [0], 2, [0], 3]";
        Assertions.assertEquals((Object)"[1, [0], 2, [0], 3]", (Object)actual);
    }

    @Test
    public void testIdentityToString() {
        ArrayList<Serializable> list = new ArrayList<Serializable>();
        list.add(Integer.valueOf(1));
        list.add(list);
        list.add(Integer.valueOf(2));
        String actual = ParameterFormatter.identityToString(list);
        String expected = list.getClass().getName() + "@" + Integer.toHexString(System.identityHashCode(list));
        Assertions.assertEquals((Object)expected, (Object)actual);
    }
}

