/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j;

import java.util.Map;
import org.apache.logging.log4j.ThreadContext;
import org.apache.logging.log4j.Timer;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class ThreadContextInheritanceTest {
    @BeforeClass
    public static void setupClass() {
        System.setProperty("isThreadContextMapInheritable", "true");
        ThreadContext.init();
    }

    @AfterClass
    public static void tearDownClass() {
        System.clearProperty("isThreadContextMapInheritable");
        ThreadContext.init();
    }

    @Test
    public void testPush() {
        ThreadContext.push((String)"Hello");
        ThreadContext.push((String)"{} is {}", (Object[])new Object[]{ThreadContextInheritanceTest.class.getSimpleName(), "running"});
        Assert.assertEquals((String)"Incorrect parameterized stack value", (Object)ThreadContext.pop(), (Object)"ThreadContextInheritanceTest is running");
        Assert.assertEquals((String)"Incorrect simple stack value", (Object)ThreadContext.pop(), (Object)"Hello");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testInheritanceSwitchedOn() throws Exception {
        System.setProperty("isThreadContextMapInheritable", "true");
        try {
            ThreadContext.clearMap();
            ThreadContext.put((String)"Greeting", (String)"Hello");
            StringBuilder sb = new StringBuilder();
            TestThread thread = new TestThread(sb);
            thread.start();
            thread.join();
            String str = sb.toString();
            Assert.assertTrue((String)("Unexpected ThreadContext value. Expected Hello. Actual " + str), (boolean)"Hello".equals(str));
            sb = new StringBuilder();
            thread = new TestThread(sb);
            thread.start();
            thread.join();
            str = sb.toString();
            Assert.assertTrue((String)("Unexpected ThreadContext value. Expected Hello. Actual " + str), (boolean)"Hello".equals(str));
        }
        finally {
            System.clearProperty("isThreadContextMapInheritable");
        }
    }

    @Test
    public void perfTest() throws Exception {
        ThreadContext.clearMap();
        Timer complete = new Timer("ThreadContextTest");
        complete.start();
        ThreadContext.put((String)"Var1", (String)"value 1");
        ThreadContext.put((String)"Var2", (String)"value 2");
        ThreadContext.put((String)"Var3", (String)"value 3");
        ThreadContext.put((String)"Var4", (String)"value 4");
        ThreadContext.put((String)"Var5", (String)"value 5");
        ThreadContext.put((String)"Var6", (String)"value 6");
        ThreadContext.put((String)"Var7", (String)"value 7");
        ThreadContext.put((String)"Var8", (String)"value 8");
        ThreadContext.put((String)"Var9", (String)"value 9");
        ThreadContext.put((String)"Var10", (String)"value 10");
        int loopCount = 1000000;
        Timer timer = new Timer("ThreadContextCopy", 1000000);
        timer.start();
        for (int i = 0; i < 1000000; ++i) {
            Map map = ThreadContext.getImmutableContext();
            Assert.assertNotNull((Object)map);
        }
        timer.stop();
        complete.stop();
        System.out.println(timer.toString());
        System.out.println(complete.toString());
    }

    @Test
    public void testGetContextReturnsEmptyMapIfEmpty() {
        ThreadContext.clearMap();
        Assert.assertTrue((boolean)ThreadContext.getContext().isEmpty());
    }

    @Test
    public void testGetContextReturnsMutableCopy() {
        ThreadContext.clearMap();
        Map map1 = ThreadContext.getContext();
        Assert.assertTrue((boolean)map1.isEmpty());
        map1.put("K", "val");
        Assert.assertEquals((Object)"val", map1.get("K"));
        Assert.assertTrue((boolean)ThreadContext.getContext().isEmpty());
        ThreadContext.put((String)"key", (String)"val2");
        Map map2 = ThreadContext.getContext();
        Assert.assertEquals((long)1L, (long)map2.size());
        Assert.assertEquals((Object)"val2", map2.get("key"));
        map2.put("K", "val");
        Assert.assertEquals((Object)"val", map2.get("K"));
        Assert.assertNotSame((Object)map1, (Object)map2);
        Assert.assertEquals((long)1L, (long)map1.size());
    }

    @Test
    public void testGetImmutableContextReturnsEmptyMapIfEmpty() {
        ThreadContext.clearMap();
        Assert.assertTrue((boolean)ThreadContext.getImmutableContext().isEmpty());
    }

    @Test(expected=UnsupportedOperationException.class)
    public void testGetImmutableContextReturnsImmutableMapIfNonEmpty() {
        ThreadContext.clearMap();
        ThreadContext.put((String)"key", (String)"val");
        Map immutable = ThreadContext.getImmutableContext();
        immutable.put("otherkey", "otherval");
    }

    @Test(expected=UnsupportedOperationException.class)
    public void testGetImmutableContextReturnsImmutableMapIfEmpty() {
        ThreadContext.clearMap();
        Map immutable = ThreadContext.getImmutableContext();
        immutable.put("otherkey", "otherval");
    }

    @Test
    public void testGetImmutableStackReturnsEmptyStackIfEmpty() {
        ThreadContext.clearStack();
        Assert.assertTrue((boolean)ThreadContext.getImmutableStack().asList().isEmpty());
    }

    @Test
    public void testPut() {
        ThreadContext.clearMap();
        Assert.assertNull((Object)ThreadContext.get((String)"testKey"));
        ThreadContext.put((String)"testKey", (String)"testValue");
        Assert.assertEquals((Object)"testValue", (Object)ThreadContext.get((String)"testKey"));
    }

    @Test
    public void testRemove() {
        ThreadContext.clearMap();
        Assert.assertNull((Object)ThreadContext.get((String)"testKey"));
        ThreadContext.put((String)"testKey", (String)"testValue");
        Assert.assertEquals((Object)"testValue", (Object)ThreadContext.get((String)"testKey"));
        ThreadContext.remove((String)"testKey");
        Assert.assertNull((Object)ThreadContext.get((String)"testKey"));
        Assert.assertTrue((boolean)ThreadContext.isEmpty());
    }

    @Test
    public void testContainsKey() {
        ThreadContext.clearMap();
        Assert.assertFalse((boolean)ThreadContext.containsKey((String)"testKey"));
        ThreadContext.put((String)"testKey", (String)"testValue");
        Assert.assertTrue((boolean)ThreadContext.containsKey((String)"testKey"));
        ThreadContext.remove((String)"testKey");
        Assert.assertFalse((boolean)ThreadContext.containsKey((String)"testKey"));
    }

    private class TestThread
    extends Thread {
        private final StringBuilder sb;

        public TestThread(StringBuilder sb) {
            this.sb = sb;
        }

        @Override
        public void run() {
            String greeting = ThreadContext.get((String)"Greeting");
            if (greeting == null) {
                this.sb.append("null");
            } else {
                this.sb.append(greeting);
            }
            ThreadContext.clearMap();
        }
    }
}

