/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.message;

import java.io.Serializable;
import java.util.Locale;
import org.apache.commons.lang3.SerializationUtils;
import org.apache.logging.log4j.message.LocalizedMessage;
import org.apache.logging.log4j.message.Mutable;
import org.junit.Assert;
import org.junit.Test;

public class LocalizedMessageTest {
    private <T extends Serializable> T roundtrip(T msg) {
        return (T)((Serializable)SerializationUtils.deserialize((byte[])SerializationUtils.serialize(msg)));
    }

    @Test
    public void testMessageFormat() {
        LocalizedMessage msg = new LocalizedMessage("MF", new Locale("en", "US"), "msg1", new Object[]{"1", "Test"});
        Assert.assertEquals((Object)"This is test number 1 with string argument Test.", (Object)msg.getFormattedMessage());
    }

    @Test
    public void testSerializationMessageFormat() {
        LocalizedMessage msg = new LocalizedMessage("MF", new Locale("en", "US"), "msg1", new Object[]{"1", "Test"});
        Assert.assertEquals((Object)"This is test number 1 with string argument Test.", (Object)msg.getFormattedMessage());
        LocalizedMessage msg2 = this.roundtrip(msg);
        Assert.assertEquals((Object)"This is test number 1 with string argument Test.", (Object)msg2.getFormattedMessage());
    }

    @Test
    public void testSerializationStringFormat() {
        LocalizedMessage msg = new LocalizedMessage("SF", new Locale("en", "US"), "msg1", new Object[]{"1", "Test"});
        Assert.assertEquals((Object)"This is test number 1 with string argument Test.", (Object)msg.getFormattedMessage());
        LocalizedMessage msg2 = this.roundtrip(msg);
        Assert.assertEquals((Object)"This is test number 1 with string argument Test.", (Object)msg2.getFormattedMessage());
    }

    @Test
    public void testStringFormat() {
        LocalizedMessage msg = new LocalizedMessage("SF", new Locale("en", "US"), "msg1", new Object[]{"1", "Test"});
        Assert.assertEquals((Object)"This is test number 1 with string argument Test.", (Object)msg.getFormattedMessage());
    }

    @Test
    public void testUnsafeWithMutableParams() {
        String testMsg = "Test message %s";
        Mutable param = new Mutable().set("abc");
        LocalizedMessage msg = new LocalizedMessage("Test message %s", (Object)param);
        param.set("XYZ");
        String actual = msg.getFormattedMessage();
        Assert.assertEquals((String)"Expected most recent param value", (Object)"Test message XYZ", (Object)actual);
    }

    @Test
    public void testSafeAfterGetFormattedMessageIsCalled() {
        String testMsg = "Test message %s";
        Mutable param = new Mutable().set("abc");
        LocalizedMessage msg = new LocalizedMessage("Test message %s", (Object)param);
        msg.getFormattedMessage();
        param.set("XYZ");
        String actual = msg.getFormattedMessage();
        Assert.assertEquals((String)"Should use initial param value", (Object)"Test message abc", (Object)actual);
    }
}

