/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.message;

import java.util.concurrent.locks.ReentrantLock;
import org.apache.logging.log4j.message.ThreadDumpMessage;
import org.junit.Assert;
import org.junit.Test;

public class ThreadDumpMessageTest {
    @Test
    public void testMessage() {
        ThreadDumpMessage msg = new ThreadDumpMessage("Testing");
        String message = msg.getFormattedMessage();
        Assert.assertTrue((String)"No header", (boolean)message.contains("Testing"));
        Assert.assertTrue((String)"No RUNNABLE", (boolean)message.contains("RUNNABLE"));
        Assert.assertTrue((String)"No ThreadDumpMessage", (boolean)message.contains("ThreadDumpMessage"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMessageWithLocks() throws Exception {
        ThreadDumpMessage msg;
        ReentrantLock lock = new ReentrantLock();
        lock.lock();
        Thread1 thread1 = new Thread1(lock);
        thread1.start();
        ThreadDumpMessageTest threadDumpMessageTest = this;
        synchronized (threadDumpMessageTest) {
            Thread2 thread2 = new Thread2(this);
            thread2.start();
            try {
                Thread.sleep(200L);
                msg = new ThreadDumpMessage("Testing");
            }
            finally {
                lock.unlock();
            }
        }
        String message = msg.getFormattedMessage();
        Assert.assertTrue((String)"No header", (boolean)message.contains("Testing"));
        Assert.assertTrue((String)"No RUNNABLE", (boolean)message.contains("RUNNABLE"));
        Assert.assertTrue((String)"No ThreadDumpMessage", (boolean)message.contains("ThreadDumpMessage"));
    }

    @Test
    public void testToString() {
        ThreadDumpMessage msg = new ThreadDumpMessage("Test");
        String expected = "ThreadDumpMessage[Title=\"Test\"]";
        Assert.assertEquals((Object)"ThreadDumpMessage[Title=\"Test\"]", (Object)msg.toString());
    }

    @Test
    public void testUseConstructorThread() throws InterruptedException {
        final ThreadDumpMessage msg = new ThreadDumpMessage("Test");
        final String[] actual = new String[1];
        Thread other = new Thread("OtherThread"){

            @Override
            public void run() {
                actual[0] = msg.getFormattedMessage();
            }
        };
        other.start();
        other.join();
        Assert.assertTrue((String)"No mention of other thread in msg", (!actual[0].contains("OtherThread") ? 1 : 0) != 0);
    }

    private class Thread2
    extends Thread {
        private final Object obj;

        public Thread2(Object obj) {
            this.obj = obj;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Object object = this.obj;
            synchronized (object) {
            }
        }
    }

    private class Thread1
    extends Thread {
        private final ReentrantLock lock;

        public Thread1(ReentrantLock lock) {
            this.lock = lock;
        }

        @Override
        public void run() {
            this.lock.lock();
            this.lock.unlock();
        }
    }
}

