/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j;

import java.util.ArrayList;
import java.util.List;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.MarkerManager;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.message.SimpleMessage;
import org.apache.logging.log4j.spi.AbstractLogger;
import org.apache.logging.log4j.util.Supplier;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class LambdaLoggerTest {
    final Logger2Impl logger2 = new Logger2Impl();
    final String stringMessage = "Hi";
    final Message message = new SimpleMessage("HiMessage");
    final Throwable throwable = new Error("I'm Bad");
    final Marker marker = MarkerManager.getMarker((String)"test");
    final MyMessageSupplier messageSupplier = new MyMessageSupplier();
    final MySupplier supplier = new MySupplier();
    final MySupplier supplier2 = new MySupplier();
    final Supplier[] supplierArray1 = new Supplier[]{this.supplier};
    final Supplier[] supplierArray2 = new Supplier[]{this.supplier, this.supplier2};

    @Before
    public void beforeEachTest() {
        this.logger2.list.clear();
        this.supplier.invoked = false;
        this.messageSupplier.invoked = false;
    }

    @Test
    public void testDebugMarkerMessageSupplier() {
        this.logger2.disable().debug(this.marker, (Supplier)this.messageSupplier);
        Assert.assertTrue((boolean)this.logger2.list.isEmpty());
        Assert.assertFalse((boolean)this.messageSupplier.invoked);
        this.logger2.enable().debug(this.marker, (Supplier)this.messageSupplier);
        Assert.assertEquals((long)1L, (long)this.logger2.list.size());
        Assert.assertTrue((boolean)this.messageSupplier.invoked);
        LogEvent event = this.logger2.list.get(0);
        Assert.assertEquals((Object)Level.DEBUG, (Object)event.level);
        Assert.assertSame((Object)this.message, (Object)event.message);
        Assert.assertSame((Object)this.marker, (Object)event.marker);
    }

    @Test
    public void testDebugMessageSupplier() {
        this.logger2.disable().debug((Supplier)this.messageSupplier);
        Assert.assertTrue((boolean)this.logger2.list.isEmpty());
        Assert.assertFalse((boolean)this.messageSupplier.invoked);
        this.logger2.enable().debug((Supplier)this.messageSupplier);
        Assert.assertEquals((long)1L, (long)this.logger2.list.size());
        Assert.assertTrue((boolean)this.messageSupplier.invoked);
        LogEvent event = this.logger2.list.get(0);
        Assert.assertEquals((Object)Level.DEBUG, (Object)event.level);
        Assert.assertSame((Object)this.message, (Object)event.message);
    }

    @Test
    public void testDebugMarkerMessageSupplierThrowable() {
        this.logger2.disable().debug(this.marker, (Supplier)this.messageSupplier, this.throwable);
        Assert.assertTrue((boolean)this.logger2.list.isEmpty());
        Assert.assertFalse((boolean)this.messageSupplier.invoked);
        this.logger2.enable().debug(this.marker, (Supplier)this.messageSupplier, this.throwable);
        Assert.assertEquals((long)1L, (long)this.logger2.list.size());
        Assert.assertTrue((boolean)this.messageSupplier.invoked);
        LogEvent event = this.logger2.list.get(0);
        Assert.assertEquals((Object)Level.DEBUG, (Object)event.level);
        Assert.assertSame((Object)this.marker, (Object)event.marker);
        Assert.assertSame((Object)this.message, (Object)event.message);
        Assert.assertSame((Object)this.throwable, (Object)event.throwable);
    }

    @Test
    public void testDebugMessageSupplierThrowable() {
        this.logger2.disable().debug((Supplier)this.messageSupplier, this.throwable);
        Assert.assertTrue((boolean)this.logger2.list.isEmpty());
        Assert.assertFalse((boolean)this.messageSupplier.invoked);
        this.logger2.enable().debug((Supplier)this.messageSupplier, this.throwable);
        Assert.assertEquals((long)1L, (long)this.logger2.list.size());
        Assert.assertTrue((boolean)this.messageSupplier.invoked);
        LogEvent event = this.logger2.list.get(0);
        Assert.assertEquals((Object)Level.DEBUG, (Object)event.level);
        Assert.assertSame((Object)this.message, (Object)event.message);
        Assert.assertSame((Object)this.throwable, (Object)event.throwable);
    }

    @Test
    public void testDebugMarkerSupplier() {
        this.logger2.disable().debug(this.marker, (Supplier)this.supplier);
        Assert.assertTrue((boolean)this.logger2.list.isEmpty());
        Assert.assertFalse((boolean)this.supplier.invoked);
        this.logger2.enable().debug(this.marker, (Supplier)this.supplier);
        Assert.assertEquals((long)1L, (long)this.logger2.list.size());
        Assert.assertTrue((boolean)this.supplier.invoked);
        LogEvent event = this.logger2.list.get(0);
        Assert.assertEquals((Object)Level.DEBUG, (Object)event.level);
        Assert.assertSame((Object)"Hi", (Object)event.message.getFormattedMessage());
        Assert.assertSame((Object)this.marker, (Object)event.marker);
    }

    @Test
    public void testDebugSupplier() {
        this.logger2.disable().debug((Supplier)this.supplier);
        Assert.assertTrue((boolean)this.logger2.list.isEmpty());
        Assert.assertFalse((boolean)this.supplier.invoked);
        this.logger2.enable().debug((Supplier)this.supplier);
        Assert.assertEquals((long)1L, (long)this.logger2.list.size());
        Assert.assertTrue((boolean)this.supplier.invoked);
        LogEvent event = this.logger2.list.get(0);
        Assert.assertEquals((Object)Level.DEBUG, (Object)event.level);
        Assert.assertSame((Object)"Hi", (Object)event.message.getFormattedMessage());
    }

    @Test
    public void testDebugMarkerSupplierThrowable() {
        this.logger2.disable().debug(this.marker, (Supplier)this.supplier, this.throwable);
        Assert.assertTrue((boolean)this.logger2.list.isEmpty());
        Assert.assertFalse((boolean)this.supplier.invoked);
        this.logger2.enable().debug(this.marker, (Supplier)this.supplier, this.throwable);
        Assert.assertEquals((long)1L, (long)this.logger2.list.size());
        Assert.assertTrue((boolean)this.supplier.invoked);
        LogEvent event = this.logger2.list.get(0);
        Assert.assertEquals((Object)Level.DEBUG, (Object)event.level);
        Assert.assertSame((Object)this.marker, (Object)event.marker);
        Assert.assertSame((Object)"Hi", (Object)event.message.getFormattedMessage());
        Assert.assertSame((Object)this.throwable, (Object)event.throwable);
    }

    @Test
    public void testDebugSupplierThrowable() {
        this.logger2.disable().debug((Supplier)this.supplier, this.throwable);
        Assert.assertTrue((boolean)this.logger2.list.isEmpty());
        Assert.assertFalse((boolean)this.supplier.invoked);
        this.logger2.enable().debug((Supplier)this.supplier, this.throwable);
        Assert.assertEquals((long)1L, (long)this.logger2.list.size());
        Assert.assertTrue((boolean)this.supplier.invoked);
        LogEvent event = this.logger2.list.get(0);
        Assert.assertEquals((Object)Level.DEBUG, (Object)event.level);
        Assert.assertSame((Object)"Hi", (Object)event.message.getFormattedMessage());
        Assert.assertSame((Object)this.throwable, (Object)event.throwable);
    }

    @Test
    public void testDebugStringParamSupplier() {
        this.logger2.disable().debug("abc {}", this.supplierArray1);
        Assert.assertTrue((boolean)this.logger2.list.isEmpty());
        Assert.assertFalse((boolean)this.supplier.invoked);
        this.logger2.enable().debug("abc {}", this.supplierArray1);
        Assert.assertEquals((long)1L, (long)this.logger2.list.size());
        Assert.assertTrue((boolean)this.supplier.invoked);
        LogEvent event = this.logger2.list.get(0);
        Assert.assertEquals((Object)Level.DEBUG, (Object)event.level);
        Assert.assertEquals((Object)"abc Hi", (Object)event.message.getFormattedMessage());
    }

    @Test
    public void testDebugMarkerStringParamSupplier() {
        this.logger2.disable().debug(this.marker, "abc {}", this.supplierArray1);
        Assert.assertTrue((boolean)this.logger2.list.isEmpty());
        Assert.assertFalse((boolean)this.supplier.invoked);
        this.logger2.enable().debug(this.marker, "abc {}", this.supplierArray1);
        Assert.assertEquals((long)1L, (long)this.logger2.list.size());
        Assert.assertTrue((boolean)this.supplier.invoked);
        LogEvent event = this.logger2.list.get(0);
        Assert.assertEquals((Object)Level.DEBUG, (Object)event.level);
        Assert.assertSame((Object)this.marker, (Object)event.marker);
        Assert.assertEquals((Object)"abc Hi", (Object)event.message.getFormattedMessage());
    }

    @Test
    public void testErrorMarkerMessageSupplier() {
        this.logger2.disable().error(this.marker, (Supplier)this.messageSupplier);
        Assert.assertTrue((boolean)this.logger2.list.isEmpty());
        Assert.assertFalse((boolean)this.messageSupplier.invoked);
        this.logger2.enable().error(this.marker, (Supplier)this.messageSupplier);
        Assert.assertEquals((long)1L, (long)this.logger2.list.size());
        Assert.assertTrue((boolean)this.messageSupplier.invoked);
        LogEvent event = this.logger2.list.get(0);
        Assert.assertEquals((Object)Level.ERROR, (Object)event.level);
        Assert.assertSame((Object)this.message, (Object)event.message);
        Assert.assertSame((Object)this.marker, (Object)event.marker);
    }

    @Test
    public void testErrorMessageSupplier() {
        this.logger2.disable().error((Supplier)this.messageSupplier);
        Assert.assertTrue((boolean)this.logger2.list.isEmpty());
        Assert.assertFalse((boolean)this.messageSupplier.invoked);
        this.logger2.enable().error((Supplier)this.messageSupplier);
        Assert.assertEquals((long)1L, (long)this.logger2.list.size());
        Assert.assertTrue((boolean)this.messageSupplier.invoked);
        LogEvent event = this.logger2.list.get(0);
        Assert.assertEquals((Object)Level.ERROR, (Object)event.level);
        Assert.assertSame((Object)this.message, (Object)event.message);
    }

    @Test
    public void testErrorMarkerMessageSupplierThrowable() {
        this.logger2.disable().error(this.marker, (Supplier)this.messageSupplier, this.throwable);
        Assert.assertTrue((boolean)this.logger2.list.isEmpty());
        Assert.assertFalse((boolean)this.messageSupplier.invoked);
        this.logger2.enable().error(this.marker, (Supplier)this.messageSupplier, this.throwable);
        Assert.assertEquals((long)1L, (long)this.logger2.list.size());
        Assert.assertTrue((boolean)this.messageSupplier.invoked);
        LogEvent event = this.logger2.list.get(0);
        Assert.assertEquals((Object)Level.ERROR, (Object)event.level);
        Assert.assertSame((Object)this.marker, (Object)event.marker);
        Assert.assertSame((Object)this.message, (Object)event.message);
        Assert.assertSame((Object)this.throwable, (Object)event.throwable);
    }

    @Test
    public void testErrorMessageSupplierThrowable() {
        this.logger2.disable().error((Supplier)this.messageSupplier, this.throwable);
        Assert.assertTrue((boolean)this.logger2.list.isEmpty());
        Assert.assertFalse((boolean)this.messageSupplier.invoked);
        this.logger2.enable().error((Supplier)this.messageSupplier, this.throwable);
        Assert.assertEquals((long)1L, (long)this.logger2.list.size());
        Assert.assertTrue((boolean)this.messageSupplier.invoked);
        LogEvent event = this.logger2.list.get(0);
        Assert.assertEquals((Object)Level.ERROR, (Object)event.level);
        Assert.assertSame((Object)this.message, (Object)event.message);
        Assert.assertSame((Object)this.throwable, (Object)event.throwable);
    }

    @Test
    public void testErrorMarkerSupplier() {
        this.logger2.disable().error(this.marker, (Supplier)this.supplier);
        Assert.assertTrue((boolean)this.logger2.list.isEmpty());
        Assert.assertFalse((boolean)this.supplier.invoked);
        this.logger2.enable().error(this.marker, (Supplier)this.supplier);
        Assert.assertEquals((long)1L, (long)this.logger2.list.size());
        Assert.assertTrue((boolean)this.supplier.invoked);
        LogEvent event = this.logger2.list.get(0);
        Assert.assertEquals((Object)Level.ERROR, (Object)event.level);
        Assert.assertSame((Object)"Hi", (Object)event.message.getFormattedMessage());
        Assert.assertSame((Object)this.marker, (Object)event.marker);
    }

    @Test
    public void testErrorSupplier() {
        this.logger2.disable().error((Supplier)this.supplier);
        Assert.assertTrue((boolean)this.logger2.list.isEmpty());
        Assert.assertFalse((boolean)this.supplier.invoked);
        this.logger2.enable().error((Supplier)this.supplier);
        Assert.assertEquals((long)1L, (long)this.logger2.list.size());
        Assert.assertTrue((boolean)this.supplier.invoked);
        LogEvent event = this.logger2.list.get(0);
        Assert.assertEquals((Object)Level.ERROR, (Object)event.level);
        Assert.assertSame((Object)"Hi", (Object)event.message.getFormattedMessage());
    }

    @Test
    public void testErrorMarkerSupplierThrowable() {
        this.logger2.disable().error(this.marker, (Supplier)this.supplier, this.throwable);
        Assert.assertTrue((boolean)this.logger2.list.isEmpty());
        Assert.assertFalse((boolean)this.supplier.invoked);
        this.logger2.enable().error(this.marker, (Supplier)this.supplier, this.throwable);
        Assert.assertEquals((long)1L, (long)this.logger2.list.size());
        Assert.assertTrue((boolean)this.supplier.invoked);
        LogEvent event = this.logger2.list.get(0);
        Assert.assertEquals((Object)Level.ERROR, (Object)event.level);
        Assert.assertSame((Object)this.marker, (Object)event.marker);
        Assert.assertSame((Object)"Hi", (Object)event.message.getFormattedMessage());
        Assert.assertSame((Object)this.throwable, (Object)event.throwable);
    }

    @Test
    public void testErrorSupplierThrowable() {
        this.logger2.disable().error((Supplier)this.supplier, this.throwable);
        Assert.assertTrue((boolean)this.logger2.list.isEmpty());
        Assert.assertFalse((boolean)this.supplier.invoked);
        this.logger2.enable().error((Supplier)this.supplier, this.throwable);
        Assert.assertEquals((long)1L, (long)this.logger2.list.size());
        Assert.assertTrue((boolean)this.supplier.invoked);
        LogEvent event = this.logger2.list.get(0);
        Assert.assertEquals((Object)Level.ERROR, (Object)event.level);
        Assert.assertSame((Object)"Hi", (Object)event.message.getFormattedMessage());
        Assert.assertSame((Object)this.throwable, (Object)event.throwable);
    }

    @Test
    public void testErrorStringParamSupplier() {
        this.logger2.disable().error("abc {}", this.supplierArray1);
        Assert.assertTrue((boolean)this.logger2.list.isEmpty());
        Assert.assertFalse((boolean)this.supplier.invoked);
        this.logger2.enable().error("abc {}", this.supplierArray1);
        Assert.assertEquals((long)1L, (long)this.logger2.list.size());
        Assert.assertTrue((boolean)this.supplier.invoked);
        LogEvent event = this.logger2.list.get(0);
        Assert.assertEquals((Object)Level.ERROR, (Object)event.level);
        Assert.assertEquals((Object)"abc Hi", (Object)event.message.getFormattedMessage());
    }

    @Test
    public void testErrorMarkerStringParamSupplier() {
        this.logger2.disable().error(this.marker, "abc {}", this.supplierArray1);
        Assert.assertTrue((boolean)this.logger2.list.isEmpty());
        Assert.assertFalse((boolean)this.supplier.invoked);
        this.logger2.enable().error(this.marker, "abc {}", this.supplierArray1);
        Assert.assertEquals((long)1L, (long)this.logger2.list.size());
        Assert.assertTrue((boolean)this.supplier.invoked);
        LogEvent event = this.logger2.list.get(0);
        Assert.assertEquals((Object)Level.ERROR, (Object)event.level);
        Assert.assertSame((Object)this.marker, (Object)event.marker);
        Assert.assertEquals((Object)"abc Hi", (Object)event.message.getFormattedMessage());
    }

    @Test
    public void testFatalMarkerMessageSupplier() {
        this.logger2.disable().fatal(this.marker, (Supplier)this.messageSupplier);
        Assert.assertTrue((boolean)this.logger2.list.isEmpty());
        Assert.assertFalse((boolean)this.messageSupplier.invoked);
        this.logger2.enable().fatal(this.marker, (Supplier)this.messageSupplier);
        Assert.assertEquals((long)1L, (long)this.logger2.list.size());
        Assert.assertTrue((boolean)this.messageSupplier.invoked);
        LogEvent event = this.logger2.list.get(0);
        Assert.assertEquals((Object)Level.FATAL, (Object)event.level);
        Assert.assertSame((Object)this.message, (Object)event.message);
        Assert.assertSame((Object)this.marker, (Object)event.marker);
    }

    @Test
    public void testFatalMessageSupplier() {
        this.logger2.disable().fatal((Supplier)this.messageSupplier);
        Assert.assertTrue((boolean)this.logger2.list.isEmpty());
        Assert.assertFalse((boolean)this.messageSupplier.invoked);
        this.logger2.enable().fatal((Supplier)this.messageSupplier);
        Assert.assertEquals((long)1L, (long)this.logger2.list.size());
        Assert.assertTrue((boolean)this.messageSupplier.invoked);
        LogEvent event = this.logger2.list.get(0);
        Assert.assertEquals((Object)Level.FATAL, (Object)event.level);
        Assert.assertSame((Object)this.message, (Object)event.message);
    }

    @Test
    public void testFatalMarkerMessageSupplierThrowable() {
        this.logger2.disable().fatal(this.marker, (Supplier)this.messageSupplier, this.throwable);
        Assert.assertTrue((boolean)this.logger2.list.isEmpty());
        Assert.assertFalse((boolean)this.messageSupplier.invoked);
        this.logger2.enable().fatal(this.marker, (Supplier)this.messageSupplier, this.throwable);
        Assert.assertEquals((long)1L, (long)this.logger2.list.size());
        Assert.assertTrue((boolean)this.messageSupplier.invoked);
        LogEvent event = this.logger2.list.get(0);
        Assert.assertEquals((Object)Level.FATAL, (Object)event.level);
        Assert.assertSame((Object)this.marker, (Object)event.marker);
        Assert.assertSame((Object)this.message, (Object)event.message);
        Assert.assertSame((Object)this.throwable, (Object)event.throwable);
    }

    @Test
    public void testFatalMessageSupplierThrowable() {
        this.logger2.disable().fatal((Supplier)this.messageSupplier, this.throwable);
        Assert.assertTrue((boolean)this.logger2.list.isEmpty());
        Assert.assertFalse((boolean)this.messageSupplier.invoked);
        this.logger2.enable().fatal((Supplier)this.messageSupplier, this.throwable);
        Assert.assertEquals((long)1L, (long)this.logger2.list.size());
        Assert.assertTrue((boolean)this.messageSupplier.invoked);
        LogEvent event = this.logger2.list.get(0);
        Assert.assertEquals((Object)Level.FATAL, (Object)event.level);
        Assert.assertSame((Object)this.message, (Object)event.message);
        Assert.assertSame((Object)this.throwable, (Object)event.throwable);
    }

    @Test
    public void testFatalMarkerSupplier() {
        this.logger2.disable().fatal(this.marker, (Supplier)this.supplier);
        Assert.assertTrue((boolean)this.logger2.list.isEmpty());
        Assert.assertFalse((boolean)this.supplier.invoked);
        this.logger2.enable().fatal(this.marker, (Supplier)this.supplier);
        Assert.assertEquals((long)1L, (long)this.logger2.list.size());
        Assert.assertTrue((boolean)this.supplier.invoked);
        LogEvent event = this.logger2.list.get(0);
        Assert.assertEquals((Object)Level.FATAL, (Object)event.level);
        Assert.assertSame((Object)"Hi", (Object)event.message.getFormattedMessage());
        Assert.assertSame((Object)this.marker, (Object)event.marker);
    }

    @Test
    public void testFatalSupplier() {
        this.logger2.disable().fatal((Supplier)this.supplier);
        Assert.assertTrue((boolean)this.logger2.list.isEmpty());
        Assert.assertFalse((boolean)this.supplier.invoked);
        this.logger2.enable().fatal((Supplier)this.supplier);
        Assert.assertEquals((long)1L, (long)this.logger2.list.size());
        Assert.assertTrue((boolean)this.supplier.invoked);
        LogEvent event = this.logger2.list.get(0);
        Assert.assertEquals((Object)Level.FATAL, (Object)event.level);
        Assert.assertSame((Object)"Hi", (Object)event.message.getFormattedMessage());
    }

    @Test
    public void testFatalMarkerSupplierThrowable() {
        this.logger2.disable().fatal(this.marker, (Supplier)this.supplier, this.throwable);
        Assert.assertTrue((boolean)this.logger2.list.isEmpty());
        Assert.assertFalse((boolean)this.supplier.invoked);
        this.logger2.enable().fatal(this.marker, (Supplier)this.supplier, this.throwable);
        Assert.assertEquals((long)1L, (long)this.logger2.list.size());
        Assert.assertTrue((boolean)this.supplier.invoked);
        LogEvent event = this.logger2.list.get(0);
        Assert.assertEquals((Object)Level.FATAL, (Object)event.level);
        Assert.assertSame((Object)this.marker, (Object)event.marker);
        Assert.assertSame((Object)"Hi", (Object)event.message.getFormattedMessage());
        Assert.assertSame((Object)this.throwable, (Object)event.throwable);
    }

    @Test
    public void testFatalSupplierThrowable() {
        this.logger2.disable().fatal((Supplier)this.supplier, this.throwable);
        Assert.assertTrue((boolean)this.logger2.list.isEmpty());
        Assert.assertFalse((boolean)this.supplier.invoked);
        this.logger2.enable().fatal((Supplier)this.supplier, this.throwable);
        Assert.assertEquals((long)1L, (long)this.logger2.list.size());
        Assert.assertTrue((boolean)this.supplier.invoked);
        LogEvent event = this.logger2.list.get(0);
        Assert.assertEquals((Object)Level.FATAL, (Object)event.level);
        Assert.assertSame((Object)"Hi", (Object)event.message.getFormattedMessage());
        Assert.assertSame((Object)this.throwable, (Object)event.throwable);
    }

    @Test
    public void testFatalStringParamSupplier() {
        this.logger2.disable().fatal("abc {}", this.supplierArray1);
        Assert.assertTrue((boolean)this.logger2.list.isEmpty());
        Assert.assertFalse((boolean)this.supplier.invoked);
        this.logger2.enable().fatal("abc {}", this.supplierArray1);
        Assert.assertEquals((long)1L, (long)this.logger2.list.size());
        Assert.assertTrue((boolean)this.supplier.invoked);
        LogEvent event = this.logger2.list.get(0);
        Assert.assertEquals((Object)Level.FATAL, (Object)event.level);
        Assert.assertEquals((Object)"abc Hi", (Object)event.message.getFormattedMessage());
    }

    @Test
    public void testFatalStringParam2Suppliers() {
        this.logger2.disable().fatal("abc {}{}", this.supplierArray2);
        Assert.assertTrue((boolean)this.logger2.list.isEmpty());
        Assert.assertFalse((boolean)this.supplier.invoked);
        Assert.assertFalse((boolean)this.supplier2.invoked);
        this.logger2.enable().fatal("abc {}{}", this.supplierArray2);
        Assert.assertEquals((long)1L, (long)this.logger2.list.size());
        Assert.assertTrue((boolean)this.supplier.invoked);
        Assert.assertTrue((boolean)this.supplier2.invoked);
        LogEvent event = this.logger2.list.get(0);
        Assert.assertEquals((Object)Level.FATAL, (Object)event.level);
        Assert.assertEquals((Object)"abc HiHi", (Object)event.message.getFormattedMessage());
    }

    @Test
    public void testFatalMarkerStringParamSupplier() {
        this.logger2.disable().fatal(this.marker, "abc {}", this.supplierArray1);
        Assert.assertTrue((boolean)this.logger2.list.isEmpty());
        Assert.assertFalse((boolean)this.supplier.invoked);
        this.logger2.enable().fatal(this.marker, "abc {}", this.supplierArray1);
        Assert.assertEquals((long)1L, (long)this.logger2.list.size());
        Assert.assertTrue((boolean)this.supplier.invoked);
        LogEvent event = this.logger2.list.get(0);
        Assert.assertEquals((Object)Level.FATAL, (Object)event.level);
        Assert.assertSame((Object)this.marker, (Object)event.marker);
        Assert.assertEquals((Object)"abc Hi", (Object)event.message.getFormattedMessage());
    }

    @Test
    public void testInfoMarkerMessageSupplier() {
        this.logger2.disable().info(this.marker, (Supplier)this.messageSupplier);
        Assert.assertTrue((boolean)this.logger2.list.isEmpty());
        Assert.assertFalse((boolean)this.messageSupplier.invoked);
        this.logger2.enable().info(this.marker, (Supplier)this.messageSupplier);
        Assert.assertEquals((long)1L, (long)this.logger2.list.size());
        Assert.assertTrue((boolean)this.messageSupplier.invoked);
        LogEvent event = this.logger2.list.get(0);
        Assert.assertEquals((Object)Level.INFO, (Object)event.level);
        Assert.assertSame((Object)this.message, (Object)event.message);
        Assert.assertSame((Object)this.marker, (Object)event.marker);
    }

    @Test
    public void testInfoMessageSupplier() {
        this.logger2.disable().info((Supplier)this.messageSupplier);
        Assert.assertTrue((boolean)this.logger2.list.isEmpty());
        Assert.assertFalse((boolean)this.messageSupplier.invoked);
        this.logger2.enable().info((Supplier)this.messageSupplier);
        Assert.assertEquals((long)1L, (long)this.logger2.list.size());
        Assert.assertTrue((boolean)this.messageSupplier.invoked);
        LogEvent event = this.logger2.list.get(0);
        Assert.assertEquals((Object)Level.INFO, (Object)event.level);
        Assert.assertSame((Object)this.message, (Object)event.message);
    }

    @Test
    public void testInfoMarkerMessageSupplierThrowable() {
        this.logger2.disable().info(this.marker, (Supplier)this.messageSupplier, this.throwable);
        Assert.assertTrue((boolean)this.logger2.list.isEmpty());
        Assert.assertFalse((boolean)this.messageSupplier.invoked);
        this.logger2.enable().info(this.marker, (Supplier)this.messageSupplier, this.throwable);
        Assert.assertEquals((long)1L, (long)this.logger2.list.size());
        Assert.assertTrue((boolean)this.messageSupplier.invoked);
        LogEvent event = this.logger2.list.get(0);
        Assert.assertEquals((Object)Level.INFO, (Object)event.level);
        Assert.assertSame((Object)this.marker, (Object)event.marker);
        Assert.assertSame((Object)this.message, (Object)event.message);
        Assert.assertSame((Object)this.throwable, (Object)event.throwable);
    }

    @Test
    public void testInfoMessageSupplierThrowable() {
        this.logger2.disable().info((Supplier)this.messageSupplier, this.throwable);
        Assert.assertTrue((boolean)this.logger2.list.isEmpty());
        Assert.assertFalse((boolean)this.messageSupplier.invoked);
        this.logger2.enable().info((Supplier)this.messageSupplier, this.throwable);
        Assert.assertEquals((long)1L, (long)this.logger2.list.size());
        Assert.assertTrue((boolean)this.messageSupplier.invoked);
        LogEvent event = this.logger2.list.get(0);
        Assert.assertEquals((Object)Level.INFO, (Object)event.level);
        Assert.assertSame((Object)this.message, (Object)event.message);
        Assert.assertSame((Object)this.throwable, (Object)event.throwable);
    }

    @Test
    public void testInfoMarkerSupplier() {
        this.logger2.disable().info(this.marker, (Supplier)this.supplier);
        Assert.assertTrue((boolean)this.logger2.list.isEmpty());
        Assert.assertFalse((boolean)this.supplier.invoked);
        this.logger2.enable().info(this.marker, (Supplier)this.supplier);
        Assert.assertEquals((long)1L, (long)this.logger2.list.size());
        Assert.assertTrue((boolean)this.supplier.invoked);
        LogEvent event = this.logger2.list.get(0);
        Assert.assertEquals((Object)Level.INFO, (Object)event.level);
        Assert.assertSame((Object)"Hi", (Object)event.message.getFormattedMessage());
        Assert.assertSame((Object)this.marker, (Object)event.marker);
    }

    @Test
    public void testInfoSupplier() {
        this.logger2.disable().info((Supplier)this.supplier);
        Assert.assertTrue((boolean)this.logger2.list.isEmpty());
        Assert.assertFalse((boolean)this.supplier.invoked);
        this.logger2.enable().info((Supplier)this.supplier);
        Assert.assertEquals((long)1L, (long)this.logger2.list.size());
        Assert.assertTrue((boolean)this.supplier.invoked);
        LogEvent event = this.logger2.list.get(0);
        Assert.assertEquals((Object)Level.INFO, (Object)event.level);
        Assert.assertSame((Object)"Hi", (Object)event.message.getFormattedMessage());
    }

    @Test
    public void testInfoMarkerSupplierThrowable() {
        this.logger2.disable().info(this.marker, (Supplier)this.supplier, this.throwable);
        Assert.assertTrue((boolean)this.logger2.list.isEmpty());
        Assert.assertFalse((boolean)this.supplier.invoked);
        this.logger2.enable().info(this.marker, (Supplier)this.supplier, this.throwable);
        Assert.assertEquals((long)1L, (long)this.logger2.list.size());
        Assert.assertTrue((boolean)this.supplier.invoked);
        LogEvent event = this.logger2.list.get(0);
        Assert.assertEquals((Object)Level.INFO, (Object)event.level);
        Assert.assertSame((Object)this.marker, (Object)event.marker);
        Assert.assertSame((Object)"Hi", (Object)event.message.getFormattedMessage());
        Assert.assertSame((Object)this.throwable, (Object)event.throwable);
    }

    @Test
    public void testInfoSupplierThrowable() {
        this.logger2.disable().info((Supplier)this.supplier, this.throwable);
        Assert.assertTrue((boolean)this.logger2.list.isEmpty());
        Assert.assertFalse((boolean)this.supplier.invoked);
        this.logger2.enable().info((Supplier)this.supplier, this.throwable);
        Assert.assertEquals((long)1L, (long)this.logger2.list.size());
        Assert.assertTrue((boolean)this.supplier.invoked);
        LogEvent event = this.logger2.list.get(0);
        Assert.assertEquals((Object)Level.INFO, (Object)event.level);
        Assert.assertSame((Object)"Hi", (Object)event.message.getFormattedMessage());
        Assert.assertSame((Object)this.throwable, (Object)event.throwable);
    }

    @Test
    public void testInfoStringParamSupplier() {
        this.logger2.disable().info("abc {}", this.supplierArray1);
        Assert.assertTrue((boolean)this.logger2.list.isEmpty());
        Assert.assertFalse((boolean)this.supplier.invoked);
        this.logger2.enable().info("abc {}", this.supplierArray1);
        Assert.assertEquals((long)1L, (long)this.logger2.list.size());
        Assert.assertTrue((boolean)this.supplier.invoked);
        LogEvent event = this.logger2.list.get(0);
        Assert.assertEquals((Object)Level.INFO, (Object)event.level);
        Assert.assertEquals((Object)"abc Hi", (Object)event.message.getFormattedMessage());
    }

    @Test
    public void testInfoMarkerStringParamSupplier() {
        this.logger2.disable().info(this.marker, "abc {}", this.supplierArray1);
        Assert.assertTrue((boolean)this.logger2.list.isEmpty());
        Assert.assertFalse((boolean)this.supplier.invoked);
        this.logger2.enable().info(this.marker, "abc {}", this.supplierArray1);
        Assert.assertEquals((long)1L, (long)this.logger2.list.size());
        Assert.assertTrue((boolean)this.supplier.invoked);
        LogEvent event = this.logger2.list.get(0);
        Assert.assertEquals((Object)Level.INFO, (Object)event.level);
        Assert.assertSame((Object)this.marker, (Object)event.marker);
        Assert.assertEquals((Object)"abc Hi", (Object)event.message.getFormattedMessage());
    }

    @Test
    public void testTraceMarkerMessageSupplier() {
        this.logger2.disable().trace(this.marker, (Supplier)this.messageSupplier);
        Assert.assertTrue((boolean)this.logger2.list.isEmpty());
        Assert.assertFalse((boolean)this.messageSupplier.invoked);
        this.logger2.enable().trace(this.marker, (Supplier)this.messageSupplier);
        Assert.assertEquals((long)1L, (long)this.logger2.list.size());
        Assert.assertTrue((boolean)this.messageSupplier.invoked);
        LogEvent event = this.logger2.list.get(0);
        Assert.assertEquals((Object)Level.TRACE, (Object)event.level);
        Assert.assertSame((Object)this.message, (Object)event.message);
        Assert.assertSame((Object)this.marker, (Object)event.marker);
    }

    @Test
    public void testTraceMessageSupplier() {
        this.logger2.disable().trace((Supplier)this.messageSupplier);
        Assert.assertTrue((boolean)this.logger2.list.isEmpty());
        Assert.assertFalse((boolean)this.messageSupplier.invoked);
        this.logger2.enable().trace((Supplier)this.messageSupplier);
        Assert.assertEquals((long)1L, (long)this.logger2.list.size());
        Assert.assertTrue((boolean)this.messageSupplier.invoked);
        LogEvent event = this.logger2.list.get(0);
        Assert.assertEquals((Object)Level.TRACE, (Object)event.level);
        Assert.assertSame((Object)this.message, (Object)event.message);
    }

    @Test
    public void testTraceMarkerMessageSupplierThrowable() {
        this.logger2.disable().trace(this.marker, (Supplier)this.messageSupplier, this.throwable);
        Assert.assertTrue((boolean)this.logger2.list.isEmpty());
        Assert.assertFalse((boolean)this.messageSupplier.invoked);
        this.logger2.enable().trace(this.marker, (Supplier)this.messageSupplier, this.throwable);
        Assert.assertEquals((long)1L, (long)this.logger2.list.size());
        Assert.assertTrue((boolean)this.messageSupplier.invoked);
        LogEvent event = this.logger2.list.get(0);
        Assert.assertEquals((Object)Level.TRACE, (Object)event.level);
        Assert.assertSame((Object)this.marker, (Object)event.marker);
        Assert.assertSame((Object)this.message, (Object)event.message);
        Assert.assertSame((Object)this.throwable, (Object)event.throwable);
    }

    @Test
    public void testTraceMessageSupplierThrowable() {
        this.logger2.disable().trace((Supplier)this.messageSupplier, this.throwable);
        Assert.assertTrue((boolean)this.logger2.list.isEmpty());
        Assert.assertFalse((boolean)this.messageSupplier.invoked);
        this.logger2.enable().trace((Supplier)this.messageSupplier, this.throwable);
        Assert.assertEquals((long)1L, (long)this.logger2.list.size());
        Assert.assertTrue((boolean)this.messageSupplier.invoked);
        LogEvent event = this.logger2.list.get(0);
        Assert.assertEquals((Object)Level.TRACE, (Object)event.level);
        Assert.assertSame((Object)this.message, (Object)event.message);
        Assert.assertSame((Object)this.throwable, (Object)event.throwable);
    }

    @Test
    public void testTraceMarkerSupplier() {
        this.logger2.disable().trace(this.marker, (Supplier)this.supplier);
        Assert.assertTrue((boolean)this.logger2.list.isEmpty());
        Assert.assertFalse((boolean)this.supplier.invoked);
        this.logger2.enable().trace(this.marker, (Supplier)this.supplier);
        Assert.assertEquals((long)1L, (long)this.logger2.list.size());
        Assert.assertTrue((boolean)this.supplier.invoked);
        LogEvent event = this.logger2.list.get(0);
        Assert.assertEquals((Object)Level.TRACE, (Object)event.level);
        Assert.assertSame((Object)"Hi", (Object)event.message.getFormattedMessage());
        Assert.assertSame((Object)this.marker, (Object)event.marker);
    }

    @Test
    public void testTraceSupplier() {
        this.logger2.disable().trace((Supplier)this.supplier);
        Assert.assertTrue((boolean)this.logger2.list.isEmpty());
        Assert.assertFalse((boolean)this.supplier.invoked);
        this.logger2.enable().trace((Supplier)this.supplier);
        Assert.assertEquals((long)1L, (long)this.logger2.list.size());
        Assert.assertTrue((boolean)this.supplier.invoked);
        LogEvent event = this.logger2.list.get(0);
        Assert.assertEquals((Object)Level.TRACE, (Object)event.level);
        Assert.assertSame((Object)"Hi", (Object)event.message.getFormattedMessage());
    }

    @Test
    public void testTraceMarkerSupplierThrowable() {
        this.logger2.disable().trace(this.marker, (Supplier)this.supplier, this.throwable);
        Assert.assertTrue((boolean)this.logger2.list.isEmpty());
        Assert.assertFalse((boolean)this.supplier.invoked);
        this.logger2.enable().trace(this.marker, (Supplier)this.supplier, this.throwable);
        Assert.assertEquals((long)1L, (long)this.logger2.list.size());
        Assert.assertTrue((boolean)this.supplier.invoked);
        LogEvent event = this.logger2.list.get(0);
        Assert.assertEquals((Object)Level.TRACE, (Object)event.level);
        Assert.assertSame((Object)this.marker, (Object)event.marker);
        Assert.assertSame((Object)"Hi", (Object)event.message.getFormattedMessage());
        Assert.assertSame((Object)this.throwable, (Object)event.throwable);
    }

    @Test
    public void testTraceSupplierThrowable() {
        this.logger2.disable().trace((Supplier)this.supplier, this.throwable);
        Assert.assertTrue((boolean)this.logger2.list.isEmpty());
        Assert.assertFalse((boolean)this.supplier.invoked);
        this.logger2.enable().trace((Supplier)this.supplier, this.throwable);
        Assert.assertEquals((long)1L, (long)this.logger2.list.size());
        Assert.assertTrue((boolean)this.supplier.invoked);
        LogEvent event = this.logger2.list.get(0);
        Assert.assertEquals((Object)Level.TRACE, (Object)event.level);
        Assert.assertSame((Object)"Hi", (Object)event.message.getFormattedMessage());
        Assert.assertSame((Object)this.throwable, (Object)event.throwable);
    }

    @Test
    public void testTraceStringParamSupplier() {
        this.logger2.disable().trace("abc {}", this.supplierArray1);
        Assert.assertTrue((boolean)this.logger2.list.isEmpty());
        Assert.assertFalse((boolean)this.supplier.invoked);
        this.logger2.enable().trace("abc {}", this.supplierArray1);
        Assert.assertEquals((long)1L, (long)this.logger2.list.size());
        Assert.assertTrue((boolean)this.supplier.invoked);
        LogEvent event = this.logger2.list.get(0);
        Assert.assertEquals((Object)Level.TRACE, (Object)event.level);
        Assert.assertEquals((Object)"abc Hi", (Object)event.message.getFormattedMessage());
    }

    @Test
    public void testTraceMarkerStringParamSupplier() {
        this.logger2.disable().trace(this.marker, "abc {}", this.supplierArray1);
        Assert.assertTrue((boolean)this.logger2.list.isEmpty());
        Assert.assertFalse((boolean)this.supplier.invoked);
        this.logger2.enable().trace(this.marker, "abc {}", this.supplierArray1);
        Assert.assertEquals((long)1L, (long)this.logger2.list.size());
        Assert.assertTrue((boolean)this.supplier.invoked);
        LogEvent event = this.logger2.list.get(0);
        Assert.assertEquals((Object)Level.TRACE, (Object)event.level);
        Assert.assertSame((Object)this.marker, (Object)event.marker);
        Assert.assertEquals((Object)"abc Hi", (Object)event.message.getFormattedMessage());
    }

    @Test
    public void testWarnMarkerMessageSupplier() {
        this.logger2.disable().warn(this.marker, (Supplier)this.messageSupplier);
        Assert.assertTrue((boolean)this.logger2.list.isEmpty());
        Assert.assertFalse((boolean)this.messageSupplier.invoked);
        this.logger2.enable().warn(this.marker, (Supplier)this.messageSupplier);
        Assert.assertEquals((long)1L, (long)this.logger2.list.size());
        Assert.assertTrue((boolean)this.messageSupplier.invoked);
        LogEvent event = this.logger2.list.get(0);
        Assert.assertEquals((Object)Level.WARN, (Object)event.level);
        Assert.assertSame((Object)this.message, (Object)event.message);
        Assert.assertSame((Object)this.marker, (Object)event.marker);
    }

    @Test
    public void testWarnMessageSupplier() {
        this.logger2.disable().warn((Supplier)this.messageSupplier);
        Assert.assertTrue((boolean)this.logger2.list.isEmpty());
        Assert.assertFalse((boolean)this.messageSupplier.invoked);
        this.logger2.enable().warn((Supplier)this.messageSupplier);
        Assert.assertEquals((long)1L, (long)this.logger2.list.size());
        Assert.assertTrue((boolean)this.messageSupplier.invoked);
        LogEvent event = this.logger2.list.get(0);
        Assert.assertEquals((Object)Level.WARN, (Object)event.level);
        Assert.assertSame((Object)this.message, (Object)event.message);
    }

    @Test
    public void testWarnMarkerMessageSupplierThrowable() {
        this.logger2.disable().warn(this.marker, (Supplier)this.messageSupplier, this.throwable);
        Assert.assertTrue((boolean)this.logger2.list.isEmpty());
        Assert.assertFalse((boolean)this.messageSupplier.invoked);
        this.logger2.enable().warn(this.marker, (Supplier)this.messageSupplier, this.throwable);
        Assert.assertEquals((long)1L, (long)this.logger2.list.size());
        Assert.assertTrue((boolean)this.messageSupplier.invoked);
        LogEvent event = this.logger2.list.get(0);
        Assert.assertEquals((Object)Level.WARN, (Object)event.level);
        Assert.assertSame((Object)this.marker, (Object)event.marker);
        Assert.assertSame((Object)this.message, (Object)event.message);
        Assert.assertSame((Object)this.throwable, (Object)event.throwable);
    }

    @Test
    public void testWarnMessageSupplierThrowable() {
        this.logger2.disable().warn((Supplier)this.messageSupplier, this.throwable);
        Assert.assertTrue((boolean)this.logger2.list.isEmpty());
        Assert.assertFalse((boolean)this.messageSupplier.invoked);
        this.logger2.enable().warn((Supplier)this.messageSupplier, this.throwable);
        Assert.assertEquals((long)1L, (long)this.logger2.list.size());
        Assert.assertTrue((boolean)this.messageSupplier.invoked);
        LogEvent event = this.logger2.list.get(0);
        Assert.assertEquals((Object)Level.WARN, (Object)event.level);
        Assert.assertSame((Object)this.message, (Object)event.message);
        Assert.assertSame((Object)this.throwable, (Object)event.throwable);
    }

    @Test
    public void testWarnMarkerSupplier() {
        this.logger2.disable().warn(this.marker, (Supplier)this.supplier);
        Assert.assertTrue((boolean)this.logger2.list.isEmpty());
        Assert.assertFalse((boolean)this.supplier.invoked);
        this.logger2.enable().warn(this.marker, (Supplier)this.supplier);
        Assert.assertEquals((long)1L, (long)this.logger2.list.size());
        Assert.assertTrue((boolean)this.supplier.invoked);
        LogEvent event = this.logger2.list.get(0);
        Assert.assertEquals((Object)Level.WARN, (Object)event.level);
        Assert.assertSame((Object)"Hi", (Object)event.message.getFormattedMessage());
        Assert.assertSame((Object)this.marker, (Object)event.marker);
    }

    @Test
    public void testWarnSupplier() {
        this.logger2.disable().warn((Supplier)this.supplier);
        Assert.assertTrue((boolean)this.logger2.list.isEmpty());
        Assert.assertFalse((boolean)this.supplier.invoked);
        this.logger2.enable().warn((Supplier)this.supplier);
        Assert.assertEquals((long)1L, (long)this.logger2.list.size());
        Assert.assertTrue((boolean)this.supplier.invoked);
        LogEvent event = this.logger2.list.get(0);
        Assert.assertEquals((Object)Level.WARN, (Object)event.level);
        Assert.assertSame((Object)"Hi", (Object)event.message.getFormattedMessage());
    }

    @Test
    public void testWarnMarkerSupplierThrowable() {
        this.logger2.disable().warn(this.marker, (Supplier)this.supplier, this.throwable);
        Assert.assertTrue((boolean)this.logger2.list.isEmpty());
        Assert.assertFalse((boolean)this.supplier.invoked);
        this.logger2.enable().warn(this.marker, (Supplier)this.supplier, this.throwable);
        Assert.assertEquals((long)1L, (long)this.logger2.list.size());
        Assert.assertTrue((boolean)this.supplier.invoked);
        LogEvent event = this.logger2.list.get(0);
        Assert.assertEquals((Object)Level.WARN, (Object)event.level);
        Assert.assertSame((Object)this.marker, (Object)event.marker);
        Assert.assertSame((Object)"Hi", (Object)event.message.getFormattedMessage());
        Assert.assertSame((Object)this.throwable, (Object)event.throwable);
    }

    @Test
    public void testWarnSupplierThrowable() {
        this.logger2.disable().warn((Supplier)this.supplier, this.throwable);
        Assert.assertTrue((boolean)this.logger2.list.isEmpty());
        Assert.assertFalse((boolean)this.supplier.invoked);
        this.logger2.enable().warn((Supplier)this.supplier, this.throwable);
        Assert.assertEquals((long)1L, (long)this.logger2.list.size());
        Assert.assertTrue((boolean)this.supplier.invoked);
        LogEvent event = this.logger2.list.get(0);
        Assert.assertEquals((Object)Level.WARN, (Object)event.level);
        Assert.assertSame((Object)"Hi", (Object)event.message.getFormattedMessage());
        Assert.assertSame((Object)this.throwable, (Object)event.throwable);
    }

    @Test
    public void testWarnStringParamSupplier() {
        this.logger2.disable().warn("abc {}", this.supplierArray1);
        Assert.assertTrue((boolean)this.logger2.list.isEmpty());
        Assert.assertFalse((boolean)this.supplier.invoked);
        this.logger2.enable().warn("abc {}", this.supplierArray1);
        Assert.assertEquals((long)1L, (long)this.logger2.list.size());
        Assert.assertTrue((boolean)this.supplier.invoked);
        LogEvent event = this.logger2.list.get(0);
        Assert.assertEquals((Object)Level.WARN, (Object)event.level);
        Assert.assertEquals((Object)"abc Hi", (Object)event.message.getFormattedMessage());
    }

    @Test
    public void testWarnMarkerStringParamSupplier() {
        this.logger2.disable().warn(this.marker, "abc {}", this.supplierArray1);
        Assert.assertTrue((boolean)this.logger2.list.isEmpty());
        Assert.assertFalse((boolean)this.supplier.invoked);
        this.logger2.enable().warn(this.marker, "abc {}", this.supplierArray1);
        Assert.assertEquals((long)1L, (long)this.logger2.list.size());
        Assert.assertTrue((boolean)this.supplier.invoked);
        LogEvent event = this.logger2.list.get(0);
        Assert.assertEquals((Object)Level.WARN, (Object)event.level);
        Assert.assertSame((Object)this.marker, (Object)event.marker);
        Assert.assertEquals((Object)"abc Hi", (Object)event.message.getFormattedMessage());
    }

    @Test
    public void testLogMarkerMessageSupplier() {
        this.logger2.disable().log(Level.WARN, this.marker, (Supplier)this.messageSupplier);
        Assert.assertTrue((boolean)this.logger2.list.isEmpty());
        Assert.assertFalse((boolean)this.messageSupplier.invoked);
        this.logger2.enable().log(Level.WARN, this.marker, (Supplier)this.messageSupplier);
        Assert.assertEquals((long)1L, (long)this.logger2.list.size());
        Assert.assertTrue((boolean)this.messageSupplier.invoked);
        LogEvent event = this.logger2.list.get(0);
        Assert.assertEquals((Object)Level.WARN, (Object)event.level);
        Assert.assertSame((Object)this.message, (Object)event.message);
        Assert.assertSame((Object)this.marker, (Object)event.marker);
    }

    @Test
    public void testLogMessageSupplier() {
        this.logger2.disable().log(Level.WARN, (Supplier)this.messageSupplier);
        Assert.assertTrue((boolean)this.logger2.list.isEmpty());
        Assert.assertFalse((boolean)this.messageSupplier.invoked);
        this.logger2.enable().log(Level.WARN, (Supplier)this.messageSupplier);
        Assert.assertEquals((long)1L, (long)this.logger2.list.size());
        Assert.assertTrue((boolean)this.messageSupplier.invoked);
        LogEvent event = this.logger2.list.get(0);
        Assert.assertEquals((Object)Level.WARN, (Object)event.level);
        Assert.assertSame((Object)this.message, (Object)event.message);
    }

    @Test
    public void testLogMarkerMessageSupplierThrowable() {
        this.logger2.disable().log(Level.WARN, this.marker, (Supplier)this.messageSupplier, this.throwable);
        Assert.assertTrue((boolean)this.logger2.list.isEmpty());
        Assert.assertFalse((boolean)this.messageSupplier.invoked);
        this.logger2.enable().log(Level.WARN, this.marker, (Supplier)this.messageSupplier, this.throwable);
        Assert.assertEquals((long)1L, (long)this.logger2.list.size());
        Assert.assertTrue((boolean)this.messageSupplier.invoked);
        LogEvent event = this.logger2.list.get(0);
        Assert.assertEquals((Object)Level.WARN, (Object)event.level);
        Assert.assertSame((Object)this.marker, (Object)event.marker);
        Assert.assertSame((Object)this.message, (Object)event.message);
        Assert.assertSame((Object)this.throwable, (Object)event.throwable);
    }

    @Test
    public void testLogMessageSupplierThrowable() {
        this.logger2.disable().log(Level.WARN, (Supplier)this.messageSupplier, this.throwable);
        Assert.assertTrue((boolean)this.logger2.list.isEmpty());
        Assert.assertFalse((boolean)this.messageSupplier.invoked);
        this.logger2.enable().log(Level.WARN, (Supplier)this.messageSupplier, this.throwable);
        Assert.assertEquals((long)1L, (long)this.logger2.list.size());
        Assert.assertTrue((boolean)this.messageSupplier.invoked);
        LogEvent event = this.logger2.list.get(0);
        Assert.assertEquals((Object)Level.WARN, (Object)event.level);
        Assert.assertSame((Object)this.message, (Object)event.message);
        Assert.assertSame((Object)this.throwable, (Object)event.throwable);
    }

    @Test
    public void testLogMarkerSupplier() {
        this.logger2.disable().log(Level.WARN, this.marker, (Supplier)this.supplier);
        Assert.assertTrue((boolean)this.logger2.list.isEmpty());
        Assert.assertFalse((boolean)this.supplier.invoked);
        this.logger2.enable().log(Level.WARN, this.marker, (Supplier)this.supplier);
        Assert.assertEquals((long)1L, (long)this.logger2.list.size());
        Assert.assertTrue((boolean)this.supplier.invoked);
        LogEvent event = this.logger2.list.get(0);
        Assert.assertEquals((Object)Level.WARN, (Object)event.level);
        Assert.assertSame((Object)"Hi", (Object)event.message.getFormattedMessage());
        Assert.assertSame((Object)this.marker, (Object)event.marker);
    }

    @Test
    public void testLogSupplier() {
        this.logger2.disable().log(Level.WARN, (Supplier)this.supplier);
        Assert.assertTrue((boolean)this.logger2.list.isEmpty());
        Assert.assertFalse((boolean)this.supplier.invoked);
        this.logger2.enable().log(Level.WARN, (Supplier)this.supplier);
        Assert.assertEquals((long)1L, (long)this.logger2.list.size());
        Assert.assertTrue((boolean)this.supplier.invoked);
        LogEvent event = this.logger2.list.get(0);
        Assert.assertEquals((Object)Level.WARN, (Object)event.level);
        Assert.assertSame((Object)"Hi", (Object)event.message.getFormattedMessage());
    }

    @Test
    public void testLogMarkerSupplierThrowable() {
        this.logger2.disable().log(Level.WARN, this.marker, (Supplier)this.supplier, this.throwable);
        Assert.assertTrue((boolean)this.logger2.list.isEmpty());
        Assert.assertFalse((boolean)this.supplier.invoked);
        this.logger2.enable().log(Level.WARN, this.marker, (Supplier)this.supplier, this.throwable);
        Assert.assertEquals((long)1L, (long)this.logger2.list.size());
        Assert.assertTrue((boolean)this.supplier.invoked);
        LogEvent event = this.logger2.list.get(0);
        Assert.assertEquals((Object)Level.WARN, (Object)event.level);
        Assert.assertSame((Object)this.marker, (Object)event.marker);
        Assert.assertSame((Object)"Hi", (Object)event.message.getFormattedMessage());
        Assert.assertSame((Object)this.throwable, (Object)event.throwable);
    }

    @Test
    public void testLogSupplierThrowable() {
        this.logger2.disable().log(Level.WARN, (Supplier)this.supplier, this.throwable);
        Assert.assertTrue((boolean)this.logger2.list.isEmpty());
        Assert.assertFalse((boolean)this.supplier.invoked);
        this.logger2.enable().log(Level.WARN, (Supplier)this.supplier, this.throwable);
        Assert.assertEquals((long)1L, (long)this.logger2.list.size());
        Assert.assertTrue((boolean)this.supplier.invoked);
        LogEvent event = this.logger2.list.get(0);
        Assert.assertEquals((Object)Level.WARN, (Object)event.level);
        Assert.assertSame((Object)"Hi", (Object)event.message.getFormattedMessage());
        Assert.assertSame((Object)this.throwable, (Object)event.throwable);
    }

    @Test
    public void testLogStringParamSupplier() {
        this.logger2.disable().log(Level.WARN, "abc {}", this.supplierArray1);
        Assert.assertTrue((boolean)this.logger2.list.isEmpty());
        Assert.assertFalse((boolean)this.supplier.invoked);
        this.logger2.enable().log(Level.WARN, "abc {}", this.supplierArray1);
        Assert.assertEquals((long)1L, (long)this.logger2.list.size());
        Assert.assertTrue((boolean)this.supplier.invoked);
        LogEvent event = this.logger2.list.get(0);
        Assert.assertEquals((Object)Level.WARN, (Object)event.level);
        Assert.assertEquals((Object)"abc Hi", (Object)event.message.getFormattedMessage());
    }

    @Test
    public void testLogMarkerStringParamSupplier() {
        this.logger2.disable().log(Level.WARN, this.marker, "abc {}", this.supplierArray1);
        Assert.assertTrue((boolean)this.logger2.list.isEmpty());
        Assert.assertFalse((boolean)this.supplier.invoked);
        this.logger2.enable().log(Level.WARN, this.marker, "abc {}", this.supplierArray1);
        Assert.assertEquals((long)1L, (long)this.logger2.list.size());
        Assert.assertTrue((boolean)this.supplier.invoked);
        LogEvent event = this.logger2.list.get(0);
        Assert.assertEquals((Object)Level.WARN, (Object)event.level);
        Assert.assertSame((Object)this.marker, (Object)event.marker);
        Assert.assertEquals((Object)"abc Hi", (Object)event.message.getFormattedMessage());
    }

    private class MySupplier
    implements Supplier<String> {
        public boolean invoked = false;

        private MySupplier() {
        }

        public String get() {
            this.invoked = true;
            return "Hi";
        }
    }

    private class MyMessageSupplier
    implements Supplier<Message> {
        public boolean invoked = false;

        private MyMessageSupplier() {
        }

        public Message get() {
            this.invoked = true;
            return LambdaLoggerTest.this.message;
        }
    }

    private static class Logger2Impl
    extends AbstractLogger {
        private static final long serialVersionUID = 1L;
        boolean enabled = true;
        final List<LogEvent> list = new ArrayList<LogEvent>();

        private Logger2Impl() {
        }

        public boolean isEnabled(Level level, Marker marker, Message message, Throwable t) {
            return this.enabled;
        }

        public boolean isEnabled(Level level, Marker marker, CharSequence message, Throwable t) {
            return this.enabled;
        }

        public boolean isEnabled(Level level, Marker marker, Object message, Throwable t) {
            return this.enabled;
        }

        public boolean isEnabled(Level level, Marker marker, String message, Throwable t) {
            return this.enabled;
        }

        public boolean isEnabled(Level level, Marker marker, String message) {
            return this.enabled;
        }

        public boolean isEnabled(Level level, Marker marker, String message, Object ... params) {
            return this.enabled;
        }

        public boolean isEnabled(Level level, Marker marker, String message, Object p0) {
            return this.enabled;
        }

        public boolean isEnabled(Level level, Marker marker, String message, Object p0, Object p1) {
            return this.enabled;
        }

        public boolean isEnabled(Level level, Marker marker, String message, Object p0, Object p1, Object p2) {
            return this.enabled;
        }

        public boolean isEnabled(Level level, Marker marker, String message, Object p0, Object p1, Object p2, Object p3) {
            return this.enabled;
        }

        public boolean isEnabled(Level level, Marker marker, String message, Object p0, Object p1, Object p2, Object p3, Object p4) {
            return this.enabled;
        }

        public boolean isEnabled(Level level, Marker marker, String message, Object p0, Object p1, Object p2, Object p3, Object p4, Object p5) {
            return this.enabled;
        }

        public boolean isEnabled(Level level, Marker marker, String message, Object p0, Object p1, Object p2, Object p3, Object p4, Object p5, Object p6) {
            return this.enabled;
        }

        public boolean isEnabled(Level level, Marker marker, String message, Object p0, Object p1, Object p2, Object p3, Object p4, Object p5, Object p6, Object p7) {
            return this.enabled;
        }

        public boolean isEnabled(Level level, Marker marker, String message, Object p0, Object p1, Object p2, Object p3, Object p4, Object p5, Object p6, Object p7, Object p8) {
            return this.enabled;
        }

        public boolean isEnabled(Level level, Marker marker, String message, Object p0, Object p1, Object p2, Object p3, Object p4, Object p5, Object p6, Object p7, Object p8, Object p9) {
            return this.enabled;
        }

        public void logMessage(String fqcn, Level level, Marker marker, Message message, Throwable t) {
            this.list.add(new LogEvent(fqcn, level, marker, message, t));
        }

        public Level getLevel() {
            return null;
        }

        public AbstractLogger disable() {
            this.enabled = false;
            return this;
        }

        public AbstractLogger enable() {
            this.enabled = true;
            return this;
        }
    }

    private static class LogEvent {
        final String fqcn;
        final Level level;
        final Marker marker;
        final Message message;
        final Throwable throwable;

        public LogEvent(String fqcn, Level level, Marker marker, Message message, Throwable t) {
            this.fqcn = fqcn;
            this.level = level;
            this.marker = marker;
            this.message = message;
            this.throwable = t;
        }
    }
}

