/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.message;

import java.io.Serializable;
import java.math.BigDecimal;
import org.apache.logging.log4j.junit.Mutable;
import org.apache.logging.log4j.junit.SerialUtil;
import org.apache.logging.log4j.message.ObjectMessage;
import org.junit.Assert;
import org.junit.Test;

public class ObjectMessageTest {
    @Test
    public void testNull() {
        ObjectMessage msg = new ObjectMessage(null);
        String result = msg.getFormattedMessage();
        Assert.assertEquals((Object)"null", (Object)result);
    }

    @Test
    public void testNotNull() {
        String testMsg = "Test message {}";
        ObjectMessage msg = new ObjectMessage((Object)"Test message {}");
        String result = msg.getFormattedMessage();
        Assert.assertEquals((Object)"Test message {}", (Object)result);
    }

    @Test
    public void testUnsafeWithMutableParams() {
        Mutable param = new Mutable().set("abc");
        ObjectMessage msg = new ObjectMessage((Object)param);
        param.set("XYZ");
        String actual = msg.getFormattedMessage();
        Assert.assertEquals((String)"Expected most recent param value", (Object)"XYZ", (Object)actual);
    }

    @Test
    public void testSafeAfterGetFormattedMessageIsCalled() {
        Mutable param = new Mutable().set("abc");
        ObjectMessage msg = new ObjectMessage((Object)param);
        msg.getFormattedMessage();
        param.set("XYZ");
        String actual = msg.getFormattedMessage();
        Assert.assertEquals((String)"Should use initial param value", (Object)"abc", (Object)actual);
    }

    @Test
    public void testSerializeWithSerializableParam() {
        BigDecimal big = BigDecimal.valueOf(123.456);
        ObjectMessage msg = new ObjectMessage((Object)big);
        ObjectMessage other = (ObjectMessage)SerialUtil.deserialize(SerialUtil.serialize((Serializable)msg));
        Assert.assertEquals((Object)msg, (Object)other);
    }

    @Test
    public void testDeserializeNonSerializableParamEqualIfToStringSame() {
        class NonSerializable {
            NonSerializable() {
            }

            public boolean equals(Object other) {
                return other instanceof NonSerializable;
            }
        }
        NonSerializable nonSerializable = new NonSerializable();
        Assert.assertFalse((boolean)(nonSerializable instanceof Serializable));
        ObjectMessage msg = new ObjectMessage((Object)nonSerializable);
        ObjectMessage other = (ObjectMessage)SerialUtil.deserialize(SerialUtil.serialize((Serializable)msg));
        Assert.assertEquals((Object)msg, (Object)other);
        Assert.assertEquals((Object)other, (Object)msg);
    }

    @Test
    public void formatTo_usesCachedMessageString() throws Exception {
        StringBuilder charSequence = new StringBuilder("initial value");
        ObjectMessage message = new ObjectMessage((Object)charSequence);
        Assert.assertEquals((Object)"initial value", (Object)message.getFormattedMessage());
        charSequence.setLength(0);
        charSequence.append("different value");
        StringBuilder result = new StringBuilder();
        message.formatTo(result);
        Assert.assertEquals((Object)"initial value", (Object)result.toString());
    }
}

