/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.message;

import java.io.Serializable;
import java.util.ArrayList;
import org.apache.logging.log4j.message.ParameterFormatter;
import org.junit.Assert;
import org.junit.Test;

public class ParameterFormatterTest {
    @Test
    public void testCountArgumentPlaceholders() throws Exception {
        Assert.assertEquals((long)0L, (long)ParameterFormatter.countArgumentPlaceholders((String)""));
        Assert.assertEquals((long)0L, (long)ParameterFormatter.countArgumentPlaceholders((String)"aaa"));
        Assert.assertEquals((long)0L, (long)ParameterFormatter.countArgumentPlaceholders((String)"\\{}"));
        Assert.assertEquals((long)1L, (long)ParameterFormatter.countArgumentPlaceholders((String)"{}"));
        Assert.assertEquals((long)1L, (long)ParameterFormatter.countArgumentPlaceholders((String)"{}\\{}"));
        Assert.assertEquals((long)2L, (long)ParameterFormatter.countArgumentPlaceholders((String)"{}{}"));
        Assert.assertEquals((long)3L, (long)ParameterFormatter.countArgumentPlaceholders((String)"{}{}{}"));
        Assert.assertEquals((long)4L, (long)ParameterFormatter.countArgumentPlaceholders((String)"{}{}{}aa{}"));
        Assert.assertEquals((long)4L, (long)ParameterFormatter.countArgumentPlaceholders((String)"{}{}{}a{]b{}"));
        Assert.assertEquals((long)5L, (long)ParameterFormatter.countArgumentPlaceholders((String)"{}{}{}a{}b{}"));
    }

    @Test
    public void testFormat3StringArgs() {
        String testMsg = "Test message {}{} {}";
        Object[] args = new String[]{"a", "b", "c"};
        String result = ParameterFormatter.format((String)"Test message {}{} {}", (Object[])args);
        Assert.assertEquals((Object)"Test message ab c", (Object)result);
    }

    @Test
    public void testFormatNullArgs() {
        String testMsg = "Test message {} {} {} {} {} {}";
        Object[] args = new String[]{"a", null, "c", null, null, null};
        String result = ParameterFormatter.format((String)"Test message {} {} {} {} {} {}", (Object[])args);
        Assert.assertEquals((Object)"Test message a null c null null null", (Object)result);
    }

    @Test
    public void testFormatStringArgsIgnoresSuperfluousArgs() {
        String testMsg = "Test message {}{} {}";
        Object[] args = new String[]{"a", "b", "c", "unnecessary", "superfluous"};
        String result = ParameterFormatter.format((String)"Test message {}{} {}", (Object[])args);
        Assert.assertEquals((Object)"Test message ab c", (Object)result);
    }

    @Test
    public void testFormatStringArgsWithEscape() {
        String testMsg = "Test message \\{}{} {}";
        Object[] args = new String[]{"a", "b", "c"};
        String result = ParameterFormatter.format((String)"Test message \\{}{} {}", (Object[])args);
        Assert.assertEquals((Object)"Test message {}a b", (Object)result);
    }

    @Test
    public void testFormatStringArgsWithTrailingEscape() {
        String testMsg = "Test message {}{} {}\\";
        Object[] args = new String[]{"a", "b", "c"};
        String result = ParameterFormatter.format((String)"Test message {}{} {}\\", (Object[])args);
        Assert.assertEquals((Object)"Test message ab c\\", (Object)result);
    }

    @Test
    public void testFormatStringArgsWithTrailingEscapedEscape() {
        String testMsg = "Test message {}{} {}\\\\";
        Object[] args = new String[]{"a", "b", "c"};
        String result = ParameterFormatter.format((String)"Test message {}{} {}\\\\", (Object[])args);
        Assert.assertEquals((Object)"Test message ab c\\\\", (Object)result);
    }

    @Test
    public void testFormatStringArgsWithEscapedEscape() {
        String testMsg = "Test message \\\\{}{} {}";
        Object[] args = new String[]{"a", "b", "c"};
        String result = ParameterFormatter.format((String)"Test message \\\\{}{} {}", (Object[])args);
        Assert.assertEquals((Object)"Test message \\ab c", (Object)result);
    }

    @Test
    public void testFormatMessage3StringArgs() {
        String testMsg = "Test message {}{} {}";
        Object[] args = new String[]{"a", "b", "c"};
        StringBuilder sb = new StringBuilder();
        ParameterFormatter.formatMessage((StringBuilder)sb, (String)"Test message {}{} {}", (Object[])args, (int)3);
        String result = sb.toString();
        Assert.assertEquals((Object)"Test message ab c", (Object)result);
    }

    @Test
    public void testFormatMessageNullArgs() {
        String testMsg = "Test message {} {} {} {} {} {}";
        Object[] args = new String[]{"a", null, "c", null, null, null};
        StringBuilder sb = new StringBuilder();
        ParameterFormatter.formatMessage((StringBuilder)sb, (String)"Test message {} {} {} {} {} {}", (Object[])args, (int)6);
        String result = sb.toString();
        Assert.assertEquals((Object)"Test message a null c null null null", (Object)result);
    }

    @Test
    public void testFormatMessageStringArgsIgnoresSuperfluousArgs() {
        String testMsg = "Test message {}{} {}";
        Object[] args = new String[]{"a", "b", "c", "unnecessary", "superfluous"};
        StringBuilder sb = new StringBuilder();
        ParameterFormatter.formatMessage((StringBuilder)sb, (String)"Test message {}{} {}", (Object[])args, (int)5);
        String result = sb.toString();
        Assert.assertEquals((Object)"Test message ab c", (Object)result);
    }

    @Test
    public void testFormatMessageStringArgsWithEscape() {
        String testMsg = "Test message \\{}{} {}";
        Object[] args = new String[]{"a", "b", "c"};
        StringBuilder sb = new StringBuilder();
        ParameterFormatter.formatMessage((StringBuilder)sb, (String)"Test message \\{}{} {}", (Object[])args, (int)3);
        String result = sb.toString();
        Assert.assertEquals((Object)"Test message {}a b", (Object)result);
    }

    @Test
    public void testFormatMessageStringArgsWithTrailingEscape() {
        String testMsg = "Test message {}{} {}\\";
        Object[] args = new String[]{"a", "b", "c"};
        StringBuilder sb = new StringBuilder();
        ParameterFormatter.formatMessage((StringBuilder)sb, (String)"Test message {}{} {}\\", (Object[])args, (int)3);
        String result = sb.toString();
        Assert.assertEquals((Object)"Test message ab c\\", (Object)result);
    }

    @Test
    public void testFormatMessageStringArgsWithTrailingEscapedEscape() {
        String testMsg = "Test message {}{} {}\\\\";
        Object[] args = new String[]{"a", "b", "c"};
        StringBuilder sb = new StringBuilder();
        ParameterFormatter.formatMessage((StringBuilder)sb, (String)"Test message {}{} {}\\\\", (Object[])args, (int)3);
        String result = sb.toString();
        Assert.assertEquals((Object)"Test message ab c\\\\", (Object)result);
    }

    @Test
    public void testFormatMessageStringArgsWithEscapedEscape() {
        String testMsg = "Test message \\\\{}{} {}";
        Object[] args = new String[]{"a", "b", "c"};
        StringBuilder sb = new StringBuilder();
        ParameterFormatter.formatMessage((StringBuilder)sb, (String)"Test message \\\\{}{} {}", (Object[])args, (int)3);
        String result = sb.toString();
        Assert.assertEquals((Object)"Test message \\ab c", (Object)result);
    }

    @Test
    public void testDeepToString() throws Exception {
        ArrayList<Serializable> list = new ArrayList<Serializable>();
        list.add(Integer.valueOf(1));
        list.add(list);
        list.add(Integer.valueOf(2));
        String actual = ParameterFormatter.deepToString(list);
        String expected = "[1, [..." + ParameterFormatter.identityToString(list) + "...], 2]";
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testIdentityToString() throws Exception {
        ArrayList<Serializable> list = new ArrayList<Serializable>();
        list.add(Integer.valueOf(1));
        list.add(list);
        list.add(Integer.valueOf(2));
        String actual = ParameterFormatter.identityToString(list);
        String expected = list.getClass().getName() + "@" + Integer.toHexString(System.identityHashCode(list));
        Assert.assertEquals((Object)expected, (Object)actual);
    }
}

