/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.message;

import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.message.ReusableMessageFactory;
import org.apache.logging.log4j.message.ReusableParameterizedMessage;
import org.junit.Assert;
import org.junit.Test;

public class ReusableMessageFactoryTest {
    @Test
    public void testCreateEventReturnsDifferentInstanceIfNotReleased() throws Exception {
        ReusableMessageFactory factory = new ReusableMessageFactory();
        Message message1 = factory.newMessage("text, p0={} p1={} p2={} p3={}", (Object)1, (Object)2, (Object)3, (Object)4);
        Message message2 = factory.newMessage("text, p0={} p1={} p2={} p3={}", (Object)9, (Object)8, (Object)7, (Object)6);
        Assert.assertNotSame((Object)message1, (Object)message2);
        ReusableMessageFactory.release((Message)message1);
        ReusableMessageFactory.release((Message)message2);
    }

    @Test
    public void testCreateEventReturnsSameInstance() throws Exception {
        ReusableMessageFactory factory = new ReusableMessageFactory();
        Message message1 = factory.newMessage("text, p0={} p1={} p2={} p3={}", (Object)1, (Object)2, (Object)3, (Object)4);
        ReusableMessageFactory.release((Message)message1);
        Message message2 = factory.newMessage("text, p0={} p1={} p2={} p3={}", (Object)9, (Object)8, (Object)7, (Object)6);
        Assert.assertSame((Object)message1, (Object)message2);
        ReusableMessageFactory.release((Message)message2);
        Message message3 = factory.newMessage("text, AAA={} BBB={} p2={} p3={}", (Object)9, (Object)8, (Object)7, (Object)6);
        Assert.assertSame((Object)message2, (Object)message3);
        ReusableMessageFactory.release((Message)message3);
    }

    private void assertReusableParameterizeMessage(Message message, String txt, Object[] params) {
        Assert.assertTrue((boolean)(message instanceof ReusableParameterizedMessage));
        ReusableParameterizedMessage msg = (ReusableParameterizedMessage)message;
        Assert.assertTrue((String)"reserved", (boolean)msg.reserved);
        Assert.assertEquals((Object)txt, (Object)msg.getFormat());
        Assert.assertEquals((String)"count", (long)msg.getParameterCount(), (long)params.length);
        Object[] messageParams = msg.getParameters();
        for (int i = 0; i < params.length; ++i) {
            Assert.assertEquals((Object)messageParams[i], (Object)params[i]);
        }
    }

    @Test
    public void testCreateEventOverwritesFields() throws Exception {
        ReusableMessageFactory factory = new ReusableMessageFactory();
        Message message1 = factory.newMessage("text, p0={} p1={} p2={} p3={}", (Object)1, (Object)2, (Object)3, (Object)4);
        this.assertReusableParameterizeMessage(message1, "text, p0={} p1={} p2={} p3={}", new Object[]{new Integer(1), new Integer(2), new Integer(3), new Integer(4)});
        ReusableMessageFactory.release((Message)message1);
        Message message2 = factory.newMessage("other, A={} B={} C={} D={}", (Object)1, (Object)2, (Object)3, (Object)4);
        this.assertReusableParameterizeMessage(message1, "other, A={} B={} C={} D={}", new Object[]{new Integer(1), new Integer(2), new Integer(3), new Integer(4)});
        Assert.assertSame((Object)message1, (Object)message2);
        ReusableMessageFactory.release((Message)message2);
    }

    @Test
    public void testCreateEventReturnsThreadLocalInstance() throws Exception {
        final ReusableMessageFactory factory = new ReusableMessageFactory();
        final Message[] message1 = new Message[1];
        final Message[] message2 = new Message[1];
        Thread t1 = new Thread("THREAD 1"){

            @Override
            public void run() {
                message1[0] = factory.newMessage("text, p0={} p1={} p2={} p3={}", (Object)1, (Object)2, (Object)3, (Object)4);
            }
        };
        Thread t2 = new Thread("Thread 2"){

            @Override
            public void run() {
                message2[0] = factory.newMessage("other, A={} B={} C={} D={}", (Object)1, (Object)2, (Object)3, (Object)4);
            }
        };
        t1.start();
        t2.start();
        t1.join();
        t2.join();
        Assert.assertNotNull((Object)message1[0]);
        Assert.assertNotNull((Object)message2[0]);
        Assert.assertNotSame((Object)message1[0], (Object)message2[0]);
        this.assertReusableParameterizeMessage(message1[0], "text, p0={} p1={} p2={} p3={}", new Object[]{new Integer(1), new Integer(2), new Integer(3), new Integer(4)});
        this.assertReusableParameterizeMessage(message2[0], "other, A={} B={} C={} D={}", new Object[]{new Integer(1), new Integer(2), new Integer(3), new Integer(4)});
        ReusableMessageFactory.release((Message)message1[0]);
        ReusableMessageFactory.release((Message)message2[0]);
    }
}

