/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.message;

import org.apache.logging.log4j.junit.Mutable;
import org.apache.logging.log4j.message.ReusableParameterizedMessage;
import org.junit.Assert;
import org.junit.Test;

public class ReusableParameterizedMessageTest {
    public static ReusableParameterizedMessage set(ReusableParameterizedMessage msg, String format, Object ... params) {
        return msg.set(format, params);
    }

    @Test
    public void testNoArgs() {
        String testMsg = "Test message {}";
        ReusableParameterizedMessage msg = new ReusableParameterizedMessage();
        msg.set("Test message {}", (Object[])null);
        String result = msg.getFormattedMessage();
        Assert.assertEquals((Object)"Test message {}", (Object)result);
        msg.set("Test message {}", null);
        result = msg.getFormattedMessage();
        Assert.assertEquals((Object)"Test message {}", (Object)result);
        msg.set("Test message {}", null, null);
        result = msg.getFormattedMessage();
        Assert.assertEquals((Object)"Test message null", (Object)result);
    }

    @Test
    public void testFormat3StringArgs() {
        String testMsg = "Test message {}{} {}";
        Object[] args = new String[]{"a", "b", "c"};
        String result = new ReusableParameterizedMessage().set("Test message {}{} {}", args).getFormattedMessage();
        Assert.assertEquals((Object)"Test message ab c", (Object)result);
    }

    @Test
    public void testFormatNullArgs() {
        String testMsg = "Test message {} {} {} {} {} {}";
        Object[] args = new String[]{"a", null, "c", null, null, null};
        String result = new ReusableParameterizedMessage().set("Test message {} {} {} {} {} {}", args).getFormattedMessage();
        Assert.assertEquals((Object)"Test message a null c null null null", (Object)result);
    }

    @Test
    public void testFormatStringArgsIgnoresSuperfluousArgs() {
        String testMsg = "Test message {}{} {}";
        Object[] args = new String[]{"a", "b", "c", "unnecessary", "superfluous"};
        String result = new ReusableParameterizedMessage().set("Test message {}{} {}", args).getFormattedMessage();
        Assert.assertEquals((Object)"Test message ab c", (Object)result);
    }

    @Test
    public void testFormatStringArgsWithEscape() {
        String testMsg = "Test message \\{}{} {}";
        Object[] args = new String[]{"a", "b", "c"};
        String result = new ReusableParameterizedMessage().set("Test message \\{}{} {}", args).getFormattedMessage();
        Assert.assertEquals((Object)"Test message {}a b", (Object)result);
    }

    @Test
    public void testFormatStringArgsWithTrailingEscape() {
        String testMsg = "Test message {}{} {}\\";
        Object[] args = new String[]{"a", "b", "c"};
        String result = new ReusableParameterizedMessage().set("Test message {}{} {}\\", args).getFormattedMessage();
        Assert.assertEquals((Object)"Test message ab c\\", (Object)result);
    }

    @Test
    public void testFormatStringArgsWithTrailingText() {
        String testMsg = "Test message {}{} {}Text";
        Object[] args = new String[]{"a", "b", "c"};
        String result = new ReusableParameterizedMessage().set("Test message {}{} {}Text", args).getFormattedMessage();
        Assert.assertEquals((Object)"Test message ab cText", (Object)result);
    }

    @Test
    public void testFormatStringArgsWithTrailingEscapedEscape() {
        String testMsg = "Test message {}{} {}\\\\";
        Object[] args = new String[]{"a", "b", "c"};
        String result = new ReusableParameterizedMessage().set("Test message {}{} {}\\\\", args).getFormattedMessage();
        Assert.assertEquals((Object)"Test message ab c\\\\", (Object)result);
    }

    @Test
    public void testFormatStringArgsWithEscapedEscape() {
        String testMsg = "Test message \\\\{}{} {}";
        Object[] args = new String[]{"a", "b", "c"};
        String result = new ReusableParameterizedMessage().set("Test message \\\\{}{} {}", args).getFormattedMessage();
        Assert.assertEquals((Object)"Test message \\ab c", (Object)result);
    }

    @Test
    public void testNotSafeWithMutableParams() {
        String testMsg = "Test message {}";
        Mutable param = new Mutable().set("abc");
        ReusableParameterizedMessage msg = new ReusableParameterizedMessage();
        msg.set("Test message {}", (Object)param);
        param.set("XYZ");
        String actual = msg.getFormattedMessage();
        Assert.assertEquals((String)"Should use current param value", (Object)"Test message XYZ", (Object)actual);
        param.set("000");
        String after = msg.getFormattedMessage();
        Assert.assertEquals((String)"Renders again", (Object)"Test message 000", (Object)after);
    }

    @Test
    public void testThrowable() {
        String testMsg = "Test message {}";
        ReusableParameterizedMessage msg = new ReusableParameterizedMessage();
        IllegalAccessError EXCEPTION1 = new IllegalAccessError("#1");
        msg.set("Test message {}", (Object)"msg", (Object)EXCEPTION1);
        Assert.assertSame((Object)EXCEPTION1, (Object)msg.getThrowable());
        UnsupportedOperationException EXCEPTION2 = new UnsupportedOperationException("#2");
        msg.set("Test message {}", (Object)"msgs", (Object)EXCEPTION2);
        Assert.assertSame((Object)EXCEPTION2, (Object)msg.getThrowable());
    }
}

