/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.message;

import org.apache.logging.log4j.message.StructuredDataMessage;
import org.junit.Assert;
import org.junit.Test;

public class StructuredDataMessageTest {
    @Test
    public void testMsg() {
        String testMsg = "Test message {}";
        StructuredDataMessage msg = new StructuredDataMessage("MsgId@12345", "Test message {}", "Alert");
        msg.put("message", "Test message {}");
        msg.put("project", "Log4j");
        msg.put("memo", "This is a very long test memo to prevent regression of LOG4J2-114");
        String result = msg.getFormattedMessage();
        String expected = "Alert [MsgId@12345 memo=\"This is a very long test memo to prevent regression of LOG4J2-114\" message=\"Test message {}\" project=\"Log4j\"] Test message {}";
        Assert.assertEquals((Object)"Alert [MsgId@12345 memo=\"This is a very long test memo to prevent regression of LOG4J2-114\" message=\"Test message {}\" project=\"Log4j\"] Test message {}", (Object)result);
    }

    @Test
    public void testBuilder() {
        String testMsg = "Test message {}";
        StructuredDataMessage msg = (StructuredDataMessage)((StructuredDataMessage)((StructuredDataMessage)new StructuredDataMessage("MsgId@12345", "Test message {}", "Alert").with("message", "Test message {}")).with("project", "Log4j")).with("memo", "This is a very long test memo to prevent regression of LOG4J2-114");
        String result = msg.getFormattedMessage();
        String expected = "Alert [MsgId@12345 memo=\"This is a very long test memo to prevent regression of LOG4J2-114\" message=\"Test message {}\" project=\"Log4j\"] Test message {}";
        Assert.assertEquals((Object)"Alert [MsgId@12345 memo=\"This is a very long test memo to prevent regression of LOG4J2-114\" message=\"Test message {}\" project=\"Log4j\"] Test message {}", (Object)result);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testMsgWithKeyTooLong() {
        String testMsg = "Test message {}";
        StructuredDataMessage msg = new StructuredDataMessage("MsgId@12345", "Test message {}", "Alert");
        msg.put("This is a very long key that will violate the key length validation", "Testing");
    }

    @Test
    public void testMutableByDesign() {
        String testMsg = "Test message {}";
        StructuredDataMessage msg = new StructuredDataMessage("MsgId@1", "Test message {}", "Alert");
        msg.put("message", "Test message {}");
        msg.put("project", "Log4j");
        String result = msg.getFormattedMessage();
        String expected = "Alert [MsgId@1 message=\"Test message {}\" project=\"Log4j\"] Test message {}";
        Assert.assertEquals((Object)"Alert [MsgId@1 message=\"Test message {}\" project=\"Log4j\"] Test message {}", (Object)result);
        msg.put("memo", "Added later");
        String result2 = msg.getFormattedMessage();
        String expected2 = "Alert [MsgId@1 memo=\"Added later\" message=\"Test message {}\" project=\"Log4j\"] Test message {}";
        Assert.assertEquals((Object)"Alert [MsgId@1 memo=\"Added later\" message=\"Test message {}\" project=\"Log4j\"] Test message {}", (Object)result2);
    }
}

