/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.util;

import org.apache.logging.log4j.util.Chars;
import org.junit.Assert;
import org.junit.Test;

public class CharsTest {
    @Test
    public void invalidDigitReturnsNullCharacter() throws Exception {
        Assert.assertEquals((long)0L, (long)Chars.getUpperCaseHex((int)-1));
        Assert.assertEquals((long)0L, (long)Chars.getUpperCaseHex((int)16));
        Assert.assertEquals((long)0L, (long)Chars.getUpperCaseHex((int)400));
        Assert.assertEquals((long)0L, (long)Chars.getLowerCaseHex((int)-1));
        Assert.assertEquals((long)0L, (long)Chars.getLowerCaseHex((int)16));
        Assert.assertEquals((long)0L, (long)Chars.getLowerCaseHex((int)400));
    }

    @Test
    public void validDigitReturnsProperCharacter() throws Exception {
        char[] expectedLower = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
        char[] expectedUpper = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
        for (int i = 0; i < 16; ++i) {
            Assert.assertEquals((String)String.format("Expected %x", i), (long)expectedLower[i], (long)Chars.getLowerCaseHex((int)i));
            Assert.assertEquals((String)String.format("Expected %X", i), (long)expectedUpper[i], (long)Chars.getUpperCaseHex((int)i));
        }
    }
}

