/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.util;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.lang.reflect.Field;
import java.net.URL;
import java.net.URLDecoder;
import java.nio.charset.Charset;
import java.util.ConcurrentModificationException;
import java.util.HashMap;
import org.apache.logging.log4j.util.BiConsumer;
import org.apache.logging.log4j.util.DeserializerHelper;
import org.apache.logging.log4j.util.ReadOnlyStringMap;
import org.apache.logging.log4j.util.SortedArrayStringMap;
import org.apache.logging.log4j.util.TriConsumer;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.Result;

public class SortedArrayStringMapTest {
    static TriConsumer<String, String, State> COUNTER = new TriConsumer<String, String, State>(){

        public void accept(String key, String value, State state) {
            Assert.assertEquals((String)"key", (Object)key, (Object)state.data.getKeyAt(state.count));
            Assert.assertEquals((String)"val", (Object)value, (Object)state.data.getValueAt(state.count));
            ++state.count;
            Assert.assertTrue((String)("count should not exceed size but was " + state.count), (state.count <= state.data.size() ? 1 : 0) != 0);
        }
    };

    @Test(expected=IllegalArgumentException.class)
    public void testConstructorDisallowsNegativeCapacity() throws Exception {
        new SortedArrayStringMap(-1);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testConstructorDisallowsZeroCapacity() throws Exception {
        new SortedArrayStringMap(0);
    }

    @Test
    public void testConstructorIgnoresNull() throws Exception {
        Assert.assertEquals((long)0L, (long)new SortedArrayStringMap((ReadOnlyStringMap)((SortedArrayStringMap)null)).size());
    }

    @Test
    public void testToString() {
        SortedArrayStringMap original = new SortedArrayStringMap();
        original.putValue("a", (Object)"avalue");
        original.putValue("B", (Object)"Bvalue");
        original.putValue("3", (Object)"3value");
        Assert.assertEquals((Object)"{3=3value, B=Bvalue, a=avalue}", (Object)original.toString());
    }

    @Test
    public void testSerialization() throws Exception {
        SortedArrayStringMap original = new SortedArrayStringMap();
        original.putValue("a", (Object)"avalue");
        original.putValue("B", (Object)"Bvalue");
        original.putValue("3", (Object)"3value");
        byte[] binary = this.serialize(original);
        SortedArrayStringMap copy = this.deserialize(binary);
        Assert.assertEquals((Object)original, (Object)copy);
    }

    @Test
    public void testSerializationOfNonSerializableValue() throws Exception {
        SortedArrayStringMap original = new SortedArrayStringMap();
        original.putValue("a", (Object)"avalue");
        original.putValue("B", (Object)"Bvalue");
        original.putValue("unserializable", new Object());
        byte[] binary = this.serialize(original);
        SortedArrayStringMap copy = this.deserialize(binary);
        SortedArrayStringMap expected = new SortedArrayStringMap();
        expected.putValue("a", (Object)"avalue");
        expected.putValue("B", (Object)"Bvalue");
        expected.putValue("unserializable", null);
        Assert.assertEquals((Object)expected, (Object)copy);
    }

    @Test
    public void testDeserializationOfUnknownClass() throws Exception {
        SortedArrayStringMap original = new SortedArrayStringMap();
        original.putValue("a", (Object)"avalue");
        original.putValue("serializableButNotInClasspathOfDeserializer", (Object)new Result());
        original.putValue("zz", (Object)"last");
        File file = new File("target/SortedArrayStringMap.ser");
        try (FileOutputStream fout = new FileOutputStream(file, false);){
            fout.write(this.serialize(original));
            fout.flush();
        }
        String classpath = this.createClassPath(SortedArrayStringMap.class, DeserializerHelper.class);
        Process process = new ProcessBuilder("java", "-cp", classpath, DeserializerHelper.class.getName(), file.getPath()).start();
        BufferedReader in = new BufferedReader(new InputStreamReader(process.getErrorStream()));
        int exitValue = process.waitFor();
        file.delete();
        if (exitValue != 0) {
            StringBuilder sb = new StringBuilder();
            sb.append("DeserializerHelper exited with error code ").append(exitValue);
            sb.append(". Classpath='").append(classpath);
            sb.append("'. Process output: ");
            int c = -1;
            while ((c = in.read()) != -1) {
                sb.append((char)c);
            }
            Assert.fail((String)sb.toString());
        }
    }

    private String createClassPath(Class<?> ... classes) throws Exception {
        StringBuilder result = new StringBuilder();
        for (Class<?> cls : classes) {
            if (result.length() > 0) {
                result.append(File.pathSeparator);
            }
            result.append(this.createClassPath(cls));
        }
        return result.toString();
    }

    private String createClassPath(Class<?> cls) throws Exception {
        String resource = "/" + cls.getName().replace('.', '/') + ".class";
        URL url = cls.getResource(resource);
        String location = url.toString();
        if (location.startsWith("jar:")) {
            location = location.substring("jar:".length(), location.indexOf(33));
        }
        if (location.startsWith("file:/")) {
            location = location.substring("file:/".length());
        }
        if (location.endsWith(resource)) {
            location = location.substring(0, location.length() - resource.length());
        }
        if (!new File(location).exists()) {
            location = File.separator + location;
        }
        return (location = URLDecoder.decode(location, Charset.defaultCharset().name())).isEmpty() ? "." : location;
    }

    private byte[] serialize(SortedArrayStringMap data) throws IOException {
        ByteArrayOutputStream arr = new ByteArrayOutputStream();
        ObjectOutputStream out = new ObjectOutputStream(arr);
        out.writeObject(data);
        return arr.toByteArray();
    }

    private SortedArrayStringMap deserialize(byte[] binary) throws IOException, ClassNotFoundException {
        ByteArrayInputStream inArr = new ByteArrayInputStream(binary);
        ObjectInputStream in = new ObjectInputStream(inArr);
        SortedArrayStringMap result = (SortedArrayStringMap)in.readObject();
        return result;
    }

    @Test
    public void testPutAll() throws Exception {
        SortedArrayStringMap original = new SortedArrayStringMap();
        original.putValue("a", (Object)"avalue");
        original.putValue("B", (Object)"Bvalue");
        original.putValue("3", (Object)"3value");
        SortedArrayStringMap other = new SortedArrayStringMap();
        other.putAll((ReadOnlyStringMap)original);
        Assert.assertEquals((Object)original, (Object)other);
        other.putValue("3", (Object)"otherValue");
        Assert.assertNotEquals((Object)original, (Object)other);
        other.putValue("3", null);
        Assert.assertNotEquals((Object)original, (Object)other);
        other.putValue("3", (Object)"3value");
        Assert.assertEquals((Object)original, (Object)other);
    }

    @Test
    public void testPutAll_overwritesSameKeys2() throws Exception {
        SortedArrayStringMap original = new SortedArrayStringMap();
        original.putValue("a", (Object)"aORIG");
        original.putValue("b", (Object)"bORIG");
        original.putValue("c", (Object)"cORIG");
        original.putValue("d", (Object)"dORIG");
        original.putValue("e", (Object)"eORIG");
        SortedArrayStringMap other = new SortedArrayStringMap();
        other.putValue("1", (Object)"11");
        other.putValue("2", (Object)"22");
        other.putValue("a", (Object)"aa");
        other.putValue("c", (Object)"cc");
        original.putAll((ReadOnlyStringMap)other);
        Assert.assertEquals((String)"size after put other", (long)7L, (long)original.size());
        Assert.assertEquals((Object)"aa", (Object)original.getValue("a"));
        Assert.assertEquals((Object)"bORIG", (Object)original.getValue("b"));
        Assert.assertEquals((Object)"cc", (Object)original.getValue("c"));
        Assert.assertEquals((Object)"dORIG", (Object)original.getValue("d"));
        Assert.assertEquals((Object)"eORIG", (Object)original.getValue("e"));
        Assert.assertEquals((Object)"11", (Object)original.getValue("1"));
        Assert.assertEquals((Object)"22", (Object)original.getValue("2"));
    }

    @Test
    public void testPutAll_nullKeyInLargeOriginal() throws Exception {
        SortedArrayStringMap original = new SortedArrayStringMap();
        original.putValue(null, (Object)"nullORIG");
        original.putValue("a", (Object)"aORIG");
        original.putValue("b", (Object)"bORIG");
        original.putValue("c", (Object)"cORIG");
        original.putValue("d", (Object)"dORIG");
        original.putValue("e", (Object)"eORIG");
        SortedArrayStringMap other = new SortedArrayStringMap();
        other.putValue("1", (Object)"11");
        other.putValue("a", (Object)"aa");
        original.putAll((ReadOnlyStringMap)other);
        Assert.assertEquals((String)"size after put other", (long)7L, (long)original.size());
        Assert.assertEquals((Object)"aa", (Object)original.getValue("a"));
        Assert.assertEquals((Object)"bORIG", (Object)original.getValue("b"));
        Assert.assertEquals((Object)"cORIG", (Object)original.getValue("c"));
        Assert.assertEquals((Object)"dORIG", (Object)original.getValue("d"));
        Assert.assertEquals((Object)"eORIG", (Object)original.getValue("e"));
        Assert.assertEquals((Object)"11", (Object)original.getValue("1"));
        Assert.assertEquals((Object)"nullORIG", (Object)original.getValue(null));
    }

    @Test
    public void testPutAll_nullKeyInSmallOriginal() throws Exception {
        SortedArrayStringMap original = new SortedArrayStringMap();
        original.putValue(null, (Object)"nullORIG");
        original.putValue("a", (Object)"aORIG");
        original.putValue("b", (Object)"bORIG");
        SortedArrayStringMap other = new SortedArrayStringMap();
        other.putValue("1", (Object)"11");
        other.putValue("2", (Object)"22");
        other.putValue("3", (Object)"33");
        other.putValue("a", (Object)"aa");
        original.putAll((ReadOnlyStringMap)other);
        Assert.assertEquals((String)"size after put other", (long)6L, (long)original.size());
        Assert.assertEquals((Object)"aa", (Object)original.getValue("a"));
        Assert.assertEquals((Object)"bORIG", (Object)original.getValue("b"));
        Assert.assertEquals((Object)"11", (Object)original.getValue("1"));
        Assert.assertEquals((Object)"22", (Object)original.getValue("2"));
        Assert.assertEquals((Object)"33", (Object)original.getValue("3"));
        Assert.assertEquals((Object)"nullORIG", (Object)original.getValue(null));
    }

    @Test
    public void testPutAll_nullKeyInSmallAdditional() throws Exception {
        SortedArrayStringMap original = new SortedArrayStringMap();
        original.putValue("a", (Object)"aORIG");
        original.putValue("b", (Object)"bORIG");
        original.putValue("c", (Object)"cORIG");
        original.putValue("d", (Object)"dORIG");
        original.putValue("e", (Object)"eORIG");
        SortedArrayStringMap other = new SortedArrayStringMap();
        other.putValue(null, (Object)"nullNEW");
        other.putValue("1", (Object)"11");
        other.putValue("a", (Object)"aa");
        original.putAll((ReadOnlyStringMap)other);
        Assert.assertEquals((String)"size after put other", (long)7L, (long)original.size());
        Assert.assertEquals((Object)"aa", (Object)original.getValue("a"));
        Assert.assertEquals((Object)"bORIG", (Object)original.getValue("b"));
        Assert.assertEquals((Object)"cORIG", (Object)original.getValue("c"));
        Assert.assertEquals((Object)"dORIG", (Object)original.getValue("d"));
        Assert.assertEquals((Object)"eORIG", (Object)original.getValue("e"));
        Assert.assertEquals((Object)"11", (Object)original.getValue("1"));
        Assert.assertEquals((Object)"nullNEW", (Object)original.getValue(null));
    }

    @Test
    public void testPutAll_nullKeyInLargeAdditional() throws Exception {
        SortedArrayStringMap original = new SortedArrayStringMap();
        original.putValue("a", (Object)"aORIG");
        original.putValue("b", (Object)"bORIG");
        SortedArrayStringMap other = new SortedArrayStringMap();
        other.putValue(null, (Object)"nullNEW");
        other.putValue("1", (Object)"11");
        other.putValue("2", (Object)"22");
        other.putValue("3", (Object)"33");
        other.putValue("a", (Object)"aa");
        original.putAll((ReadOnlyStringMap)other);
        Assert.assertEquals((String)"size after put other", (long)6L, (long)original.size());
        Assert.assertEquals((Object)"aa", (Object)original.getValue("a"));
        Assert.assertEquals((Object)"bORIG", (Object)original.getValue("b"));
        Assert.assertEquals((Object)"11", (Object)original.getValue("1"));
        Assert.assertEquals((Object)"22", (Object)original.getValue("2"));
        Assert.assertEquals((Object)"33", (Object)original.getValue("3"));
        Assert.assertEquals((Object)"nullNEW", (Object)original.getValue(null));
    }

    @Test
    public void testPutAll_nullKeyInBoth_LargeOriginal() throws Exception {
        SortedArrayStringMap original = new SortedArrayStringMap();
        original.putValue(null, (Object)"nullORIG");
        original.putValue("a", (Object)"aORIG");
        original.putValue("b", (Object)"bORIG");
        original.putValue("c", (Object)"cORIG");
        original.putValue("d", (Object)"dORIG");
        original.putValue("e", (Object)"eORIG");
        SortedArrayStringMap other = new SortedArrayStringMap();
        other.putValue(null, (Object)"nullNEW");
        other.putValue("1", (Object)"11");
        other.putValue("a", (Object)"aa");
        original.putAll((ReadOnlyStringMap)other);
        Assert.assertEquals((String)"size after put other", (long)7L, (long)original.size());
        Assert.assertEquals((Object)"aa", (Object)original.getValue("a"));
        Assert.assertEquals((Object)"bORIG", (Object)original.getValue("b"));
        Assert.assertEquals((Object)"cORIG", (Object)original.getValue("c"));
        Assert.assertEquals((Object)"dORIG", (Object)original.getValue("d"));
        Assert.assertEquals((Object)"eORIG", (Object)original.getValue("e"));
        Assert.assertEquals((Object)"11", (Object)original.getValue("1"));
        Assert.assertEquals((Object)"nullNEW", (Object)original.getValue(null));
    }

    @Test
    public void testPutAll_nullKeyInBoth_SmallOriginal() throws Exception {
        SortedArrayStringMap original = new SortedArrayStringMap();
        original.putValue(null, (Object)"nullORIG");
        original.putValue("a", (Object)"aORIG");
        original.putValue("b", (Object)"bORIG");
        SortedArrayStringMap other = new SortedArrayStringMap();
        other.putValue(null, (Object)"nullNEW");
        other.putValue("1", (Object)"11");
        other.putValue("2", (Object)"22");
        other.putValue("3", (Object)"33");
        other.putValue("a", (Object)"aa");
        original.putAll((ReadOnlyStringMap)other);
        Assert.assertEquals((String)"size after put other", (long)6L, (long)original.size());
        Assert.assertEquals((Object)"aa", (Object)original.getValue("a"));
        Assert.assertEquals((Object)"bORIG", (Object)original.getValue("b"));
        Assert.assertEquals((Object)"11", (Object)original.getValue("1"));
        Assert.assertEquals((Object)"22", (Object)original.getValue("2"));
        Assert.assertEquals((Object)"33", (Object)original.getValue("3"));
        Assert.assertEquals((Object)"nullNEW", (Object)original.getValue(null));
    }

    @Test
    public void testPutAll_overwritesSameKeys1() throws Exception {
        SortedArrayStringMap original = new SortedArrayStringMap();
        original.putValue("a", (Object)"aORIG");
        original.putValue("b", (Object)"bORIG");
        original.putValue("c", (Object)"cORIG");
        SortedArrayStringMap other = new SortedArrayStringMap();
        other.putValue("1", (Object)"11");
        other.putValue("2", (Object)"22");
        other.putValue("a", (Object)"aa");
        other.putValue("c", (Object)"cc");
        original.putAll((ReadOnlyStringMap)other);
        Assert.assertEquals((String)"size after put other", (long)5L, (long)original.size());
        Assert.assertEquals((Object)"aa", (Object)original.getValue("a"));
        Assert.assertEquals((Object)"bORIG", (Object)original.getValue("b"));
        Assert.assertEquals((Object)"cc", (Object)original.getValue("c"));
        Assert.assertEquals((Object)"11", (Object)original.getValue("1"));
        Assert.assertEquals((Object)"22", (Object)original.getValue("2"));
    }

    @Test
    public void testEquals() {
        SortedArrayStringMap original = new SortedArrayStringMap();
        original.putValue("a", (Object)"avalue");
        original.putValue("B", (Object)"Bvalue");
        original.putValue("3", (Object)"3value");
        Assert.assertEquals((Object)original, (Object)original);
        SortedArrayStringMap other = new SortedArrayStringMap();
        other.putValue("a", (Object)"avalue");
        Assert.assertNotEquals((Object)original, (Object)other);
        other.putValue("B", (Object)"Bvalue");
        Assert.assertNotEquals((Object)original, (Object)other);
        other.putValue("3", (Object)"3value");
        Assert.assertEquals((Object)original, (Object)other);
        other.putValue("3", (Object)"otherValue");
        Assert.assertNotEquals((Object)original, (Object)other);
        other.putValue("3", null);
        Assert.assertNotEquals((Object)original, (Object)other);
        other.putValue("3", (Object)"3value");
        Assert.assertEquals((Object)original, (Object)other);
    }

    @Test
    public void testToMap() throws Exception {
        SortedArrayStringMap original = new SortedArrayStringMap();
        original.putValue("a", (Object)"avalue");
        original.putValue("B", (Object)"Bvalue");
        original.putValue("3", (Object)"3value");
        HashMap<String, String> expected = new HashMap<String, String>();
        expected.put("a", "avalue");
        expected.put("B", "Bvalue");
        expected.put("3", "3value");
        Assert.assertEquals(expected, (Object)original.toMap());
        try {
            original.toMap().put("abc", "xyz");
        }
        catch (UnsupportedOperationException ex) {
            Assert.fail((String)("Expected map to be mutable, but " + ex));
        }
    }

    @Test
    public void testPutAll_KeepsExistingValues() {
        SortedArrayStringMap original = new SortedArrayStringMap();
        original.putValue("a", (Object)"aaa");
        original.putValue("b", (Object)"bbb");
        original.putValue("c", (Object)"ccc");
        Assert.assertEquals((String)"size", (long)3L, (long)original.size());
        original.putAll((ReadOnlyStringMap)new SortedArrayStringMap());
        Assert.assertEquals((String)"size after put empty", (long)3L, (long)original.size());
        Assert.assertEquals((Object)"aaa", (Object)original.getValue("a"));
        Assert.assertEquals((Object)"bbb", (Object)original.getValue("b"));
        Assert.assertEquals((Object)"ccc", (Object)original.getValue("c"));
        SortedArrayStringMap other = new SortedArrayStringMap();
        other.putValue("1", (Object)"111");
        other.putValue("2", (Object)"222");
        other.putValue("3", (Object)"333");
        original.putAll((ReadOnlyStringMap)other);
        Assert.assertEquals((String)"size after put other", (long)6L, (long)original.size());
        Assert.assertEquals((Object)"aaa", (Object)original.getValue("a"));
        Assert.assertEquals((Object)"bbb", (Object)original.getValue("b"));
        Assert.assertEquals((Object)"ccc", (Object)original.getValue("c"));
        Assert.assertEquals((Object)"111", (Object)original.getValue("1"));
        Assert.assertEquals((Object)"222", (Object)original.getValue("2"));
        Assert.assertEquals((Object)"333", (Object)original.getValue("3"));
    }

    @Test
    public void testPutAll_sizePowerOfTwo() {
        SortedArrayStringMap original = new SortedArrayStringMap();
        original.putValue("a", (Object)"aaa");
        original.putValue("b", (Object)"bbb");
        original.putValue("c", (Object)"ccc");
        original.putValue("d", (Object)"ddd");
        Assert.assertEquals((String)"size", (long)4L, (long)original.size());
        original.putAll((ReadOnlyStringMap)new SortedArrayStringMap());
        Assert.assertEquals((String)"size after put empty", (long)4L, (long)original.size());
        Assert.assertEquals((Object)"aaa", (Object)original.getValue("a"));
        Assert.assertEquals((Object)"bbb", (Object)original.getValue("b"));
        Assert.assertEquals((Object)"ccc", (Object)original.getValue("c"));
        Assert.assertEquals((Object)"ddd", (Object)original.getValue("d"));
        SortedArrayStringMap other = new SortedArrayStringMap();
        other.putValue("1", (Object)"111");
        other.putValue("2", (Object)"222");
        other.putValue("3", (Object)"333");
        other.putValue("4", (Object)"444");
        original.putAll((ReadOnlyStringMap)other);
        Assert.assertEquals((String)"size after put other", (long)8L, (long)original.size());
        Assert.assertEquals((Object)"aaa", (Object)original.getValue("a"));
        Assert.assertEquals((Object)"bbb", (Object)original.getValue("b"));
        Assert.assertEquals((Object)"ccc", (Object)original.getValue("c"));
        Assert.assertEquals((Object)"ddd", (Object)original.getValue("d"));
        Assert.assertEquals((Object)"111", (Object)original.getValue("1"));
        Assert.assertEquals((Object)"222", (Object)original.getValue("2"));
        Assert.assertEquals((Object)"333", (Object)original.getValue("3"));
        Assert.assertEquals((Object)"444", (Object)original.getValue("4"));
    }

    @Test
    public void testPutAll_largeAddition() {
        int i;
        SortedArrayStringMap original = new SortedArrayStringMap();
        original.putValue(null, (Object)"nullVal");
        original.putValue("a", (Object)"aaa");
        original.putValue("b", (Object)"bbb");
        original.putValue("c", (Object)"ccc");
        original.putValue("d", (Object)"ddd");
        Assert.assertEquals((String)"size", (long)5L, (long)original.size());
        SortedArrayStringMap other = new SortedArrayStringMap();
        for (i = 0; i < 500; ++i) {
            other.putValue(String.valueOf(i), (Object)String.valueOf(i));
        }
        other.putValue(null, (Object)"otherVal");
        original.putAll((ReadOnlyStringMap)other);
        Assert.assertEquals((String)"size after put other", (long)505L, (long)original.size());
        Assert.assertEquals((Object)"otherVal", (Object)original.getValue(null));
        Assert.assertEquals((Object)"aaa", (Object)original.getValue("a"));
        Assert.assertEquals((Object)"bbb", (Object)original.getValue("b"));
        Assert.assertEquals((Object)"ccc", (Object)original.getValue("c"));
        Assert.assertEquals((Object)"ddd", (Object)original.getValue("d"));
        for (i = 0; i < 500; ++i) {
            Assert.assertEquals((Object)String.valueOf(i), (Object)original.getValue(String.valueOf(i)));
        }
    }

    @Test
    public void testPutAllSelfDoesNotModify() {
        SortedArrayStringMap original = new SortedArrayStringMap();
        original.putValue("a", (Object)"aaa");
        original.putValue("b", (Object)"bbb");
        original.putValue("c", (Object)"ccc");
        Assert.assertEquals((String)"size", (long)3L, (long)original.size());
        original.putAll((ReadOnlyStringMap)original);
        Assert.assertEquals((String)"size after put empty", (long)3L, (long)original.size());
        Assert.assertEquals((Object)"aaa", (Object)original.getValue("a"));
        Assert.assertEquals((Object)"bbb", (Object)original.getValue("b"));
        Assert.assertEquals((Object)"ccc", (Object)original.getValue("c"));
    }

    @Test(expected=ConcurrentModificationException.class)
    public void testConcurrentModificationBiConsumerPut() {
        final SortedArrayStringMap original = new SortedArrayStringMap();
        original.putValue("a", (Object)"aaa");
        original.forEach((BiConsumer)new BiConsumer<String, Object>(){

            public void accept(String s, Object o) {
                original.putValue("c", (Object)"other");
            }
        });
    }

    @Test(expected=ConcurrentModificationException.class)
    public void testConcurrentModificationBiConsumerPutValue() {
        final SortedArrayStringMap original = new SortedArrayStringMap();
        original.putValue("a", (Object)"aaa");
        original.forEach((BiConsumer)new BiConsumer<String, Object>(){

            public void accept(String s, Object o) {
                original.putValue("c", (Object)"other");
            }
        });
    }

    @Test(expected=ConcurrentModificationException.class)
    public void testConcurrentModificationBiConsumerRemove() {
        final SortedArrayStringMap original = new SortedArrayStringMap();
        original.putValue("a", (Object)"aaa");
        original.forEach((BiConsumer)new BiConsumer<String, Object>(){

            public void accept(String s, Object o) {
                original.remove("a");
            }
        });
    }

    @Test(expected=ConcurrentModificationException.class)
    public void testConcurrentModificationBiConsumerClear() {
        final SortedArrayStringMap original = new SortedArrayStringMap();
        original.putValue("a", (Object)"aaa");
        original.forEach((BiConsumer)new BiConsumer<String, Object>(){

            public void accept(String s, Object o) {
                original.clear();
            }
        });
    }

    @Test(expected=ConcurrentModificationException.class)
    public void testConcurrentModificationTriConsumerPut() {
        final SortedArrayStringMap original = new SortedArrayStringMap();
        original.putValue("a", (Object)"aaa");
        original.forEach((TriConsumer)new TriConsumer<String, Object, Object>(){

            public void accept(String s, Object o, Object o2) {
                original.putValue("c", (Object)"other");
            }
        }, null);
    }

    @Test(expected=ConcurrentModificationException.class)
    public void testConcurrentModificationTriConsumerPutValue() {
        final SortedArrayStringMap original = new SortedArrayStringMap();
        original.putValue("a", (Object)"aaa");
        original.forEach((TriConsumer)new TriConsumer<String, Object, Object>(){

            public void accept(String s, Object o, Object o2) {
                original.putValue("c", (Object)"other");
            }
        }, null);
    }

    @Test(expected=ConcurrentModificationException.class)
    public void testConcurrentModificationTriConsumerRemove() {
        final SortedArrayStringMap original = new SortedArrayStringMap();
        original.putValue("a", (Object)"aaa");
        original.forEach((TriConsumer)new TriConsumer<String, Object, Object>(){

            public void accept(String s, Object o, Object o2) {
                original.remove("a");
            }
        }, null);
    }

    @Test(expected=ConcurrentModificationException.class)
    public void testConcurrentModificationTriConsumerClear() {
        final SortedArrayStringMap original = new SortedArrayStringMap();
        original.putValue("a", (Object)"aaa");
        original.forEach((TriConsumer)new TriConsumer<String, Object, Object>(){

            public void accept(String s, Object o, Object o2) {
                original.clear();
            }
        }, null);
    }

    @Test
    public void testInitiallyNotFrozen() {
        Assert.assertFalse((boolean)new SortedArrayStringMap().isFrozen());
    }

    @Test
    public void testIsFrozenAfterCallingFreeze() {
        SortedArrayStringMap original = new SortedArrayStringMap();
        Assert.assertFalse((String)"before freeze", (boolean)original.isFrozen());
        original.freeze();
        Assert.assertTrue((String)"after freeze", (boolean)original.isFrozen());
    }

    @Test(expected=UnsupportedOperationException.class)
    public void testFreezeProhibitsPutValue() {
        SortedArrayStringMap original = new SortedArrayStringMap();
        original.freeze();
        original.putValue("a", (Object)"aaa");
    }

    @Test(expected=UnsupportedOperationException.class)
    public void testFreezeProhibitsRemove() {
        SortedArrayStringMap original = new SortedArrayStringMap();
        original.putValue("b", (Object)"bbb");
        original.freeze();
        original.remove("b");
    }

    @Test
    public void testFreezeAllowsRemoveOfNonExistingKey() {
        SortedArrayStringMap original = new SortedArrayStringMap();
        original.putValue("b", (Object)"bbb");
        original.freeze();
        original.remove("a");
    }

    @Test
    public void testFreezeAllowsRemoveIfEmpty() {
        SortedArrayStringMap original = new SortedArrayStringMap();
        original.freeze();
        original.remove("a");
    }

    @Test(expected=UnsupportedOperationException.class)
    public void testFreezeProhibitsClear() {
        SortedArrayStringMap original = new SortedArrayStringMap();
        original.putValue("a", (Object)"aaa");
        original.freeze();
        original.clear();
    }

    @Test
    public void testFreezeAllowsClearIfEmpty() {
        SortedArrayStringMap original = new SortedArrayStringMap();
        original.freeze();
        original.clear();
    }

    @Test
    public void testPutInsertsInAlphabeticOrder() throws Exception {
        SortedArrayStringMap original = new SortedArrayStringMap();
        original.putValue("a", (Object)"avalue");
        original.putValue("B", (Object)"Bvalue");
        original.putValue("3", (Object)"3value");
        original.putValue("c", (Object)"cvalue");
        original.putValue("d", (Object)"dvalue");
        Assert.assertEquals((Object)"avalue", (Object)original.getValue("a"));
        Assert.assertEquals((Object)"avalue", (Object)original.getValueAt(2));
        Assert.assertEquals((Object)"Bvalue", (Object)original.getValue("B"));
        Assert.assertEquals((Object)"Bvalue", (Object)original.getValueAt(1));
        Assert.assertEquals((Object)"3value", (Object)original.getValue("3"));
        Assert.assertEquals((Object)"3value", (Object)original.getValueAt(0));
        Assert.assertEquals((Object)"cvalue", (Object)original.getValue("c"));
        Assert.assertEquals((Object)"cvalue", (Object)original.getValueAt(3));
        Assert.assertEquals((Object)"dvalue", (Object)original.getValue("d"));
        Assert.assertEquals((Object)"dvalue", (Object)original.getValueAt(4));
    }

    @Test
    public void testPutValueInsertsInAlphabeticOrder() throws Exception {
        SortedArrayStringMap original = new SortedArrayStringMap();
        original.putValue("a", (Object)"avalue");
        original.putValue("B", (Object)"Bvalue");
        original.putValue("3", (Object)"3value");
        original.putValue("c", (Object)"cvalue");
        original.putValue("d", (Object)"dvalue");
        Assert.assertEquals((Object)"avalue", (Object)original.getValue("a"));
        Assert.assertEquals((Object)"avalue", (Object)original.getValueAt(2));
        Assert.assertEquals((Object)"Bvalue", (Object)original.getValue("B"));
        Assert.assertEquals((Object)"Bvalue", (Object)original.getValueAt(1));
        Assert.assertEquals((Object)"3value", (Object)original.getValue("3"));
        Assert.assertEquals((Object)"3value", (Object)original.getValueAt(0));
        Assert.assertEquals((Object)"cvalue", (Object)original.getValue("c"));
        Assert.assertEquals((Object)"cvalue", (Object)original.getValueAt(3));
        Assert.assertEquals((Object)"dvalue", (Object)original.getValue("d"));
        Assert.assertEquals((Object)"dvalue", (Object)original.getValueAt(4));
    }

    @Test
    public void testNullKeysAllowed() {
        SortedArrayStringMap original = new SortedArrayStringMap();
        original.putValue("a", (Object)"avalue");
        original.putValue("B", (Object)"Bvalue");
        original.putValue("3", (Object)"3value");
        original.putValue("c", (Object)"cvalue");
        original.putValue("d", (Object)"dvalue");
        Assert.assertEquals((long)5L, (long)original.size());
        Assert.assertEquals((Object)"{3=3value, B=Bvalue, a=avalue, c=cvalue, d=dvalue}", (Object)original.toString());
        original.putValue(null, (Object)"nullvalue");
        Assert.assertEquals((long)6L, (long)original.size());
        Assert.assertEquals((Object)"{null=nullvalue, 3=3value, B=Bvalue, a=avalue, c=cvalue, d=dvalue}", (Object)original.toString());
        original.putValue(null, (Object)"otherNullvalue");
        Assert.assertEquals((Object)"{null=otherNullvalue, 3=3value, B=Bvalue, a=avalue, c=cvalue, d=dvalue}", (Object)original.toString());
        Assert.assertEquals((long)6L, (long)original.size());
        original.putValue(null, (Object)"nullvalue");
        Assert.assertEquals((long)6L, (long)original.size());
        Assert.assertEquals((Object)"{null=nullvalue, 3=3value, B=Bvalue, a=avalue, c=cvalue, d=dvalue}", (Object)original.toString());
        original.putValue(null, (Object)"abc");
        Assert.assertEquals((long)6L, (long)original.size());
        Assert.assertEquals((Object)"{null=abc, 3=3value, B=Bvalue, a=avalue, c=cvalue, d=dvalue}", (Object)original.toString());
    }

    @Test
    public void testNullKeysCopiedToAsMap() {
        SortedArrayStringMap original = new SortedArrayStringMap();
        original.putValue("a", (Object)"avalue");
        original.putValue("B", (Object)"Bvalue");
        original.putValue("3", (Object)"3value");
        original.putValue("c", (Object)"cvalue");
        original.putValue("d", (Object)"dvalue");
        Assert.assertEquals((long)5L, (long)original.size());
        HashMap<String, String> expected = new HashMap<String, String>();
        expected.put("a", "avalue");
        expected.put("B", "Bvalue");
        expected.put("3", "3value");
        expected.put("c", "cvalue");
        expected.put("d", "dvalue");
        Assert.assertEquals((String)"initial", expected, (Object)original.toMap());
        original.putValue(null, (Object)"nullvalue");
        expected.put(null, "nullvalue");
        Assert.assertEquals((long)6L, (long)original.size());
        Assert.assertEquals((String)"with null key", expected, (Object)original.toMap());
        original.putValue(null, (Object)"otherNullvalue");
        expected.put(null, "otherNullvalue");
        Assert.assertEquals((long)6L, (long)original.size());
        Assert.assertEquals((String)"with null key value2", expected, (Object)original.toMap());
        original.putValue(null, (Object)"nullvalue");
        expected.put(null, "nullvalue");
        Assert.assertEquals((long)6L, (long)original.size());
        Assert.assertEquals((String)"with null key value1 again", expected, (Object)original.toMap());
        original.putValue(null, (Object)"abc");
        expected.put(null, "abc");
        Assert.assertEquals((long)6L, (long)original.size());
        Assert.assertEquals((String)"with null key value3", expected, (Object)original.toMap());
    }

    @Test
    public void testRemove() {
        SortedArrayStringMap original = new SortedArrayStringMap();
        original.putValue("a", (Object)"avalue");
        Assert.assertEquals((long)1L, (long)original.size());
        Assert.assertEquals((Object)"avalue", (Object)original.getValue("a"));
        original.remove("a");
        Assert.assertEquals((long)0L, (long)original.size());
        Assert.assertNull((String)"no a val", (Object)original.getValue("a"));
        original.remove("B");
        Assert.assertEquals((long)0L, (long)original.size());
        Assert.assertNull((String)"no B val", (Object)original.getValue("B"));
    }

    @Test
    public void testRemoveNullsOutRemovedSlot() throws Exception {
        SortedArrayStringMap original = new SortedArrayStringMap();
        original.putValue("a", (Object)"avalue");
        original.putValue("b", (Object)"bvalue");
        original.putValue("c", (Object)"cvalue");
        original.putValue("d", (Object)"dvalue");
        original.remove("a");
        original.remove("b");
        original.remove("c");
        original.remove("d");
        Assert.assertNull((Object)original.getValueAt(0));
        Field f = SortedArrayStringMap.class.getDeclaredField("values");
        f.setAccessible(true);
        Object[] values = (Object[])f.get(original);
        for (int i = 0; i < values.length; ++i) {
            Assert.assertNull((Object)values[i]);
        }
    }

    @Test
    public void testRemoveWhenFull() throws Exception {
        SortedArrayStringMap original = new SortedArrayStringMap();
        original.putValue("a", (Object)"avalue");
        original.putValue("b", (Object)"bvalue");
        original.putValue("c", (Object)"cvalue");
        original.putValue("d", (Object)"dvalue");
        original.remove("d");
    }

    @Test
    public void testNullValuesArePreserved() {
        SortedArrayStringMap original = new SortedArrayStringMap();
        original.putValue("a", (Object)"avalue");
        Assert.assertEquals((long)1L, (long)original.size());
        Assert.assertEquals((Object)"avalue", (Object)original.getValue("a"));
        original.putValue("a", null);
        Assert.assertEquals((long)1L, (long)original.size());
        Assert.assertNull((String)"no a val", (Object)original.getValue("a"));
        original.putValue("B", null);
        Assert.assertEquals((long)2L, (long)original.size());
        Assert.assertNull((String)"no B val", (Object)original.getValue("B"));
    }

    @Test
    public void testGet() throws Exception {
        SortedArrayStringMap original = new SortedArrayStringMap();
        original.putValue("a", (Object)"avalue");
        original.putValue("B", (Object)"Bvalue");
        original.putValue("3", (Object)"3value");
        Assert.assertEquals((Object)"avalue", (Object)original.getValue("a"));
        Assert.assertEquals((Object)"Bvalue", (Object)original.getValue("B"));
        Assert.assertEquals((Object)"3value", (Object)original.getValue("3"));
        original.putValue("0", (Object)"0value");
        Assert.assertEquals((Object)"0value", (Object)original.getValue("0"));
        Assert.assertEquals((Object)"3value", (Object)original.getValue("3"));
        Assert.assertEquals((Object)"Bvalue", (Object)original.getValue("B"));
        Assert.assertEquals((Object)"avalue", (Object)original.getValue("a"));
    }

    @Test
    public void testGetValue_GetValueAt() throws Exception {
        SortedArrayStringMap original = new SortedArrayStringMap();
        original.putValue("a", (Object)"avalue");
        original.putValue("B", (Object)"Bvalue");
        original.putValue("3", (Object)"3value");
        Assert.assertEquals((Object)"avalue", (Object)original.getValue("a"));
        Assert.assertEquals((Object)"avalue", (Object)original.getValueAt(2));
        Assert.assertEquals((Object)"Bvalue", (Object)original.getValue("B"));
        Assert.assertEquals((Object)"Bvalue", (Object)original.getValueAt(1));
        Assert.assertEquals((Object)"3value", (Object)original.getValue("3"));
        Assert.assertEquals((Object)"3value", (Object)original.getValueAt(0));
        original.putValue("0", (Object)"0value");
        Assert.assertEquals((Object)"0value", (Object)original.getValue("0"));
        Assert.assertEquals((Object)"0value", (Object)original.getValueAt(0));
        Assert.assertEquals((Object)"3value", (Object)original.getValue("3"));
        Assert.assertEquals((Object)"3value", (Object)original.getValueAt(1));
        Assert.assertEquals((Object)"Bvalue", (Object)original.getValue("B"));
        Assert.assertEquals((Object)"Bvalue", (Object)original.getValueAt(2));
        Assert.assertEquals((Object)"avalue", (Object)original.getValue("a"));
        Assert.assertEquals((Object)"avalue", (Object)original.getValueAt(3));
    }

    @Test
    public void testClear() throws Exception {
        SortedArrayStringMap original = new SortedArrayStringMap();
        original.putValue("a", (Object)"avalue");
        original.putValue("B", (Object)"Bvalue");
        original.putValue("3", (Object)"3value");
        Assert.assertEquals((long)3L, (long)original.size());
        original.clear();
        Assert.assertEquals((long)0L, (long)original.size());
        Field f = SortedArrayStringMap.class.getDeclaredField("values");
        f.setAccessible(true);
        Object[] values = (Object[])f.get(original);
        for (int i = 0; i < values.length; ++i) {
            Assert.assertNull((Object)values[i]);
        }
    }

    @Test
    public void testIndexOfKey() throws Exception {
        SortedArrayStringMap original = new SortedArrayStringMap();
        original.putValue("a", (Object)"avalue");
        Assert.assertEquals((long)0L, (long)original.indexOfKey("a"));
        original.putValue("B", (Object)"Bvalue");
        Assert.assertEquals((long)1L, (long)original.indexOfKey("a"));
        Assert.assertEquals((long)0L, (long)original.indexOfKey("B"));
        original.putValue("3", (Object)"3value");
        Assert.assertEquals((long)2L, (long)original.indexOfKey("a"));
        Assert.assertEquals((long)1L, (long)original.indexOfKey("B"));
        Assert.assertEquals((long)0L, (long)original.indexOfKey("3"));
        original.putValue("A", (Object)"AAA");
        Assert.assertEquals((long)3L, (long)original.indexOfKey("a"));
        Assert.assertEquals((long)2L, (long)original.indexOfKey("B"));
        Assert.assertEquals((long)1L, (long)original.indexOfKey("A"));
        Assert.assertEquals((long)0L, (long)original.indexOfKey("3"));
        original.putValue("C", (Object)"CCC");
        Assert.assertEquals((long)4L, (long)original.indexOfKey("a"));
        Assert.assertEquals((long)3L, (long)original.indexOfKey("C"));
        Assert.assertEquals((long)2L, (long)original.indexOfKey("B"));
        Assert.assertEquals((long)1L, (long)original.indexOfKey("A"));
        Assert.assertEquals((long)0L, (long)original.indexOfKey("3"));
        original.putValue("2", (Object)"222");
        Assert.assertEquals((long)5L, (long)original.indexOfKey("a"));
        Assert.assertEquals((long)4L, (long)original.indexOfKey("C"));
        Assert.assertEquals((long)3L, (long)original.indexOfKey("B"));
        Assert.assertEquals((long)2L, (long)original.indexOfKey("A"));
        Assert.assertEquals((long)1L, (long)original.indexOfKey("3"));
        Assert.assertEquals((long)0L, (long)original.indexOfKey("2"));
    }

    @Test
    public void testContainsKey() throws Exception {
        SortedArrayStringMap original = new SortedArrayStringMap();
        Assert.assertFalse((String)"a", (boolean)original.containsKey("a"));
        Assert.assertFalse((String)"B", (boolean)original.containsKey("B"));
        Assert.assertFalse((String)"3", (boolean)original.containsKey("3"));
        Assert.assertFalse((String)"A", (boolean)original.containsKey("A"));
        original.putValue("a", (Object)"avalue");
        Assert.assertTrue((String)"a", (boolean)original.containsKey("a"));
        Assert.assertFalse((String)"B", (boolean)original.containsKey("B"));
        Assert.assertFalse((String)"3", (boolean)original.containsKey("3"));
        Assert.assertFalse((String)"A", (boolean)original.containsKey("A"));
        original.putValue("B", (Object)"Bvalue");
        Assert.assertTrue((String)"a", (boolean)original.containsKey("a"));
        Assert.assertTrue((String)"B", (boolean)original.containsKey("B"));
        Assert.assertFalse((String)"3", (boolean)original.containsKey("3"));
        Assert.assertFalse((String)"A", (boolean)original.containsKey("A"));
        original.putValue("3", (Object)"3value");
        Assert.assertTrue((String)"a", (boolean)original.containsKey("a"));
        Assert.assertTrue((String)"B", (boolean)original.containsKey("B"));
        Assert.assertTrue((String)"3", (boolean)original.containsKey("3"));
        Assert.assertFalse((String)"A", (boolean)original.containsKey("A"));
        original.putValue("A", (Object)"AAA");
        Assert.assertTrue((String)"a", (boolean)original.containsKey("a"));
        Assert.assertTrue((String)"B", (boolean)original.containsKey("B"));
        Assert.assertTrue((String)"3", (boolean)original.containsKey("3"));
        Assert.assertTrue((String)"A", (boolean)original.containsKey("A"));
    }

    @Test
    public void testGetValueAt() throws Exception {
        SortedArrayStringMap original = new SortedArrayStringMap();
        original.putValue("a", (Object)"avalue");
        Assert.assertEquals((Object)"a", (Object)original.getKeyAt(0));
        Assert.assertEquals((Object)"avalue", (Object)original.getValueAt(0));
        original.putValue("B", (Object)"Bvalue");
        Assert.assertEquals((Object)"B", (Object)original.getKeyAt(0));
        Assert.assertEquals((Object)"Bvalue", (Object)original.getValueAt(0));
        Assert.assertEquals((Object)"a", (Object)original.getKeyAt(1));
        Assert.assertEquals((Object)"avalue", (Object)original.getValueAt(1));
        original.putValue("3", (Object)"3value");
        Assert.assertEquals((Object)"3", (Object)original.getKeyAt(0));
        Assert.assertEquals((Object)"3value", (Object)original.getValueAt(0));
        Assert.assertEquals((Object)"B", (Object)original.getKeyAt(1));
        Assert.assertEquals((Object)"Bvalue", (Object)original.getValueAt(1));
        Assert.assertEquals((Object)"a", (Object)original.getKeyAt(2));
        Assert.assertEquals((Object)"avalue", (Object)original.getValueAt(2));
    }

    @Test
    public void testSizeAndIsEmpty() throws Exception {
        SortedArrayStringMap original = new SortedArrayStringMap();
        Assert.assertEquals((long)0L, (long)original.size());
        Assert.assertTrue((String)"initial", (boolean)original.isEmpty());
        original.putValue("a", (Object)"avalue");
        Assert.assertEquals((long)1L, (long)original.size());
        Assert.assertFalse((String)("size=" + original.size()), (boolean)original.isEmpty());
        original.putValue("B", (Object)"Bvalue");
        Assert.assertEquals((long)2L, (long)original.size());
        Assert.assertFalse((String)("size=" + original.size()), (boolean)original.isEmpty());
        original.putValue("3", (Object)"3value");
        Assert.assertEquals((long)3L, (long)original.size());
        Assert.assertFalse((String)("size=" + original.size()), (boolean)original.isEmpty());
        original.remove("B");
        Assert.assertEquals((long)2L, (long)original.size());
        Assert.assertFalse((String)("size=" + original.size()), (boolean)original.isEmpty());
        original.remove("3");
        Assert.assertEquals((long)1L, (long)original.size());
        Assert.assertFalse((String)("size=" + original.size()), (boolean)original.isEmpty());
        original.remove("a");
        Assert.assertEquals((long)0L, (long)original.size());
        Assert.assertTrue((String)("size=" + original.size()), (boolean)original.isEmpty());
    }

    @Test
    public void testForEachBiConsumer() throws Exception {
        final SortedArrayStringMap original = new SortedArrayStringMap();
        original.putValue("a", (Object)"avalue");
        original.putValue("B", (Object)"Bvalue");
        original.putValue("3", (Object)"3value");
        original.forEach((BiConsumer)new BiConsumer<String, String>(){
            int count = 0;

            public void accept(String key, String value) {
                Assert.assertEquals((String)"key", (Object)key, (Object)original.getKeyAt(this.count));
                Assert.assertEquals((String)"val", (Object)value, (Object)original.getValueAt(this.count));
                ++this.count;
                Assert.assertTrue((String)("count should not exceed size but was " + this.count), (this.count <= original.size() ? 1 : 0) != 0);
            }
        });
    }

    @Test
    public void testForEachTriConsumer() throws Exception {
        SortedArrayStringMap original = new SortedArrayStringMap();
        original.putValue("a", (Object)"avalue");
        original.putValue("B", (Object)"Bvalue");
        original.putValue("3", (Object)"3value");
        State state = new State();
        state.data = original;
        original.forEach(COUNTER, (Object)state);
        Assert.assertEquals((long)state.count, (long)original.size());
    }

    static class State {
        SortedArrayStringMap data;
        int count;

        State() {
        }
    }
}

