/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.util;

import org.apache.logging.log4j.util.Constants;
import org.apache.logging.log4j.util.StringBuilders;
import org.junit.Assert;
import org.junit.Test;

public class StringBuildersTest {
    @Test
    public void trimToMaxSize() throws Exception {
        StringBuilder sb = new StringBuilder();
        char[] value = new char[4096];
        sb.append(value);
        Assert.assertTrue((String)"needs trimming", (sb.length() > Constants.MAX_REUSABLE_MESSAGE_SIZE ? 1 : 0) != 0);
        StringBuilders.trimToMaxSize((StringBuilder)sb, (int)Constants.MAX_REUSABLE_MESSAGE_SIZE);
        Assert.assertTrue((String)"trimmed OK", (sb.length() <= Constants.MAX_REUSABLE_MESSAGE_SIZE ? 1 : 0) != 0);
    }

    @Test
    public void trimToMaxSizeWithLargeCapacity() throws Exception {
        StringBuilder sb = new StringBuilder();
        char[] value = new char[4096];
        sb.append(value);
        sb.setLength(0);
        Assert.assertTrue((String)"needs trimming", (sb.capacity() > Constants.MAX_REUSABLE_MESSAGE_SIZE ? 1 : 0) != 0);
        StringBuilders.trimToMaxSize((StringBuilder)sb, (int)Constants.MAX_REUSABLE_MESSAGE_SIZE);
        Assert.assertTrue((String)"trimmed OK", (sb.capacity() <= Constants.MAX_REUSABLE_MESSAGE_SIZE ? 1 : 0) != 0);
    }
}

