/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.changelog;

import java.nio.file.Path;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.logging.log4j.changelog.util.FileUtils;

public final class ChangelogFiles {
    private ChangelogFiles() {
    }

    public static Path unreleasedDirectory(Path changelogDirectory, int versionMajor) {
        String filename = String.format(".%d.x.x", versionMajor);
        return changelogDirectory.resolve(filename);
    }

    public static Set<Integer> unreleasedDirectoryVersionMajors(Path changelogDirectory) {
        return FileUtils.findAdjacentFiles(changelogDirectory, false, paths -> paths.flatMap(path -> {
            Pattern versionPattern = Pattern.compile("^\\.(\\d+)\\.x\\.x$");
            Matcher versionMatcher = versionPattern.matcher(path.getFileName().toString());
            if (!versionMatcher.matches()) {
                return Stream.empty();
            }
            String versionMajorString = versionMatcher.group(1);
            int versionMajor = Integer.parseInt(versionMajorString);
            return Stream.of(Integer.valueOf(versionMajor));
        }).collect(Collectors.toSet()));
    }

    public static Path indexTemplateFile(Path changelogDirectory) {
        return changelogDirectory.resolve(".index.adoc.ftl");
    }

    public static String indexTemplateFile(Path changelogDirectory, Path baseDir) {
        return baseDir.relativize(ChangelogFiles.indexTemplateFile(changelogDirectory)).toString().replaceAll("\\\\", "/");
    }

    public static Path releaseDirectory(Path changelogDirectory, String releaseVersion) {
        return changelogDirectory.resolve(releaseVersion);
    }

    public static Path releaseXmlFile(Path releaseDirectory) {
        return releaseDirectory.resolve(".release.xml");
    }

    public static Path releaseChangelogTemplateFile(Path releaseDirectory) {
        return releaseDirectory.resolve(".changelog.adoc.ftl");
    }

    public static String releaseChangelogTemplateFile(Path releaseDirectory, Path baseDir) {
        return baseDir.relativize(ChangelogFiles.releaseChangelogTemplateFile(releaseDirectory)).toString().replaceAll("\\\\", "/");
    }
}

