/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.changelog.exporter;

import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.logging.log4j.changelog.ChangelogEntry;
import org.apache.logging.log4j.changelog.ChangelogFiles;
import org.apache.logging.log4j.changelog.ChangelogRelease;
import org.apache.logging.log4j.changelog.exporter.ChangelogExporterArgs;
import org.apache.logging.log4j.changelog.exporter.FreeMarkerUtils;
import org.apache.logging.log4j.changelog.util.FileUtils;

public final class ChangelogExporter {
    private ChangelogExporter() {
    }

    public static void main(String[] mainArgs) {
        ChangelogExporterArgs args = ChangelogExporterArgs.fromSystemProperties();
        ChangelogExporter.performExport(args);
    }

    public static void performExport(ChangelogExporterArgs args) {
        List<Path> releaseDirectories = ChangelogExporter.findReleaseDirectories(args);
        int releaseDirectoryCount = releaseDirectories.size();
        List<ChangelogRelease> changelogReleases = releaseDirectories.stream().map(releaseDirectory -> {
            Path releaseXmlFile = ChangelogFiles.releaseXmlFile(releaseDirectory);
            return ChangelogRelease.readFromXmlFile(releaseXmlFile);
        }).collect(Collectors.toList());
        if (releaseDirectoryCount > 0) {
            for (int releaseIndex = 0; releaseIndex < releaseDirectories.size(); ++releaseIndex) {
                Path releaseDirectory2 = releaseDirectories.get(releaseIndex);
                ChangelogRelease changelogRelease = (ChangelogRelease)changelogReleases.get(releaseIndex);
                Path releaseChangelogTemplateFile = ChangelogFiles.releaseChangelogTemplateFile(releaseDirectory2);
                try {
                    ChangelogExporter.exportRelease(args.outputDirectory, args.changelogDirectory, releaseDirectory2, changelogRelease, releaseChangelogTemplateFile);
                    continue;
                }
                catch (Exception error) {
                    String message = String.format("failed exporting release from directory `%s`", releaseDirectory2);
                    throw new RuntimeException(message, error);
                }
            }
            if (releaseDirectoryCount == 1) {
                System.out.format("exported a single release directory: `%s`%n", releaseDirectories.get(0));
            } else {
                System.out.format("exported %d release directories: ..., `%s`%n", releaseDirectories.size(), releaseDirectories.get(releaseDirectoryCount - 1));
            }
        }
        ChangelogFiles.unreleasedDirectoryVersionMajors(args.changelogDirectory).stream().sorted().forEach(upcomingReleaseVersionMajor -> {
            Path upcomingReleaseDirectory = ChangelogFiles.unreleasedDirectory(args.changelogDirectory, upcomingReleaseVersionMajor);
            ChangelogRelease upcomingRelease = ChangelogExporter.upcomingRelease(upcomingReleaseVersionMajor);
            Path upcomingReleaseChangelogTemplateFile = ChangelogFiles.releaseChangelogTemplateFile(upcomingReleaseDirectory);
            System.out.format("exporting upcoming release directory: `%s`%n", upcomingReleaseDirectory);
            ChangelogExporter.exportRelease(args.outputDirectory, args.changelogDirectory, upcomingReleaseDirectory, upcomingRelease, upcomingReleaseChangelogTemplateFile);
            changelogReleases.add(upcomingRelease);
        });
        ChangelogExporter.exportIndex(args.outputDirectory, args.changelogDirectory, changelogReleases);
    }

    private static List<Path> findReleaseDirectories(ChangelogExporterArgs args) {
        return FileUtils.findAdjacentFiles(args.changelogDirectory, true, paths -> paths.filter(ChangelogExporter::isNonEmptyDirectory).sorted(Comparator.comparing(releaseDirectory -> {
            Path releaseXmlFile = ChangelogFiles.releaseXmlFile(releaseDirectory);
            ChangelogRelease changelogRelease = ChangelogRelease.readFromXmlFile(releaseXmlFile);
            return changelogRelease.date;
        })).collect(Collectors.toList()));
    }

    private static boolean isNonEmptyDirectory(Path path) {
        return Files.isDirectory(path, new LinkOption[0]) && FileUtils.findAdjacentFiles(path, false, paths -> paths.findFirst().isPresent()) != false;
    }

    private static void exportRelease(Path outputDirectory, Path changelogDirectory, Path releaseDirectory, ChangelogRelease changelogRelease, Path releaseChangelogTemplateFile) {
        Map<ChangelogEntry.Type, List<ChangelogEntry>> changelogEntriesByType = ChangelogExporter.readChangelogEntriesByType(releaseDirectory);
        try {
            ChangelogExporter.exportRelease(outputDirectory, changelogDirectory, changelogRelease, changelogEntriesByType, releaseChangelogTemplateFile);
        }
        catch (IOException error) {
            String message = String.format("failed exporting release from directory `%s`", releaseDirectory);
            throw new UncheckedIOException(message, error);
        }
    }

    private static Map<ChangelogEntry.Type, List<ChangelogEntry>> readChangelogEntriesByType(Path releaseDirectory) {
        return FileUtils.findAdjacentFiles(releaseDirectory, true, stream -> stream.sorted().map(ChangelogEntry::readFromXmlFile).collect(Collectors.groupingBy(changelogEntry -> changelogEntry.type, TreeMap::new, Collectors.toList())));
    }

    private static void exportRelease(Path outputDirectory, Path changelogDirectory, ChangelogRelease release, Map<ChangelogEntry.Type, List<ChangelogEntry>> entriesByType, Path releaseChangelogTemplateFile) throws IOException {
        String releaseChangelogFileName = ChangelogExporter.releaseChangelogFileName(release);
        Path releaseChangelogFile = outputDirectory.resolve(releaseChangelogFileName);
        LinkedHashMap<String, Object> releaseChangelogTemplateData = new LinkedHashMap<String, Object>();
        releaseChangelogTemplateData.put("release", release);
        releaseChangelogTemplateData.put("entriesByType", entriesByType);
        String releaseChangelogTemplateName = ChangelogExporter.templateName(changelogDirectory, releaseChangelogTemplateFile);
        FreeMarkerUtils.render(changelogDirectory, releaseChangelogTemplateName, releaseChangelogTemplateData, releaseChangelogFile);
    }

    private static ChangelogRelease upcomingRelease(int versionMajor) {
        String releaseVersion = versionMajor + ".x.x";
        return new ChangelogRelease(releaseVersion, null);
    }

    private static void exportIndex(Path outputDirectory, Path changelogDirectory, List<ChangelogRelease> changelogReleases) {
        Map indexTemplateData = Collections.singletonMap("releases", IntStream.range(0, changelogReleases.size()).boxed().sorted(Comparator.reverseOrder()).map(releaseIndex -> {
            ChangelogRelease changelogRelease = (ChangelogRelease)changelogReleases.get((int)releaseIndex);
            LinkedHashMap<String, String> changelogReleaseData = new LinkedHashMap<String, String>();
            changelogReleaseData.put("version", changelogRelease.version);
            changelogReleaseData.put("date", changelogRelease.date);
            changelogReleaseData.put("changelogFileName", ChangelogExporter.releaseChangelogFileName(changelogRelease));
            return changelogReleaseData;
        }).collect(Collectors.toList()));
        Path indexTemplateFile = ChangelogFiles.indexTemplateFile(changelogDirectory);
        String indexTemplateName = ChangelogExporter.templateName(changelogDirectory, indexTemplateFile);
        Path indexFile = outputDirectory.resolve("index.adoc");
        FreeMarkerUtils.render(changelogDirectory, indexTemplateName, indexTemplateData, indexFile);
    }

    private static String releaseChangelogFileName(ChangelogRelease changelogRelease) {
        return String.format("%s.adoc", changelogRelease.version);
    }

    private static String templateName(Path changelogDirectory, Path path) {
        Path relativePath = changelogDirectory.relativize(path);
        return File.pathSeparatorChar == '/' ? relativePath.toString() : relativePath.toString().replace('\\', '/');
    }
}

