/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.changelog.importer;

import java.nio.file.Path;
import java.util.Objects;
import org.apache.logging.log4j.changelog.util.PropertyUtils;

public final class MavenChangesImporterArgs {
    public static final String CHANGELOG_DIRECTORY_PROPERTY_NAME = "log4j.changelog.directory";
    public static final String CHANGES_XML_FILE_PROPERTY_NAME = "log4j.changelog.changesXmlFile";
    public static final String RELEASE_VERSION_MAJOR_PROPERTY_NAME = "log4j.changelog.releaseVersionMajor";
    final Path changelogDirectory;
    final Path changesXmlFile;
    final int releaseVersionMajor;

    public MavenChangesImporterArgs(Path changelogDirectory, Path changesXmlFile, int releaseVersionMajor) {
        Objects.requireNonNull(changelogDirectory, "changelogDirectory");
        Objects.requireNonNull(changesXmlFile, "changesXmlFile");
        if (releaseVersionMajor < 0) {
            String message = String.format("was expecting `releaseVersionMajor >= 0`, found: %d", releaseVersionMajor);
            throw new IllegalArgumentException(message);
        }
        this.changelogDirectory = changelogDirectory;
        this.changesXmlFile = changesXmlFile;
        this.releaseVersionMajor = releaseVersionMajor;
    }

    static MavenChangesImporterArgs fromSystemProperties() {
        Path changelogDirectory = PropertyUtils.requireNonBlankPathProperty(CHANGELOG_DIRECTORY_PROPERTY_NAME);
        Path changesXmlFile = PropertyUtils.requireNonBlankPathProperty(CHANGES_XML_FILE_PROPERTY_NAME);
        int releaseVersionMajor = PropertyUtils.requireNonBlankIntProperty(RELEASE_VERSION_MAJOR_PROPERTY_NAME);
        return new MavenChangesImporterArgs(changelogDirectory, changesXmlFile, releaseVersionMajor);
    }
}

