/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.docgen.maven;

import java.io.File;
import java.util.Set;
import java.util.function.Predicate;
import org.apache.logging.log4j.docgen.PluginSet;
import org.apache.logging.log4j.docgen.generator.DocumentationGenerator;
import org.apache.logging.log4j.docgen.generator.DocumentationGeneratorArgs;
import org.apache.logging.log4j.docgen.generator.DocumentationTemplate;
import org.apache.logging.log4j.docgen.maven.AbstractGeneratorMojo;
import org.apache.logging.log4j.docgen.maven.DocumentationTemplateMojo;
import org.apache.logging.log4j.docgen.maven.PluginSets;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;

@Mojo(name="generate-documentation", defaultPhase=LifecyclePhase.GENERATE_RESOURCES, threadSafe=true)
public class DocumentationGeneratorMojo
extends AbstractGeneratorMojo {
    @Parameter(property="log4j.docgen.templateDirectory", required=true)
    private File templateDirectory;
    @Parameter(required=true)
    private DocumentationTemplateMojo indexTemplate;
    @Parameter(required=true)
    private DocumentationTemplateMojo typeTemplate;

    public void execute() {
        Set<PluginSet> pluginSets = PluginSets.ofDescriptorFilesAndFileMatchers(this.descriptorFiles, this.descriptorFileMatchers);
        Predicate<String> classNameFilter = this.typeFilter != null ? this.typeFilter.createPredicate() : ignored -> true;
        DocumentationGeneratorArgs generatorArgs = new DocumentationGeneratorArgs(pluginSets, classNameFilter, this.templateDirectory.toPath(), DocumentationGeneratorMojo.toApiModel(this.indexTemplate), DocumentationGeneratorMojo.toApiModel(this.typeTemplate));
        DocumentationGenerator.generateDocumentation((DocumentationGeneratorArgs)generatorArgs);
    }

    private static DocumentationTemplate toApiModel(DocumentationTemplateMojo mojo) {
        return new DocumentationTemplate(mojo.source, mojo.target);
    }
}

