/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.docgen.maven;

import java.io.File;
import java.util.Set;
import java.util.function.Predicate;
import javax.xml.stream.XMLStreamException;
import org.apache.logging.log4j.docgen.PluginSet;
import org.apache.logging.log4j.docgen.generator.SchemaGenerator;
import org.apache.logging.log4j.docgen.generator.SchemaGeneratorArgs;
import org.apache.logging.log4j.docgen.maven.AbstractGeneratorMojo;
import org.apache.logging.log4j.docgen.maven.PluginSets;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;

@Mojo(name="generate-schema", defaultPhase=LifecyclePhase.GENERATE_RESOURCES, threadSafe=true)
public class SchemaGeneratorMojo
extends AbstractGeneratorMojo {
    @Parameter(property="log4j.docgen.schemaVersion", required=true)
    private String schemaVersion;
    @Parameter(property="log4j.docgen.schemaFile", required=true)
    private File schemaFile;

    public void execute() throws MojoExecutionException {
        Set<PluginSet> pluginSets = PluginSets.ofDescriptorFilesAndFileMatchers(this.descriptorFiles, this.descriptorFileMatchers);
        Predicate<String> classNameFilter = this.typeFilter != null ? this.typeFilter.createPredicate() : ignored -> true;
        try {
            SchemaGeneratorArgs generatorArgs = new SchemaGeneratorArgs(pluginSets, classNameFilter, this.schemaVersion, this.schemaFile.toPath());
            SchemaGenerator.generateSchema((SchemaGeneratorArgs)generatorArgs);
        }
        catch (XMLStreamException error) {
            String message = String.format("failed generating the schema file `%s`", this.schemaFile);
            throw new MojoExecutionException(message, (Exception)error);
        }
    }
}

