/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.docgen.io.stax;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import java.util.TreeSet;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.apache.logging.log4j.docgen.AbstractType;
import org.apache.logging.log4j.docgen.Description;
import org.apache.logging.log4j.docgen.PluginAttribute;
import org.apache.logging.log4j.docgen.PluginElement;
import org.apache.logging.log4j.docgen.PluginSet;
import org.apache.logging.log4j.docgen.PluginType;
import org.apache.logging.log4j.docgen.ScalarType;
import org.apache.logging.log4j.docgen.ScalarValue;
import org.apache.logging.log4j.docgen.Type;

public class PluginBundleStaxReader {
    public String determineVersion(Reader reader) throws IOException, XMLStreamException {
        XMLStreamReader xmlStreamReader = XMLInputFactory.newInstance().createXMLStreamReader(reader);
        while (xmlStreamReader.hasNext()) {
            int eventType = xmlStreamReader.next();
            if (eventType != 1) continue;
            return this.getVersionFromField(xmlStreamReader);
        }
        throw new XMLStreamException("Version not found in document", xmlStreamReader.getLocation());
    }

    private String getVersionFromField(XMLStreamReader xmlStreamReader) throws XMLStreamException {
        int depth = 0;
        while (depth >= 0) {
            int eventType = xmlStreamReader.next();
            if (eventType == 1) {
                if (depth == 0 && "version".equals(xmlStreamReader.getLocalName())) {
                    return xmlStreamReader.getElementText();
                }
                ++depth;
            }
            if (eventType != 2) continue;
            --depth;
        }
        throw new XMLStreamException("Field: 'version' does not exist in the document.", xmlStreamReader.getLocation());
    }

    public PluginSet read(Reader reader, boolean strict) throws IOException, XMLStreamException {
        XMLStreamReader xmlStreamReader = XMLInputFactory.newInstance().createXMLStreamReader(reader);
        return this.read(xmlStreamReader, strict);
    }

    public PluginSet read(Reader reader) throws IOException, XMLStreamException {
        return this.read(reader, true);
    }

    public PluginSet read(InputStream stream, boolean strict) throws IOException, XMLStreamException {
        XMLStreamReader xmlStreamReader = XMLInputFactory.newInstance().createXMLStreamReader(stream);
        return this.read(xmlStreamReader, strict);
    }

    public PluginSet read(InputStream stream) throws IOException, XMLStreamException {
        return this.read(stream, true);
    }

    public PluginSet read(String filePath, boolean strict) throws IOException, XMLStreamException {
        File file = new File(filePath);
        XMLStreamReader xmlStreamReader = XMLInputFactory.newInstance().createXMLStreamReader(file.toURI().toURL().toExternalForm(), new FileInputStream(file));
        return this.read(xmlStreamReader, strict);
    }

    public PluginSet read(String filePath) throws IOException, XMLStreamException {
        return this.read(filePath, true);
    }

    private boolean checkFieldWithDuplicate(XMLStreamReader xmlStreamReader, String tagName, String alias, Set parsed) throws XMLStreamException {
        if (!xmlStreamReader.getLocalName().equals(tagName) && !xmlStreamReader.getLocalName().equals(alias)) {
            return false;
        }
        if (!parsed.add(tagName)) {
            throw new XMLStreamException("Duplicated tag: '" + tagName + "'", xmlStreamReader.getLocation());
        }
        return true;
    }

    private void checkUnknownElement(XMLStreamReader xmlStreamReader, boolean strict) throws XMLStreamException {
        if (strict) {
            throw new XMLStreamException("Unrecognised tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation());
        }
        int unrecognizedTagCount = 1;
        while (unrecognizedTagCount != 0) {
            xmlStreamReader.next();
            if (xmlStreamReader.getEventType() == 1) {
                ++unrecognizedTagCount;
                continue;
            }
            if (xmlStreamReader.getEventType() != 2) continue;
            --unrecognizedTagCount;
        }
    }

    private boolean getBooleanValue(String s, String attribute, XMLStreamReader xmlStreamReader) throws XMLStreamException {
        if (s != null) {
            return Boolean.valueOf(s);
        }
        return false;
    }

    private byte getByteValue(String s, String attribute, XMLStreamReader xmlStreamReader, boolean strict) throws XMLStreamException {
        block3: {
            if (s != null) {
                try {
                    return Byte.valueOf(s);
                }
                catch (NumberFormatException nfe) {
                    if (!strict) break block3;
                    throw new XMLStreamException("Unable to parse element '" + attribute + "', must be a byte but was '" + s + "'", xmlStreamReader.getLocation(), nfe);
                }
            }
        }
        return 0;
    }

    private char getCharacterValue(String s, String attribute, XMLStreamReader xmlStreamReader) throws XMLStreamException {
        if (s != null) {
            return s.charAt(0);
        }
        return '\u0000';
    }

    private Date getDateValue(String s, String attribute, String dateFormat, XMLStreamReader xmlStreamReader) throws XMLStreamException {
        if (s != null) {
            String effectiveDateFormat = dateFormat;
            if (dateFormat == null) {
                effectiveDateFormat = "yyyy-MM-dd'T'HH:mm:ss.SSS";
            }
            if ("long".equals(effectiveDateFormat)) {
                try {
                    return new Date(Long.parseLong(s));
                }
                catch (NumberFormatException e) {
                    throw new XMLStreamException(e.getMessage(), xmlStreamReader.getLocation(), e);
                }
            }
            try {
                SimpleDateFormat dateParser = new SimpleDateFormat(effectiveDateFormat, Locale.US);
                return dateParser.parse(s);
            }
            catch (ParseException e) {
                throw new XMLStreamException(e.getMessage(), xmlStreamReader.getLocation(), e);
            }
        }
        return null;
    }

    private String getDefaultValue(String s, String v) {
        if (s == null) {
            s = v;
        }
        return s;
    }

    private double getDoubleValue(String s, String attribute, XMLStreamReader xmlStreamReader, boolean strict) throws XMLStreamException {
        block3: {
            if (s != null) {
                try {
                    return Double.valueOf(s);
                }
                catch (NumberFormatException nfe) {
                    if (!strict) break block3;
                    throw new XMLStreamException("Unable to parse element '" + attribute + "', must be a floating point number but was '" + s + "'", xmlStreamReader.getLocation(), nfe);
                }
            }
        }
        return 0.0;
    }

    private float getFloatValue(String s, String attribute, XMLStreamReader xmlStreamReader, boolean strict) throws XMLStreamException {
        block3: {
            if (s != null) {
                try {
                    return Float.valueOf(s).floatValue();
                }
                catch (NumberFormatException nfe) {
                    if (!strict) break block3;
                    throw new XMLStreamException("Unable to parse element '" + attribute + "', must be a floating point number but was '" + s + "'", xmlStreamReader.getLocation(), nfe);
                }
            }
        }
        return 0.0f;
    }

    private int getIntegerValue(String s, String attribute, XMLStreamReader xmlStreamReader, boolean strict) throws XMLStreamException {
        block3: {
            if (s != null) {
                try {
                    return Integer.valueOf(s);
                }
                catch (NumberFormatException nfe) {
                    if (!strict) break block3;
                    throw new XMLStreamException("Unable to parse element '" + attribute + "', must be an integer but was '" + s + "'", xmlStreamReader.getLocation(), nfe);
                }
            }
        }
        return 0;
    }

    private long getLongValue(String s, String attribute, XMLStreamReader xmlStreamReader, boolean strict) throws XMLStreamException {
        block3: {
            if (s != null) {
                try {
                    return Long.valueOf(s);
                }
                catch (NumberFormatException nfe) {
                    if (!strict) break block3;
                    throw new XMLStreamException("Unable to parse element '" + attribute + "', must be a long integer but was '" + s + "'", xmlStreamReader.getLocation(), nfe);
                }
            }
        }
        return 0L;
    }

    private String getRequiredAttributeValue(String s, String attribute, XMLStreamReader xmlStreamReader, boolean strict) throws XMLStreamException {
        if (s == null && strict) {
            throw new XMLStreamException("Missing required value for attribute '" + attribute + "'", xmlStreamReader.getLocation());
        }
        return s;
    }

    private short getShortValue(String s, String attribute, XMLStreamReader xmlStreamReader, boolean strict) throws XMLStreamException {
        block3: {
            if (s != null) {
                try {
                    return Short.valueOf(s);
                }
                catch (NumberFormatException nfe) {
                    if (!strict) break block3;
                    throw new XMLStreamException("Unable to parse element '" + attribute + "', must be a short integer but was '" + s + "'", xmlStreamReader.getLocation(), nfe);
                }
            }
        }
        return 0;
    }

    private String getTrimmedValue(String s) {
        if (s != null) {
            s = s.trim();
        }
        return s;
    }

    private int nextTag(XMLStreamReader xmlStreamReader) throws XMLStreamException {
        block4: while (true) {
            int eventType = xmlStreamReader.next();
            switch (eventType) {
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 12: {
                    continue block4;
                }
                case 1: 
                case 2: {
                    return eventType;
                }
            }
            break;
        }
        throw new XMLStreamException("expected start or end tag", xmlStreamReader.getLocation());
    }

    private AbstractType parseAbstractType(XMLStreamReader xmlStreamReader, boolean strict) throws IOException, XMLStreamException {
        AbstractType abstractType = new AbstractType();
        HashSet parsed = new HashSet();
        abstractType.setClassName(this.getTrimmedValue(xmlStreamReader.getAttributeValue(null, "className")));
        while ((strict ? xmlStreamReader.nextTag() : this.nextTag(xmlStreamReader)) == 1) {
            if (this.checkFieldWithDuplicate(xmlStreamReader, "description", null, parsed)) {
                abstractType.setDescription(this.parseDescription(xmlStreamReader, strict));
                continue;
            }
            this.checkUnknownElement(xmlStreamReader, strict);
        }
        return abstractType;
    }

    private Description parseDescription(XMLStreamReader xmlStreamReader, boolean strict) throws IOException, XMLStreamException {
        Description description = new Description();
        description.setFormat(this.getTrimmedValue(this.getDefaultValue(xmlStreamReader.getAttributeValue(null, "format"), "asciidoc")));
        description.setText(xmlStreamReader.getElementText());
        return description;
    }

    private PluginAttribute parsePluginAttribute(XMLStreamReader xmlStreamReader, boolean strict) throws IOException, XMLStreamException {
        PluginAttribute pluginAttribute = new PluginAttribute();
        HashSet parsed = new HashSet();
        pluginAttribute.setName(this.getTrimmedValue(xmlStreamReader.getAttributeValue(null, "name")));
        pluginAttribute.setType(this.getTrimmedValue(this.getDefaultValue(xmlStreamReader.getAttributeValue(null, "type"), "java.lang.String")));
        pluginAttribute.setRequired(this.getBooleanValue(this.getTrimmedValue(this.getDefaultValue(xmlStreamReader.getAttributeValue(null, "required"), "false")), "required", xmlStreamReader));
        pluginAttribute.setDefaultValue(this.getTrimmedValue(xmlStreamReader.getAttributeValue(null, "defaultValue")));
        pluginAttribute.setDefaultProperty(this.getTrimmedValue(xmlStreamReader.getAttributeValue(null, "defaultProperty")));
        while ((strict ? xmlStreamReader.nextTag() : this.nextTag(xmlStreamReader)) == 1) {
            if (this.checkFieldWithDuplicate(xmlStreamReader, "description", null, parsed)) {
                pluginAttribute.setDescription(this.parseDescription(xmlStreamReader, strict));
                continue;
            }
            this.checkUnknownElement(xmlStreamReader, strict);
        }
        return pluginAttribute;
    }

    private PluginElement parsePluginElement(XMLStreamReader xmlStreamReader, boolean strict) throws IOException, XMLStreamException {
        PluginElement pluginElement = new PluginElement();
        HashSet parsed = new HashSet();
        pluginElement.setMultiplicity(this.getTrimmedValue(this.getDefaultValue(xmlStreamReader.getAttributeValue(null, "multiplicity"), "1")));
        pluginElement.setRequired(this.getBooleanValue(this.getTrimmedValue(this.getDefaultValue(xmlStreamReader.getAttributeValue(null, "required"), "false")), "required", xmlStreamReader));
        pluginElement.setType(this.getTrimmedValue(xmlStreamReader.getAttributeValue(null, "type")));
        while ((strict ? xmlStreamReader.nextTag() : this.nextTag(xmlStreamReader)) == 1) {
            if (this.checkFieldWithDuplicate(xmlStreamReader, "description", null, parsed)) {
                pluginElement.setDescription(this.parseDescription(xmlStreamReader, strict));
                continue;
            }
            this.checkUnknownElement(xmlStreamReader, strict);
        }
        return pluginElement;
    }

    private PluginSet parsePluginSet(XMLStreamReader xmlStreamReader, boolean strict) throws IOException, XMLStreamException {
        PluginSet pluginSet = new PluginSet();
        HashSet parsed = new HashSet();
        pluginSet.setSchemaVersion(this.getTrimmedValue(xmlStreamReader.getAttributeValue(null, "version")));
        while ((strict ? xmlStreamReader.nextTag() : this.nextTag(xmlStreamReader)) == 1) {
            if (this.checkFieldWithDuplicate(xmlStreamReader, "groupId", null, parsed)) {
                pluginSet.setGroupId(this.getTrimmedValue(xmlStreamReader.getElementText()));
                continue;
            }
            if (this.checkFieldWithDuplicate(xmlStreamReader, "artifactId", null, parsed)) {
                pluginSet.setArtifactId(this.getTrimmedValue(xmlStreamReader.getElementText()));
                continue;
            }
            if (this.checkFieldWithDuplicate(xmlStreamReader, "version", null, parsed)) {
                pluginSet.setVersion(this.getTrimmedValue(xmlStreamReader.getElementText()));
                continue;
            }
            if (this.checkFieldWithDuplicate(xmlStreamReader, "description", null, parsed)) {
                pluginSet.setDescription(this.parseDescription(xmlStreamReader, strict));
                continue;
            }
            if (this.checkFieldWithDuplicate(xmlStreamReader, "scalars", null, parsed)) {
                TreeSet<ScalarType> scalars = new TreeSet<ScalarType>();
                pluginSet.setScalars(scalars);
                while (xmlStreamReader.nextTag() == 1) {
                    if ("scalar".equals(xmlStreamReader.getLocalName())) {
                        pluginSet.addScalar(this.parseScalarType(xmlStreamReader, strict));
                        continue;
                    }
                    throw new XMLStreamException("Unrecognised tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation());
                }
                continue;
            }
            if (this.checkFieldWithDuplicate(xmlStreamReader, "plugins", null, parsed)) {
                TreeSet<PluginType> plugins = new TreeSet<PluginType>();
                pluginSet.setPlugins(plugins);
                while (xmlStreamReader.nextTag() == 1) {
                    if ("plugin".equals(xmlStreamReader.getLocalName())) {
                        pluginSet.addPlugin(this.parsePluginType(xmlStreamReader, strict));
                        continue;
                    }
                    throw new XMLStreamException("Unrecognised tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation());
                }
                continue;
            }
            if (this.checkFieldWithDuplicate(xmlStreamReader, "abstractTypes", null, parsed)) {
                TreeSet<AbstractType> abstractTypes = new TreeSet<AbstractType>();
                pluginSet.setAbstractTypes(abstractTypes);
                while (xmlStreamReader.nextTag() == 1) {
                    if ("abstractType".equals(xmlStreamReader.getLocalName())) {
                        pluginSet.addAbstractType(this.parseAbstractType(xmlStreamReader, strict));
                        continue;
                    }
                    throw new XMLStreamException("Unrecognised tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation());
                }
                continue;
            }
            this.checkUnknownElement(xmlStreamReader, strict);
        }
        return pluginSet;
    }

    private PluginType parsePluginType(XMLStreamReader xmlStreamReader, boolean strict) throws IOException, XMLStreamException {
        PluginType pluginType = new PluginType();
        HashSet parsed = new HashSet();
        pluginType.setName(this.getTrimmedValue(xmlStreamReader.getAttributeValue(null, "name")));
        pluginType.setNamespace(this.getTrimmedValue(this.getDefaultValue(xmlStreamReader.getAttributeValue(null, "namespace"), "Core")));
        pluginType.setDeferChildren(this.getBooleanValue(this.getTrimmedValue(this.getDefaultValue(xmlStreamReader.getAttributeValue(null, "deferChildren"), "false")), "deferChildren", xmlStreamReader));
        pluginType.setClassName(this.getTrimmedValue(xmlStreamReader.getAttributeValue(null, "className")));
        while ((strict ? xmlStreamReader.nextTag() : this.nextTag(xmlStreamReader)) == 1) {
            if (this.checkFieldWithDuplicate(xmlStreamReader, "aliases", null, parsed)) {
                TreeSet<String> aliases = new TreeSet<String>();
                pluginType.setAliases(aliases);
                while (xmlStreamReader.nextTag() == 1) {
                    if ("alias".equals(xmlStreamReader.getLocalName())) {
                        aliases.add(this.getTrimmedValue(this.getDefaultValue(xmlStreamReader.getElementText(), "new java.util.TreeSet/*<String>*/()")));
                        continue;
                    }
                    throw new XMLStreamException("Unrecognised tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation());
                }
                continue;
            }
            if (this.checkFieldWithDuplicate(xmlStreamReader, "supertypes", null, parsed)) {
                TreeSet<String> supertypes = new TreeSet<String>();
                pluginType.setSupertypes(supertypes);
                while (xmlStreamReader.nextTag() == 1) {
                    if ("supertype".equals(xmlStreamReader.getLocalName())) {
                        supertypes.add(this.getTrimmedValue(this.getDefaultValue(xmlStreamReader.getElementText(), "new java.util.TreeSet/*<String>*/()")));
                        continue;
                    }
                    throw new XMLStreamException("Unrecognised tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation());
                }
                continue;
            }
            if (this.checkFieldWithDuplicate(xmlStreamReader, "attributes", null, parsed)) {
                ArrayList<PluginAttribute> attributes = new ArrayList<PluginAttribute>();
                pluginType.setAttributes(attributes);
                while (xmlStreamReader.nextTag() == 1) {
                    if ("attribute".equals(xmlStreamReader.getLocalName())) {
                        pluginType.addAttribute(this.parsePluginAttribute(xmlStreamReader, strict));
                        continue;
                    }
                    throw new XMLStreamException("Unrecognised tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation());
                }
                continue;
            }
            if (this.checkFieldWithDuplicate(xmlStreamReader, "elements", null, parsed)) {
                ArrayList<PluginElement> elements = new ArrayList<PluginElement>();
                pluginType.setElements(elements);
                while (xmlStreamReader.nextTag() == 1) {
                    if ("element".equals(xmlStreamReader.getLocalName())) {
                        pluginType.addElement(this.parsePluginElement(xmlStreamReader, strict));
                        continue;
                    }
                    throw new XMLStreamException("Unrecognised tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation());
                }
                continue;
            }
            if (this.checkFieldWithDuplicate(xmlStreamReader, "description", null, parsed)) {
                pluginType.setDescription(this.parseDescription(xmlStreamReader, strict));
                continue;
            }
            this.checkUnknownElement(xmlStreamReader, strict);
        }
        return pluginType;
    }

    private ScalarType parseScalarType(XMLStreamReader xmlStreamReader, boolean strict) throws IOException, XMLStreamException {
        ScalarType scalarType = new ScalarType();
        HashSet parsed = new HashSet();
        scalarType.setClassName(this.getTrimmedValue(xmlStreamReader.getAttributeValue(null, "className")));
        while ((strict ? xmlStreamReader.nextTag() : this.nextTag(xmlStreamReader)) == 1) {
            if (this.checkFieldWithDuplicate(xmlStreamReader, "values", null, parsed)) {
                ArrayList<ScalarValue> values = new ArrayList<ScalarValue>();
                scalarType.setValues(values);
                while (xmlStreamReader.nextTag() == 1) {
                    if ("value".equals(xmlStreamReader.getLocalName())) {
                        scalarType.addValue(this.parseScalarValue(xmlStreamReader, strict));
                        continue;
                    }
                    throw new XMLStreamException("Unrecognised tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation());
                }
                continue;
            }
            if (this.checkFieldWithDuplicate(xmlStreamReader, "description", null, parsed)) {
                scalarType.setDescription(this.parseDescription(xmlStreamReader, strict));
                continue;
            }
            this.checkUnknownElement(xmlStreamReader, strict);
        }
        return scalarType;
    }

    private ScalarValue parseScalarValue(XMLStreamReader xmlStreamReader, boolean strict) throws IOException, XMLStreamException {
        ScalarValue scalarValue = new ScalarValue();
        HashSet parsed = new HashSet();
        scalarValue.setName(this.getTrimmedValue(xmlStreamReader.getAttributeValue(null, "name")));
        while ((strict ? xmlStreamReader.nextTag() : this.nextTag(xmlStreamReader)) == 1) {
            if (this.checkFieldWithDuplicate(xmlStreamReader, "description", null, parsed)) {
                scalarValue.setDescription(this.parseDescription(xmlStreamReader, strict));
                continue;
            }
            this.checkUnknownElement(xmlStreamReader, strict);
        }
        return scalarValue;
    }

    private Type parseType(XMLStreamReader xmlStreamReader, boolean strict) throws IOException, XMLStreamException {
        Type type = new Type();
        HashSet parsed = new HashSet();
        type.setClassName(this.getTrimmedValue(xmlStreamReader.getAttributeValue(null, "className")));
        while ((strict ? xmlStreamReader.nextTag() : this.nextTag(xmlStreamReader)) == 1) {
            if (this.checkFieldWithDuplicate(xmlStreamReader, "description", null, parsed)) {
                type.setDescription(this.parseDescription(xmlStreamReader, strict));
                continue;
            }
            this.checkUnknownElement(xmlStreamReader, strict);
        }
        return type;
    }

    private PluginSet read(XMLStreamReader xmlStreamReader, boolean strict) throws IOException, XMLStreamException {
        int eventType = xmlStreamReader.getEventType();
        String encoding = null;
        while (eventType != 8) {
            if (eventType == 7) {
                encoding = xmlStreamReader.getCharacterEncodingScheme();
            }
            if (eventType == 1) {
                if (strict && !"pluginSet".equals(xmlStreamReader.getLocalName())) {
                    throw new XMLStreamException("Expected root element 'pluginSet' but found '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation(), null);
                }
                PluginSet pluginSet = this.parsePluginSet(xmlStreamReader, strict);
                pluginSet.setModelEncoding(encoding);
                this.resolveReferences(pluginSet);
                return pluginSet;
            }
            eventType = xmlStreamReader.next();
        }
        throw new XMLStreamException("Expected root element 'pluginSet' but found no element at all: invalid XML document", xmlStreamReader.getLocation(), null);
    }

    private void resolveReferences(PluginSet value) {
    }
}

