/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.docgen.processor;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.lang.model.AnnotatedConstruct;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Name;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Elements;
import javax.lang.model.util.SimpleElementVisitor8;
import javax.lang.model.util.Types;

final class Annotations {
    private static final Collection<String> FACTORY_ANNOTATION_NAMES = Arrays.asList("org.apache.logging.log4j.core.config.plugins.PluginBuilderFactory", "org.apache.logging.log4j.core.config.plugins.PluginFactory", "org.apache.logging.log4j.plugins.Factory", "org.apache.logging.log4j.plugins.PluginFactory");
    private static final String NAMESPACE_ANNOTATION_NAME = "org.apache.logging.log4j.plugins.Namespace";
    private static final String PLUGIN_V2_ANNOTATION_NAME = "org.apache.logging.log4j.core.config.plugins.Plugin";
    private static final String PLUGIN_V3_ANNOTATION_NAME = "org.apache.logging.log4j.plugins.Plugin";
    private static final Collection<String> PLUGIN_ALIAS_ANNOTATION_NAMES = Arrays.asList("org.apache.logging.log4j.core.config.plugins.PluginAliases", "org.apache.logging.log4j.plugins.PluginAliases");
    private static final Collection<String> PLUGIN_ATTRIBUTE_ANNOTATION_NAMES = Arrays.asList("org.apache.logging.log4j.core.config.plugins.PluginBuilderAttribute", "org.apache.logging.log4j.core.config.plugins.PluginAttribute", "org.apache.logging.log4j.plugins.PluginAttribute", "org.apache.logging.log4j.plugins.PluginBuilderAttribute");
    private static final Collection<String> PLUGIN_ELEMENT_ANNOTATION_NAMES = Arrays.asList("org.apache.logging.log4j.core.config.plugins.PluginElement", "org.apache.logging.log4j.plugins.PluginElement");
    private static final Collection<String> REQUIRED_CONSTRAINT_ANNOTATION_NAMES = Arrays.asList("org.apache.logging.log4j.core.config.plugins.validation.constraints.Required", "org.apache.logging.log4j.plugins.validation.constraints.Required");
    private final Elements elements;
    private final Types types;
    private final Name category;
    private final Name name;
    private final Name value;
    private final DeclaredType deprecatedAnnotation;
    private final TypeElement[] pluginAnnotationElements;
    private final DeclaredType namespaceAnnotation;
    private final DeclaredType pluginV2Annotation;
    private final DeclaredType pluginV3Annotation;
    private final Collection<DeclaredType> factoryAnnotations = new HashSet<DeclaredType>();
    private final Collection<DeclaredType> pluginAliasAnnotations = new HashSet<DeclaredType>();
    private final Collection<DeclaredType> pluginAttributeAnnotations = new HashSet<DeclaredType>();
    private final Collection<DeclaredType> pluginAttributeAndElementAnnotations = new HashSet<DeclaredType>();
    private final Collection<DeclaredType> requiredConstraintAnnotations = new HashSet<DeclaredType>();

    Annotations(Elements elements, Types types) {
        TypeElement namespaceAnnotation;
        TypeElement pluginV3Annotation;
        this.elements = elements;
        this.types = types;
        this.category = elements.getName("category");
        this.name = elements.getName("name");
        this.value = elements.getName("value");
        this.deprecatedAnnotation = (DeclaredType)elements.getTypeElement("java.lang.Deprecated").asType();
        ArrayList<TypeElement> pluginAnnotations = new ArrayList<TypeElement>();
        TypeElement pluginV2Annotation = elements.getTypeElement(PLUGIN_V2_ANNOTATION_NAME);
        DeclaredType declaredType = this.pluginV2Annotation = pluginV2Annotation != null ? (DeclaredType)pluginV2Annotation.asType() : null;
        if (pluginV2Annotation != null) {
            pluginAnnotations.add(pluginV2Annotation);
        }
        DeclaredType declaredType2 = this.pluginV3Annotation = (pluginV3Annotation = elements.getTypeElement(PLUGIN_V3_ANNOTATION_NAME)) != null ? (DeclaredType)pluginV3Annotation.asType() : null;
        if (pluginV3Annotation != null) {
            pluginAnnotations.add(pluginV3Annotation);
        }
        this.namespaceAnnotation = (namespaceAnnotation = elements.getTypeElement(NAMESPACE_ANNOTATION_NAME)) != null ? (DeclaredType)namespaceAnnotation.asType() : null;
        this.pluginAnnotationElements = pluginAnnotations.toArray(new TypeElement[0]);
        FACTORY_ANNOTATION_NAMES.forEach(name -> this.addDeclaredTypeIfExists((CharSequence)name, (Collection<? super DeclaredType>)this.factoryAnnotations));
        PLUGIN_ALIAS_ANNOTATION_NAMES.forEach(name -> this.addDeclaredTypeIfExists((CharSequence)name, (Collection<? super DeclaredType>)this.pluginAliasAnnotations));
        PLUGIN_ATTRIBUTE_ANNOTATION_NAMES.forEach(name -> this.addDeclaredTypeIfExists((CharSequence)name, (Collection<? super DeclaredType>)this.pluginAttributeAnnotations));
        this.pluginAttributeAndElementAnnotations.addAll(this.pluginAttributeAnnotations);
        PLUGIN_ELEMENT_ANNOTATION_NAMES.forEach(name -> this.addDeclaredTypeIfExists((CharSequence)name, (Collection<? super DeclaredType>)this.pluginAttributeAndElementAnnotations));
        REQUIRED_CONSTRAINT_ANNOTATION_NAMES.forEach(name -> this.addDeclaredTypeIfExists((CharSequence)name, (Collection<? super DeclaredType>)this.requiredConstraintAnnotations));
    }

    public TypeElement[] getPluginAnnotations() {
        return this.pluginAnnotationElements;
    }

    public Optional<String> getAttributeSpecifiedName(AnnotationMirror annotation) {
        return Optional.ofNullable(this.getValueAsString(annotation, this.value));
    }

    public Optional<String> getPluginSpecifiedName(AnnotatedConstruct element) {
        return this.getAnnotationValue(element, this.pluginV2Annotation, this.name, this.pluginV3Annotation, this.value);
    }

    public Optional<String> getPluginSpecifiedNamespace(AnnotatedConstruct element) {
        return this.getAnnotationValue(element, this.pluginV2Annotation, this.category, this.namespaceAnnotation, this.value);
    }

    public boolean hasDeprecatedAnnotation(Element element) {
        return this.elements.getAllAnnotationMirrors(element).stream().anyMatch(annotationMirror -> {
            DeclaredType annotationType = annotationMirror.getAnnotationType();
            return this.types.isSameType(annotationType, this.deprecatedAnnotation);
        });
    }

    public boolean hasFactoryAnnotation(Element element) {
        return this.hasAnyDirectAnnotation(element, this.factoryAnnotations);
    }

    public boolean hasRequiredConstraint(Element element) {
        return this.hasAnyDirectAnnotation(element, this.requiredConstraintAnnotations);
    }

    public boolean isAttributeAnnotation(AnnotationMirror annotation) {
        return this.contains(this.pluginAttributeAnnotations, annotation.getAnnotationType());
    }

    public Collection<? extends AnnotationMirror> findAttributeAndPropertyAnnotations(Element element) {
        HashSet annotations = new HashSet();
        element.accept(new SimpleElementVisitor8<Void, Collection<? super AnnotationMirror>>(){

            @Override
            protected Void defaultAction(Element e, Collection<? super AnnotationMirror> annotations) {
                for (AnnotationMirror annotationMirror : e.getAnnotationMirrors()) {
                    if (!Annotations.this.contains(Annotations.this.pluginAttributeAndElementAnnotations, annotationMirror.getAnnotationType())) continue;
                    annotations.add(annotationMirror);
                }
                return null;
            }

            @Override
            public Void visitExecutable(ExecutableElement e, Collection<? super AnnotationMirror> annotations) {
                for (VariableElement variableElement : e.getParameters()) {
                    variableElement.accept(this, annotations);
                }
                return (Void)super.visitExecutable(e, annotations);
            }
        }, annotations);
        return annotations;
    }

    private String getValueAsString(AnnotationMirror annotation, Name property) {
        Object value = this.getValue(annotation, property);
        return value != null ? value.toString() : null;
    }

    private boolean hasAnyDirectAnnotation(Element element, Iterable<? extends DeclaredType> annotationTypes) {
        return this.elements.getAllAnnotationMirrors(element).stream().anyMatch(mirror -> this.contains(annotationTypes, mirror.getAnnotationType()));
    }

    private Object getValue(AnnotationMirror annotation, Name property) {
        for (Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> entry : annotation.getElementValues().entrySet()) {
            if (!entry.getKey().getSimpleName().equals(property)) continue;
            return entry.getValue().getValue();
        }
        return null;
    }

    private <T extends TypeMirror> boolean contains(Iterable<? extends T> collection, T type) {
        for (TypeMirror t : collection) {
            if (!this.types.isSameType(t, type)) continue;
            return true;
        }
        return false;
    }

    private void addDeclaredTypeIfExists(CharSequence className, Collection<? super DeclaredType> collection) {
        TypeMirror type;
        TypeElement element = this.elements.getTypeElement(className);
        if (element != null && (type = element.asType()) instanceof DeclaredType) {
            collection.add((DeclaredType)type);
        }
    }

    private Optional<String> getAnnotationValue(AnnotatedConstruct element, TypeMirror v2Annotation, Name v2Property, TypeMirror v3Annotation, Name v3Property) {
        return element.getAnnotationMirrors().stream().map(annotation -> {
            DeclaredType annotationType = annotation.getAnnotationType();
            if (v2Annotation != null && this.types.isSameType(v2Annotation, annotationType)) {
                return this.getValueAsString((AnnotationMirror)annotation, v2Property);
            }
            return v3Annotation != null && this.types.isSameType(v3Annotation, annotationType) ? this.getValueAsString((AnnotationMirror)annotation, v3Property) : null;
        }).filter(Objects::nonNull).findAny();
    }
}

