/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.kubernetes;

import io.fabric8.kubernetes.api.model.Container;
import io.fabric8.kubernetes.api.model.ContainerStatus;
import io.fabric8.kubernetes.api.model.Namespace;
import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.dsl.PodResource;
import io.fabric8.kubernetes.client.dsl.Resource;
import java.net.URL;
import java.nio.file.Paths;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.lookup.AbstractLookup;
import org.apache.logging.log4j.kubernetes.KubernetesClientBuilder;
import org.apache.logging.log4j.status.StatusLogger;
import org.apache.logging.log4j.util.LoaderUtil;
import org.apache.logging.log4j.util.Strings;

@Plugin(name="k8s", category="Lookup")
public class KubernetesLookup
extends AbstractLookup {
    private static final Logger LOGGER = StatusLogger.getLogger();
    private static final String HOSTNAME = "HOSTNAME";
    private static final String SPRING_ENVIRONMENT_KEY = "SpringEnvironment";
    private static volatile KubernetesInfo kubernetesInfo;
    private static Lock initLock;
    private static boolean isSpringIncluded;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean initialize() {
        if (kubernetesInfo == null || isSpringIncluded && !KubernetesLookup.kubernetesInfo.isSpringActive) {
            initLock.lock();
            boolean isSpringActive = this.isSpringActive();
            if (kubernetesInfo == null || !KubernetesLookup.kubernetesInfo.isSpringActive && isSpringActive) {
                try {
                    KubernetesClient client = new KubernetesClientBuilder().createClient();
                    if (client != null) {
                        KubernetesInfo info = new KubernetesInfo();
                        info.isSpringActive = isSpringActive;
                        info.hostName = this.getHostname();
                        Pod pod = this.getCurrentPod(info.hostName, client);
                        if (pod != null) {
                            ContainerStatus containerStatus;
                            info.app = (String)pod.getMetadata().getLabels().get("app");
                            String app = info.app != null ? info.app : "";
                            info.podTemplateHash = (String)pod.getMetadata().getLabels().get("pod-template-hash");
                            info.accountName = pod.getSpec().getServiceAccountName();
                            info.clusterName = pod.getMetadata().getClusterName();
                            info.hostIp = pod.getStatus().getHostIP();
                            info.labels = pod.getMetadata().getLabels();
                            info.podId = pod.getMetadata().getUid();
                            info.podIp = pod.getStatus().getPodIP();
                            info.podName = pod.getMetadata().getName();
                            Container container = pod.getSpec().getContainers().stream().filter(c -> c.getName().equals(app)).findFirst().orElse(null);
                            if (container != null) {
                                info.containerName = container.getName();
                                info.imageName = container.getImage();
                            }
                            info.masterUrl = client.getMasterUrl();
                            info.namespace = pod.getMetadata().getNamespace();
                            Namespace namespace = (Namespace)((Resource)client.namespaces().withName(info.namespace)).get();
                            if (namespace != null) {
                                info.namespaceId = namespace.getMetadata().getUid();
                            }
                            if ((containerStatus = (ContainerStatus)pod.getStatus().getContainerStatuses().stream().filter(cs -> cs.getName().equals(app)).findFirst().orElse(null)) != null) {
                                info.containerId = containerStatus.getContainerID();
                                info.imageId = containerStatus.getImageID();
                            }
                            kubernetesInfo = info;
                        }
                    }
                }
                finally {
                    initLock.unlock();
                }
            }
        }
        return kubernetesInfo != null;
    }

    public String lookup(LogEvent event, String key) {
        if (!this.initialize()) {
            return null;
        }
        switch (key) {
            case "accountName": {
                return KubernetesLookup.kubernetesInfo.accountName;
            }
            case "containerId": {
                return KubernetesLookup.kubernetesInfo.containerId;
            }
            case "containerName": {
                return KubernetesLookup.kubernetesInfo.containerName;
            }
            case "clusterName": {
                return KubernetesLookup.kubernetesInfo.clusterName;
            }
            case "host": {
                return KubernetesLookup.kubernetesInfo.hostName;
            }
            case "hostIp": {
                return KubernetesLookup.kubernetesInfo.hostIp;
            }
            case "labels": {
                return KubernetesLookup.kubernetesInfo.labels.toString();
            }
            case "labels.app": {
                return KubernetesLookup.kubernetesInfo.app;
            }
            case "labels.podTemplateHash": {
                return KubernetesLookup.kubernetesInfo.podTemplateHash;
            }
            case "masterUrl": {
                return KubernetesLookup.kubernetesInfo.masterUrl.toString();
            }
            case "namespaceId": {
                return KubernetesLookup.kubernetesInfo.namespaceId;
            }
            case "namespaceName": {
                return KubernetesLookup.kubernetesInfo.namespace;
            }
            case "podId": {
                return KubernetesLookup.kubernetesInfo.podId;
            }
            case "podIp": {
                return KubernetesLookup.kubernetesInfo.podIp;
            }
            case "podName": {
                return KubernetesLookup.kubernetesInfo.podName;
            }
            case "imageId": {
                return KubernetesLookup.kubernetesInfo.imageId;
            }
            case "imageName": {
                return KubernetesLookup.kubernetesInfo.imageName;
            }
        }
        return null;
    }

    private String getHostname() {
        return System.getenv(HOSTNAME);
    }

    private Pod getCurrentPod(String hostName, KubernetesClient kubernetesClient) {
        try {
            if (this.isServiceAccount() && Strings.isNotBlank((String)hostName)) {
                return (Pod)((PodResource)kubernetesClient.pods().withName(hostName)).get();
            }
        }
        catch (Throwable t) {
            LOGGER.debug("Unable to locate pod with name {}.", (Object)hostName);
        }
        return null;
    }

    private boolean isServiceAccount() {
        return Paths.get("/var/run/secrets/kubernetes.io/serviceaccount/token", new String[0]).toFile().exists() && Paths.get("/var/run/secrets/kubernetes.io/serviceaccount/ca.crt", new String[0]).toFile().exists();
    }

    private boolean isSpringActive() {
        return isSpringIncluded && LogManager.getFactory() != null && LogManager.getFactory().hasContext(KubernetesLookup.class.getName(), null, false) && LogManager.getContext((boolean)false).getObject(SPRING_ENVIRONMENT_KEY) != null;
    }

    static {
        initLock = new ReentrantLock();
        isSpringIncluded = LoaderUtil.isClassAvailable((String)"org.apache.logging.log4j.spring.cloud.config.client.SpringEnvironmentHolder");
    }

    private static class KubernetesInfo {
        boolean isSpringActive;
        String accountName;
        String app;
        String clusterName;
        String containerId;
        String containerName;
        String hostName;
        String hostIp;
        String imageId;
        String imageName;
        Map<String, String> labels;
        URL masterUrl;
        String namespace;
        String namespaceId;
        String podId;
        String podIp;
        String podName;
        String podTemplateHash;

        private KubernetesInfo() {
        }
    }
}

